/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Text.DecimalFormat = OpenLayers
    .Class(
        Legato.Text.Format,
        {
          formatSymbols : {
            groupingSeparator :'.',
            decimalSeparator :','
          },
          initialize : function(options) {
          },
          format : function(number) {
            var decimalDigits = 10;
            var groupLength = 3;

            var sign = (number > 0) ? 1 : (number < 0 ? -1 : 0);
            var fractionalPart = Math.abs(number) % 1;
            var integerPart = Math.abs(number) - fractionalPart;

            var signAsString = (sign < 0) ? '-' : '';

            var groupDivider = groupLength > 0 ? Math.pow(10, groupLength) : 10;
            var groupingSeparator = groupLength > 0 ? this.formatSymbols.groupingSeparator
                : '';

            var integerPartAsString = this.calculateIntegerPartAsString(integerPart, groupDivider, groupingSeparator);

            var scale = 10;

            var fractionalPartAsString = this.calculateFranctionalPartAsString(fractionalPart, scale);

            return signAsString + integerPartAsString + fractionalPartAsString;
          },
          calculateIntegerPartAsString: function(integerPart, groupDivider, groupingSeparator) {
            var car = integerPart;
            var cdr = 0;

            var result = (car === 0) ? '0' : '';

            while (car > 0) {
              cdr = car % groupDivider;
              car = (car - cdr) / groupDivider;

              if (car === 0) {
                result = cdr.toString() + result;
              } else {
                result = groupingSeparator
                    + (groupDivider + cdr).toString().substring(1) + result;
              }
            }
            return result;
          },
          calculateFranctionalPartAsString: function(fractionalPart, scale) {
            var car = Math.round(fractionalPart * Math.pow(10, scale));
            var cdr = 0;
            var onlyZeroes = true;
            var result = '';
            for ( var index = 0; index < scale; index++) {
              cdr = car % 10;
              car = (car - cdr) / 10;
              onlyZeroes = onlyZeroes && (cdr === 0);
              if (!onlyZeroes) {
                result = cdr + result;
              }
            }
            return (result.length === 0 ? ''
                : this.formatSymbols.decimalSeparator)
                + result;
          },
          parse : function(string) {
            var one = string.replace(/\./g, '');
            var two = one.replace(/,/, '.');
            return Number(two);
          },
          destroy : function() {
          },
          CLASS_NAME :"Legato.Text.DecimalFormat"
        });
