/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Beans.ComplexType = Legato.Lang
    .Class(
        Legato.Lang.AnyType,
        {
          typeName :null,
          qName :null,
          _constructor :null,
          factoryFunction :null,
          constructorArguments :null,
          constructorOrder :null,
          options :null,
          fields :null,
          properties :null,
          components :null,
          afterInstancePopulated :null,
          initialize : function(name, qName, definition) {

            if (typeof name != 'string') {
              throw new Error('Name [' + name + '] must be string.');
            }
            if (!(qName instanceof Legato.XML.QName)) {
              throw new Error(
                  'Qualified name [' + qName.toString() + '] must be an instance of [Legato.XML.QName].');
            }
            if (typeof definition != 'object') {
              throw new Error(
                  'Definition [' + definition + '] must be an object.');
            }

            // TODO Check arguments
            this.typeName = name;
            this.qName = qName;
            this._constructor = definition._constructor;
            this.factoryFunction = definition.factoryFunction;
            this.constructorArguments = definition.constructorArguments;
            this.constructorOrder = (definition.constructorOrder) ? definition.constructorOrder
                : [];
            this.options = (definition.options) ? definition.options : null;
            this.fields = definition.fields;
            this.properties = definition.properties;
            this.afterInstancePopulated = definition.afterInstancePopulated;

            // Register all the components
            this.components = {};
            for ( var constructorArgumentName in this.constructorArguments) {
              if (this.constructorArguments
                  .hasOwnProperty(constructorArgumentName)) {
                this.components[constructorArgumentName] = this.constructorArguments[constructorArgumentName];
              }
            }
            for ( var optionName in this.options) {
              if (this.options.hasOwnProperty(optionName)) {
                this.components[optionName] = this.options[optionName];
              }
            }
            for ( var fieldName in this.fields) {
              if (this.fields.hasOwnProperty(fieldName)) {
                this.components[fieldName] = this.fields[fieldName];
              }
            }
            for ( var propertyName in this.properties) {
              if (this.properties.hasOwnProperty(propertyName)) {
                this.components[propertyName] = this.properties[propertyName].type;
              }
            }
            Legato.Beans.ComplexType.registerTypeNS(this,
                this.qName.namespaceURI, this.qName.localPart);
          },
          Extend : function(name, qName, extension) {
            // TODO Check arguments
          var base = this;
          var extended = {};
          // constructor
          if (extension._constructor) {
            extended._constructor = extension._constructor;
          } else if (extension.factoryFunction) {
            extended.factoryFunction = extension.factoryFunction;
          } else if (base._constructor) {
            extended._constructor = base._constructor;
          } else if (base.factoryFunction) {
            extended.factoryFunction = base.factoryFunction;
          }
          // constructorArguments
          if (extension.constructorArguments) {
            extended.constructorArguments = extension.constructorArguments;
          } else {
            extended.constructorArguments = {};
            for ( var constructorArgumentName in base.constructorArguments) {
              if (base.constructorArguments
                  .hasOwnProperty(constructorArgumentName)) {
                extended.constructorArguments[constructorArgumentName] = base.constructorArguments[constructorArgumentName];
              }
            }
          }
          // constructorOrder
          if (extension.constructorOrder) {
            extended.constructorOrder = extension.constructorOrder;
          } else {
            extended.constructorOrder = [];
            for ( var index = 0; index < base.constructorOrder.length; index++) {
              extended.constructorOrder[index] = base.constructorOrder[index];
            }
          }

          // afterInstancePopulated
          if (extension.afterInstancePopulated) {
            extended.afterInstancePopulated = extension.afterInstancePopulated;
          } else if (base.afterInstancePopulated) {
            extended.afterInstancePopulated = base.afterInstancePopulated;
          } else {
            extended.afterInstancePopulated = null;
          }

          var copy = function(source, target) {
            for ( var name in source) {
              if (source.hasOwnProperty(name))
              {
                target[name] = source[name];
              }
            }
          };

          var merge = function(base, extension, extended) {
            if (base) {
              copy(base, extended);
            }
            if (extension) {
              copy(extension, extended);
            }
          };
          // options
          if (base.options || extension.options) {
            extended.options = {};
            merge(base.options, extension.options, extended.options);
          } else {
            extended.options = null;
          }

          // fields
          extended.fields = {};
          merge(base.fields, extension.fields, extended.fields);
          // properties
          extended.properties = {};
          merge(base.properties, extension.properties, extended.properties);
          return new Legato.Beans.ComplexType(name, qName, extended);
        },
        Components : function() {
          return new Legato.Beans.ComplexType.Components(this);
        },
        define : function(definition) {
          return new Legato.Beans.BeanDefinition(this, definition);
        }
        });

Legato.Beans.ComplexType.Components = Legato.Lang.Class(
    Legato.Beans.ComplexType, {
      initialize : function(type) {
        var name = type.typeName + '.Components';
        var qName = new Legato.XML.QName(type.qName.namespaceURI,
            type.qName.localPart + '-Components', type.qName.prefix);

        var definition = {
          _constructor :Object,
          constructorArguments : {},
          constructorOrder : [],
          fields : {},
          properties : {}
        };
        for ( var componentName in type.components) {
          if (type.components.hasOwnProperty(componentName)) {
            definition.fields[componentName] = type.components[componentName];
          }
        }
        Legato.Beans.ComplexType.prototype.initialize.apply(this, [ name,
            qName, definition ]);
      }
    });

Legato.Beans.ComplexType.types = {};
Legato.Beans.ComplexType.registerTypeNS = function(type, namespaceURI,
    localPart) {
  var qNameAsString = (namespaceURI == '' ? '' : '{' + namespaceURI + '}')
      + localPart;
  Legato.Beans.ComplexType.types[qNameAsString] = type;
};
Legato.Beans.ComplexType.getTypeNS = function(namespaceURI, localPart) {
  var qNameAsString = (namespaceURI == '' ? '' : '{' + namespaceURI + '}')
      + localPart;
  return Legato.Beans.ComplexType.types[qNameAsString];
};