/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.procedure;

import java.util.List;
import net.disy.ogc.wps.v_1_0_0.model.CRS;
import net.disy.ogc.wps.v_1_0_0.model.DataType;
import net.disy.ogc.wps.v_1_0_0.model.DataTypeTypeVisitor;
import net.disy.ogc.wps.v_1_0_0.procedure.AbstractDataInputOutputBuilder;
import net.disy.ogc.wps.v_1_0_0.procedure.OutputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.procedure.WpsProcessContext;
import net.disy.ogc.wps.v_1_0_0.util.WpsUtils;
import net.opengis.ows.v_1_1_0.DomainMetadataType;
import net.opengis.ows.v_1_1_0.MetadataType;
import net.opengis.wps.v_1_0_0.CRSsType;
import net.opengis.wps.v_1_0_0.LiteralOutputType;
import net.opengis.wps.v_1_0_0.OutputDescriptionType;
import net.opengis.wps.v_1_0_0.ProcessDescriptionType;
import net.opengis.wps.v_1_0_0.SupportedCRSsType;
import net.opengis.wps.v_1_0_0.SupportedComplexDataType;

public class ProcessOutputDescriptionBuilder
extends AbstractDataInputOutputBuilder {
    private final ProcessDescriptionType.ProcessOutputs processOutputs = this.getContext().getWpsObjectFactory().createProcessDescriptionTypeProcessOutputs();

    public ProcessOutputDescriptionBuilder(WpsProcessContext context) {
        super(context);
    }

    public ProcessDescriptionType.ProcessOutputs getProcessOutputs() {
        return this.processOutputs;
    }

    public void addOutput(OutputParameterDescription outputParameter) {
        this.processOutputs.getOutput().add(this.getOutputDescription(outputParameter));
    }

    private OutputDescriptionType getOutputDescription(OutputParameterDescription outputParameter) {
        final OutputDescriptionType output = this.getContext().getWpsObjectFactory().createOutputDescriptionType();
        output.setIdentifier(WpsUtils.createCodeType(outputParameter.getId()));
        output.setTitle(WpsUtils.createLanguageStringType(outputParameter.getTitle()));
        output.setAbstract(WpsUtils.createLanguageStringType(outputParameter.getAbstract()));
        List<MetadataType> metadata = outputParameter.getMetadata();
        if (!metadata.isEmpty()) {
            output.setMetadata(metadata);
        }
        final DataType<?> dataType = this.getContext().getDataTypeHelper().getDataType(outputParameter, outputParameter.getParameterClass());
        dataType.getType().accept(new DataTypeTypeVisitor(){

            @Override
            public void visitLiteral() {
                ProcessOutputDescriptionBuilder.this.addLiteralOutput(output, dataType);
            }

            @Override
            public void visitComplex() {
                ProcessOutputDescriptionBuilder.this.addComplexOutput(output, dataType);
            }

            @Override
            public void visitBBox() {
                ProcessOutputDescriptionBuilder.this.addBoundingBoxOutput(output, dataType);
            }
        });
        return output;
    }

    private void addLiteralOutput(OutputDescriptionType output, DataType<?> dataType) {
        LiteralOutputType literalOutput = this.getContext().getWpsObjectFactory().createLiteralOutputType();
        DomainMetadataType metadataType = this.getMetaDataType(dataType);
        literalOutput.setDataType(metadataType);
        output.setLiteralOutput(literalOutput);
    }

    private void addComplexOutput(OutputDescriptionType output, DataType<?> dataType) {
        SupportedComplexDataType complexOutput = this.getContext().getWpsObjectFactory().createSupportedComplexDataType();
        output.setComplexOutput(complexOutput);
        this.addDataCombinations(dataType, complexOutput);
    }

    private void addBoundingBoxOutput(OutputDescriptionType output, DataType<?> dataType) {
        SupportedCRSsType supportedCRSsType = this.getContext().getWpsObjectFactory().createSupportedCRSsType();
        output.setBoundingBoxOutput(supportedCRSsType);
        SupportedCRSsType.Default defaultCRS = this.getContext().getWpsObjectFactory().createSupportedCRSsTypeDefault();
        supportedCRSsType.setDefault(defaultCRS);
        defaultCRS.setCRS(this.getContext().getCRSRegistry().getDefaultCRS().getName());
        CRSsType supportedCRSs = this.getContext().getWpsObjectFactory().createCRSsType();
        for (CRS supportedCRS : this.getContext().getCRSRegistry().getSupportedCRSs()) {
            supportedCRSs.getCRS().add(supportedCRS.getName());
        }
        supportedCRSsType.setSupported(supportedCRSs);
    }
}

