/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.procedure;

import java.lang.reflect.Array;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import net.disy.ogc.ows.v_1_1_0.OwsException;
import net.disy.ogc.wps.v_1_0_0.procedure.InputArgumentBuilder;
import net.disy.ogc.wps.v_1_0_0.procedure.InputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.procedure.OutputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.procedure.ProcedureWpsProcessDescriptionFactory;
import net.disy.ogc.wps.v_1_0_0.procedure.ProcessOutputBuilder;
import net.disy.ogc.wps.v_1_0_0.procedure.WpsProcedure;
import net.disy.ogc.wps.v_1_0_0.procedure.WpsProcessContext;
import net.disy.ogc.wps.v_1_0_0.util.WpsUtils;
import net.opengis.wps.v_1_0_0.DataInputsType;
import net.opengis.wps.v_1_0_0.ExecuteResponse;
import net.opengis.wps.v_1_0_0.InputType;
import net.opengis.wps.v_1_0_0.ObjectFactory;
import net.opengis.wps.v_1_0_0.OutputDefinitionsType;
import net.opengis.wps.v_1_0_0.OutputDescriptionType;
import net.opengis.wps.v_1_0_0.ProcessDescriptionType;
import net.opengis.wps.v_1_0_0.ResponseFormType;
import net.opengis.wps.v_1_0_0.StatusType;

public class ProcedureWpsProcessExecutor {
    private final WpsProcessContext context;

    public ProcedureWpsProcessExecutor(WpsProcessContext context) {
        this.context = context;
    }

    public ExecuteResponse execute(DataInputsType dataInputs, ResponseFormType responseForm, WpsProcedure processHelper) throws OwsException {
        ProcedureWpsProcessDescriptionFactory processDescriptionFactory = new ProcedureWpsProcessDescriptionFactory(this.context);
        ProcessDescriptionType processDescription = processDescriptionFactory.createProcessDescription(processHelper);
        ExecuteResponse executeResponse = this.createResponse(processDescription, responseForm, dataInputs);
        Object[] arguments = this.getArguments(processHelper, dataInputs);
        Object result = processHelper.execute(arguments);
        executeResponse.setProcessOutputs(this.getOutputs(processHelper, processDescription, result));
        return executeResponse;
    }

    private ExecuteResponse createResponse(ProcessDescriptionType processDescription, ResponseFormType responseForm, DataInputsType dataInputs) {
        boolean lineage;
        ObjectFactory wpsObjectFactory = this.context.getWpsObjectFactory();
        ExecuteResponse executeResponse = wpsObjectFactory.createExecuteResponse();
        executeResponse.setService("WPS");
        executeResponse.setVersion("1.0.0");
        executeResponse.setProcess(WpsUtils.createBriefDescription(processDescription));
        StatusType status = wpsObjectFactory.createStatusType();
        status.setProcessSucceeded("Ok.");
        try {
            status.setCreationTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        }
        catch (DatatypeConfigurationException ignored) {
            // empty catch block
        }
        executeResponse.setStatus(status);
        boolean bl = lineage = responseForm != null && responseForm.getResponseDocument() != null && responseForm.getResponseDocument().isLineage();
        if (lineage) {
            executeResponse.setDataInputs(dataInputs);
            if (!responseForm.getResponseDocument().getOutput().isEmpty()) {
                OutputDefinitionsType outputDefinitions = wpsObjectFactory.createOutputDefinitionsType();
                outputDefinitions.getOutput().addAll(responseForm.getResponseDocument().getOutput());
                executeResponse.setOutputDefinitions(outputDefinitions);
            }
        }
        executeResponse.setLang(Locale.GERMAN.toString());
        return executeResponse;
    }

    private Object[] getArguments(WpsProcedure processHelper, DataInputsType dataInputs) {
        List<InputParameterDescription> inputParameters = processHelper.getInputParameters();
        InputArgumentBuilder argumentBuilder = new InputArgumentBuilder(this.context);
        argumentBuilder.setInputParameters(inputParameters);
        if (dataInputs != null) {
            for (InputType input : dataInputs.getInput()) {
                argumentBuilder.addInput(input);
            }
        }
        return argumentBuilder.getArguments();
    }

    private ExecuteResponse.ProcessOutputs getOutputs(WpsProcedure processHelper, ProcessDescriptionType processDescription, Object result) {
        ProcessOutputBuilder processOutputBuilder = new ProcessOutputBuilder(this.context);
        List outputDescriptions = processDescription.getProcessOutputs().getOutput();
        if (outputDescriptions.size() == 0) {
            return processOutputBuilder.getProcessOutputs();
        }
        OutputDescriptionType outputDescription = (OutputDescriptionType)outputDescriptions.get(0);
        OutputParameterDescription outputParameter = processHelper.getOutputParameters().get(0);
        Class<?> outputClass = outputParameter.getParameterClass();
        if (result == null || !outputClass.isArray()) {
            processOutputBuilder.addOutput(outputDescription, outputParameter, outputClass, result);
        } else {
            for (int i = 0; i < Array.getLength(result); ++i) {
                processOutputBuilder.addOutput(outputDescription, outputParameter, outputClass.getComponentType(), Array.get(result, i));
            }
        }
        return processOutputBuilder.getProcessOutputs();
    }
}

