/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.converter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBElement;
import net.disy.ogc.wps.v_1_0_0.converter.AbstractConverter;
import net.disy.ogc.wps.v_1_0_0.converter.TypeConverter;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class SingleJAXBElementTypeConverter<V, D>
extends AbstractConverter<List<Object>, D> {
    private TypeConverter<JAXBElement<? extends V>, D> jaxbElementTypeConverter;

    public SingleJAXBElementTypeConverter(TypeConverter<JAXBElement<? extends V>, D> jaxbElementTypeConverter) {
        Validate.notNull(jaxbElementTypeConverter);
        this.jaxbElementTypeConverter = jaxbElementTypeConverter;
    }

    @Override
    protected List<Object> convertFromNotNull(D source) {
        return Collections.singletonList(this.jaxbElementTypeConverter.convertFrom(source));
    }

    @Override
    protected D convertToNotNull(List<Object> source) {
        Collection sourceWithoutWhitespaceStrings = CollectionUtils.select(source, (Predicate)new Predicate<Object>(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof String) {
                    return !StringUtils.isWhitespace((String)((String)object));
                }
                return true;
            }
        });
        if (sourceWithoutWhitespaceStrings.size() != 1) {
            throw new IllegalArgumentException("Source list must have exactly one JAXB element.");
        }
        Object item = sourceWithoutWhitespaceStrings.iterator().next();
        if (item instanceof JAXBElement) {
            JAXBElement element = (JAXBElement)item;
            return this.jaxbElementTypeConverter.convertTo(element);
        }
        throw new IllegalArgumentException("Source list must have exactly one JAXB element.");
    }

    @Override
    public Class<D> getDestinationClass() {
        return this.jaxbElementTypeConverter.getDestinationClass();
    }

    @Override
    public Class<List<Object>> getSourceClass() {
        Class<List> theClass;
        Class<List> sourceClass = theClass = List.class;
        return sourceClass;
    }
}

