/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.converter;

import net.disy.ogc.wps.v_1_0_0.converter.TypeConverter;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;

public class PrimitiveTypeConverter<T>
implements TypeConverter<T, T> {
    private final Class<T> sourceClass;
    private final Class<T> destinationClass;

    public PrimitiveTypeConverter(Class<T> primitiveClass) {
        Class wrapperClass;
        Validate.notNull(primitiveClass);
        Validate.isTrue((boolean)primitiveClass.isPrimitive(), (String)("The class [" + primitiveClass + "] is not a primitive class."));
        this.sourceClass = wrapperClass = ClassUtils.primitiveToWrapper(primitiveClass);
        this.destinationClass = primitiveClass;
    }

    @Override
    public T convertFrom(T value) {
        Validate.notNull(value);
        return value;
    }

    @Override
    public T convertTo(T value) {
        Validate.notNull(value);
        return value;
    }

    @Override
    public Class<T> getDestinationClass() {
        return this.destinationClass;
    }

    @Override
    public Class<T> getSourceClass() {
        return this.sourceClass;
    }
}

