/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import net.disy.ogc.ows.v_1_1_0.OwsException;
import net.disy.ogc.wps.v_1_0_0.WpsConstants;
import net.disy.ogc.wps.v_1_0_0.WpsOperations;
import net.opengis.wps.v_1_0_0.DescribeProcess;
import net.opengis.wps.v_1_0_0.Execute;
import net.opengis.wps.v_1_0_0.ExecuteResponse;
import net.opengis.wps.v_1_0_0.GetCapabilities;
import net.opengis.wps.v_1_0_0.ProcessDescriptions;
import net.opengis.wps.v_1_0_0.WPSCapabilitiesType;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingWpsOperationdDecorator
implements WpsOperations {
    private static Log logger = LogFactory.getLog(WpsOperations.class);
    private final WpsOperations wpsOperations;
    private final JAXBContext context;

    public LoggingWpsOperationdDecorator(WpsOperations wpsOperations, JAXBContext context) {
        Validate.notNull((Object)wpsOperations);
        Validate.notNull((Object)context);
        this.wpsOperations = wpsOperations;
        this.context = context;
    }

    public WpsOperations getWpsOperations() {
        return this.wpsOperations;
    }

    public JAXBContext getContext() {
        return this.context;
    }

    @Override
    public WPSCapabilitiesType getCapabilities(GetCapabilities input) throws IOException, OwsException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Incoming wps:GetCapabilities request:\n" + this.marshal(input)));
        }
        WPSCapabilitiesType capabilities = this.getWpsOperations().getCapabilities(input);
        JAXBElement output = new JAXBElement(new QName("http://www.opengis.net/wps/1.0.0", "Capabilities"), WPSCapabilitiesType.class, (Object)capabilities);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Outgoing wps:Capabilities response:\n" + this.marshal(output)));
        }
        return (WPSCapabilitiesType)output.getValue();
    }

    @Override
    public ProcessDescriptions describeProcess(DescribeProcess input) throws IOException, OwsException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Incoming wps:DescribeProcess request:\n" + this.marshal(input)));
        }
        ProcessDescriptions output = this.getWpsOperations().describeProcess(input);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Outgoing wps:ProcessDescriptions response:\n" + this.marshal(output)));
        }
        return output;
    }

    @Override
    public ExecuteResponse execute(Execute input) throws IOException, OwsException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Incoming wps:Execute request:\n" + this.marshal(input)));
        }
        ExecuteResponse output = this.getWpsOperations().execute(input);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Outgoing wps:ExecuteResponse response:\n" + this.marshal(output)));
        }
        return output;
    }

    private String marshal(Object object) {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = this.getContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)WpsConstants.NAMESPACE_PREFIX_MAPPER);
            marshaller.marshal(object, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (Exception ex) {
            logger.warn((Object)("Could not marshall the object [" + object + "]."), (Throwable)ex);
            return "Could not marshall the object.";
        }
    }
}

