/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0;

import java.util.Collections;
import java.util.Locale;
import net.disy.commons.servlet.util.UrlProvider;
import net.disy.ogc.wps.v_1_0_0.DefaultDescribeProcessService;
import net.disy.ogc.wps.v_1_0_0.DefaultExecuteService;
import net.disy.ogc.wps.v_1_0_0.DefaultGetCapabilitiesService;
import net.disy.ogc.wps.v_1_0_0.DefaultOperationsMetadataFactory;
import net.disy.ogc.wps.v_1_0_0.DefaultWpsOperations;
import net.disy.ogc.wps.v_1_0_0.WpsOperations;
import net.disy.ogc.wps.v_1_0_0.WpsProcessRegistry;
import net.opengis.ows.v_1_1_0.ServiceIdentification;
import net.opengis.ows.v_1_1_0.ServiceProvider;

public class DefaultWpsOperationsFactory {
    private final ServiceIdentification serviceIdentification;
    private final ServiceProvider serviceProvider;
    private Locale defaultLanguage = Locale.ENGLISH;
    private final WpsProcessRegistry wpsProcessRegistry;
    private final String servletName;

    public DefaultWpsOperationsFactory(ServiceIdentification serviceIdentification, ServiceProvider serviceProvider, Locale defaultLocale, WpsProcessRegistry processRegistry, String servletName) {
        this.serviceIdentification = serviceIdentification;
        this.serviceProvider = serviceProvider;
        this.defaultLanguage = defaultLocale;
        this.wpsProcessRegistry = processRegistry;
        this.servletName = servletName;
    }

    public ServiceIdentification getServiceIdentification() {
        return this.serviceIdentification;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public Locale getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public WpsProcessRegistry getWpsProcessRegistry() {
        return this.wpsProcessRegistry;
    }

    public WpsOperations createWpsOperations(UrlProvider urlProvider) {
        DefaultGetCapabilitiesService getCapabilitiesService = new DefaultGetCapabilitiesService();
        getCapabilitiesService.setWpsProcessRegistry(this.getWpsProcessRegistry());
        getCapabilitiesService.setDefaultLanguage(this.getDefaultLanguage());
        getCapabilitiesService.setSupportedLanguages(Collections.singletonList(this.getDefaultLanguage()));
        getCapabilitiesService.setOperationsMetadata(new DefaultOperationsMetadataFactory(urlProvider.getUrl(this.servletName)).createOperationsMetadata());
        getCapabilitiesService.setServiceIdentification(this.getServiceIdentification());
        getCapabilitiesService.setServiceProvider(this.getServiceProvider());
        DefaultDescribeProcessService describeProcessService = new DefaultDescribeProcessService();
        describeProcessService.setWpsProcessRegistry(this.getWpsProcessRegistry());
        describeProcessService.setDefaultLanguage(this.getDefaultLanguage());
        DefaultExecuteService executeService = new DefaultExecuteService(urlProvider.getUrl(this.servletName));
        executeService.setWpsProcessRegistry(this.getWpsProcessRegistry());
        DefaultWpsOperations wpsOperations = new DefaultWpsOperations();
        wpsOperations.setGetCapabilitiesService(getCapabilitiesService);
        wpsOperations.setDescribeProcessService(describeProcessService);
        wpsOperations.setExecuteService(executeService);
        return wpsOperations;
    }
}

