/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.tools.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import net.disy.legato.tools.util.PropertiesMapPersister;

public class DefaultMapPersister
implements PropertiesMapPersister {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public void load(Map<String, String> props, InputStream inStream) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        LineReader lr = new LineReader(inStream);
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (c == '=' && !precedingBackslash) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            props.put(key, value);
        }
    }

    @Override
    public void load(Map<String, String> props, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if ((line = DefaultMapPersister.trimLeadingWhitespace(line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (this.endsWithContinuationMarker(line)) {
                String nextLine = in.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = line + DefaultMapPersister.trimLeadingWhitespace(nextLine);
            }
            int separatorIndex = line.indexOf("=");
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = DefaultMapPersister.trimTrailingWhitespace(key);
            value = DefaultMapPersister.trimLeadingWhitespace(value);
            props.put(this.unescape(key), this.unescape(value));
        }
        return;
    }

    protected boolean endsWithContinuationMarker(String line) {
        boolean evenSlashCount = true;
        for (int index = line.length() - 1; index >= 0 && line.charAt(index) == '\\'; --index) {
            evenSlashCount = !evenSlashCount;
        }
        return !evenSlashCount;
    }

    protected String unescape(String str) {
        StringBuffer outBuffer = new StringBuffer(str.length());
        int index = 0;
        while (index < str.length()) {
            int c;
            if ((c = str.charAt(index++)) == 92) {
                if ((c = str.charAt(index++)) == 116) {
                    c = 9;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 102) {
                    c = 12;
                }
            }
            outBuffer.append((char)c);
        }
        return outBuffer.toString();
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    @Override
    public void store(Map<String, String> props, OutputStream out, String header) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            DefaultMapPersister.writeln(awriter, "#" + header);
        }
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String key = this.saveConvert(entry.getKey(), true);
            String val = this.saveConvert(entry.getValue(), false);
            DefaultMapPersister.writeln(awriter, key + "=" + val);
        }
        awriter.flush();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(DefaultMapPersister.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(DefaultMapPersister.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(DefaultMapPersister.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(DefaultMapPersister.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    @Override
    public void store(Map<String, String> props, Writer writer, String header) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        if (header != null) {
            out.write("#" + header);
            out.newLine();
        }
        out.write("#" + new Date());
        out.newLine();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            out.write(this.escape(key, true) + "=" + this.escape(val, false));
            out.newLine();
        }
        out.flush();
    }

    protected String escape(String str, boolean isKey) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int index = 0; index < len; ++index) {
            char c = str.charAt(index);
            switch (c) {
                case ' ': {
                    if (index == 0 || isKey) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    outBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    outBuffer.append("\\n");
                    continue block8;
                }
                case '\r': {
                    outBuffer.append("\\r");
                    continue block8;
                }
                case '\f': {
                    outBuffer.append("\\f");
                    continue block8;
                }
                default: {
                    if ("=: \t\r\n\f#!".indexOf(c) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(c);
                }
            }
        }
        return outBuffer.toString();
    }

    private static String trimLeadingWhitespace(String str) {
        if (!DefaultMapPersister.hasLength(str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    private static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    private static String trimTrailingWhitespace(String str) {
        if (!DefaultMapPersister.hasLength(str)) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    class LineReader {
        byte[] inBuf = new byte[8192];
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        return len;
                    }
                }
                c = (char)(0xFF & this.inBuf[this.inOff++]);
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

