/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.tools.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final List<String> allowedUrls = new LinkedList<String>();

    public void init() throws ServletException {
        String allowedUrlsParameter = this.getServletConfig().getInitParameter("allowedUrls");
        if (allowedUrlsParameter != null) {
            String[] urls;
            for (String url : urls = allowedUrlsParameter.split(",")) {
                String trimmedUrl = url.trim();
                if (!this.isValidUrl(trimmedUrl)) continue;
                this.allowedUrls.add(trimmedUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String url = req.getParameter("url");
        if (!this.isAllowed(url)) {
            resp.setStatus(403);
            return;
        }
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        method.setFollowRedirects(true);
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != -1) {
                String contents = method.getResponseBodyAsString();
                resp.getOutputStream().print(contents);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private boolean isValidUrl(String urlString) {
        try {
            URI uri = new URI(urlString);
            return uri.getHost() != null && !"".equals(uri.getHost());
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private boolean isAllowed(String urlString) {
        try {
            URI uri = new URI(urlString);
            String startUrl = uri.normalize().toString();
            for (String allowedPrefix : this.allowedUrls) {
                if (!startUrl.startsWith(allowedPrefix)) continue;
                return true;
            }
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block18: {
            String url = req.getParameter("url");
            if (!this.isAllowed(url)) {
                resp.setStatus(403);
                return;
            }
            HttpClient client = new HttpClient();
            client.getParams().setVersion(HttpVersion.HTTP_1_0);
            PostMethod method = new PostMethod(url);
            method.getParams().setVersion(HttpVersion.HTTP_1_0);
            method.setFollowRedirects(false);
            InputStreamRequestEntity entity = new InputStreamRequestEntity((InputStream)req.getInputStream());
            method.setRequestEntity((RequestEntity)entity);
            try {
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode == -1) break block18;
                InputStream is = null;
                ServletOutputStream os = null;
                try {
                    is = method.getResponseBodyAsStream();
                    try {
                        os = resp.getOutputStream();
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.flush();
                            }
                            catch (IOException ignored) {}
                        }
                    }
                }
                catch (IOException ioex) {
                    String message = ioex.getMessage();
                    if (!"chunked stream ended unexpectedly".equals(message)) {
                        throw ioex;
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            finally {
                method.releaseConnection();
            }
        }
    }
}

