/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import com.vividsolutions.jts.geom.Coordinate;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import org.jvnet.ogc.gml.v_3_1_1.ObjectFactoryInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311SRSReferenceGroupConverterInterface;

public class JTSToGML311CoordinateConverter {
    private final ObjectFactoryInterface objectFactory;
    private final JTSToGML311SRSReferenceGroupConverterInterface srsReferenceGroupConverter;

    public JTSToGML311CoordinateConverter(ObjectFactoryInterface objectFactory, JTSToGML311SRSReferenceGroupConverterInterface srsReferenceGroupConverter) {
        this.objectFactory = objectFactory;
        this.srsReferenceGroupConverter = srsReferenceGroupConverter;
    }

    public DirectPositionType convertCoordinate(Coordinate coordinate) {
        DirectPositionType directPosition = this.objectFactory.createDirectPositionType();
        directPosition.getValue().add(coordinate.x);
        directPosition.getValue().add(coordinate.y);
        if (!Double.isNaN(coordinate.z)) {
            directPosition.getValue().add(coordinate.z);
        }
        return directPosition;
    }

    public DirectPositionType[] convertCoordinates(Coordinate[] coordinates) {
        if (coordinates == null) {
            return null;
        }
        DirectPositionType[] directPositions = new DirectPositionType[coordinates.length];
        for (int index = 0; index < coordinates.length; ++index) {
            directPositions[index] = this.convertCoordinate(coordinates[index]);
        }
        return directPositions;
    }
}

