/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.directwebremoting.Container;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.WebContext;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.impl.DefaultServerContext;
import org.directwebremoting.util.SwallowingHttpServletResponse;
import org.directwebremoting.util.VersionUtil;

public class DefaultWebContext
extends DefaultServerContext
implements WebContext {
    private String scriptSessionId = null;
    private String page = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;

    public DefaultWebContext(HttpServletRequest request, HttpServletResponse response, ServletConfig config, ServletContext context, Container container) {
        super(config, context, container);
        this.request = request;
        this.response = response;
    }

    public void setCurrentPageInformation(String page, String scriptSessionId) {
        this.scriptSessionId = scriptSessionId;
        this.page = page;
    }

    public String getCurrentPage() {
        return this.page;
    }

    public ScriptSession getScriptSession() {
        ScriptSessionManager manager = this.getScriptSessionManager();
        RealScriptSession scriptSession = manager.getScriptSession(this.scriptSessionId);
        manager.setPageForScriptSession(scriptSession, this.page);
        return scriptSession;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    public String forwardToString(String url) throws ServletException, IOException {
        StringWriter sout = new StringWriter();
        StringBuffer buffer = sout.getBuffer();
        HttpServletResponse realResponse = this.getHttpServletResponse();
        SwallowingHttpServletResponse fakeResponse = new SwallowingHttpServletResponse(realResponse, sout, realResponse.getCharacterEncoding());
        HttpServletRequest realRequest = this.getHttpServletRequest();
        realRequest.setAttribute("org.directwebremoting", (Object)Boolean.TRUE);
        this.getServletContext().getRequestDispatcher(url).forward((ServletRequest)realRequest, (ServletResponse)fakeResponse);
        return buffer.toString();
    }

    public String getVersion() {
        return VersionUtil.getVersion();
    }
}

