/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Message = OpenLayers.Class(WPS.Result, {
  message : null,
  initialize : function(id, message, options) {
    WPS.Result.prototype.initialize.apply(this, [ id, options ]);
    Legato.Util.Ensure.ensureExists(message, 'message should be defined');
    // Text
    if (Legato.Lang.ObjectUtils.isString(message)) {
      this.message = message;
    }
    // Hypertext
    else if (Legato.Lang.ObjectUtils.exists(message.nodeType)) {
      var format = new OpenLayers.Format.XML();
      this.message = format.write(message);
    } else {
      throw new Legato.Lang.Exception('Unsupported message content.');
    }
  },

  execute : function() {
    if (!Legato.Lang.ObjectUtils.isFunction(this.popupCallback)) {
      alert(this.message);
      return;
    }

    if (Legato.Lang.ObjectUtils.exists(this.type) && this.type === 'error') {
      this.errorCallback(this.createContent());
    }

    this.popupCallback(this.createContent());
  },

  createResultContainer: function(){
    var resultContainer = document.createElement('div');
    resultContainer.id = this.id;

    var resultTitle = document.createElement('div');
    resultTitle.className = 'wpsResultTitle';
    resultTitle.innerHTML = this.title;

    var resultAbstract = document.createElement('div');
    resultAbstract.className = 'wpsResultAbstract';
    resultAbstract.innerHTML = this.description;

    resultContainer.appendChild(resultTitle);
    resultContainer.appendChild(resultAbstract);

    return resultContainer;
  },

  createContent : function() {
    var resultContainer = this.createResultContainer();

    if (!Legato.Lang.ObjectUtils.isString(this.message)) {
      resultContainer.appendChild(this.message);
      return resultContainer;
    }

    var resultMessageContainer = document.createElement('div');
    resultMessageContainer.className = 'wpsResult';

    var resultMessage = document.createElement('textarea');
    resultMessage.value = this.message;
    resultMessage.readOnly = 'readOnly';
    resultMessage.cols = 68;
    resultMessage.rows = 10;
    resultMessage.onclick = function(){
      this.select();
    };

    if (Legato.Lang.ObjectUtils.exists(this.type)) {
      OpenLayers.Element.addClass(resultMessage, this.type);
    }

    resultMessageContainer.appendChild(resultMessage);
    resultContainer.appendChild(resultMessageContainer);

    return resultContainer;
  },

  destroy : function() {
    this.message = null;
    WPS.Result.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME : 'WPS.Result.Message'
});

WPS.Result.Message.LiteralFactory = OpenLayers.Class(
    WPS.Result.SimpleFactory, {

      createResult : function(id, outputData, options) {
        return new WPS.Result.Message(id, outputData.data.literalData.value,
            options);
      },

      CLASS_NAME : 'WPS.Result.Message.LiteralFactory'
    });

WPS.Result.Message.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {

      schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Message',

      name : new Legato.XML.QName('http://www.disy.net/pd', 'Message', 'pd'),

      createResult : function(id, outputData, options) {
        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;

        if (Legato.Lang.ObjectUtils.exists(value.type)
            && Legato.Lang.ObjectUtils.isString(value.type)) {
          options.type = value.type;
        } else {
          options.type = 'none';
        }

        return new WPS.Result.Message(id, value.content, options);
      },
      CLASS_NAME : 'WPS.Result.Message.ComplexFactory'
    });