/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: WPS.Control.ToggleWpsForm
 *
 * Switches WPS form on and off
 *
 * Inherits from:
 * - <Legato.Control>
 *
 */
WPS.Control.GeoControlSync = OpenLayers.Class(WPS.Control, {

  form: null,
  initialize : function(options) {
    if (! options.displayClass) {
      options.displayClass = 'LegatoControlInvisible';
    }
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.events.on({
        'geoInputActivation': this.geoInputActivated,
        scope: this
      });
    }
  },

  geoInputActivated: function() {
    Legato.Util.fireDOMEvent(this.panel_div, "click");
  },

  destroy: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.events.un({
        'geoInputActivation': this.activate,
        scope: this
      });
    }
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },


  /** Function: activate
   * Invoked when the control is activated in toggle mode
   */
  activate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.activate();
    }
    WPS.Control.prototype.activate.apply(this, arguments);
  },

  /** Function: deactivate
   * Invoked when the control is deactivated in toggle mode
   */
  deactivate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.deactivate();
    }
    WPS.Control.prototype.deactivate.apply(this, arguments);
  },

  CLASS_NAME :"WPS.Control.GeoControlSync"
});

/**
 * Structure: wpc:ToggleWpsForm
 * XML based config for a <WPS.Control.GeoControlSync>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ToggleDiv would be:
 * (start code)
 * <lwpsc:GeoControlSync>
 * <form>
 * <lb:Reference target="WpsForm" />
 * </form>
 * </lwpsc:GeoControlSync>
 * (end)
 */
WPS.Control.GeoControlSync.Bean = WPS.Control.Bean.Extend(
  'WPS.Control.GeoControlSync',
  //
  WPS.Control.QName('GeoControlSync'),
  //
  {
    _constructor : WPS.Control.GeoControlSync,
    options:
    {
      form: WPS.Form
    }
});
