/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.Factory = OpenLayers.Class({
  map : null,
  options : null,
  initialize : function(map, options) {
    Legato.Util.Ensure.ensureExists(map, "map should be defined");
    this.map = map;
    if (Legato.Lang.ObjectUtils.isObject(options)) {
      this.options = options;
    } else {
      this.options = {};
    }
  },
  createComponent : function(model) {
    var id = OpenLayers.Util.createUniqueID('WPS_Component_');
    if ('WPS.Model.Literal' === model.CLASS_NAME) {
      return new WPS.Component.Literal(id, model, this.map, this.options);
    } else if ('WPS.Model.Geo' === model.CLASS_NAME) {
      switch (model.getSchema()) {
      case WPS.GEOM_POINT_URI:
        return new WPS.Component.Point(id, model, this.map, this.options);
      case WPS.GEOM_LINE_STRING_URI:
        return new WPS.Component.LineString(id, model, this.map, this.options);
      case WPS.GEOM_POLYGON_URI:
        return new WPS.Component.Polygon(id, model, this.map, this.options);
      default:
        throw new Legato.Lang.Exception("Unsupported geo model type [" + model.getSchema() + "]");
      }
    } else {
      throw new Legato.Lang.Exception("Unsupported model.");
    }
  },
  destroy : function() {
  },
  CLASS_NAME : 'WPS.Component.Factory'
});