/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Hack
OpenLayers.Map.prototype.EVENT_TYPES.push('legato.refresh');
OpenLayers.Map.prototype.EVENT_TYPES.push('legato.selectlayer');
OpenLayers.Map.prototype.EVENT_TYPES.push('legato.deselectlayer');
OpenLayers.Map.prototype.EVENT_TYPES.push('legato.selectobjects');

// Hack
OpenLayers.Map.prototype.setLayerZIndex = function(layer, zIdx) {
	if (Legato.Lang.ObjectUtils.isTrue(layer.isFeatureLayer)) {
		layer.setZIndex(this.Z_INDEX_BASE.Feature + zIdx * 5);

	} else if (Legato.Lang.ObjectUtils.isTrue(layer.isBaseLayer)) {
		layer.setZIndex(this.Z_INDEX_BASE.BaseLayer + zIdx * 5);

	} else {
		layer.setZIndex(this.Z_INDEX_BASE.Overlay + zIdx * 5);
	}
};

Legato.OpenLayers.Map = {};

/**
 * Component: ol:Map
 * Configuration component for {<OpenLayers.Map>}.
 * 
 * See also:
 * - <ol> namespace
 * - {<OpenLayers.Map>}
 */
OpenLayers.Map.Bean = Legato.Beans.Object.Extend('OpenLayers.Map',
		Legato.OpenLayers.QName('Map'),
		//
		{
			factoryFunction : function(id, options) {
				if (!Legato.Lang.ObjectUtils.exists(options)) {
					options = {};
				}
				if (!Legato.Lang.ObjectUtils.exists(options.controls)) {
					options.controls = [];
				}
				if (!Legato.Lang.ObjectUtils.exists(options.theme)) {
					options.theme = null;
				}
				return new OpenLayers.Map(id, options);
			},
			constructorArguments : {
				/**
				 * Element: id
				 * {String}
				 */
				id : Legato.Lang.String
			},
			constructorOrder : [ 'id' ],
			options : {

				/**
				 * Element: projection
				 * {<ol:Projection>}
				 */
				projection : OpenLayers.Projection.Bean,
				// - theme: Legato.Lang.String,
				/**
				 * Element: displayProjection
				 * {<ol:Projection>}
				 */
				displayProjection : OpenLayers.Projection.Bean,
				/**
				 * Element: initialExtent
				 * {<ol:Bounds>}
				 */
				initialExtent : OpenLayers.Bounds,
				/**
				 * Element: tags
				 * {<lu:Tag> []}
				 */
				tags : Legato.Util.Tag.Bean.List(),
				/**
				 * Element: center
				 * {<ol:LonLat>}
				 */
				center : OpenLayers.LonLat.Bean,
				/**
				 * Element: fractionalZoom
				 * {Boolean}
				 */
				fractionalZoom : Legato.Lang.Boolean,
				/**
				 * Element: div
				 * {DOMElement}
				 */
				div : Legato.Lang.Element,
				/**
				 * Element: dragging
				 * {Boolean}
				 */
				dragging : Legato.Lang.Boolean,
				/**
				 * Element: size
				 * {<ol:Size>}
				 */
				size : OpenLayers.Size.Bean,
				/**
				 * Element: viewPortDiv
				 * {DOMElement}
				 */
				viewPortDiv : Legato.Lang.Element,
				/**
				 * Element: layerContainerDiv
				 * {DOMElement}
				 */
				layerContainerDiv : Legato.Lang.Element,

				// - baseLayer: ???,

				/**
				 * Element: resolution
				 * {Double}
				 */
				resolution : Legato.Lang.Double,

				/**
				 * Element: zoom
				 * {Integer}
				 */
				zoom : Legato.Lang.Integer,

				/**
				 * Element: panRatio
				 * {Double}
				 */
				panRatio : Legato.Lang.Double,

				/**
				 * Element: viewRequestID
				 * {String}
				 */
				viewRequestID : Legato.Lang.String,

				/**
				 * Element: tileSize
				 * {<ol:Size>}
				 */
				tileSize : OpenLayers.Size.Bean,

				/**
				 * Element: units
				 * {String}
				 */
				units : Legato.Lang.String,

				/**
				 * Element: dpi
				 * {Integer}
				 */
				dpi : Legato.Lang.Integer,

				/**
				 * Element: resolutions
				 * {Double[]}
				 */
				resolutions : Legato.Lang['Double[]'],

				/**
				 * Element: maxResolution
				 * {Double[]}
				 */
				maxResolution : Legato.Lang.Double,

				/**
				 * Element: minResolution
				 * {Double[]}
				 */
				minResolution : Legato.Lang.Double,

				/**
				 * Element: maxScale
				 * {Double[]}
				 */
				maxScale : Legato.Lang.Double,

				/**
				 * Element: minScale
				 * {Double}
				 */
				minScale : Legato.Lang.Double,

				/**
				 * Element: minExtent
				 * {<ol:Bounds>}
				 */
				minExtent : OpenLayers.Bounds.Bean,

				/**
				 * Element: maxExtent
				 * {<ol:Bounds>}
				 */
				maxExtent : OpenLayers.Bounds.Bean,

				/**
				 * Element: restrictedExtent
				 * {<ol:Bounds>}
				 */
				restrictedExtent : OpenLayers.Bounds.Bean,

				/**
				 * Element: numZoomLevels
				 * {Integer}
				 */
				numZoomLevels : Legato.Lang.Integer,

				/*
				 * Element: fallThrough
				 * {Boolean}
				 */
				fallThrough : Legato.Lang.Boolean
			},
			properties : {
				/**
				 * Element: layers
				 * {<oll:Layer> []}
				 */
				layers : new Legato.Beans.Property(
						OpenLayers.Layer.Bean.List(), function(map, layers) {
							map.addLayers(layers);
						}),
				/**
				 * Element: controls
				 * {<olc:Control> []}
				 */
				controls : new Legato.Beans.Property(OpenLayers.Control.Bean
						.List(), function(map, controls) {
					for ( var index = 0; index < controls.length; index++) {
						map.addControl(controls[index]);
					}
				})
			},
			afterInstancePopulated : function(map) {
				if (Legato.Lang.ObjectUtils.exists(map.initialExtent)) {
					map.zoomToExtent(map.initialExtent, true);
				}
				map.events.triggerEvent("legato.refresh", {});
			}
		});