/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var LegatoJQuery = {
  singleFile : true
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @requires OpenLayers.js
 */

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @requires OpenLayers.js
 */

(function() {
    var singleFile = (typeof LegatoJQuery == "object" && LegatoJQuery.singleFile);
    /**
     * Relative path of this script.
     */
    var scriptName = (!singleFile) ? "lib/LegatoJQuery.js" : "LegatoJQuery.js";
    var jsFiles = window.LegatoJQuery;

    window.LegatoJQuery = {
        _getScriptLocation: (function() {
            var r = new RegExp("(^|(.*?\\/))(" + scriptName + ")(\\?|$)"),
                s = document.getElementsByTagName('script'),
                src, m, l = "";
            for(var i=0, len=s.length; i<len; i++) {
                src = s[i].getAttribute('src');
                if(src) {
                    m = src.match(r);
                    if(m) {
                        l = m[1];
                        break;
                    }
                }
            }
            return (function() { return l; });
        })()
    };

    if(!singleFile) {
      /**
       * PATCH
       */
      //if (!jsFiles) {
      jsFiles = [
       'LegatoJQuery/Control.js',
       'LegatoJQuery/Control/MapResizer.js',
       'LegatoJQuery/Popup.js',
       'LegatoJQuery/Popup/DialogPopup.js'
      ]; // etc.
      /**
       * PATCHJ
       */
      //}

      // use "parser-inserted scripts" for guaranteed execution order
      // http://hsivonen.iki.fi/script-execution/
      var scriptTags = new Array(jsFiles.length);
      var host = LegatoJQuery._getScriptLocation() + "lib/";
      for (var i=0, len=jsFiles.length; i<len; i++) {
          scriptTags[i] = "<script src='" + host + jsFiles[i] +
                                 "'></script>";
      }
      if (scriptTags.length > 0) {
          document.write(scriptTags.join(""));
      }
    }
})();

/**
 * Constant: VERSION_NUMBER
 */
LegatoJQuery.VERSION_NUMBER = "$Revision: 75646 $";
LegatoJQuery.NAMESPACE_URI = 'http://www.disy.net/legatojquery/';
LegatoJQuery.PREFIX = 'ljq';
LegatoJQuery.QName = function(localPart) {
  return new Legato.XML.QName(LegatoJQuery.NAMESPACE_URI, localPart, LegatoJQuery.PREFIX);
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires LegatoJQuery.js
 * @requires OpenLayers/Control.js
 */

/**
 * Class: LegatoJQuery.Control
 * Abstract base class for all Legato control classes
 *
 * Inherits from:
 *  - <OpenLayers.Control>
 */
LegatoJQuery.Control = OpenLayers.Class(OpenLayers.Control, {
  CLASS_NAME : 'LegatoJQuery.Control'
});

/**
 * Space: lc
 * Namespace for Legato controls.
 */
/*
 * URI: Namespace URI
 * {http://www.disy.net/legato/control}
 */
LegatoJQuery.Control.NAMESPACE_URI = 'http://www.disy.net/legatojquery/control';

/*
 * Prefix: Default prefix
 * {ljqc}
 */
LegatoJQuery.Control.PREFIX = 'ljqc';

LegatoJQuery.Control.QName = function(localPart) {
  return new Legato.XML.QName(LegatoJQuery.Control.NAMESPACE_URI, localPart,
      LegatoJQuery.Control.PREFIX);
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.Control.MapResizer = OpenLayers.Class(OpenLayers.Control, {

  type : OpenLayers.Control.TYPE_TOOL,
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
  },
  draw : function() {
    var div = OpenLayers.Control.prototype.draw.apply(this, arguments);
    return div;
  },
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);
    OpenLayers.Function.bind(jQuery(this.map.div).resizable({
      stop: OpenLayers.Function.bind(this.onMapResized, this)
    }), this);
  },
  onMapResized: function(event, ui){
    this.map.updateSize();
  },
  destroy : function() {
  },
  CLASS_NAME : "LegatoJQuery.Control.MapResizer"
});

/**
 * Component: ljqc:MapResizer
 *
 * The MapResizer control adds resizing capabilities for the OpenLayers map using jQuery.
 *
 * See also:
 * - <ljqc> namespace
 */
LegatoJQuery.Control.MapResizer.Bean = OpenLayers.Control.Bean.Extend(

'LegatoJQuery.Control.MapResizer',

LegatoJQuery.Control.QName('MapResizer'), {
  _constructor : LegatoJQuery.Control.MapResizer,
  options : {
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.Popup = {};

/**
 * Space: ljqpo
 * Namespace for Legato jQuery popups.
 */
/**
 * URI: Namespace URI
 * {http://www.disy.net/legatojquery/popup}
 */
LegatoJQuery.Popup.NAMESPACE_URI = 'http://www.disy.net/legatojquery/popup';
/**
 * Prefix: Default prefix
 * {ljqpo}
 */
LegatoJQuery.Popup.PREFIX = 'ljqpo';
LegatoJQuery.Popup.QName = function(localPart) {
  return new Legato.XML.QName(LegatoJQuery.Popup.NAMESPACE_URI, localPart, LegatoJQuery.Popup.PREFIX);
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.Popup.DialogPopup = OpenLayers.Class(
  Legato.Popup,
  {
    initialize: function(options){
      if(Legato.Lang.ObjectUtils.isNullOrUndefined(jQuery)){
        throw new Legato.Lang.Exception('jQuery is not found');
      }
      Legato.Popup.prototype.initialize.apply(
        this, [options]
      );
      this.dialog = jQuery('<div></div>')
      .html('')
      .dialog({
        autoOpen: false
      });
      this.configureDialog();
    },

    configureDialog: function(){
      this.dialog.dialog( 'option', 'title', this.title );

      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.size)){
        this.dialog.dialog( 'option', 'height', this.size.h );
        this.dialog.dialog( 'option', 'width', this.size.w );
      }

      this.setPosition(this.position);

      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.zIndex)){
        this.dialog.dialog( 'option', 'zIndex', this.zIndex );
      }
    },

    openUrl : function(url) {
      this.dialog.html("<iframe id='modalIframeId' width='100%' height='100%' marginWidth='0' marginHeight='0' frameBorder='0' scrolling='auto' src='" +
          url
          + "'>Your browser does not support iFrames</iframe>");
      //this.configureDialog();
      this.dialog.dialog('open');
    },

    open : function(element) {
      this.dialog.html(element);
      //this.configureDialog();
      this.dialog.dialog('open');
    },

    close : function() {
      this.dialog.dialog('close');
    },

    CLASS_NAME : 'LegatoJQuery.Popup.DialogPopup'
  }
);

/**
 * Component: ljqpo:DialogPopup
 *
 * The DialogPopup control creates and displays text or urls using the jQuery library.
 *
 * See also:
 * - <ljqpo> namespace
 */
LegatoJQuery.Popup.DialogPopup.Bean = Legato.Popup.Bean.Extend('LegatoJQuery.Popup.DialogPopup',
LegatoJQuery.Popup.QName('DialogPopup'),
//
{
  _constructor : LegatoJQuery.Popup.DialogPopup
});

