/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * A control to measure the length of lines
 */
Legato.Control.MeasureLine = OpenLayers.Class(OpenLayers.Control.Measure,
{
  handleMeasurements: function(event) {
    var geometry = event.geometry;
    var units = event.units;
    var order = event.order;
    var measure = event.measure;
    var out = measure.toFixed(3) + " " + units;
    this.div.innerHTML = out;
  },


    /*
     * Function: initialize
     * Basic control for the legend control
     *
     * Parameters:
     * options - {Object} A Hashmap containing option parameters for this control
     * The following keys are supported
     * - div {DOMElement} an optional DOMElement instance where this control should been rendered.
     *   If not defined the legend control will render itself inside the map DOMElement
     */
    initialize: function(options) {

       if (!Legato.Lang.ObjectUtils.exists(options)) {
         options = [];
       }

      // style the sketch fancy
      var sketchSymbolizers = {
          "Point": {
              pointRadius: "4",
              graphicName: "square",
              fillColor: "white",
              fillOpacity: "1",
              strokeWidth: "1",
              strokeOpacity: "1",
              strokeColor: "#333333"
          },
          "Line": {
              strokeWidth: "3",
              strokeOpacity: "1",
              strokeColor: "#666666",
              strokeDashstyle: "dash"
          },
          "Polygon": {
              strokeWidth: "2",
              strokeOpacity: "1",
              strokeColor: "#666666",
              fillColor: "white",
              fillOpacity: "0.3"
          }
      };
      var style = new OpenLayers.Style();
      style.addRules([
          new OpenLayers.Rule({symbolizer: sketchSymbolizers})
      ]);
      var styleMap = new OpenLayers.StyleMap({"default": style});

      options.handlerOptions = {
        layerOptions: {styleMap: styleMap, legatoIgnore: true}
      };

      //options.geodesic = true;

      OpenLayers.Control.Measure.prototype.initialize.apply(this, [OpenLayers.Handler.Path, options]);
      this.events.on({
        "measure": this.handleMeasurements,
        "measurepartial": this.handleMeasurements
      });

    },

    /*
     * Function: destroy
     * APIMethod: called if destroyed
     */
    destroy: function() {
      this.events.un( {
        "measure": this.handleMeasurements,
        "measurepartial": this.handleMeasurements
      });

      OpenLayers.Control.Measure.prototype.destroy.apply(this, arguments);
    },


    /*
     * Function: deactivate
     * APIMethod: called when component is deactivated
     */
    deactivate: function() {
      this.div.innerHTML = "";
      OpenLayers.Control.Measure.prototype.deactivate.apply(this, arguments);
    },

    CLASS_NAME : 'Legato.Control.MeasureLine'
});



Legato.Control.MeasureLine.Bean = OpenLayers.Control.Bean.Extend(
    'Legato.Control.MeasureLine',
    //
    Legato.Control.QName('MeasureLine'),
    //
    {
      _constructor :Legato.Control.MeasureLine,
      options:
      {
        persist: Legato.Lang.Boolean
        //TODO: Add style support
      }
    });