/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.LayerSelection = OpenLayers.Class( {
  map :null,
  initialize : function(map) {
    this.map = map;
    this.map.selectLayer = OpenLayers.Function.bind(this.selectLayer, this);
    this.map.deselectLayer = OpenLayers.Function.bind(this.deselectLayer, this);
  },
  selectLayer : function(selectedLayer) {
    for ( var index = 0; index < this.map.layers.length; index++) {
      var deselectedLayer = this.map.layers[index];
      if (Legato.Lang.ObjectUtils.isTrue(deselectedLayer.selected)) {
        deselectedLayer.selected = false;
        this.map.events.triggerEvent("legato.deselectlayer", {
          layer :deselectedLayer
        });
      }
    }
    if (Legato.Lang.ObjectUtils.exists(selectedLayer)) {
      if (Legato.Lang.ObjectUtils.isFalse(selectedLayer.selected)) {
        selectedLayer.selected = true;
        this.map.events.triggerEvent("legato.selectlayer", {
          layer :selectedLayer
        });
      }
    }
  },
  deselectLayer : function(deselectedLayer) {
    if (Legato.Lang.ObjectUtils.exists(deselectedLayer)) {
      if (Legato.Lang.ObjectUtils.isTrue(deselectedLayer.selected)) {
        deselectedLayer.selected = false;
        this.map.events.triggerEvent("legato.deselectlayer", {
          layer :deselectedLayer
        });
      }
    }
  },
  destroy : function() {
    this.map.selectLayer = null;
  },
  CLASS_NAME :'Legato.Control.LayerSelection'
});

Legato.Control.LayerSelection.Bean = Legato.Beans.Object.Extend(

'Legato.Control.LayerSelection',

Legato.Control.QName('LayerSelection'), {
  _constructor :Legato.Control.LayerSelection,
  constructorArguments : {
    map :OpenLayers.Map.Bean
  },
  constructorOrder : [ 'map' ]
});
