/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
    var singleFile = (typeof Legato == "object" && Legato.singleFile);
    /**
     * Relative path of this script.
     */
    var scriptName = (!singleFile) ? "lib/Legato.js" : 'Legato.js';
    var jsFiles = window.Legato;

    window.Legato = {
        _getScriptLocation: (function() {
            var r = new RegExp("(^|(.*?\\/))(" + scriptName + ")(\\?|$)"),
                s = document.getElementsByTagName('script'),
                src, m, l = "";
            for(var i=0, len=s.length; i<len; i++) {
                src = s[i].getAttribute('src');
                if(src) {
                    m = src.match(r);
                    if(m) {
                        l = m[1];
                        break;
                    }
                }
            }
            return (function() { return l; });
        })()
    };

    if(!singleFile) {
      /**
       * PATCH
       */
      //if (!jsFiles) {
      jsFiles = [
                 'Legato/Feature.js',
                 'Legato/Singleton.js',
                 'Legato/Util.js',
                 'Legato/Lang.js',
                 'Legato/Graph.js',
                 'Legato/Proj4js.js',
                 'Legato/XML.js',
                 'Legato/Lang/Class.js',
                 'Legato/Lang/ObjectUtils.js',
                 'Legato/Lang/ArrayUtils.js',
                 'Legato/Lang/CollectionUtils.js',
                 'Legato/Lang/NumberUtils.js',
                 'Legato/Lang/StringUtils.js',
                 'Legato/Lang/Exception.js',
                 'Legato/Lang/IllegalArgumentException.js',
                 'Legato/Lang/AnyType.js',
                 'Legato/Lang/AnySimpleType.js',
                 'Legato/Lang/List.js',
                 'Legato/Lang/Map.js',
                 'Legato/Lang/Null.js',
                 'Legato/Lang/Enum.js',
                 'Legato/Lang/Boolean.js',
                 'Legato/Lang/Integer.js',
                 'Legato/Lang/Number.js',
                 'Legato/Lang/Double.js',
                 'Legato/Lang/String.js',
                 'Legato/Lang/Element.js',
                 'Legato/Lang/Function.js',
                 'Legato/Lang/RGBColor.js',
                 'Legato/Util/Accessor.js',
                 'Legato/Util/ObjectValueAccessor.js',
                 'Legato/Util/ObjectFilter.js',
                 'Legato/Util/Ensure.js',
                 'Legato/Util/Matcher.js',
                 'Legato/Util/HashSet.js',
                 'Legato/Util/Tag.js',
                 'Legato/Util/DOM.js',
                 'Legato/Util/GeoLocation.js',
                 'Legato/Util/Logger.js',
                 'Legato/Graph/DirectedGraph.js',
                 'Legato/Graph/Vertex.js',
                 'Legato/XML/QName.js',
                 'Legato/XML/ElementUtils.js',
                 'Legato/Beans.js',
                 'Legato/Beans/Property.js',
                 'Legato/Beans/BeanDefinition.js',
                 'Legato/Beans/ComplexType.js',
                 'Legato/Beans/Object.js',
                 'Legato/Beans/BeanFactory.js',
                 'Legato/Beans/XMLBeanFactory.js',
                 'Legato/Beans/Reference.js',
                 'Legato/Beans/Evaluate.js',
                 'Legato/Beans/Field.js',
                 'Legato/Predicate.js',
                 'Legato/Predicate/And.js',
                 'Legato/Predicate/Contains.js',
                 'Legato/Predicate/Equals.js',
                 'Legato/Predicate/False.js',
                 'Legato/Predicate/Or.js',
                 'Legato/Predicate/True.js',
                 'Legato/Lang/Library.js',
                 'Legato/Util/Library.js',
                 'Legato/Text.js',
                 'Legato/Text/Format.js',
                 'Legato/Text/DecimalFormat.js',
                 'Legato/Text/PrecisionScaleFormat.js',
                 'Legato/OpenLayers.js',
                 'Legato/OpenLayers/Bounds.js',
                 'Legato/OpenLayers/LonLat.js',
                 'Legato/OpenLayers/Projection.js',
                 'Legato/OpenLayers/Size.js',
                 'Legato/OpenLayers/Pixel.js',
                 'Legato/OpenLayers/Icon.js',
                 'Legato/OpenLayers/Layer.js',
                 'Legato/OpenLayers/Control.js',
                 'Legato/OpenLayers/Map.js',
                 'Legato/OpenLayers/Map/Util.js',
                 'Legato/OpenLayers/Patches/Popup.js',
                 'Legato/OpenLayers/Control/ArgParser.js',
                 'Legato/OpenLayers/Control/Attribution.js',
                 'Legato/OpenLayers/Control/DrawFeature.js',
                 'Legato/OpenLayers/Control/ModifyFeature.js',
                 'Legato/OpenLayers/Control/LayerSwitcher.js',
                 'Legato/OpenLayers/Control/LoadingPanel.js',
                 'Legato/OpenLayers/Control/Scale.js',
                 'Legato/OpenLayers/Control/ScaleLine.js',
                 'Legato/OpenLayers/Control/Navigation.js',
                 'Legato/OpenLayers/Control/NavigationHistory.js',
                 'Legato/OpenLayers/Control/OverviewMap.js',
                 'Legato/OpenLayers/Control/Panel.js',
                 'Legato/OpenLayers/Control/PanZoom.js',
                 'Legato/OpenLayers/Control/PanZoomBar.js',
                 'Legato/OpenLayers/Control/MouseDefaults.js',
                 'Legato/OpenLayers/Control/MousePosition.js',
                 'Legato/OpenLayers/Control/ZoomBox.js',
                 'Legato/OpenLayers/Control/ZoomInBox.js',
                 'Legato/OpenLayers/Control/ZoomOutBox.js',
                 'Legato/OpenLayers/Control/ZoomOut.js',
                 'Legato/OpenLayers/Control/ZoomToMaxExtent.js',
                 'Legato/OpenLayers/Popup/MarginAwareFramedCloud.js',
                 'Legato/Service.js',
                 'Legato/Service/LayerCapabilities.js',
                 'Legato/Service/CapabilitiesURLs.js',
                 'Legato/Handler.js',
                 'Legato/Handler/Box.js',
                 'Legato/Handler/Path.js',
                 'Legato/Handler/Point.js',
                 'Legato/Handler/Polygon.js',
                 'Legato/I18n.js',
                 'Legato/I18n/BrowserLocaleFactoryBean.js',
                 'Legato/I18n/Messages.js',
                 'Legato/I18n/MessageSource.js',
                 'Legato/I18n/Message.js',
                 'Legato/Popup.js',
                 'Legato/Layer.js',
                 'Legato/Layer/Predicate.js',
                 'Legato/Layer/Predicate/BaseLayer.js',
                 'Legato/Layer/Predicate/LayerId.js',
                 'Legato/Layer/Predicate/LayerWithAttribute.js',
                 'Legato/Layer/Predicate/Overlay.js',
                 'Legato/Layer/Predicate/SelectedLayer.js',
                 'Legato/Layer/Transformer.js',
                 'Legato/Layer/Transformer/SublayerFilteringTransformer.js',
                 'Legato/Control.js',
                 'Legato/Control/ArgParser.js',
                 'Legato/Control/BBoxValueProvider.js',
                 'Legato/Control/ControlFunction.js',
                 'Legato/Control/ControlSwitcher.js',
                 'Legato/Control/DefaultBaseLayer.js',
                 'Legato/Control/DrawFeature.js',
                 'Legato/Control/DrawBox.js',
                 'Legato/Control/DrawPoint.js',
                 'Legato/Control/DrawLineString.js',
                 'Legato/Control/DrawPolygon.js',
                 'Legato/Control/FeatureSelector.js',
                 'Legato/Control/LayersValueProvider.js',
                 'Legato/Control/LayerSelection.js',
                 'Legato/Control/Legend.js',
                 'Legato/Control/Legend/Plugin.js',
                 'Legato/Control/Legend/Plugin/Layer.js',
                 'Legato/Control/Legend/Plugin/LayerDescription.js',
                 'Legato/Control/Legend/Plugin/LayerFunction.js',
                 'Legato/Control/Legend/Plugin/LayerLink.js',
                 'Legato/Control/Legend/Plugin/LayerName.js',
                 'Legato/Control/Legend/Plugin/LayerPosition.js',
                 'Legato/Control/Legend/Plugin/LayerRemove.js',
                 'Legato/Control/Legend/Plugin/LayerVisibility.js',
                 'Legato/Control/Legend/Plugin/LayerZoomToVisibleScale.js',
                 'Legato/Control/MapAttribution.js',
                 'Legato/Control/MeasureLine.js',
                 'Legato/Control/MeasurePolygon.js',
                 'Legato/Control/ModifyFeature.js',
                 'Legato/Control/ModifyPolygon.js',
                 'Legato/Control/ModifyPoint.js',
                 'Legato/Control/ModifyLineString.js',
                 'Legato/Control/NavigationHistory.js',
                 'Legato/Control/AbstractNavigationHistoryButton.js',
                 'Legato/Control/NavigationHistoryNext.js',
                 'Legato/Control/NavigationHistoryPrevious.js',
                 'Legato/Control/OverviewBoundingBox.js',
                 'Legato/Control/PanZoom.js',
                 'Legato/Control/PanZoomBar.js',
                 'Legato/Control/SelectionBoxValueProvider.js',
                 'Legato/Control/SetMapSize.js',
                 'Legato/Control/SyncMapDivSize.js',
                 'Legato/Control/ToggleDisplay.js',
                 'Legato/Control/ToggleDiv.js',
                 'Legato/Control/WMSGetFeatureInfo.js',
                 'Legato/Control/ViewContextValueProvider.js',
                 'Legato/Control/ScaleInput.js',
                 'Legato/Control/SelectBounds.js',
                 'Legato/Control/SelectLonLat.js',
                 'Legato/Control/Separator.js',
                 'Legato/Control/GeoLocation.js',
                 'Legato/Control/CallbackLocker.js',
                 'Legato/Control/SynchronousSnappingResolver.js',
                 'Legato/Control/SnappingController.js',
                 'Legato/Control/SnappableLayerSelector.js',
                 'Legato/Format.js',
                 'Legato/Format/ArcXML.js',
                 'Legato/Format/GML3.js',
                 'Legato/Format/ExtendedWMC.js',
                 'Legato/Format/ExtendedWMC/Model.js',
                 'Legato/Format/ExtendedWMC/Parser.js',
                 'Legato/OpenLayers/Layer/Image.js',
                 'Legato/OpenLayers/Layer/Markers.js',
                 'Legato/OpenLayers/Layer/GeoRSS.js',
                 'Legato/OpenLayers/Layer/Grid.js',
                 'Legato/OpenLayers/Layer/Vector.js',
                 'Legato/OpenLayers/Layer/WMS.js',
                 'Legato/OpenLayers/Layer/WFS.js',
                 'Legato/OpenLayers/Layer/GML.js',
                 'Legato/OpenLayers/Layer/Yahoo.js',
                 'Legato/OpenLayers/Layer/ArcIMS.js',
                 'Legato/OpenLayers/Layer/Google.js',
                 'Legato/OpenLayers/Layer/ArcGIS93Rest.js',
                 'Legato/OpenLayers/Layer/XYZ.js',
                 'Legato/OpenLayers/Layer/OSM.js',
                 'Legato/Layer/Blank.js',
                 'Legato/Layer/VectorOSM.js',
                 'Legato/Layer/GetLegend.js',
                 'Legato/Layer/Legend.js',
                 'Legato/Layer/VectorUpdater.js',
                 'Legato/Layer/Library.js',
                 'Legato/OverviewMap.js',
                 'Legato/BootLoader.js',
                 'Legato/I18n/Messages/en.js',
                 'Legato/Util/EventListener.js'
      ]; // etc.
      /**
       * PATCH
       */
      // }

      // use "parser-inserted scripts" for guaranteed execution order
      // http://hsivonen.iki.fi/script-execution/
      var scriptTags = new Array(jsFiles.length);
      var host = Legato._getScriptLocation() + "lib/";
      for (var i=0, len=jsFiles.length; i<len; i++) {
          scriptTags[i] = "<script src='" + host + jsFiles[i] +
                                 "'></script>";
      }
      if (scriptTags.length > 0) {
          document.write(scriptTags.join(""));
      }
    }
})();

/**
 * Constant: VERSION_NUMBER
 */
Legato.VERSION_NUMBER = "$Revision$";
Legato.NAMESPACE_URI = "http://www.disy.net/legato";
Legato.PREFIX = 'l';
Legato.QName = function(localPart) {
  return new Legato.XML.QName(Legato.NAMESPACE_URI, localPart,
      Legato.PREFIX);
};