/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.disy.ogc.wps.v_1_0_0.annotation.Metadata;
import net.opengis.ows.v_1_1_0.MetadataType;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.lang.StringUtils;

public class WpsProcessUtilities {
    public static <E, T extends Throwable> E getSingleRequired(E[] array, Predicate<? super E> predicate, T throwable) throws T {
        return WpsProcessUtilities.getSingleRequired(Arrays.asList(array), predicate, throwable);
    }

    public static <E, T extends Throwable> E getSingleRequired(List<E> list, Predicate<? super E> predicate, T throwable) throws T {
        Collection found = CollectionUtils.select(list, predicate);
        if (found.size() != 1) {
            throw throwable;
        }
        return found.iterator().next();
    }

    public static List<MetadataType> getMetadata(Metadata[] mds) {
        if (mds == null || mds.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<MetadataType> metadata = new ArrayList<MetadataType>(mds.length);
        for (Metadata md : mds) {
            MetadataType item = new MetadataType();
            String about = md.about();
            String href = md.href();
            String title = md.title();
            if (!StringUtils.isEmpty((String)about)) {
                item.setAbout(about);
            }
            if (!StringUtils.isEmpty((String)href)) {
                item.setHref(href);
            }
            if (!StringUtils.isEmpty((String)title)) {
                item.setTitle(title);
            }
            metadata.add(item);
        }
        return metadata;
    }
}

