/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.procedure;

import java.util.List;
import net.disy.ogc.wps.v_1_0_0.procedure.DataInputBuilder;
import net.disy.ogc.wps.v_1_0_0.procedure.InputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.procedure.OutputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.procedure.ProcessOutputDescriptionBuilder;
import net.disy.ogc.wps.v_1_0_0.procedure.WpsProcedure;
import net.disy.ogc.wps.v_1_0_0.procedure.WpsProcessContext;
import net.disy.ogc.wps.v_1_0_0.util.WpsUtils;
import net.opengis.ows.v_1_1_0.MetadataType;
import net.opengis.wps.v_1_0_0.ProcessDescriptionType;

public class ProcedureWpsProcessDescriptionFactory {
    private final WpsProcessContext context;

    public ProcedureWpsProcessDescriptionFactory(WpsProcessContext context) {
        this.context = context;
    }

    public ProcessDescriptionType createProcessDescription(WpsProcedure process) {
        ProcessDescriptionType processDescription = this.context.getWpsObjectFactory().createProcessDescriptionType();
        this.setProcessProperties(process, processDescription);
        processDescription.setDataInputs(this.createDataInputs(process));
        processDescription.setProcessOutputs(this.createProcessOutputs(process));
        return processDescription;
    }

    private void setProcessProperties(WpsProcedure process, ProcessDescriptionType processDescription) {
        processDescription.setIdentifier(WpsUtils.createCodeType(process.getId()));
        processDescription.setTitle(WpsUtils.createLanguageStringType(process.getTitle()));
        processDescription.setAbstract(WpsUtils.createLanguageStringType(process.getAbstract()));
        List<MetadataType> metadata = process.getMetadata();
        if (!metadata.isEmpty()) {
            processDescription.setMetadata(metadata);
        }
        processDescription.setProcessVersion("1.0.0");
        processDescription.setStatusSupported(false);
        processDescription.setStoreSupported(false);
    }

    private ProcessDescriptionType.DataInputs createDataInputs(WpsProcedure processHelper) {
        List<InputParameterDescription> inputParameters = processHelper.getInputParameters();
        if (inputParameters.isEmpty()) {
            return null;
        }
        DataInputBuilder dataInputBuilder = new DataInputBuilder(this.context);
        for (InputParameterDescription parameter : inputParameters) {
            dataInputBuilder.addParameter(parameter);
        }
        return dataInputBuilder.getDataInputs();
    }

    private ProcessDescriptionType.ProcessOutputs createProcessOutputs(WpsProcedure processHelper) {
        ProcessOutputDescriptionBuilder outputBuilder = new ProcessOutputDescriptionBuilder(this.context);
        for (OutputParameterDescription outputParameter : processHelper.getOutputParameters()) {
            outputBuilder.addOutput(outputParameter);
        }
        return outputBuilder.getProcessOutputs();
    }
}

