/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.model;

import javax.xml.namespace.QName;
import net.disy.ogc.wps.v_1_0_0.model.DataType;
import net.disy.ogc.wps.v_1_0_0.model.DataTypeType;
import net.disy.ogc.wps.v_1_0_0.model.DefaultDataType;
import org.apache.commons.lang.Validate;

public class SchemaReference {
    public static char DELIMITER = (char)35;
    public static String TYPE_PREFIX = "~";
    public static String ELEMENT_PREFIX = "";
    private final String location;
    private final String namespaceUri;
    private final String defaultPrefix;

    public SchemaReference(String location, String namespaceUri) {
        this(location, namespaceUri, null);
    }

    public SchemaReference(String location, String namespaceUri, String defaultPrefix) {
        Validate.notNull((Object)location);
        Validate.notNull((Object)namespaceUri);
        this.location = location;
        this.namespaceUri = namespaceUri;
        this.defaultPrefix = defaultPrefix;
    }

    public QName qname(String localPart) {
        if (this.defaultPrefix == null) {
            return new QName(this.namespaceUri, localPart);
        }
        return new QName(this.namespaceUri, localPart, this.defaultPrefix);
    }

    public String typeDesignator(String localTypeName) {
        Validate.notNull((Object)localTypeName);
        return this.location + DELIMITER + TYPE_PREFIX + localTypeName;
    }

    public String elementDesignator(String localElementName) {
        Validate.notNull((Object)localElementName);
        return this.location + DELIMITER + ELEMENT_PREFIX + localElementName;
    }

    public <T> DataType<T> literalDataType(String localTypeName, Class<T> defaultClass) {
        return new DefaultDataType<T>(this.typeDesignator(localTypeName), defaultClass, DataTypeType.LITERAL);
    }

    public <T> DataType<T> bboxDataType(String localElementName, Class<T> defaultClass) {
        return new DefaultDataType<T>(this.elementDesignator(localElementName), defaultClass, DataTypeType.BBOX);
    }

    public <T> DataType<T> complexDataType(String localElementName, Class<T> defaultClass) {
        return new DefaultDataType<T>(this.elementDesignator(localElementName), defaultClass, DataTypeType.COMPLEX);
    }
}

