/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.gml.v_3_1_1.dwr;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import net.disy.ogc.gml.v_3_1_1.dwr.AbstractGeometryTypeConverter;
import net.opengis.gml.v_3_1_1.AbstractGeometryType;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import net.opengis.gml.v_3_1_1.LineStringType;
import org.directwebremoting.extend.MarshallException;
import org.jvnet.jaxb2_commons.locator.DefaultRootObjectLocator;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.ogc.gml.v_3_1_1.jts.ConversionFailedException;

public class LineStringTypeConverter
extends AbstractGeometryTypeConverter<LineStringType, double[][]> {
    @Override
    protected Class<double[][]> getCoordinatesType() {
        return double[][].class;
    }

    @Override
    protected double[][] createCoordinates(LineStringType geometry) throws MarshallException {
        try {
            LineString lineString = (LineString)this.getConverter().createGeometry((ObjectLocator)new DefaultRootObjectLocator((Object)geometry), (AbstractGeometryType)geometry);
            Coordinate[] lineStringCoordinates = lineString.getCoordinates();
            double[][] coordinates = new double[lineStringCoordinates.length][];
            for (int index = 0; index < lineStringCoordinates.length; ++index) {
                Coordinate lineStringCoordinate = lineStringCoordinates[index];
                coordinates[index] = Double.isNaN(lineStringCoordinate.z) ? new double[]{lineStringCoordinate.x, lineStringCoordinate.y} : new double[]{lineStringCoordinate.x, lineStringCoordinate.y, lineStringCoordinate.z};
            }
            return coordinates;
        }
        catch (ConversionFailedException cfex) {
            throw new MarshallException(LineStringType.class, (Throwable)cfex);
        }
    }

    @Override
    protected String getGeometryType() {
        return "LineString";
    }

    @Override
    protected LineStringType createGeometry(double[][] coordinates) {
        LineStringType lineString = new LineStringType();
        for (double[] pos : coordinates) {
            DirectPositionType position = new DirectPositionType();
            for (double coordinate : pos) {
                position.getValue().add(coordinate);
            }
            lineString.getPosOrPointPropertyOrPointRep().add(new JAXBElement(new QName("http://www.opengis.net/gml", "pos"), DirectPositionType.class, (Object)position));
        }
        return lineString;
    }
}

