/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import com.vividsolutions.jts.geom.Geometry;
import java.text.MessageFormat;
import java.text.ParseException;
import net.opengis.gml.v_3_1_1.SRSReferenceGroup;
import org.apache.commons.lang.Validate;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.ogc.gml.v_3_1_1.jts.ConversionFailedException;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSSRIDConverterInterface;

public class GML311ToJTSSRIDConverter
implements GML311ToJTSSRIDConverterInterface {
    private final String[] patterns;

    public GML311ToJTSSRIDConverter(String[] patterns) {
        this.patterns = patterns;
    }

    public void convert(ObjectLocator locator, SRSReferenceGroup source, Geometry target) throws ConversionFailedException {
        Validate.notNull((Object)source);
        Validate.notNull((Object)target);
        String srsName = source.getSrsName();
        if (srsName != null) {
            for (String pattern : this.patterns) {
                try {
                    MessageFormat format = new MessageFormat(pattern);
                    Object[] codearray = format.parse(srsName);
                    if (codearray.length <= 0) continue;
                    target.setSRID(((Number)codearray[0]).intValue());
                    if (target.getUserData() != null) continue;
                    target.setUserData((Object)srsName);
                    return;
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            if (target.getUserData() != null) {
                throw new ConversionFailedException(locator, MessageFormat.format("Could not parse SRS name [{0}].", srsName));
            }
            target.setUserData((Object)srsName);
        }
    }
}

