/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.List;
import net.opengis.gml.v_3_1_1.CoordType;
import net.opengis.gml.v_3_1_1.CoordinatesType;
import net.opengis.gml.v_3_1_1.DirectPositionListType;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import org.apache.commons.lang.StringUtils;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.ogc.gml.v_3_1_1.jts.ConversionFailedException;

public class GML311ToJTSCoordinateConverter {
    public Coordinate createCoordinate(ObjectLocator locator, DirectPositionType directPositionType) throws ConversionFailedException {
        List value = directPositionType.getValue();
        int count = value.size();
        if (count == 2) {
            double x = (Double)value.get(0);
            double y = (Double)value.get(1);
            return new Coordinate(x, y);
        }
        if (count == 3) {
            double x = (Double)value.get(0);
            double y = (Double)value.get(1);
            double z = (Double)value.get(2);
            return new Coordinate(x, y, z);
        }
        throw new ConversionFailedException((ObjectLocator)locator.property("value", (Object)value), "Direct position type is expected to have 2 or 3 items.");
    }

    public Coordinate[] createCoordinates(ObjectLocator locator, DirectPositionListType directPositionListType) throws ConversionFailedException {
        int dimensions;
        int n = dimensions = directPositionListType.isSetSrsDimension() ? directPositionListType.getSrsDimension().intValue() : 2;
        if (dimensions < 2 || dimensions > 3) {
            throw new ConversionFailedException((ObjectLocator)locator.property("srsDimension", (Object)dimensions), "Only two- or three-dimensional coordinates are supported.");
        }
        List values = directPositionListType.getValue();
        if (values.size() % dimensions != 0) {
            throw new ConversionFailedException((ObjectLocator)locator.property("value", (Object)values), "Wrong number of entries in the list.");
        }
        Coordinate[] coordinates = new Coordinate[values.size() / dimensions];
        for (int index = 0; index < values.size() / dimensions; ++index) {
            if (dimensions == 2) {
                coordinates[index] = new Coordinate(((Double)values.get(index * dimensions)).doubleValue(), ((Double)values.get(index * dimensions + 1)).doubleValue());
                continue;
            }
            if (dimensions != 3) continue;
            coordinates[index] = new Coordinate(((Double)values.get(index * dimensions)).doubleValue(), ((Double)values.get(index * dimensions + 1)).doubleValue(), ((Double)values.get(index * dimensions + 2)).doubleValue());
        }
        return coordinates;
    }

    public Coordinate createCoordinate(ObjectLocator locator, CoordType coordType) throws ConversionFailedException {
        if (coordType.isSetX() && coordType.isSetY() && !coordType.isSetZ()) {
            return new Coordinate(coordType.getX().doubleValue(), coordType.getY().doubleValue());
        }
        if (coordType.isSetX() && coordType.isSetY() && !coordType.isSetZ()) {
            return new Coordinate(coordType.getX().doubleValue(), coordType.getY().doubleValue(), coordType.getZ().doubleValue());
        }
        throw new ConversionFailedException(locator, "Either X, Y or X, Y, Z values are required.");
    }

    public Coordinate[] createCoordinates(ObjectLocator locator, CoordinatesType coordinates) throws ConversionFailedException {
        Coordinate[] coords = this.createCoordinates(locator, coordinates.getValue(), coordinates.getDecimal(), coordinates.getCs(), coordinates.getTs());
        return coords;
    }

    public Coordinate[] createCoordinates(ObjectLocator locator, String value, String ds, String cs, String ts) throws ConversionFailedException {
        String tupleSeparator = ts == null ? " " : ts;
        String[] tuples = StringUtils.split((String)value, (String)tupleSeparator);
        Coordinate[] coordinatesArray = new Coordinate[tuples.length];
        for (int index = 0; index < tuples.length; ++index) {
            coordinatesArray[index] = this.createCoordinate((ObjectLocator)locator.item(index, (Object)tuples[index]), tuples[index], ds, cs);
        }
        return coordinatesArray;
    }

    public Coordinate createCoordinate(ObjectLocator locator, String value, String ds, String cs) throws ConversionFailedException {
        String coordinateSeparator = cs == null ? "," : cs;
        String[] coordinates = StringUtils.split((String)value, (String)coordinateSeparator);
        double[] coordinateComponents = new double[coordinates.length];
        for (int index = 0; index < coordinates.length; ++index) {
            coordinateComponents[index] = this.createCoordinateComponent((ObjectLocator)locator.item(index, (Object)coordinates[index]), coordinates[index], ds);
        }
        if (coordinateComponents.length == 2) {
            return new Coordinate(coordinateComponents[0], coordinateComponents[1]);
        }
        if (coordinateComponents.length == 3) {
            return new Coordinate(coordinateComponents[0], coordinateComponents[1], coordinateComponents[2]);
        }
        throw new ConversionFailedException(locator, "Expected two or three coordinates.");
    }

    public double createCoordinateComponent(ObjectLocator locator, String value, String ds) throws ConversionFailedException {
        String decimalSeparator = ds == null ? "." : ds;
        try {
            return Double.parseDouble(value.replace(decimalSeparator, "."));
        }
        catch (NumberFormatException nfex) {
            throw new ConversionFailedException(locator, (Throwable)nfex);
        }
    }
}

