/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.proxy;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.disy.ogc.wps.v_1_0_0.proxy.PrefixStrategy;
import net.disy.ogc.wps.v_1_0_0.proxy.WPSConnectionException;

public class HostPrefixStrategy
implements PrefixStrategy {
    private static final String LOCALHOST = "localhost";
    private static final String FILE_PROTOCOL = "file";
    private static final String INDEX_SEPARATOR = "-";
    private final Map<String, Integer> generatedPrefixes = new HashMap<String, Integer>();

    @Override
    public synchronized String createPrefixFromURL(String url) throws WPSConnectionException {
        URL givenUrl;
        if (url == null) {
            throw new WPSConnectionException("url should not be null");
        }
        try {
            givenUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new WPSConnectionException("The provided url [" + url + "] is not a valid URL.");
        }
        String host = this.extractHostName(givenUrl);
        if (host != null && host.length() > 0) {
            if (this.generatedPrefixes.containsKey(host)) {
                int lastIndex = this.generatedPrefixes.get(host);
                int newIndex = lastIndex + 1;
                this.generatedPrefixes.put(host, newIndex);
                host = host + INDEX_SEPARATOR + newIndex;
            } else {
                this.generatedPrefixes.put(host, 1);
            }
            return host;
        }
        throw new WPSConnectionException("No host could been identified in the provided URL [" + url + "]");
    }

    private String extractHostName(URL url) {
        String host = null;
        host = FILE_PROTOCOL.equals(url.getProtocol()) ? LOCALHOST : url.getHost();
        return host;
    }
}

