/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import net.disy.ogc.ows.v_1_1_0.OwsException;
import net.disy.ogc.wps.v_1_0_0.WpsProcess;
import net.disy.ogc.wps.v_1_0_0.proxy.ExceptionHandlingUtils;
import net.disy.ogc.wps.v_1_0_0.proxy.GenericMarshallingHttpClient;
import net.disy.ogc.wps.v_1_0_0.proxy.PrefixStrategy;
import net.disy.ogc.wps.v_1_0_0.proxy.ProxyProcess;
import net.disy.ogc.wps.v_1_0_0.proxy.ProxyWpsProcessFactory;
import net.disy.ogc.wps.v_1_0_0.proxy.RequestMethodUtils;
import net.disy.ogc.wps.v_1_0_0.proxy.WPSConnectionException;
import net.disy.ogc.wps.v_1_0_0.proxy.WPSMarshallingException;
import net.disy.ogc.wps.v_1_0_0.util.WpsUtils;
import net.opengis.ows.v_1_1_0.CodeType;
import net.opengis.ows.v_1_1_0.DCP;
import net.opengis.ows.v_1_1_0.Operation;
import net.opengis.ows.v_1_1_0.RequestMethodType;
import net.opengis.wps.v_1_0_0.ProcessBriefType;
import net.opengis.wps.v_1_0_0.ProcessDescriptionType;
import net.opengis.wps.v_1_0_0.ProcessDescriptions;
import net.opengis.wps.v_1_0_0.WPSCapabilitiesType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultProxyWpsProcessFactory
implements ProxyWpsProcessFactory {
    private final Log log = LogFactory.getLog(DefaultProxyWpsProcessFactory.class);
    private static final String ID_SEPARATOR = "-";
    private final GenericMarshallingHttpClient httpClient;
    private final PrefixStrategy prefixStrategy;

    public DefaultProxyWpsProcessFactory(GenericMarshallingHttpClient httpClient, PrefixStrategy prefixStrategy) {
        this.httpClient = httpClient;
        this.prefixStrategy = prefixStrategy;
    }

    @Override
    public Collection<WpsProcess> createProxyWpsProcesses(String capabilitiesUrl) throws OwsException, WPSConnectionException, WPSMarshallingException {
        ArrayList<WpsProcess> result = new ArrayList<WpsProcess>();
        JAXBElement capabilities = ExceptionHandlingUtils.handleExceptionReport(this.httpClient.executeFullyParametrizedGetRequest(capabilitiesUrl), JAXBElement.class);
        String describeProcessUrl = null;
        String executeUrl = null;
        for (Operation op : ((WPSCapabilitiesType)capabilities.getValue()).getOperationsMetadata().getOperation()) {
            JAXBElement<RequestMethodType> describeProcessRequestMethod;
            List requestMethods = ((DCP)op.getDCP().get(0)).getHTTP().getGetOrPost();
            if ("DescribeProcess".equals(op.getName())) {
                describeProcessRequestMethod = RequestMethodUtils.getGet(requestMethods);
                if (describeProcessRequestMethod != null) {
                    String describeProcessBaseUrl = ((RequestMethodType)describeProcessRequestMethod.getValue()).getHref();
                    this.log.debug((Object)("Extracted describe process URL: [" + describeProcessBaseUrl + "]"));
                    describeProcessUrl = describeProcessBaseUrl + (describeProcessBaseUrl.contains("?") ? "" : "?") + "service=WPS&request=DescribeProcess&version=1.0.0&identifier=";
                    continue;
                }
                throw new UnsupportedOperationException("Currently only GET DescribeProcess operation is supported");
            }
            if (!"Execute".equals(op.getName())) continue;
            describeProcessRequestMethod = RequestMethodUtils.getPost(requestMethods);
            if (describeProcessRequestMethod != null) {
                String executeBaseUrl = ((RequestMethodType)describeProcessRequestMethod.getValue()).getHref();
                this.log.debug((Object)("Extracted execute URL: [" + executeBaseUrl + "]"));
                executeUrl = executeBaseUrl + (executeBaseUrl.contains("?") ? "" : "?") + "service=WPS&request=Execute&version=1.0.0&identifier=";
                continue;
            }
            throw new UnsupportedOperationException("Only POST is supported for Execute");
        }
        String proxyPrefix = this.prefixStrategy.createPrefixFromURL(capabilitiesUrl);
        this.log.debug((Object)("Created prefix [" + proxyPrefix + "] for the capabilities URL [" + capabilitiesUrl + "]"));
        for (ProcessBriefType process : ((WPSCapabilitiesType)capabilities.getValue()).getProcessOfferings().getProcess()) {
            CodeType remoteId = process.getIdentifier();
            String describeProcessUrlWithId = describeProcessUrl + remoteId.getValue();
            String executeUrlWithId = executeUrl + remoteId.getValue();
            ProcessDescriptions processes = ExceptionHandlingUtils.handleExceptionReport(this.httpClient.executeFullyParametrizedGetRequest(describeProcessUrlWithId), ProcessDescriptions.class);
            ProcessDescriptionType remoteDescription = (ProcessDescriptionType)processes.getProcessDescription().get(0);
            CodeType proxyId = WpsUtils.createCodeType((String)(proxyPrefix + ID_SEPARATOR + remoteId.getValue()));
            this.log.debug((Object)("Created proxy id [" + proxyId.getValue() + "]"));
            ProxyProcess proxyProcess = new ProxyProcess(proxyId, executeUrlWithId, remoteDescription, this.httpClient);
            this.log.debug((Object)("Created proxy process: " + proxyProcess));
            result.add(proxyProcess);
        }
        return result;
    }
}

