/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.tools.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.disy.legato.tools.util.DefaultMapPersister;
import org.apache.commons.collections15.OrderedMap;
import org.apache.commons.collections15.map.ListOrderedMap;
import org.apache.commons.collections15.map.UnmodifiableOrderedMap;
import org.apache.commons.io.IOUtils;

public class ResourceMappingFilter
implements Filter {
    private static final String FILTER_PATH_PARAMETER_NAME = "filterPath";
    private static final String MAPPING_PROPERTIES_INIT_PARAMETER_NAME = "mappingProperties";
    private Map<String, String> mapping = Collections.emptyMap();
    private String filterPath = "";

    public String getFilterPath() {
        return this.filterPath;
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    public void init(FilterConfig config) throws ServletException {
        String filterPath = config.getInitParameter(FILTER_PATH_PARAMETER_NAME);
        if (filterPath == null) {
            throw new ServletException("Required init parameter [prefix] is not specified.");
        }
        this.setFilterPath(filterPath);
        String configuredMappingPropertiesResourceName = config.getInitParameter(MAPPING_PROPERTIES_INIT_PARAMETER_NAME);
        String mappingPropertiesResourceName = configuredMappingPropertiesResourceName != null ? configuredMappingPropertiesResourceName : this.getDefaultMappingPropertiesResourceName();
        DefaultMapPersister propertiesMapPersister = new DefaultMapPersister();
        ListOrderedMap mapping = new ListOrderedMap();
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(mappingPropertiesResourceName);
            if (is == null) {
                throw new ServletException("Could not load mapping properties from the resource [" + mappingPropertiesResourceName + "] because it does not exist.");
            }
            propertiesMapPersister.load((Map<String, String>)mapping, is);
        }
        catch (IOException ioex) {
            try {
                throw new ServletException("Could not load mapping properties from the resource [" + mappingPropertiesResourceName + "].", (Throwable)ioex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        this.mapping = UnmodifiableOrderedMap.decorate((OrderedMap)mapping);
    }

    public void destroy() {
    }

    protected String getDefaultMappingPropertiesResourceName() {
        return "/" + this.getClass().getName().replace('.', '/') + ".properties";
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            String contextPath = httpServletRequest.getContextPath() + "/";
            String requestURI = httpServletRequest.getRequestURI();
            if (requestURI.startsWith(contextPath)) {
                String filterPath;
                String filterURI = requestURI.substring(contextPath.length());
                if (filterURI.startsWith(filterPath = this.getFilterPath())) {
                    String targetURI = filterURI.substring(filterPath.length());
                    for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
                        InputStream is;
                        String resourceName;
                        block12: {
                            String key = entry.getKey();
                            String value = entry.getValue();
                            if (!targetURI.startsWith(key) || targetURI.length() <= key.length()) continue;
                            resourceName = value + targetURI.substring(key.length());
                            is = null;
                            is = this.getClass().getResourceAsStream("/" + resourceName);
                            if (is == null) break block12;
                            IOUtils.copy((InputStream)is, (OutputStream)httpServletResponse.getOutputStream());
                            httpServletResponse.flushBuffer();
                            IOUtils.closeQuietly((InputStream)is);
                            break;
                        }
                        try {
                            httpServletResponse.sendError(404);
                        }
                        catch (IOException ioex) {
                            try {
                                throw new ServletException("Error serving resource [" + resourceName + "].", (Throwable)ioex);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(is);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((InputStream)is);
                        break;
                    }
                } else {
                    chain.doFilter(request, response);
                }
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }
}

