/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.tools.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import net.disy.legato.tools.jts.AbstractGeometryConverter;
import net.disy.legato.tools.jts.PointConverter;
import org.directwebremoting.extend.MarshallException;

public class PolygonConverter
extends AbstractGeometryConverter<Polygon, double[][][]> {
    private final PointConverter pointConverter = new PointConverter();

    @Override
    protected String getGeometryType() {
        return "Polygon";
    }

    @Override
    protected Class<double[][][]> getCoordinatesType() {
        return double[][][].class;
    }

    @Override
    protected double[][][] createCoordinates(Polygon polygon) throws MarshallException {
        if (polygon == null) {
            return null;
        }
        if (polygon.isEmpty()) {
            return new double[0][0][0];
        }
        int numberOfPoints = polygon.getExteriorRing().getNumPoints();
        double[][][] coordinates = new double[1 + polygon.getNumInteriorRing()][numberOfPoints][];
        for (int index = 0; index < numberOfPoints; ++index) {
            coordinates[0][index] = this.pointConverter.createCoordinates(polygon.getExteriorRing().getPointN(index));
        }
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LineString interiorRingN = polygon.getInteriorRingN(i);
            double[][] holeCoordinates = new double[interiorRingN.getNumPoints()][];
            for (int j = 0; j < interiorRingN.getNumPoints(); ++j) {
                holeCoordinates[j] = this.pointConverter.createCoordinates(interiorRingN.getPointN(j));
            }
            coordinates[i + 1] = holeCoordinates;
        }
        return coordinates;
    }

    @Override
    protected Polygon createGeometry(double[][][] coordinates) throws MarshallException {
        if (coordinates == null || coordinates[0] == null) {
            return null;
        }
        Coordinate[] coordinateArray = new Coordinate[coordinates[0].length];
        for (int index = 0; index < coordinates[0].length; ++index) {
            coordinateArray[index] = this.pointConverter.createGeometry(coordinates[0][index]).getCoordinate();
        }
        LinearRing shell = new LinearRing((CoordinateSequence)new CoordinateArraySequence(coordinateArray), this.getGeometryFactory());
        LinearRing[] holes = new LinearRing[coordinates.length - 1];
        for (int j = 1; j < coordinates.length; ++j) {
            coordinateArray = new Coordinate[coordinates[j].length];
            for (int index = 0; index < coordinates[j].length; ++index) {
                coordinateArray[index] = this.pointConverter.createGeometry(coordinates[j][index]).getCoordinate();
            }
            holes[j - 1] = new LinearRing((CoordinateSequence)new CoordinateArraySequence(coordinateArray), this.getGeometryFactory());
        }
        return this.getGeometryFactory().createPolygon(shell, holes);
    }
}

