/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPSPD.Result.Geometry = OpenLayers.Class(WPS.Result.Geometry, {

  symbolizer : null,
  layer : null,

  initialize : function(id, map, symbolizer, options) {
    WPS.Result.Geometry.prototype.initialize.apply(this, [ id, map, options ]);
    this.symbolizer = symbolizer;
  },

  createGeometryStyle : function() {
    var style = OpenLayers.Util.extend({}, WPS.Feature.Style.ACTIVE);
    if (Legato.Lang.ObjectUtils.exists(this.symbolizer)) {
      this.configureStyle(style);
    }
    return style;
  },

  configureStyle : function(style) {
    throw new Legato.Lang.Exception(this.CLASS_NAME + ' must implement the configureStyle function from from abstract class '
        + WPSPD.Result.Geometry.CLASS_NAME);
  },

  evaluateStyleConfiguration : function(styleConfig, style) {
    var declarationMap = {
      'stroke' : 'strokeColor',
      'stroke-width' : 'strokeWidth',
      'fill' : 'fillColor'
    };
    if (Legato.Lang.ObjectUtils.exists(styleConfig.svgParameter)) {
      for (index = 0; index < styleConfig.svgParameter.length; index++) {
        var svgParameter = styleConfig.svgParameter[index];
        if (Legato.Lang.ObjectUtils.exists(declarationMap[svgParameter.name])) {
          style[declarationMap[svgParameter.name]] = svgParameter.content[0];
        }
      }
    }
  },

  destroy : function() {
    this.map = null;
    this.layer = null;
    WPS.Result.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME : 'WPSPD.Result.Geometry'

});

WPSPD.Result.Geometry.ComplexFactory = OpenLayers.Class(WPS.Result.ComplexFactory, {
  schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Geometry',
  name : new Legato.XML.QName('http://www.disy.net/pd', 'Geometry', 'pd'),
  createResult : function(id, outputData, options) {
    var complexData = outputData.data.complexData;
    var value = complexData.content[0].value;
    var geometryValue = value.geometry.value;
    var symbolizer;
    if (Legato.Lang.ObjectUtils.exists(value.symbolizer) && Legato.Lang.ObjectUtils.exists(value.symbolizer.value)) {
      symbolizer = value.symbolizer.value;
    } else {
      symbolizer = null;
    }
    var type = geometryValue.type;
    var coordinates = geometryValue.coordinates;
    switch (type) {
    case 'Polygon':
      return new WPSPD.Result.Polygon(id, this.map, coordinates, symbolizer, options);
    case 'LineString':
      return new WPSPD.Result.LineString(id, this.map, coordinates, symbolizer, options);
    case 'Point':
      return new WPSPD.Result.Point(id, this.map, coordinates, symbolizer, options);
    }
  },
  CLASS_NAME : 'WPSPD.Result.Geometry.ComplexFactory'
});