/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Geometry = OpenLayers.Class(WPS.Result, {

  map : null,
  layer : null,

  initialize : function(id, map, options) {
    WPS.Result.prototype.initialize.apply(this, [ id, options ]);
    this.map = map;
  },

  execute : function() {
    var layerOptions = {
      isFeatureLayer: true,
      legatoIgnore: true,
      // indicate that the temp vector layer will never be out of range
      // without this, resolution properties must be specified at the
      // map-level for this temporary layer to init its resolutions
      // correctly
      calculateInRange : function() {
        return true;
      }
    };
    this.layer = new OpenLayers.Layer.Vector('Result geometry layer',
        layerOptions);
    this.layer.style = WPS.Feature.Style.ACTIVE;
    this.map.addLayer(this.layer);
    var feature = this.createFeature();
    this.layer.addFeatures([ feature ]);
  },

  createFeature : function() {
    var geojson_format = new OpenLayers.Format.GeoJSON();
    var resultGeometry = this.createResultGeometry();
    var feature = new OpenLayers.Feature.Vector(geojson_format.read(
        resultGeometry, 'Geometry'));
    feature.style = this.createGeometryStyle();
    return feature;
  },

  createGeometryStyle : function() {
    return WPS.Feature.Style.ACTIVE;
  },

  createResultGeometry : function() {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the createResultGeometry function from from abstract class ' +
        WPS.Result.Geometry.CLASS_NAME);
  },

  destroy : function() {
    this.map = null;
    this.layer = null;
    WPS.Result.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME : 'WPS.Result.Geometry'

});

WPS.Result.Geometry.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {
      schema : 'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Geometry',
      name : new Legato.XML.QName('http://www.opengis.net/gml', 'Geometry',
          'gml'),
      createResult : function(id, outputData, options) {
        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;
        var type = value.type;
        var coordinates = value.coordinates;
        switch (type) {
        case 'Polygon':
          return new WPS.Result.Polygon(id, this.map, coordinates, options);
        case 'LineString':
          return new WPS.Result.LineString(id, this.map, coordinates, options);
        case 'Point':
          return new WPS.Result.Point(id, this.map, coordinates, options);
        }
      },
      CLASS_NAME : 'WPS.Result.Geometry.ComplexFactory'
    });