/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var WPS = {
	singleFile : true
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 81311 $
 * @requires OpenLayers.js
 */

(function() {
    var singleFile = (typeof WPS == "object" && WPS.singleFile);
    /**
     * Relative path of this script.
     */
    var scriptName = (!singleFile) ? "lib/WPS.js" : 'WPS.js';
    var jsFiles = window.WPS;

    window.WPS = {
        _getScriptLocation: (function() {
            var r = new RegExp("(^|(.*?\\/))(" + scriptName + ")(\\?|$)"),
                s = document.getElementsByTagName('script'),
                src, m, l = "";
            for(var i=0, len=s.length; i<len; i++) {
                src = s[i].getAttribute('src');
                if(src) {
                    m = src.match(r);
                    if(m) {
                        l = m[1];
                        break;
                    }
                }
            }
            return (function() { return l; });
        })()
    };

    if(!singleFile) {
        if (!jsFiles) {
            jsFiles = [
             'WPS/Common.js',
             'WPS/Feature.js',
             'WPS/Component.js',
             'WPS/Model.js',
             'WPS/Form.js',
             'WPS/ToolbarManager.js',
             'WPS/Inceptor.js',
             'WPS/Predicate.js',
             'WPS/Predicate/Metadata.js',
             'WPS/Predicate/MapTags.js',
             'WPS/ProcessSelector.js',
             'WPS/Result.js',
             'WPS/Control.js',
             'WPS/Control/GeoControlSync.js',
             'WPS/Control/GeometryEditor.js',
             'WPS/Control/ObjectVisualizer.js',
             'WPS/Control/ToggleWpsForm.js',
             'WPS/Control/WpsButton.js',
             'WPS/Model/Complex.js',
             'WPS/Model/Factory.js',
             'WPS/Model/Geo.js',
             'WPS/Model/Literal.js',
             'WPS/Model/Process.js',
             'WPS/Component/AbstractGeometry.js',
             'WPS/Component/Factory.js',
             'WPS/Component/Literal.js',
             'WPS/Component/Point.js',
             'WPS/Component/LineString.js',
             'WPS/Component/Polygon.js',
             'WPS/Component/Process.js',
             'WPS/Result/Geometry.js',
             'WPS/Result/Factory.js',
             'WPS/Result/Link.js',
             'WPS/Result/Message.js',
             'WPS/Result/BoundingBox.js',
             'WPS/Result/ExceptionReport.js',
             'WPS/Result/Point.js',
             'WPS/Result/LineString.js',
             'WPS/Result/Polygon.js',
             'WPS/Result/Group.js',
             'WPS/Result/ProcessDescription.js',
             'WPS/Result/WPSPDGeometry.js',
             'WPS/Result/WPSPDPoint.js',
             'WPS/Result/WPSPDPolygon.js',
             'WPS/Result/WPSPDLineString.js',
             'WPS/Result/WPSPDMarker.js'
            ]; // etc.
        }

        // use "parser-inserted scripts" for guaranteed execution order
        // http://hsivonen.iki.fi/script-execution/
        var scriptTags = new Array(jsFiles.length);
        var host = WPS._getScriptLocation() + "lib/";
        for (var i=0, len=jsFiles.length; i<len; i++) {
            scriptTags[i] = "<script src='" + host + jsFiles[i] +
                                   "'></script>";
        }
        if (scriptTags.length > 0) {
            document.write(scriptTags.join(""));
        }
    }
})();

/**
 * Constant: VERSION_NUMBER
 */
WPS.VERSION_NUMBER = "$Revision: 81311 $";
WPS.NAMESPACE_URI = 'http://www.disy.net/WPS/wps';
WPS.PREFIX = 'lwps';
WPS.QName = function(localPart) {
  return new Legato.XML.QName(WPS.NAMESPACE_URI, localPart,
      WPS.PREFIX);
};

WPSPD = {
    Result : {}
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.GEOM_POINT_URI = 'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Point';
WPS.GEOM_LINE_STRING_URI = 'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#LineString';
//WPS.GEOM_BOX_URI = 'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Envelope';
WPS.GEOM_POLYGON_URI = 'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Polygon';
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Feature = {};

WPS.Feature.Style = {
  ACTIVE: {
    fillColor: "#fa8072",
    fillOpacity: 0.6,
    hoverFillColor: "white",
    hoverFillOpacity: 0.9,
    strokeColor: "#fa8072",
    strokeOpacity: 1,
    strokeWidth: 2,
    strokeLinecap: "round",
    strokeDashstyle: "solid",
    hoverStrokeColor: "red",
    hoverStrokeOpacity: 1,
    hoverStrokeWidth: 0.2,
    pointRadius: 6,
    hoverPointRadius: 1,
    hoverPointUnit: "%",
    pointerEvents: "visiblePainted",
    cursor: "inherit"
  },
  ACTIVE_HOVER: {
    fillColor: "#ff4500",
    fillOpacity: 0.6,
    hoverFillColor: "white",
    hoverFillOpacity: 0.9,
    strokeColor: "#ff4500",
    strokeOpacity: 1,
    strokeWidth: 2,
    strokeLinecap: "round",
    strokeDashstyle: "solid",
    hoverStrokeColor: "red",
    hoverStrokeOpacity: 1,
    hoverStrokeWidth: 0.2,
    pointRadius: 6,
    hoverPointRadius: 1,
    hoverPointUnit: "%",
    pointerEvents: "visiblePainted",
    cursor: "inherit"
  },
  INACTIVE: {
    fillColor: "#a9a9a9",
    fillOpacity: 0.4,
    hoverFillColor: "white",
    hoverFillOpacity: 0.6,
    strokeColor: "#a9a9a9",
    strokeOpacity: 1,
    strokeWidth: 2,
    strokeLinecap: "round",
    strokeDashstyle: "solid",
    hoverStrokeColor: "red",
    hoverStrokeOpacity: 1,
    hoverStrokeWidth: 0.2,
    pointRadius: 6,
    hoverPointRadius: 1,
    hoverPointUnit: "%",
    pointerEvents: "visiblePainted",
    cursor: "inherit"
  },
  INACTIVE_HOVER: {
    fillColor: "#a9a9a9",
    fillOpacity: 0.4,
    hoverFillColor: "white",
    hoverFillOpacity: 0.6,
    strokeColor: "#a9a9a9",
    strokeOpacity: 1,
    strokeWidth: 2,
    strokeLinecap: "round",
    strokeDashstyle: "solid",
    hoverStrokeColor: "red",
    hoverStrokeOpacity: 1,
    hoverStrokeWidth: 0.2,
    pointRadius: 6,
    hoverPointRadius: 1,
    hoverPointUnit: "%",
    pointerEvents: "visiblePainted",
    cursor: "inherit"
  }
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component = OpenLayers.Class({
  EVENT_TYPES : [ 'activate', 'deactivate', 'validitychange' ],
  id : null,
  model : null,
  map : null,
  container : null,
  titleElement : null,
  checkedBox : null,
  events : null,
  status : null,
  validitySymbol : null,

  initialize : function(id, model, map, options) {
    Legato.Util.Ensure.ensureExists(id, 'Id must be defined.');
    Legato.Util.Ensure.ensureExists(model, 'Model must be defined.');
    Legato.Util.Ensure.ensureExists(map, 'Map must be defined.');
    OpenLayers.Util.extend(this, options);
    this.id = id;
    this.model = model;
    this.map = map;
    this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES);

    this.container = document.createElement('div');
    this.container.id = this.id + '_Container';
    if (this.model.required) {
      OpenLayers.Element.addClass(this.container, 'required');
    }
    this.container.onmouseover = OpenLayers.Function.bindAsEventListener(
        this.hoverIn, this);
    this.container.onmouseout = OpenLayers.Function.bindAsEventListener(
        this.hoverOut, this);
    this.container.component = this;
    var checkedElement = document.createElement('div');
    OpenLayers.Element.addClass(checkedElement, 'isInputChecked');

    this.container.appendChild(checkedElement);

    this.checkedBox = document.createElement('input');
    this.checkedBox.type = 'checkbox';
    this.checkedBox.name = this.id + '_Checked';
    this.checkedBox.checked = this.model.checked;
    this.checkedBox.onclick = OpenLayers.Function.bindAsEventListener(
        this.checkedChanged, this);
    checkedElement.appendChild(this.checkedBox);

    this.validitySymbol = document.createElement('div');
    OpenLayers.Element.addClass(this.validitySymbol, 'validitySymbol');
    this.container.appendChild(this.validitySymbol);

    this.titleElement = document.createElement('div');
    OpenLayers.Element.addClass(this.titleElement, 'title');
    this.titleElement.innerHTML = model.title;
    this.container.appendChild(this.titleElement);

    var inputElement = this.initializeInputs();
    /*jslint sub:true*/
    inputElement.title = model['abstract'];

    if (Legato.Lang.ObjectUtils.exists(this.model.getValue())) {
      this.onModelValueChange({
        value : this.model.getValue()
      });
    }

    this.model.events.on({
      'valuechange' : this.onModelValueChange,
      'validitychange' : this.onModelValidityChange,
      scope : this
    });

    if (this.model.getValue() === null) {
      this.onDeactivation();
    } else {
      this.onActivation();
    }

    this.initializeMetaData();
    this.updateValiditySymbol();
  },
  destroy : function() {

    this.container = null;

    if (Legato.Lang.ObjectUtils.exists(this.events)) {
      this.events.destroy();
      this.events = null;
    }

    if (Legato.Lang.ObjectUtils.exists(this.checkedBox)) {
      this.checkedBox.onclick = null;
      this.checkedBox = null;
    }

    if (Legato.Lang.ObjectUtils.exists(this.container)) {
      this.container.component = null;
      this.container.onmouseover = null;
      this.container.onmouseout = null;
      this.container = null;
    }
    this.model.events.un({
      'valuechange' : this.onModelValueChange,
      'validitychange' : this.onModelValidityChange,
      scope : this
    });
  },

  isActive : function() {
    return (WPS.Component.STATUS_ACTIVE_HOVER === this.status || WPS.Component.STATUS_ACTIVE === this.status);
  },

  isInactive : function() {
    return (WPS.Component.STATUS_INACTIVE_HOVER === this.status || WPS.Component.STATUS_INACTIVE === this.status);
  },

  hoverIn : function() {
    this.onHoverIn();
  },

  hoverOut : function() {
    this.onHoverOut();
  },

  initializeInputs : function() {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the initializeInputs function from from abstract class ' +
        WPS.Component.CLASS_NAME);
  },

  initializeMetaData : function() {
    if (!Legato.Lang.ObjectUtils.isNotEmptyArray(this.model.metadata)) {
      return;
    }
    for ( var i = 0; i < this.model.metadata.length; i++) {
      this.handleMetaData(this.model.metadata[i]);
    }
  },

  handleMetaData : function(metadata) {
    var about = Legato.Lang.ObjectUtils.exists(metadata.about) ? metadata.about : null;
    var href = Legato.Lang.ObjectUtils.exists(metadata.href) ? metadata.href : null;
    var title = Legato.Lang.ObjectUtils.exists(metadata.title) ? metadata.title : null;

    if (about === 'visibility' && href === 'hidden') {
      OpenLayers.Element.hide(this.container);
    }
  },

  isAccessable : function(){
    return OpenLayers.Element.visible(this.container);
  },

  checkedChanged : function(event) {
    var checked = (event.target || event.srcElement).checked;
    this.model.setChecked(checked);
  },


  onModelValueChange : function(event) {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the onModelValueChange function from from abstract class ' +
        WPS.Component.CLASS_NAME);
  },

  updateValiditySymbol : function() {
    this.validitySymbol.title = '';
    if (this.model.valid) {
      OpenLayers.Element.addClass(this.container, 'valid');
      OpenLayers.Element.removeClass(this.container, 'invalid');
    } else {
      OpenLayers.Element.addClass(this.container, 'invalid');
      OpenLayers.Element.removeClass(this.container, 'valid');
      this.validitySymbol.title += this.model.validationMessages.join('; ');
    }
  },

  onModelValidityChange : function(event) {
    this.updateValiditySymbol();
    this.events.triggerEvent('validitychange', {
      component : this
    });
  },

  activate : function() {
    this.onActivation();
  },

  deactivate : function() {
    this.onDeactivation();
  },

  onHoverIn : function() {
    if (WPS.Component.STATUS_INACTIVE === this.status) {
      this.status = WPS.Component.STATUS_INACTIVE_HOVER;
      this.replaceStatusClass('inputContainerInactiveHover');
    } else {
      this.status = WPS.Component.STATUS_ACTIVE_HOVER;
      this.replaceStatusClass('inputContainerActiveHover');
    }
  },

  onHoverOut : function(triggerEvent) {
    if (WPS.Component.STATUS_ACTIVE_HOVER === this.status) {
      this.status = WPS.Component.STATUS_ACTIVE;
      this.replaceStatusClass('inputContainerActive');
    } else {
      this.status = WPS.Component.STATUS_INACTIVE;
      this.replaceStatusClass('inputContainerInactive');
    }
  },

  onActivation : function(triggerEvent) {
    this.status = WPS.Component.STATUS_ACTIVE_HOVER;
    this.replaceStatusClass('inputContainerActiveHover');
    if (triggerEvent) {
      this.events.triggerEvent('activate', {
        component : this
      });
    }
    this.model.setChecked(true);
    this.checkedBox.checked = true;
  },

  onDeactivation : function(triggerEvent) {
    this.status = WPS.Component.STATUS_INACTIVE;
    this.replaceStatusClass('inputContainerInactive');
    if (triggerEvent) {
      this.events.triggerEvent('deactivate', {
        component : this
      });
    }
  },

  replaceStatusClass : function(currentClass) {
    if (this.container) {
      OpenLayers.Element.removeClass(this.container,
          'inputContainerInactive');
      OpenLayers.Element.removeClass(this.container,
          'inputContainerInactiveHover');
      OpenLayers.Element.removeClass(this.container,
          'inputContainerActive');
      OpenLayers.Element.removeClass(this.container,
          'inputContainerActiveHover');
      OpenLayers.Element.addClass(this.container,
          currentClass);
    }
  },

  CLASS_NAME : 'WPS.Component'
});

WPS.Component.STATUS_ACTIVE_HOVER = 1;
WPS.Component.STATUS_ACTIVE = 2;
WPS.Component.STATUS_INACTIVE_HOVER = 3;
WPS.Component.STATUS_INACTIVE = 4;


/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Model = OpenLayers.Class({

  EVENT_TYPES : [ 'valuechange', 'validitychange' ],

  identifier :null,

  title :null,

  'abstract' :null,

  minOccurs :null,

  maxOccurs :1,

  value :null,

  defaultValue :null,

  events :null,

  valueProperty :null,

  checked: false,

  required: false,

  valid: false,

  validationMessages: null,

  initialize : function(modelFactory, options) {
    OpenLayers.Util.extend(this, options);
    this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES);
    this.required = (this.minOccurs > 0);
    this.validationMessages = [];
    if (Legato.Lang.ObjectUtils.exists(this.defaultValue))
    {
      this.setValue(this.defaultValue);
      this.setChecked(true);
    }
    else
    {
      this.validate();
    }
  },

  getValue : function() {
    return this.value;
  },

  setValue : function(value) {
    if (value !== this.value)
    {
      this.value = value;
      this.events.triggerEvent('valuechange', {
        value :value
      });
    }
    this.validate();
  },

  resetValue : function() {
    this.setValue(this.getDefaultValue());
  },

  getDefaultValue: function(){
    return this.defaultValue;
  },

  setDefaultValue: function(defaultValue){
    this.defaultValue = defaultValue;
    if(this.getValue() === null){
      this.setValue(this.defaultValue);
    }
  },

  setChecked : function(checked) {
    this.checked = checked;
    if (! this.checked) {
      this.resetValue();
    }
    this.validate();
  },

  validate: function() {
    var oldValid = this.valid;
    this.validationMessages = [];
    if (this.required && !(this.getValue() && this.checked)) {
      this.valid = false;
      this.validationMessages.push(this.title + ' muss ausgef\u00FCllt werden');
    } else {
      this.valid = true;
    }
    //if (this.valid !== oldValid) {
    //}
    this.events.triggerEvent('validitychange', {
      valid :this.valid,
      validBefore: oldValid
    });
  },

  getData : function() {
    if (this.value === null || !this.checked) {
      return null;
    } else {
      var data = {
        identifier : {
          value :this.identifier
        },
        data : {}
      };
      return [ this.populateData(data) ];
    }
  },

  populateData : function(data) {
    return data;
  },

  destroy : function() {
    if (this.events) {
      this.events.destroy();
      this.events = null;
    }
    this.value = null;
  },

  CLASS_NAME :'WPS.Model'
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: WPS.Form
 */

WPS.Form = OpenLayers.Class({
  EVENT_TYPES : [ 'geoInputActivation', 'processSelectionCancellation', 'processExecutionCancellation', 'on', 'off' ],
  events : null,
  processSelector : null,
  processComponent : null,

  /**
   * Element: allowSelection
   * {Boolean} State variable which remembers that the form is currently on. Might also be set
   * by the WPS.Inceptor class!
   *
   */
  isOn : false,
  map : null,
  currentProcessId : null,
  currentProcessModel : null,
  capabilities : null,
  container : null,
  childContainer : null,
  onCallback : null,
  offCallback : null,
  wpsOperations : null,
  predicate : null,
  resultFactory : null,
  popupCallback : null,
  errorCallback : null,
  txtExecute : null,
  txtSelect : null,
  txtCancel : null,
  componentFactoryOptions : null,

  /**
   * Constructor: WPS.Form
   *
   * Creates a new WPS form.
   *
   * Parameters: map - {<OpenLayers.Map>} The map. options - {Object} Optional
   * object whose properties will be set on the instance.
   */
  initialize : function(map, options) {
    Legato.Util.Ensure.ensureExists(map, "map must be defined");
    this.map = map;
    OpenLayers.Util.extend(this, options);
    this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES);
    if (this.container === null) {
      this.container = document.createElement('div');
      this.container.className = 'wpsForm';
    }
    if (this.wpsOperations === null) {
      this.wpsOperations = WpsOperations;
    }
    if (this.resultFactory === null) {
      this.resultFactory = new WPS.Result.Factory(this.map, this);
    }
    if (!Legato.Lang.ObjectUtils.isString(this.txtExecute)) {
      this.txtExecute = 'OK';
    }
    if (!Legato.Lang.ObjectUtils.isString(this.txtSelect)) {
      this.txtSelect = 'OK';
    }
    if (!Legato.Lang.ObjectUtils.isString(this.txtCancel)) {
      this.txtCancel = 'Cancel';
    }
    if (!Legato.Lang.ObjectUtils.isObject(this.componentFactoryOptions)) {
      this.componentFactoryOptions = {};
    }
  },

  initCapabilities : function() {
    this.capabilitiesReady = false;
    var getCapabilitiesRequest = {
      service : 'WPS',
      acceptVersions : {
        version : [ '1.0.0' ]
      }
    };
    this.wpsOperations.getCapabilities(getCapabilitiesRequest, OpenLayers.Function.bind(function(capabilities) {
      if (Legato.Lang.ObjectUtils.exists(capabilities) && Legato.Lang.ObjectUtils.exists(capabilities.processOfferings)
          && Legato.Lang.ObjectUtils.exists(capabilities.processOfferings.process)) {
        var predicate;
        if (Legato.Lang.ObjectUtils.exists(this.predicate)) {
          predicate = this.predicate;
        } else {
          predicate = this.createDefaultPredicate();
        }
        var processes = [];
        for ( var processIndex = 0; processIndex < capabilities.processOfferings.process.length; processIndex++) {
          var process = capabilities.processOfferings.process[processIndex];
          if (predicate.evaluate(process)) {
            processes.push(process);
          }
        }
        this.capabilities = processes;

      } else {
        this.capabilities = null;
      }
      this.capabilitiesReady = true;
    }, this));
  },
  createDefaultPredicate : function() {
    return new WPS.Predicate.MapTags(this.map, {
      prefix : 'wps:form:',
      defaultIncludes : true
    });
  },
  onWithCapabilities : function() {
    if (this.capabilitiesReady) {
      if (!Legato.Lang.ObjectUtils.exists(this.currentProcessId)) {
        this.processSelector = new WPS.ProcessSelector(this.capabilities, OpenLayers.Function.bind(this.selectProcess, this), OpenLayers.Function.bind(
            this.cancelSelection, this), {
          txtSelect : this.txtSelect,
          txtCancel : this.txtCancel
        });
        this.replaceChildContainer(this.processSelector.container);
      } else {
        this.processComponent = new WPS.Component.Process(this.currentProcessModel, this.map, OpenLayers.Function.bind(this.execute, this), OpenLayers.Function
            .bind(this.cancelExecution, this), {
          txtExecute : this.txtExecute,
          txtCancel : this.txtCancel,
          componentFactoryOptions : this.componentFactoryOptions
        });
        this.processComponent.events.on({
          'geoInputActivation' : this.geoInputActivated,
          scope : this
        });
        this.replaceChildContainer(this.processComponent.container);
      }

      this.isOn = true;
      this.events.triggerEvent('on', {});
      OpenLayers.Element.show(this.container);
      if (this.onCallback) {
        this.onCallback(this);
      }
      return;
    } else {
      setTimeout(OpenLayers.Function.bind(this.onWithCapabilities, this), 200);
    }
  },

  destroy : function() {
    if (Legato.Lang.ObjectUtils.exists(this.events)) {
      this.events.destroy();
      this.events = null;
    }
    this.destroyChildren();
  },

  destroyProcessSelector : function() {
    this.processSelector.destroy();
    this.processSelector = null;
    this.childContainer = null;
    this.container.innerHTML = '';
  },

  destroyProcessComponent : function() {
    if (Legato.Lang.ObjectUtils.exists(this.processComponent.events)) {
      this.processComponent.events.un({
        'geoInputActivation' : this.geoInputActivated,
        scope : this
      });
    }
    this.processComponent.destroy();
    this.processComponent = null;
    this.childContainer = null;
    this.container.innerHTML = '';
  },

  destroyChildren : function() {
    if (Legato.Lang.ObjectUtils.exists(this.processSelector)) {
      this.destroyProcessSelector();
    }
    if (Legato.Lang.ObjectUtils.exists(this.processComponent)) {
      this.destroyProcessComponent();
    }
  },

  geoInputActivated : function(event) {
    this.events.triggerEvent('geoInputActivation', {});
  },

  on : function() {
    if (!Legato.Lang.ObjectUtils.exists(this.capabilities)) {
      this.initCapabilities();
    }
    this.onWithCapabilities();
  },

  replaceChildContainer : function(container) {
    this.container.innerHTML = '';
    this.childContainer = container;
    this.container.appendChild(this.childContainer);
  },

  selectProcess : function(processId, closeForm) {
    this.currentProcessId = null;
    var describeProcessRequest = {
      identifier : [ {
        value : processId
      } ]
    };
    this.wpsOperations.describeProcess(describeProcessRequest, OpenLayers.Function.bind(function(processDescriptions) {
      // var processDescription =
      // Legato.Lang.ArrayUtils.get(processDescriptions.processDescription, 0);
      var processDescription = processDescriptions.processDescription[0];
      if (Legato.Lang.ObjectUtils.exists(processDescription)) {
        this.activateProcessDescription(processDescription, closeForm);
      } else {
        // should never happen
        alert('Could not retrieve WPS process description from server');
      }
    }, this));
  },
  activateProcessDescription : function(processDescription, closeForm) {
    this.currentProcessId = processDescription.identifier.value;
    this.currentProcessModel = new WPS.Model.Process(processDescription);
    var onExecute = OpenLayers.Function.bind(this.execute, this);
    var onCancel = Legato.Lang.ObjectUtils.isTrue(closeForm) ? OpenLayers.Function.bind(this.cancelExecutionAndCloseForm, this) : OpenLayers.Function.bind(
        this.cancelExecutionAndShowSelection, this);
    this.processComponent = new WPS.Component.Process(this.currentProcessModel, this.map, onExecute, onCancel, {
      txtExecute : this.txtExecute,
      txtCancel : this.txtCancel,
      componentFactoryOptions: this.componentFactoryOptions
    });
    this.processComponent.events.on({
      'geoInputActivation' : this.geoInputActivated,
      scope : this
    });
    this.replaceChildContainer(this.processComponent.container);
  },
  cancelSelection : function() {
    this.currentProcessId = null;
    this.events.triggerEvent('processSelectionCancellation', {});
  },
  cancelExecutionAndCloseForm : function() {
    this.cancelExecution();
    this.off();
  },
  cancelExecutionAndShowSelection : function() {
    this.cancelExecution();
  },
  cancelExecution : function() {
    this.destroyProcessComponent();
    if (Legato.Lang.ObjectUtils.exists(this.currentProcessModel)) {
      this.currentProcessModel.destroy();
      this.currentProcessModel = null;
    }

    this.events.triggerEvent('processExecutionCancellation', {
      processId : this.currentProcessId
    });

    this.currentProcessId = null;

    // If there are no capabilities we just turn off
    if (!Legato.Lang.ObjectUtils.exists(this.capabilities)) {
      this.off();
      return;
    }

    this.processSelector = new WPS.ProcessSelector(
      this.capabilities,
      OpenLayers.Function.bind(this.selectProcess, this),
      OpenLayers.Function.bind(this.cancelSelection, this),
      {
        txtCancel: this.txtCancel,
        txtExecute: this.txtExecute
      }
    );
    this.replaceChildContainer(this.processSelector.container);
  },

  execute : function(process, executeRequest) {
    this.wpsOperations.execute(executeRequest, OpenLayers.Function.bind(function(executeResponse) {
      var result = this.resultFactory.createResult(executeResponse, this.popupCallback, this.errorCallback);
      result.execute();
    }, this));
  },

  off : function() {
    this.destroyChildren();
    this.isOn = false;
    this.events.triggerEvent('off', {});
    OpenLayers.Element.hide(this.container);
    if (this.offCallback) {
      this.offCallback(this);
    }
  },

  activate : function() {
    if (this.isOn && Legato.Lang.ObjectUtils.exists(this.processComponent)) {
      this.processComponent.activate();
    }
  },

  deactivate : function() {
    if (this.isOn && Legato.Lang.ObjectUtils.exists(this.processComponent)) {
      this.processComponent.deactivate();
    }
  },

  CLASS_NAME : 'WPS.Form'
});

/**
 * Structure: lwps:Form
 * XML-based configuration for a {<WPS.Form>}.
 *
 * Configuration example:
 * (start code)
 * <lwps:Form xmlns:lwps="http://www.disy.net/WPS/wps">
 *   <map>
 *     <lb:Reference target="map" />
 *   </map>
 *   <wpsOperations>
 *     <lb:Reference target="WpsOperations" />
 *   </wpsOperations>
 * </lwps:Form>
 * (end)
 */
WPS.Form.Bean = Legato.Beans.Object.Extend('WPS.Form',
//
WPS.QName('Form'),
//
{
  _constructor : WPS.Form,
  constructorArguments : {
    /**
     * Property: map {<OpenLayers.Map>} The map.
     */
    map : OpenLayers.Map.Bean
  },
  constructorOrder : [ 'map' ],
  options : {
    container : Legato.Lang.Element,
    onCallback : Legato.Lang.Function,
    offCallback : Legato.Lang.Function,
    popupCallback : Legato.Lang.Function,
    errorCallback : Legato.Lang.Function,
    /**
     * Property: wpsOperations {Object} WPS operations object.
     */
    wpsOperations : Legato.Beans.Object,
    predicate : Legato.Beans.Object,
    txtExecute : Legato.Lang.String,
    txtSelect : Legato.Lang.String,
    txtCancel : Legato.Lang.String,
    componentFactoryOptions : Legato.Beans['Object{}']
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.ToolbarManager = OpenLayers.Class( {
  map :null,
  panel :null,
  form :null,
  wpsOperations :null,
  predicate :null,
  initialize : function(map, panel, options) {
    Legato.Util.Ensure.ensureObject(map);
    this.map = map;
    this.panel = panel;
    OpenLayers.Util.extend(this, options);
    this.map.events.on( {
      'legato.refresh' :this.manageToolbar,
      scope :this
    });
  },
  destroy : function() {
    this.map.events.un( {
      'legato.refresh' :this.manageToolbar,
      scope :this
    });
  },
  manageToolbar : function() {
    var getCapabilitiesRequest = {
      service :'WPS',
      acceptVersions : {
        version : [ '1.0.0' ]
      }
    };
    this.wpsOperations.getCapabilities(getCapabilitiesRequest,
        OpenLayers.Function.bind( function(capabilities) {

          //iterate over panel elements
          var panelButtons = new Legato.Util.HashSet();
          for (var ind = 0; ind < this.panel.controls.length; ind++) {
            var panelButton = this.panel.controls[ind];
            if (panelButton.CLASS_NAME == "WPS.Control.WpsButton") {
              panelButtons.add(panelButton.processIdentifier);
            }
          }

          var buttons = [];
          var processDescriptions = capabilities.processOfferings.process;
          var predicate;
          if (Legato.Lang.ObjectUtils.exists(this.predicate)) {
            predicate = this.predicate;
          } else {
            predicate = this.createDefaultPredicate();
          }
          for ( var index = 0; index < processDescriptions.length; index++) {
            var processDescription = processDescriptions[index];
            if (predicate.evaluate(processDescription) && !panelButtons.contains(processDescription.identifier.value)) {
              var button = new WPS.Control.WpsButton( {
                form :this.form,
                wpsOperations :this.wpsOperations,
                processDescription :processDescription
              });
              buttons.push(button);
            }
          }
          this.panel.addControls(buttons);
        }, this));
  },
  createDefaultPredicate : function() {
    return new WPS.Predicate.MapTags(this.map, {
      prefix :'wps:toolbar:',
      defaultIncludes :false
    });
  },
  CLASS_NAME :'WPS.ToolbarManager'
});
WPS.ToolbarManager.Bean = Legato.Beans.Object.Extend('WPS.ToolbarManager',
//
    WPS.QName('ToolbarManager'),
    //
    {
      _constructor :WPS.ToolbarManager,
      constructorArguments : {
        map :Legato.Beans.Object,
        panel :Legato.Beans.Object
      },
      constructorOrder : [ 'map', 'panel' ],
      options : {
        form :Legato.Beans.Object,
        wpsOperations :Legato.Lang.Function,
        predicate :Legato.Beans.Object
      }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: WPS.Inceptor
 *
 * Activates a default process description in the target WPS form.
 *
 * The default process description is provided by the configured inception
 * function of the form:
 * (start code)
 * function incept(activate) {
 *   var myProcessDescription = ...;
 *   activate(myProcessDescription);
 * }
 * (end)
 */
WPS.Inceptor = OpenLayers.Class({
  map : null,
  form : null,
  inception : null,
  resultFactory: null,
  autoExecutionPredicate: null,
  /**
   * Constructor: WPS.Inceptor
   *
   * Creates a new WPS inceptor.
   *
   * Parameters:
   * map - {<OpenLayers.Map>} The map.
   * form - {<WPS.Form>} Target WPS form.
   * inception - {Function} Inception function which provides
   * the default process description.
   */
  initialize : function(map, form, inception, options) {
    Legato.Util.Ensure.ensureObject(map);
    Legato.Util.Ensure.ensureObject(form);
    Legato.Util.Ensure.ensureFunction(inception);
    this.map = map;
    this.form = form;
    this.inception = inception;
//    this.map.events.on({
//      'legato.refresh' : this.incept,
//      scope : this
//    });
    this.autoExecutionPredicate = new WPS.Predicate.Metadata('auto', {about : 'execution'});
    this.resultFactory = new WPS.Result.Factory(map, null);

    this.incept();
  },
  destroy : function() {
//    this.map.events.un({
//      'legato.refresh' : this.incept,
//      scope : this
//    });
  },
  incept : function() {
    var that = this;
    that.inception(function(processDescription) {
      if (Legato.Lang.ObjectUtils.exists(processDescription)) {
        if (that.autoExecutionPredicate.evaluate(processDescription))
        {
          var processModel = new WPS.Model.Process(processDescription);

          var executeRequest = processModel.getData();
          if (!Legato.Lang.ObjectUtils.exists(executeRequest.service)) {
            executeRequest.service = 'WPS';
          }
          if (!Legato.Lang.ObjectUtils.exists(executeRequest.version)) {
            executeRequest.version = '1.0.0';
          }
          that.form.execute(null, executeRequest);
        }
        else
        {
          that.form.activateProcessDescription(processDescription, true);
          //Has to be set, otherwise the form does not know that it has been activated by the inceptor
          that.form.isOn = true;
          if (that.form.onCallback) {
            that.form.onCallback(that.form);
          }
        }
      }
    });
  },
  CLASS_NAME : 'WPS.Inceptor'
});
/**
 * Structure: lwps:Inceptor
 * XML-based configuration for a {<WPS.Inceptor>}.
 *
 * Configuration example:
 * (start code)
 * <lwps:Inceptor xmlns:lwps="http://www.disy.net/WPS/wps">
 *   <map>
 *     <lb:Reference target="map" />
 *   </map>
 *   <form>
 *     <lb:Reference target="WPSForm" />
 *   </form>
 *   <inception>
 *     <lb:Reference target="WpsInception" />
 *   </inception>
 * </lwps:Inceptor>
 * (end)
 */
WPS.Inceptor.Bean = Legato.Beans.Object.Extend('WPS.Inceptor',
//
WPS.QName('Inceptor'),
//
{
  _constructor : WPS.Inceptor,
  constructorArguments : {
    /**
     * Property: map
     * {<OpenLayers.Map>} The map.
     */
    map : Legato.Beans.Object,
    /**
     * Property: form
     * {<WPS.Form>} Target WPS form.
     */
    form : Legato.Beans.Object,
    /**
     * Property: inception
     * {Function} Inception function.
     */
    inception : Legato.Lang.Function
  },
  constructorOrder : [ 'map', 'form', 'inception' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Revision: 69543 $
 * @requires WPS.js
 */

/**
 * Structure: WPS.Predicate Abstract base class for all WPS process predicates
 * 
 */
WPS.Predicate = OpenLayers.Class( {
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(processDescription) {
    return true;
  },
  CLASS_NAME :'WPS.Predicate'
});

WPS.Predicate.And = OpenLayers.Class( {
  predicates :null,
  initialize : function(predicates) {
    this.predicates = predicates;
  },
  evaluate : function(processDescription) {
    for ( var index = 0; index < this.predicates.length; index++) {
      var currentPredicate = this.predicates[index];
      if (!currentPredicate.evaluate(processDescription)) {
        return false;
      }
    }
    return true;
  },
  CLASS_NAME :'WPS.Predicate.And'
});

WPS.Predicate.Or = OpenLayers.Class( {
  predicates :null,
  initialize : function(predicates) {
    Legato.Util.Ensure.ensureArray(predicates);
    this.predicates = predicates;
  },
  evaluate : function(processDescription) {
    for ( var index = 0; index < this.predicates.length; index++) {
      var currentPredicate = this.predicates[index];
      if (currentPredicate.evaluate(processDescription)) {
        return true;
      }
    }
    return false;
  },
  CLASS_NAME :'WPS.Predicate.Or'
});

WPS.Predicate.Not = OpenLayers.Class( {
  predicate :null,
  initialize : function(predicate) {
    this.predicate = predicate;
  },
  evaluate : function(processDescription) {
    return !this.predicate.evaluate(processDescription);
  },
  CLASS_NAME :'WPS.Predicate.Not'
});
WPS.Predicate.True = OpenLayers.Class( {
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(processDescription) {
    return true;
  },
  CLASS_NAME :'WPS.Predicate.True'
});
WPS.Predicate.False = OpenLayers.Class( {
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(processDescription) {
    return false;
  },
  CLASS_NAME :'WPS.Predicate.False'
});

/*
 * Property: NAMESPACE_URI Defines the Namespace URI for all WPS Predicate
 * Elements. Needed in XML based config files.
 */
WPS.Predicate.NAMESPACE_URI = 'http://www.disy.net/WPS/predicate';

/*
 * Property: PREFIX Global defined prefix for all WPS Predicate classes.
 */
WPS.Predicate.PREFIX = 'lwpsp';

/*
 * Property: QName Defines the qualified name. Needed for XML based config.
 */
WPS.Predicate.QName = function(localPart) {
  return new Legato.XML.QName(WPS.Predicate.NAMESPACE_URI, localPart,
      WPS.Predicate.PREFIX);
};

/**
 * Structure: lwpsp:somePredicate XML based config for a <WPS.Predicate>
 * subclasses.
 * 
 * See Also: - <Predicate>
 * - &lt;QName&gt;
 * - &lt;PREFIX&gt;
 * - &lt;Legato.Beans.BeanFactory&gt;
 * All WPS predicates could be configured using XML. If so, the config needs to define
 * the namespace prefix (&lt;PREFIX&gt;). The needed namespace URL should point to &lt;NAMESPACE_URI&gt;.
 * After that you're able to configure all WPS predicate subclasses via XML.
 * A valid example could be:
 * (start code)
 * &lt;lwpsp:somePredicate foo=&quot;bar&quot;/&gt;
 * (end)
 * For detailed informations have a look at the &lt;WPS.Predicate&gt; subclass documentation.
 * 
 */
WPS.Predicate.Bean = Legato.Beans.Object.Extend('WPS.Predicate',
//
    WPS.Predicate.QName('Predicate'),
    //
    {
      _constructor :WPS.Predicate
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Predicate.Metadata = OpenLayers.Class( {
  about :'tag',
  value :null,
  initialize : function(value, options) {
    Legato.Util.Ensure.ensureString(value);
    this.value = value;
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(processDescription) {
    var metadata = processDescription.metadata;
    for ( var index = 0; index < metadata.length; index++) {
      var item = metadata[index];
      if (item.about === this.about) {
        if (this.value === item.href) {
          return true;
        }
      }
    }
    return false;
  },
  CLASS_NAME :'WPS.Predicate.Metadata'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Predicate.MapTags = OpenLayers.Class( {
  map :null,
  defaultIncludes :true,
  prefix :'wps:',
  includeInfix :'include:metadata:tag',
  includeTagName :null,
  predicate :null,
  initialize : function(map, options) {
    Legato.Util.Ensure.ensureObject(map);
    this.map = map;
    OpenLayers.Util.extend(this, options);
    this.includeTagName = this.prefix + this.includeInfix;
    this.initializePredicate();
  },
  initializePredicate : function() {
    if (Legato.Lang.ObjectUtils.isArray(this.map.tags)) {
      this.predicate = this.createPredicate(this.map.tags);
    } else {
      this.predicate = this.createDefaultPredicate();
    }
  },
  createDefaultPredicate : function() {
    if (this.defaultIncludes) {
      return new WPS.Predicate.True();
    } else {
      return new WPS.Predicate.False();
    }
  },
  createPredicate : function(tags) {
    var includePredicates = [];
    if (Legato.Lang.ObjectUtils.isArray(tags)) {
      for ( var index = 0; index < tags.length; index++) {
        var tag = tags[index];
        if (tag.name == this.includeTagName
            && Legato.Lang.ObjectUtils.isString(tag.value)) {
          var includePredicate = new WPS.Predicate.Metadata(tag.value);
          includePredicates.push(includePredicate);
        }
      }
    }
    if (includePredicates.length === 0) {
      return this.createDefaultPredicate();
    } else {
      return new WPS.Predicate.Or(includePredicates);
    }
  },
  evaluate : function(processDescription) {
    return this.predicate.evaluate(processDescription);
  },
  CLASS_NAME :'WPS.Predicate.MapTags'
});

WPS.Predicate.MapTags.Bean = WPS.Predicate.Bean.Extend('WPS.Predicate.MapTags',
//
    WPS.Predicate.QName('MapTags'),
    //
    {
      _constructor :WPS.Predicate.MapTags,
      constructorArguments : {
        map :Legato.Beans.Object
      },
      constructorOrder : [ 'map' ],
      options : {
        prefix :Legato.Lang.String,
        defaultIncludes :Legato.Lang.Boolean
      }
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.ProcessSelector = OpenLayers.Class( {
  container: null,
  menuContainer: null,
  menuElement: null,
  processDescriptions: null,
  selectedCallback: null,
  cancelCallback: null,
  abstractElement: null,
  buttonsElement: null,
  okButton: null,
  cancelButton: null,
  selectedProcessId: null,
  txtSelect: 'OK',
  txtCancel: 'Cancel',
  initialize : function(processDescriptions, selectedCallback, cancelCallback, options) {
    Legato.Util.Ensure.ensureArray(processDescriptions, "processDescriptions should be defined");
    Legato.Util.Ensure.ensureFunction(selectedCallback, "selected callback should be a function");
    Legato.Util.Ensure.ensureFunction(cancelCallback, "cancel callback should be a function");
    this.processDescriptions = processDescriptions;
    this.selectedCallback = selectedCallback;
    this.cancelCallback = cancelCallback;
    OpenLayers.Util.extend(this, options);
    if (this.container === null) {
      this.container = document.createElement('div');
      this.container.className = 'wpsContainer';
    }

    this.titleElement = document.createElement('div');
    this.titleElement.className = 'wpsContainerTitle';
    this.titleElement.innerHTML = 'Auswahl';
    this.container.appendChild(this.titleElement);

    this.abstractElement =  document.createElement('div');
    this.abstractElement.className = 'wpsContainerAbstract';
    this.abstractElement.innerHTML = 'Web Processing Services (WPS) erweitern den Funktionsumfang von GISterm durch zentral bereitgestellte Dienste. Bitte w\u00E4hlen Sie einen WPS-Dienst aus.';
    this.container.appendChild(this.abstractElement);

    this.generateInputContainer();

    this.buttonsElement = document.createElement('div');
    this.buttonsElement.className = 'wpsButtons';
    this.container.appendChild(this.buttonsElement);

    this.okButton = document.createElement('input');
    this.okButton.id = 'wpsProcessSelectionOKButton';
    this.okButton.type = 'button';
    this.okButton.value = this.txtSelect;
    this.okButton.disabled = true;
    this.okButton.onclick = OpenLayers.Function.bindAsEventListener(
        this.okButtonClicked, this);
    this.buttonsElement.appendChild(this.okButton);

    this.cancelButton = document.createElement('input');
    this.cancelButton.id = 'wpsProcessSelectionCancelButton';
    this.cancelButton.type = 'button';
    this.cancelButton.value = this.txtCancel;
    this.cancelButton.disabled = false;
    this.cancelButton.onclick = OpenLayers.Function.bindAsEventListener(
        this.cancelButtonClicked, this);
    this.buttonsElement.appendChild(this.cancelButton);
  },

  okButtonClicked: function() {
    this.selectedCallback(/*this, */this.selectedProcessId);
  },

  cancelButtonClicked: function() {
    this.selectProcess(null);
    var options = this.menuElement.childNodes;
    for (var i=0; i < options.length; i++) {
      var value = options[i].value;
      if ('' === value) {
        options[i].selected = true;
      } else {
        options[i].selected = false;
      }
    }
    this.cancelCallback(this);
  },

  generateInputContainer: function() {
    var inputContainer =  document.createElement('div');
    inputContainer.className = 'wpsProcessSelectionInputsContainer';

    this.menuContainer = document.createElement('div');
    this.menuContainer.className = 'wpsProcessSelectionDropDownContainer';

    this.menuElement = document.createElement('select');
    this.menuElement.id = 'wpsProcessesSelectionDropDown';
    this.menuElement.className = 'wpsProcessesSelectionDropDown';
    this.menuElement.size = this.processDescriptions.length > 10 ? 10 : this.processDescriptions.length;

    this.menuElement.onchange = OpenLayers.Function.bindAsEventListener(
        this.processChanged, this);

    this.menuContainer.appendChild(this.menuElement);
    inputContainer.appendChild(this.menuContainer);

    this.descriptionContainer = document.createElement('div');
    this.descriptionContainer.className = 'wpsProcessSelectionDescriptionContainer';

    this.descriptionInfoText = document.createElement('div');
    this.descriptionInfoText.className = 'wpsProcessSelectionInfoText';
    this.descriptionInfoText.innerHTML = 'Beschreibung';

    this.abstractElement = document.createElement('div');
    this.abstractElement.className = 'wpsProcessSelectionAbstract';
    this.abstractElement.innerHTML = '';
    OpenLayers.Element.hide(this.descriptionContainer);

    this.descriptionContainer.appendChild(this.descriptionInfoText);
    this.descriptionContainer.appendChild(this.abstractElement);
    inputContainer.appendChild(this.descriptionContainer);

    this.container.appendChild(inputContainer);

    for (var index = 0; index < this.processDescriptions.length; index++)
    {
      var process = this.processDescriptions[index];
      this.menuElement.appendChild(this.createOption(process.title.value, process.identifier.value, false));
    }
  },

  createOption : function(name, value, selected) {
    var option = document.createElement('option');
    option.value = value;
    option.selected = selected;
    option.innerHTML = name;
    option.title = name;
    return option;
  },

  processChanged: function(event) {
    var selectedProcessId = (event.target || event.srcElement).value;
    this.selectProcess(selectedProcessId);
  },

  selectProcess: function(processId) {
    this.selectedProcessId = null;
    if (processId) {
      for (var index = 0; index < this.processDescriptions.length; index++)
      {
        var process = this.processDescriptions[index];
        if (processId === process.identifier.value) {
          this.selectedProcessId = processId;
          /*jslint sub:true*/
          this.abstractElement.innerHTML = process['abstract'].value;
          OpenLayers.Element.show(this.descriptionContainer);
          this.okButton.disabled = false;
          break;
        }
      }
    }
    if (! this.selectedProcessId)  {
      this.abstractElement.innerHTML = '';
      OpenLayers.Element.hide(this.descriptionContainer);
      this.okButton.disabled = true;
    }
  },

  destroy: function() {
    this.processDescriptions = null;
    this.selectedCallback = null;
    this.cancelCallback = null;
  },

  CLASS_NAME :'WPS.ProcessSelector'
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result = OpenLayers.Class({

  id :null,

  title :null,

  description :null,

  popupCallback: null,

  errorCallback: null,

  initialize : function(id, options) {
    Legato.Util.Ensure.ensureExists(id, 'id should be defined');
    this.id = id;
    OpenLayers.Util.extend(this, options);

    if (!Legato.Lang.ObjectUtils.isString(this.title)) {
      this.title = this.createDefaultTitle();
    }
    if (!Legato.Lang.ObjectUtils.isString(this.description)) {
      this.description = this.createDefaultDescription();
    }
  },

  createDefaultTitle : function() {
    return '...';
  },

  createDefaultDescription : function() {
    return null;
  },

  destroy : function() {
    this.id = null;
    this.title = null;
    this.description = null;
  },

  execute : function() {
  },

  createContent : function() {
    var content = document.createElement('div');
    return content;
  },

  CLASS_NAME :'WPS.Result'
});

WPS.Result.SimpleFactory = OpenLayers.Class({

  map: null,

  initialize : function(map) {
    this.map = map;
  },

  destroy : function() {
    this.map = null;
  },

  createResult: function(id, outputData, options)
  {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the createResult function from from abstract class ' +
        WPS.Result.SimpleFactory.CLASS_NAME);
  },

  CLASS_NAME :'WPS.Result.SimpleFactory'
});

WPS.Result.ComplexFactory = OpenLayers.Class({

  schema: null,

  elementName: null,

  map: null,

  initialize : function(map) {
    this.map = map;
  },

  destroy : function() {
    this.schema = null;
    this.elementName = null;
    this.map = null;
  },

  createResult: function(id, outputData, options)
  {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the createResult function from from abstract class ' +
        WPS.Result.ComplexFactory.CLASS_NAME);
  },

  CLASS_NAME :'WPS.Result.ComplexFactory'
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires WPS.js
 * @requires OpenLayers/Control.js
 */

/**
 * Structure: WPS.Control
 * Abstract base class for all WPS control classes
 *
 * Inherits from:
 *  - <OpenLayers.Control>
 */
WPS.Control =
  OpenLayers.Class(Legato.Control, {
    CLASS_NAME: 'WPS.Control'
});

/*
 * Property: NAMESPACE_URI
 * Defines the Namespace URI for all Legato Control Element. Needed in XML based config
 * file.
 */
WPS.Control.NAMESPACE_URI = 'http://www.disy.net/WPS/control';

/*
 * Property: PREFIX
 * Global defined prefix for all WPS Control classes.
 */
WPS.Control.PREFIX = 'lwpsc';

/*
 * Property: QName
 * Defines the qualified name. Needed for XML based config.
 */
WPS.Control.QName = function(localPart)
{
  return new Legato.XML.QName(WPS.Control.NAMESPACE_URI, localPart, WPS.Control.PREFIX);
};

/**
 * Structure: wpc:someControl
 * XML based config for a <WPS.Control> subclass.
 *
 * See Also:
 * - <Control>
 * - <QName>
 * - <PREFIX>
 * - <Legato.Beans.BeanFactory>
 *
 * All legato controls could be configured using xml. If so, the config needs to define
 * the namespace prefix (<PREFIX>). The needed NS URL should point to <NAMESPACE_URI>.
 * After that you're able to configure all legato control subclasses via XML.
 *
 * A valid example could be
 *
 * (start code)
 * <lwpsc:someControl foo="bar"/>
 * (end)
 *
 * For detailed informations have a look at the <WPS.Control> subclass documentation.
 */
WPS.Control.Bean = Legato.Control.Bean.Extend('WPS.Control',
    //
    WPS.Control.QName('Control'),
    //
    {
   _constructor :WPS.Control
});




/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: WPS.Control.ToggleWpsForm
 *
 * Switches WPS form on and off
 *
 * Inherits from:
 * - <Legato.Control>
 *
 */
WPS.Control.GeoControlSync = OpenLayers.Class(WPS.Control, {

  form: null,
  initialize : function(options) {
    if (! options.displayClass) {
      options.displayClass = 'LegatoControlInvisible';
    }
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.events.on({
        'geoInputActivation': this.geoInputActivated,
        scope: this
      });
    }
  },

  geoInputActivated: function() {
    Legato.Util.fireDOMEvent(this.panel_div, "click");
  },

  destroy: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.events.un({
        'geoInputActivation': this.activate,
        scope: this
      });
    }
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },


  /** Function: activate
   * Invoked when the control is activated in toggle mode
   */
  activate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.activate();
    }
    WPS.Control.prototype.activate.apply(this, arguments);
  },

  /** Function: deactivate
   * Invoked when the control is deactivated in toggle mode
   */
  deactivate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.deactivate();
    }
    WPS.Control.prototype.deactivate.apply(this, arguments);
  },

  CLASS_NAME :"WPS.Control.GeoControlSync"
});

/**
 * Structure: wpc:ToggleWpsForm
 * XML based config for a <WPS.Control.GeoControlSync>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ToggleDiv would be:
 * (start code)
 * <lwpsc:GeoControlSync>
 * <form>
 * <lb:Reference target="WpsForm" />
 * </form>
 * </lwpsc:GeoControlSync>
 * (end)
 */
WPS.Control.GeoControlSync.Bean = WPS.Control.Bean.Extend(
  'WPS.Control.GeoControlSync',
  //
  WPS.Control.QName('GeoControlSync'),
  //
  {
    _constructor : WPS.Control.GeoControlSync,
    options:
    {
      form: WPS.Form
    }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: WPS.Control.GeometryEditor
 *
 * The Geometry editor gives access to the legato map client. It is possible
 * to create and edit geometrys using JS code.
 *
 * Inherits from: - <WPS.Contro>
 *
 */
WPS.Control.GeometryEditor = OpenLayers.Class( WPS.Control, {

  /*
   * {<OpenLayers.Map>} the current used map
   */
  map: null,


  /*
   * {<DOMElement>} the element where this control will be rendered
   */
  div: null,

  /*
   * {Object} the current wps process description hashmap
   */
  processDescription: null,

  /*
   * {<WPS.Model.Process>} the current wps process model
   */
  currentProcessModel: null,

  /*
   * {<WPS.Component.Process>} the current wps process component
   */
  processComponent: null,

  /*
   * Function: initialize
   * Basic constructor
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control
   * The following keys are supported
   * - map {<OpenLayers.Map>} The current map
   */
  initialize : function(options) {
    Legato.Util.Ensure.ensureExists(options.map, "form must be defined");
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
  },

  /*
   * Function: destroy
   *
   * See Also:
   * <OpenLayer.Control>
   */
  destroy : function() {
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  /*
   * Function: draw
   *
   * See Also:
   * <OpenLayer.Control>
   */
  draw: function () {
    OpenLayers.Control.prototype.draw.apply(this, arguments);
    return this.div;
  },


  /*
   * Function: resets the Geometry Editor and clears the editor form
   */
  reset:function(){
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.processComponent) &&
       !Legato.Lang.ObjectUtils.isNullOrUndefined(this.processComponent.container)){
     this.div.removeChild(this.processComponent.container);
     this.processComponent.destroy();
     this.currentProcessModel.destroy();
     this.processComponent = null;
     this.currentProcessModel = null;
     this.processDescription = null;
    }
  },

  /**
   * Function: createGeometry
   *
   * Shows a Form in configured div and enables the user to paint a geometry based on given
   * process settings.
   *
   * Parameters:
   * processDesc - {Object} A Hashmap containing the description for the process
   * The following keys are supported
   * - id {String} The id for this process
   * - title {String} A title describing this process
   * - description {String} A detailed description for this process
   *
   * paramDesc - {Object} A Hashmap containing the description for the process parameter
   * The following keys are supported
   * - id {String} The id for this process
   * - title {String} A title describing this process
   * - description {String} A detailed description for this process
   * - type {String} The geometry type which will been painted by the user (e.g. Point, Polygon, etc)
   *
   * onExecute - {Function} A callback method which will been executed after the user has finished
   *   the procress. If this callback returns true the editor resets itself automatically.
   * onCancel - {Function} A callback method which will been executed if the user has canceled
   *   this process. If this callback returns true the editor resets itself automatically.
   */
  createGeometry: function(processDesc, paramDesc, onExecute, onCancel){
    this.reset();
    this.processDescription = this.createCreateGeometryProcressDesc(processDesc, paramDesc);
    this.execute(this.processDescription, onExecute, onCancel);
  },

  /**
   * Function: createGeometry
   *
   * Shows a Form in configured div and enables the user to edit the given geometry.
   *
   * Parameters:
   * processDesc - {Object} A Hashmap containing the description for the process
   * The following keys are supported
   * - id {String} The id for this process
   * - title {String} A title describing this process
   * - description {String} A detailed description for this process
   *
   * paramDesc - {Object} A Hashmap containing the description for the process parameter
   * The following keys are supported
   * - id {String} The id for this process
   * - title {String} A title describing this process
   * - description {String} A detailed description for this process
   * - geometry {JSON} A GEO JSON Object representing the geometry for editing
   *
   * onExecute - {Function} A callback method which will been executed after the user has finished
   *   the procress. If this callback returns true the editor resets itself automatically.
   * onCancel - {Function} A callback method which will been executed if the user has canceled
   *   this process. If this callback returns true the editor resets itself automatically.
   */
  editGeometry: function(processDesc, paramDesc, onExecute, onCancel){
    this.reset();
    this.processDescription = this.createEditGeometryProcressDesc(processDesc, paramDesc);
    this.execute(this.processDescription, onExecute, onCancel);

    //Zoom to given geometry
    var parser = new OpenLayers.Format.GeoJSON();
    var geometry = parser.parseGeometry(paramDesc.geometry);
    this.map.zoomToExtent(geometry.getBounds());
  },

  /*
   * Creates a WPS Process Description, creates a new processComponent and displays it.
   */
  execute: function(processDescription, onExecute, onCancel){
    this.currentProcessModel = new WPS.Model.Process(processDescription);
    this.processComponent = new WPS.Component.Process(
      this.currentProcessModel,
      this.map,
      OpenLayers.Function.bind(function(process,executeRequest){
        if(onExecute(this.getProcessModelAsGeoJSON(process.processModel.models)) === true){
          this.reset();
        }
      }, this),
      OpenLayers.Function.bind(function(process){
        if(onCancel() === true){
          this.reset();
        }
      }, this)
    );

    this.div.appendChild(this.processComponent.container);
  },

  /*
   * Creates a basic Procress Description which has all what a createProcressDesc and
   * a EditProcressDescription have in common
   */
  createBasicProcessDesc: function(processDesc, paramDesc){
    var processDescription = {
        identifier: {
          value: processDesc.id
        },
        title: {
          value: processDesc.title
        },
        'abstract': {
          value: processDesc.description
        },
        dataInputs: {
          input: [ {
            identifier: {
              value: paramDesc.id
            },
            title: {
              value: paramDesc.title
            },
            'abstract': {
              value: paramDesc.description
            },
            minOccurs: 1,
            maxOccurs: 1,
            complexData: {
              'default': {
                format: {
                  schema: 'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#'
                }
              }
            }
        }]
      }
    };

    return processDescription;
  },

  /*
   * Create a ProcressDescription for creating a new geoemtry.
   */
  createCreateGeometryProcressDesc: function(processDesc, paramDesc){
    var processDescription = this.createBasicProcessDesc(processDesc, paramDesc);
    processDescription.dataInputs.input[0].complexData['default'].format.schema += paramDesc.type;
    return processDescription;
  },

  /*
   * Create a ProcressDescription for editing a given GeoJSON geoemtry.
   */
  createEditGeometryProcressDesc: function(processDesc, paramDesc){
    var processDescription = this.createBasicProcessDesc(processDesc, paramDesc);
    processDescription.dataInputs.input[0].complexData['default'].format.schema += paramDesc.geometry.type;
    processDescription.dataInputs.input[0].complexData.defaultValue = {
      content: [{
        value: paramDesc.geometry
      }]
    };
    return processDescription;
  },

  /*
   * Converts the passed process models into geoJSON based format and returns it
   *
   * Parameters:
   * models - {Array} An array of processmodels
   *
   * See Also:
   * <WPS.Model.Process>
   */
  getProcessModelAsGeoJSON: function(models){
    var geoJSON = null;
    if (models.length === 1) {
      geoJSON = new OpenLayers.Format.GeoJSON().write(models[0].value);
      return new OpenLayers.Format.JSON().read(geoJSON);
    }
    var components = [];
    for (i = 0; i < models.length; i++) {
      components[i] = models[i].value;
    }
    geoJSON = new OpenLayers.Format.GeoJSON().write(new OpenLayers.Geometry.Collection(components));
    return new OpenLayers.Format.JSON().read(geoJSON);
  },

  CLASS_NAME : "WPS.Control.GeometryEditor"
});

/**
 * Structure: lwpsc:GeometryEditor
 * XML based config for a <WPS.Control.GeometryEditor>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a GeometryEditor would be:
 * (start code)
 * <lwpsc:GeometryEditor id="geometryEditor" div="geometryEditor">
 *   <map>
 *     <lb:Reference target="map" />
 *   </map>
 * </lwpsc:GeometryEditor>
 * (end)
 */
WPS.Control.GeometryEditor.Bean = WPS.Control.Bean.Extend('WPS.Control.GeometryEditor',
  WPS.Control.QName('GeometryEditor'),
  {
    _constructor : WPS.Control.GeometryEditor,
    options : {
      map : OpenLayers.Map
    }
  }
);
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: WPS.Control.ObjectVisualizer
 *
 * The Object visualizer gives access to the legato map client. It is possible
 * to visualize GeoJSON objects with styles and set the visible area of the map via a bounding box
 * or a center point with a minimum and maximum scale.
 *
 * Inherits from: - <WPS.Control>
 *
 */
WPS.Control.ObjectVisualizer = OpenLayers.Class( WPS.Control, {

  /*
   * {<OpenLayers.Map>} the current used map
   */
  map: null,

  currentLayerId : 0,

  factory: null,

  /**
   * Function: initialize
   * Basic constructor
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control
   * The following keys are supported
   * - map {<OpenLayers.Map>} The current map
   */
  initialize : function(options) {
    Legato.Util.Ensure.ensureExists(options.map, "map must be defined");
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
    this.factory = new WPS.Result.Factory(options.map, null);
  },

  /**
   * Function: destroy
   *
   * See Also:
   * <WPS.Control>
   */
  destroy : function() {
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  /**
   * Function: setBoundingBox
   *
   * Sets the map extent to the bounding box with given coordinates.
   *
   * Parameters:
   * left - {Number} Minimum horizontal coordinate.
   * bottom - {Number} Minimum vertical coordinate.
   * right - {Number} Maximum horizontal coordinate.
   * top - {Number} Maximum vertical coordinate.
   */
  setBoundingBox : function(left, bottom, right, top) {
    Legato.Util.Ensure.ensureNumber(left, "The parameter for the minimum horizontal coordinate must be a number.");
    Legato.Util.Ensure.ensureNumber(bottom, "The parameter for the minimum vertical coordinate must be a number.");
    Legato.Util.Ensure.ensureNumber(right, "The parameter for the maximum horizontal coordinate must be a number.");
    Legato.Util.Ensure.ensureNumber(top, "The parameter for the maximum vertical coordinate must be a number.");
    var bbox = new OpenLayers.Bounds(left, bottom, right, top);
    this.map.zoomToExtent(bbox);
  },

  /**
   * Function: setCenterAndScale
   *
   * Sets the map extent based on the center point with given coordinates and the scale.
   *
   * Parameters:
   * x - {Number} Horizontal coordinate of the center point.
   * y - {Number} Vertical coordinate of the center point.
   * scale - {Number} Denominator value of scale. If null, the minimum possible scale will be used.
   */
  setCenterAndScale : function(x, y, scale) {
    Legato.Util.Ensure.ensureNumber(x, "The parameter for the horizontal coordinate must be a number.");
    Legato.Util.Ensure.ensureNumber(y, "The parameter for the vertical coordinate must be a number.");

    if (scale !== null) {
      Legato.Util.Ensure.ensureNumber(scale, "The parameter for the scale must be a number.");
    }

    //zoom map
    this.map.zoomToScale(scale);
    this.map.setCenter(new OpenLayers.LonLat(x, y));
  },

  /**
   * Function: visualize
   *
   * Shows the given objects with styles and map tips on the map. All the given objects will be in the
   * same layer. After adding the objects, the map client zooms to the newly added objects.
   *
   * Parameters:
   * layerName - {String} The name of the layer where the given geometry objects should be added. If this parameter
   * is null, then a new layer will be created and its name will be generated automatically. Otherwise,
   * the method looks for the layer with the given name. If the layer is found, then the objects will
   * be in that layer. Otherwise, a new layer with the given name is created.
   * objects - {Array} An array of geometry objects to add.
   * The following keys are supported:
   * - geometry {GeoJSON} Mandatory. A GeoJSON Object representing the geometry for visualizing in the map client.
   * - mapTip {String} Optional. If exists, the visualized object will have a map tip that is shown
   * when the mouse is over the geometry object.
   * - style {Object} Optional. This object contains styling attributes corresponding to SVG definition.
   * The following SVG styling attributes are supported:
   * - fill
   * - stroke
   * - stroke-width
   */
  visualize : function(layerName, objects) {
    var layer = this.getLayer(layerName);
    var zoomBounds = {
        left: Number.MAX_VALUE,
        bottom : Number.MAX_VALUE,
        right : Number.MIN_VALUE,
        top : Number.MIN_VALUE
    };
    for(var index = 0; index < objects.size(); index++) {
      var geoJsonObject = objects[index];
      Legato.Util.Ensure.ensureExists(geoJsonObject.geometry, "geometry must be defined");
      var resultObject = this.createBasicResultObject(geoJsonObject.geometry);
      var symbolizerPart = this.setAndReturnBasicGraphicsInformation(resultObject, geoJsonObject.geometry);
      if (Legato.Lang.ObjectUtils.exists(geoJsonObject.style)) {
        this.setStyleInformation(geoJsonObject.style, symbolizerPart);
      }
      if (Legato.Lang.ObjectUtils.exists(geoJsonObject.mapTip)) {
        this.setMapTipInformation(geoJsonObject.mapTip, resultObject);
      }
      var marker = this.factory.createResult(resultObject);
      var feature = marker.createFeature();

      var bounds = feature.geometry.getBounds();
      zoomBounds.left = Math.min(zoomBounds.left, bounds.left);
      zoomBounds.bottom = Math.min(zoomBounds.bottom, bounds.bottom);
      zoomBounds.right = Math.max(zoomBounds.right, bounds.right);
      zoomBounds.top = Math.max(zoomBounds.top, bounds.top);

      marker.feature = feature;
      layer.addFeatures([feature]);
      marker.createSelectControl(layer, feature);
      if (Legato.Lang.ObjectUtils.exists(marker.selectControl)) {
        this.map.addControl(marker.selectControl);
        marker.selectControl.activate();
      }
    }

    if (objects.size() > 0) {
      this.map.zoomToExtent(new OpenLayers.Bounds(zoomBounds.left, zoomBounds.bottom, zoomBounds.right, zoomBounds.top));
    }

    for(index = 0; index < this.map.layers.length; index++) {
      if (this.map.layers[index] == layer) {
          return;
      }
    }
    this.map.addLayer(layer);
  },

  getLayer : function (layerName) {
    if (!Legato.Lang.ObjectUtils.isNull(layerName)) {
      var layers = this.map.layers;
      for (var index = 0; index < layers.size(); index++) {
        var layer = layers[index];
        if (layerName == layer.name) {
          return layer;
        }
      }
    }
    var layerOptions = {
      displayInLayerSwitcher : true,
      calculateInRange : function() {
        return true;
      },
      style : WPS.Feature.Style.ACTIVE
    };
    if (!Legato.Lang.ObjectUtils.isNull(layerName)) {
      return new OpenLayers.Layer.Vector(layerName, layerOptions);
    }
    else {
      this.currentLayerId++;
      return new OpenLayers.Layer.Vector("Result Marker Layer #" + this.currentLayerId, layerOptions);
    }
  },

  setStyleInformation : function(style, symbolizerPart) {
    fillParameters = ["fill"];
    strokeParameters = ["stroke", "stroke-width"];
    symbolizerPart.fill = {
        svgParameter : []
    };
    symbolizerPart.stroke = {
        svgParameter : []
    };
    this.setStyleParameters(style, symbolizerPart.fill, fillParameters);
    this.setStyleParameters(style, symbolizerPart.stroke, strokeParameters);
  },

  setStyleParameters : function(source, destination, parameters) {
    for (var index = 0; index < parameters.size(); index++) {
      var paramName = parameters[index];
      if (Legato.Lang.ObjectUtils.exists(source[paramName])) {
        destination.svgParameter.push({
          name : paramName,
          content : [ source[paramName] ]
        });
      }
    }
  },

  setMapTipInformation : function (mapTip, resultObject) {
    resultObject.processOutputs.output[0].data.complexData.content[0].value.message = {
      value : {
        content : mapTip
      }
    };
  },

  setAndReturnBasicGraphicsInformation : function (resultObject, geoJsonObject) {
    var graphicsInformation = resultObject.processOutputs.output[0].data.complexData.content[0].value.geometry.value.symbolizer.value;
    switch (geoJsonObject.type) {
      case "Point":
        resultObject.processOutputs.output[0].data.complexData.content[0].value.geometry.value.symbolizer.value = {
          graphic : {
            externalGraphicOrMark : [ {} ]
          }
        };
        return resultObject.processOutputs.output[0].data.complexData.content[0].value.geometry.value.symbolizer.value.graphic.externalGraphicOrMark[0];
      case "LineString": case "Polygon":
        return graphicsInformation;
    }
  },

  createBasicResultObject : function(geoJsonObject) {
    var markerSchema = WPSPD.Result.Marker.ComplexFactory.prototype.schema;
    var basicResultObject = {
        processOutputs : {
          output : [{
            data : {
              complexData : {
                schema : markerSchema,
                content : [{
                  value : {
                    geometry : {
                      value : {
                        geometry : {
                          value : geoJsonObject
                        },
                        symbolizer : {
                          value : {

                          }
                        }
                      }
                    }
                  }
                }]
              }
            }
          }]
        }
      };
      return basicResultObject;
  },

  CLASS_NAME : "WPS.Control.ObjectVisualizer"
});

/**
 * Structure: lwpsc:ObjectVisualizer
 * XML based configuration for a <WPS.Control.ObjectVisualizer>.
 *
 * A valid configuration example for a ObjectVisualizer would be:
 * (start code)
 * <lwpsc:ObjectVisualizer>
 *   <map>
 *     <lb:Reference target="map" />
 *   </map>
 * </lwpsc:ObjectVisualizer>
 * (end)
 */
WPS.Control.ObjectVisualizer.Bean = WPS.Control.Bean.Extend('WPS.Control.ObjectVisualizer',
  WPS.Control.QName('ObjectVisualizer'),
  {
    _constructor : WPS.Control.ObjectVisualizer,
    options : {
      map : OpenLayers.Map
    }
  }
);

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: WPS.Control.ToggleWpsForm
 *
 * Switches WPS form on and off
 *
 * Inherits from:
 * - <Legato.Control>
 *
 */
WPS.Control.ToggleWpsForm = OpenLayers.Class(WPS.Control, {

  type :OpenLayers.Control.TYPE_TOGGLE,
  form: null,
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.events.on({
        'processSelectionCancellation': this.deactivate,
        scope: this
      });
      this.form.events.on({
        'on': this.activate,
        scope: this
      });
      this.form.events.on({
        'off': this.deactivate,
        scope: this
      });
    }
  },

  destroy: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.events.un({
        'processSelectionCancellation': this.deactivate,
        scope: this
      });
      this.form.events.un({
        'on': this.activate,
        scope: this
      });
      this.form.events.un({
        'off': this.deactivate,
        scope: this
      });
    }
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },


  /** Function: activate
   * Invoked when the control is activated in toggle mode
   */
  activate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form) && (this.form.isOn === false)) {
      this.form.on();
    }
    WPS.Control.prototype.activate.apply(this, arguments);
  },

  /** Function: deactivate
   * Invoked when the control is deactivated in toggle mode
   */
  deactivate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form) && (this.form.isOn === true)) {
      this.form.off();
    }
    WPS.Control.prototype.deactivate.apply(this, arguments);
  },

  CLASS_NAME :"WPS.Control.ToggleWpsForm"
});

/**
 * Structure: wpc:ToggleWpsForm
 * XML based config for a <WPS.Control.ToggleWpsForm>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ToggleDiv would be:
 * (start code)
 * <lwpsc:ToggleWpsForm>
 * <form>
 * <lb:Reference target="WpsForm" />
 * </form>
 * </lwpsc:ToggleWpsForm>
 * (end)
 */
WPS.Control.ToggleWpsForm.Bean = WPS.Control.Bean.Extend(
  'WPS.Control.ToggleWpsForm',
  //
  WPS.Control.QName('ToggleWpsForm'),
  //
  {
    _constructor : WPS.Control.ToggleWpsForm,
    options:
    {
      form: WPS.Form
    }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: WPS.Control.WpsButton
 *
 * A WPS Button which build a WPS specific map tool button for easy
 * access.
 *
 * Inherits from: - <WPS.Contro>
 *
 */
WPS.Control.WpsButton = OpenLayers.Class( WPS.Control, {

  type : OpenLayers.Control.TYPE_BUTTON,

  form : null,

  wpsOperations : null,

  processIdentifier : null,

  processDescription : null,

  initialize : function(options) {
    Legato.Util.Ensure.ensureExists(options.form, "form must be defined");
    OpenLayers.Control.prototype.initialize.apply(this, arguments);

    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.events.on( {
        'processSelectionCancellation' : this.deactivate,
        scope : this
      });
    }

    OpenLayers.Util.extend(this, options);

    if (!Legato.Lang.ObjectUtils.exists(this.processIdentifier) &&
        Legato.Lang.ObjectUtils.exists(this.processDescription)) {
      this.processIdentifier = this.processDescription.identifier.value;
    }

    if (this.wpsOperations === null) {
      this.wpsOperations = WpsOperations;
    }
  },

  parseDescriptions : function(processDesc) {
    if(this.panel_div === null){
      return;
    }

    var processDescriptions = processDesc.processDescription;
    for ( var index = 0; index < processDescriptions.length; index++) {
      var processDescription = processDescriptions[index];
      if (Legato.Lang.ObjectUtils.isArray(processDescription.metadata)) {
        for ( var i = 0; i < processDescription.metadata.length; i++) {
          if (processDescription.metadata[i].about == "shortcut icon") {
            this.panel_div.style.backgroundImage = "url("
                + processDescription.metadata[i].href + ")";
          }
        }
      }
    }
  },

  draw: function (px) {
    if (this.processDescription === null) {
      var describeProcessRequest = {
          identifier : [{
            value : this.processIdentifier
          }]
      };
      this.wpsOperations.describeProcess(
          describeProcessRequest,
          OpenLayers.Function.bind(this.parseDescriptions, this)
      );
    } else {
      var processDescriptions = {
          processDescription : [this.processDescription]
      };
      this.parseDescriptions(processDescriptions);
    }

    OpenLayers.Control.prototype.draw.apply(this, arguments);
    return this.div;
  },

  destroy : function() {
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  trigger : function() {
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.off();
      if (Legato.Lang.ObjectUtils.exists(this.form.processComponent)) {
        this.form.cancelExecution();
      }
      this.form.selectProcess(this.processIdentifier, true);
      this.form.on();
    }
  },

  CLASS_NAME : "WPS.Control.WpsButton"
});

WPS.Control.WpsButton.Bean = WPS.Control.Bean.Extend('WPS.Control.WpsButton',
  WPS.Control.QName('WpsButton'),
  {
    _constructor : WPS.Control.WpsButton,
    options : {
      form : WPS.Form,
      wpsOperations : Legato.Lang.Function,
      processIdentifier : Legato.Lang.String,
      processDescription : Legato.Lang.Object
    }
  }
);
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Model.Complex = OpenLayers.Class(WPS.Model, {

  defaultFormat : null,

  populateData : function(data) {
    data.data.complexData = {};
    data.data.complexData.content = this.getContent();
    if (Legato.Lang.ObjectUtils.exists(this.defaultFormat) && Legato.Lang.ObjectUtils.exists(this.defaultFormat.schema)) {
      data.data.complexData.schema = this.defaultFormat.schema;
    }
    return data;
  },

  getContent: function() {
    return this.inverse(this.getValue());
  },

  setContent: function( content ) {
    this.setValue(this.direct(content));
  },

  setDefaultContent: function( content ) {
    this.setDefaultValue(this.direct(content));
  },

  direct: function( content ) {
    return content;
  },

  inverse: function( content ) {
    return content;
  },

  getSchema: function() {
    if (this.defaultFormat === null) { return null; }
    return this.defaultFormat.schema;
  },

  CLASS_NAME :'WPS.Model.Complex'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Model.Factory = OpenLayers.Class({

  initialize : function() {
  },

  createModel : function(inputDescription) {
    var modelOptions = {};
    modelOptions.identifier = inputDescription.identifier.value;
    modelOptions.title = inputDescription.title.value;
    /*jslint sub:true*/
    modelOptions['abstract'] = inputDescription['abstract'].value;
    if(Legato.Lang.ObjectUtils.isNotEmptyArray(inputDescription.metadata)){
      modelOptions.metadata = inputDescription.metadata;
    }
    modelOptions.minOccurs = Legato.Lang.ObjectUtils
        .exists(inputDescription.minOccurs) ? inputDescription.minOccurs
        : 1;
    modelOptions.maxOccurs = Legato.Lang.ObjectUtils
        .exists(inputDescription.maxOccurs) ? inputDescription.maxOccurs
        : 1;

    var model;
    if (Legato.Lang.ObjectUtils.exists(inputDescription.literalData)) {
      var literalData = inputDescription.literalData;

      modelOptions.dataType = Legato.Lang.ObjectUtils
          .exists(literalData.dataType) ? literalData.dataType.value : null;
      modelOptions.defaultValue = {
        value :(Legato.Lang.ObjectUtils.exists(literalData.defaultValue) ? literalData.defaultValue
            : null),
        uom :null
      };
      // TODO uoms

      model = new WPS.Model.Literal(this, modelOptions);
    } else if (Legato.Lang.ObjectUtils.exists(inputDescription.complexData)) {
      var complexData = inputDescription.complexData;
      if (! Legato.Lang.ObjectUtils.exists(complexData['default'].format)) {
        throw new Legato.Lang.Exception("Missing default format in complex data");
      }
      modelOptions.defaultFormat = complexData['default'].format;
      if (! Legato.Lang.ObjectUtils.exists(modelOptions.defaultFormat)) {
        throw new Legato.Lang.Exception("Missing schema definition in default format");
      }
      var schema = modelOptions.defaultFormat.schema;
      if (WPS.GEOM_POINT_URI === schema ||
          WPS.GEOM_LINE_STRING_URI === schema ||
          WPS.GEOM_POLYGON_URI === schema ) {
        model = new WPS.Model.Geo(this, modelOptions, model);
        if (Legato.Lang.ObjectUtils.exists(complexData['defaultValue'])) {
          model.setDefaultContent(complexData['defaultValue'].content);
        }
      } else {
        throw new Legato.Lang.Exception("Unsupported complex data type: " + schema);
      }
    } else {
      throw new Legato.Lang.Exception("Unsupported input description type");
    }
    return model;
  },

  destroy : function() {
  },

  CLASS_NAME : 'WPS.Model.Factory'
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Model.Geo = OpenLayers.Class( WPS.Model.Complex, {

  geoJsonFormat: null,

  initialize : function(modelFactory, options) {
    this.geoJsonFormat = new OpenLayers.Format.GeoJSON();
    WPS.Model.Complex.prototype.initialize.apply(this, arguments);
  },

  inverse: function(value){
    var geoJsonValue = this.geoJsonFormat.extract.geometry.call(this.geoJsonFormat, value);
    var elementName = {
        namespaceURI:'http://www.opengis.net/gml',
        localPart: geoJsonValue.type,
        prefix:'gml'
    };
    var geoContent = {
        name: elementName,
        value: geoJsonValue
    };
    return [ geoContent ];
  },

  direct: function(content){
    var geoJsonValue = content[0].value;
    return this.geoJsonFormat.parseGeometry(geoJsonValue);
  },

  CLASS_NAME : 'WPS.Model.Geo'

});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Model.Literal = OpenLayers.Class(WPS.Model, {
  dataType :null,
  //
  populateData : function(data) {
    data.data.literalData = this.getValue();
    if (Legato.Lang.ObjectUtils.exists(this.dataType)) {
      data.data.literalData.dataType = this.dataType;
    }
    return data;
  },
  CLASS_NAME :'WPS.Model.Literal'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Model.Process = OpenLayers.Class({

  EVENT_TYPES : [ 'validitychange' ],

  processDescription :null,

  processIdentifier: null,

  modelFactory :null,

  models :null,

  events: null,

  initialize : function(processDescription, options) {
    OpenLayers.Util.extend(this, options);
    this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES);
    this.processDescription = processDescription;
    this.processIdentifier = processDescription.identifier.value;
    this.models = [];
    if (!Legato.Lang.ObjectUtils.exists(this.modelFactory)) {
      this.modelFactory = new WPS.Model.Factory();
    }
    if (this.processDescription.dataInputs && this.processDescription.dataInputs.input) {
      var inputDescriptions = this.processDescription.dataInputs.input;
      for ( var index = 0; index < inputDescriptions.length; index++) {
        var inputDescription = inputDescriptions[index];
        var model = this.modelFactory.createModel(inputDescription);
        this.models.push(model);
      }
    }
  },

  destroy : function() {
    if (Legato.Lang.ObjectUtils.exists(this.events)) {
      this.events.destroy();
      this.events = null;
    }
    this.processDescription = null;
    if (Legato.Lang.ObjectUtils.exists(this.modelFactory)) {
      this.modelFactory.destroy();
      this.modelFactory = null;
    }
    if (Legato.Lang.ObjectUtils.exists(this.models)) {
      for ( var index = 0; index < this.models.length; index++) {
        this.models[index].destroy();
      }
      this.models = null;
    }
  },

  getData : function() {
    var inputs = [];
    for ( var index = 0; index < this.models.length; index++) {
      var modelData = this.models[index].getData();
      if (Legato.Lang.ObjectUtils.exists(modelData)) {
        for ( var jndex = 0; jndex < modelData.length; jndex++) {
          inputs.push(modelData[jndex]);
        }
      }
    }
    var data = {
      identifier :this.processDescription.identifier,
      dataInputs : {
        input :inputs
      }
    };
    return data;
  },

  CLASS_NAME :'WPS.Model.Process'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.AbstractGeometry = OpenLayers.Class(WPS.Component, {
  inputPanelDiv : null,
  inputPanel : null,
  geoInputControl : null,
  geoModifyControl : null,
  featureSelector : null,
  map : null,
  layer : null,
  featureGeometrySelectionController : null,
  geometryType : null,
  initialize : function(id, model, map, options) {
    WPS.Component.prototype.initialize.apply(this, arguments);
    this.geoInputControl.events.on({
      "activate" : this.geoInputControlActivated,
      "deactivate" : this.geoInputControlDeactivated,
      scope : this
    });
    this.geoModifyControl.events.on({
      "activate" : this.geoModifyControlActivated,
      scope : this
    });
    if (this.featureSelector) {
      this.featureSelector.events.on({
        "activate" : this.featureSelectorActivated,
        scope : this
      });
    }
  },
  destroy : function() {
    this.geoInputControl.events.un({
      "activate" : this.controlActivated,
      "deactivate" : this.controlDeactivated,
      scope : this
    });
    this.geoModifyControl.events.un({
      "activate" : this.geoModifyControlActivated,
      scope : this
    });
    if (this.featureSelector) {
      this.featureSelector.events.un({
        "activate" : this.featureSelectorActivated,
        scope : this
      });
    }
    this.unregisterLayerEvents();
    if (Legato.Lang.ObjectUtils.exists(this.map) && Legato.Lang.ObjectUtils.exists(this.layer)) {
      this.map.removeLayer(this.layer);
    }
    WPS.Component.prototype.destroy.apply(this, arguments);
  },
  checkedChanged : function(event) {
    WPS.Component.prototype.checkedChanged.call(this, event);
    var checked = (event.target || event.srcElement).checked;
    if (!checked) {
      this.geoInputControl.deactivate();
      this.geoModifyControl.deactivate();
      if (this.featureSelector) {
        this.featureSelector.deactivate();
      }
    }
  },

  geoModifyControlActivated : function() {
    this.geoInputControl.deactivate();
    if (this.featureSelector) {
      this.featureSelector.deactivate();
    }
    this.onActivation(true);
  },

  geoInputControlActivated : function() {
    this.geoModifyControl.deactivate();
    if (this.featureSelector) {
      this.featureSelector.deactivate();
    }
    this.onActivation(true);
  },

  geoInputControlDeactivated : function() {
    this.onDeactivation(true);
  },

  featureSelectorActivated : function() {
    this.geoModifyControl.deactivate();
    this.geoInputControl.deactivate();
    this.onActivation(true);
  },

  initializeInputs : function() {
    var layerOptions = {
      displayInLayerSwitcher : false,
      // indicate that the temp vector layer will never be out of range
      // without this, resolution properties must be specified at the
      // map-level for this temporary layer to init its resolutions
      // correctly
      calculateInRange : function() {
        return true;
      },
      isFeatureLayer : true
    };
    this.layer = new OpenLayers.Layer.Vector(this.model.identifier + 'Input', layerOptions);
    this.layer.style = WPS.Feature.Style.ACTIVE;
    this.map.addLayer(this.layer);

    // Always ensure that the draw layer will be on top
    this.layer.setZIndex(this.map.Z_INDEX_BASE.Feature - 1);

    this.registerLayerEvents();

    this.inputPanelDiv = document.createElement('div');
    OpenLayers.Element.addClass(this.inputPanelDiv, 'olControlPanel');
    this.container.appendChild(this.inputPanelDiv);

    var panelOptions = {
      div : this.inputPanelDiv
    };

    this.inputPanel = new OpenLayers.Control.Panel(panelOptions);
    this.map.addControl(this.inputPanel);
    this.initializeGeoInputControl();
    this.initializeGeoModifyControl();
    this.initializeFeatureSelector();
    return this.inputPanelDiv;
  },

  onGeometryChange : function(event) {
    var feature;
    switch (event.type) {
    case "featuresadded":
      feature = event.features[0];
      this.model.setValue(feature.geometry);
      break;
    case "featuresremoved":
      this.model.setValue(null);
      break;
    case "featuremodified":
      feature = event.feature;
      this.model.setValue(feature.geometry);
      break;
    default:
      break;
      // do nothing
    }
  },

  activate : function() {
    if (!(this.geoInputControl.active || this.geoModifyControl.active || (this.featureSelector && this.featureSelector.active))) {
      this.geoInputControl.activate();
      this.onActivation();
    }
  },

  deactivate : function() {
    this.geoInputControl.deactivate();
    this.geoModifyControl.deactivate();
    if (this.featureSelector) {
      this.featureSelector.deactivate();
    }
    this.onDeactivation();
  },

  initializeGeoInputControl : function() {
    var controlOptions = {
      mode : Legato.Control.DrawFeature.MODE_REPLACE_FEATURE,
      type : OpenLayers.Control.TYPE_TOGGLE
    };
    var control = this.createGeoInputControl(controlOptions);
    this.inputPanel.addControls([ control ]);
    this.geoInputControl = control;
  },

  initializeGeoModifyControl : function() {
    var controlOptions = {
      mode : Legato.Control.ModifyFeature.MODE_RESHAPE
    };
    var control = this.createGeoModifyControl(controlOptions);
    this.inputPanel.addControls([ control ]);
    this.geoModifyControl = control;
  },

  initializeFeatureSelector : function() {

    if (Legato.Lang.ObjectUtils.exists(this.featureGeometrySelectionController)) {

      var that = this;

      var geometryType = that.geometryType;

      var layerPredicate = new Legato.Predicate.And([ new Legato.Layer.Predicate.SelectedLayer(), new Legato.Layer.Predicate.LayerWithAttribute({
        name : 'featureLayer',
        value : 'true'
      }), new Legato.Layer.Predicate.LayerWithAttribute({
        name : 'geometryType',
        predicate : new Legato.Predicate.Contains(geometryType)
      }) ]);

      var featureGeometrySelectionController = that.featureGeometrySelectionController;
      var format = new OpenLayers.Format.GeoJSON();

      var featureSelectionController = function(layers, selectionGeometry, mode, callbacks) {
        // Create array of layer ids
        var layerIds = [];
        for ( var index = 0; index < layers.length; index++) {
          layerIds.push(Legato.Lang.ObjectUtils.exists(layers[index].layerId) ? layers[index].layerId : layers[index].name);
        }

        var geometry = format.extract.geometry.call(format, selectionGeometry);
        featureGeometrySelectionController(layerIds, geometryType, 1, geometry, callbacks);
      };

      var model = that.model;

      var callback = function(geometries) {
        if (geometries && geometries.length >= 0 && geometries[0]) {
          // REVIEW AV Format neu erstellen
          var geometry = format.parseGeometry(geometries[0]);
          model.setValue(geometry);
        }
      };

      var featureSelector = new Legato.Control.FeatureSelector({
        layerPredicate : layerPredicate,
        controller : featureSelectionController,
        callback : callback,
        //i18n
        title: 'Zur Auswahl von Geometrien. Bitte vorher das gewünschte Thema markieren.'
      });
      this.inputPanel.addControls([ featureSelector ]);
      this.featureSelector = featureSelector;

    } else {
      this.featureSelector = null;
    }
  },

  createGeoInputControl : function(controlOptions) {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
      ' must implement the createGeoInputControl function from from abstract class ' +
      WPS.Component.AbstractGeometry.CLASS_NAME);
  },

  createGeoModifyControl : function(controlOptions) {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the createGeoModifyControl function from from abstract class ' +
        WPS.Component.AbstractGeometry.CLASS_NAME);
  },

  registerLayerEvents : function() {
    this.layer.events.on({
      'featuresadded' : this.onGeometryChange,
      'featuresremoved' : this.onGeometryChange,
      'featuremodified' : this.onGeometryChange,
      scope : this
    });
  },

  unregisterLayerEvents : function() {
    this.layer.events.un({
      'featuresadded' : this.onGeometryChange,
      'featuresremoved' : this.onGeometryChange,
      'featuremodified' : this.onGeometryChange,
      scope : this
    });
  },

  onModelValueChange : function(event) {
    var silentOption = {
      silent : true
    };
    var layerFeatures = this.layer.features;
    var feature = null;
    if (layerFeatures && layerFeatures.length > 0) {
      feature = layerFeatures[0];
    }
    this.layer.destroyFeatures(null, silentOption);
    if (this.model.getValue() !== null) {
      if (feature !== null) {
        feature.geometry = this.model.getValue();
      } else {
        feature = new OpenLayers.Feature.Vector(this.model.getValue());
      }
      this.layer.addFeatures(feature, silentOption);
    }
  },

  redrawFeaturesWithStyle : function(style) {
    var features = this.layer.features;
    if (features) {
      for ( var i = 0; i < features.length; i++) {
        this.layer.drawFeature(features[i], style);
      }
    }
  },

  onHoverIn : function() {
    if (WPS.Component.STATUS_INACTIVE === this.status) {
      this.redrawFeaturesWithStyle(WPS.Feature.Style.INACTIVE_HOVER);
    } else {
      this.redrawFeaturesWithStyle(WPS.Feature.Style.ACTIVE_HOVER);
    }
    WPS.Component.prototype.onHoverIn.call(this);
  },

  onHoverOut : function() {
    if (WPS.Component.STATUS_ACTIVE_HOVER === this.status) {
      this.redrawFeaturesWithStyle(WPS.Feature.Style.ACTIVE);
    } else {
      this.redrawFeaturesWithStyle(WPS.Feature.Style.INACTIVE);
    }
    WPS.Component.prototype.onHoverOut.call(this);
  },

  onActivation : function(triggerEvent) {
    this.redrawFeaturesWithStyle(WPS.Feature.Style.ACTIVE_HOVER);
    WPS.Component.prototype.onActivation.call(this, triggerEvent);
  },

  onDeactivation : function(triggerEvent) {
    WPS.Component.prototype.onDeactivation.call(this, triggerEvent);
    this.redrawFeaturesWithStyle(WPS.Feature.Style.INACTIVE);
  },

  CLASS_NAME : 'WPS.Component.AbstractGeometry'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.Factory = OpenLayers.Class({
  map : null,
  options : null,
  initialize : function(map, options) {
    Legato.Util.Ensure.ensureExists(map, "map should be defined");
    this.map = map;
    if (Legato.Lang.ObjectUtils.isObject(options)) {
      this.options = options;
    } else {
      this.options = {};
    }
  },
  createComponent : function(model) {
    var id = OpenLayers.Util.createUniqueID('WPS_Component_');
    if ('WPS.Model.Literal' === model.CLASS_NAME) {
      return new WPS.Component.Literal(id, model, this.map, this.options);
    } else if ('WPS.Model.Geo' === model.CLASS_NAME) {
      switch (model.getSchema()) {
      case WPS.GEOM_POINT_URI:
        return new WPS.Component.Point(id, model, this.map, this.options);
      case WPS.GEOM_LINE_STRING_URI:
        return new WPS.Component.LineString(id, model, this.map, this.options);
      case WPS.GEOM_POLYGON_URI:
        return new WPS.Component.Polygon(id, model, this.map, this.options);
      default:
        throw new Legato.Lang.Exception("Unsupported geo model type [" + model.getSchema() + "]");
      }
    } else {
      throw new Legato.Lang.Exception("Unsupported model.");
    }
  },
  destroy : function() {
  },
  CLASS_NAME : 'WPS.Component.Factory'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.Literal = OpenLayers.Class( WPS.Component, {
  input :null,

  initializeInputs : function() {
    if (this.input === null) {
      this.input = document.createElement('input');
      this.input.type = 'text';
      this.container.appendChild(this.input);
    }
    this.input.onchange = OpenLayers.Function.bindAsEventListener(
        this.onInputValueChange, this);
    this.input.onfocus = OpenLayers.Function.bindAsEventListener(
        this.onInputActivated, this);

    return this.input;
  },

  onInputValueChange : function() {
    var value = this.input.value;
    this.model.setValue( {
      value :value, /* TODO uom */
      uom :null
    });
  },

  onInputActivated : function() {
    this.onActivation(true);
  },

  onModelValueChange : function(event) {
    this.input.value = event.value.value ? event.value.value : '';
    // TODO uom
  },

  destroy : function() {
    WPS.Component.prototype.destroy.apply(this,
        arguments);
    if (Legato.Lang.ObjectUtils.exists(this.input)) {
      this.input.onchange = null;
      this.input = null;
    }
  },

  onDeactivation: function() {
    WPS.Component.prototype.onDeactivation.call(this);
    this.input.blur();
  },

  CLASS_NAME :'WPS.Component.Literal'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.Point = OpenLayers.Class(WPS.Component.AbstractGeometry, {
  geometryType : 'Point',

  createGeoInputControl : function(controlOptions) {
    if(Legato.Lang.ObjectUtils.isObject(controlOptions)){
      //i18n
      controlOptions.title = 'Zeichnet eine Punkt.';
    }
    return new Legato.Control.DrawPoint(this.layer, controlOptions);
  },
  createGeoModifyControl : function(controlOptions) {
    if(Legato.Lang.ObjectUtils.isObject(controlOptions)){
      //i18n
      controlOptions.title = 'Ändert den Punkt.';
    }
    return new Legato.Control.ModifyPoint(this.layer, controlOptions);
  },

  CLASS_NAME : 'WPS.Component.Point'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.LineString = OpenLayers.Class(WPS.Component.AbstractGeometry, {
  geometryType : 'LineString',

  createGeoInputControl : function(controlOptions) {
    if(Legato.Lang.ObjectUtils.isObject(controlOptions)){
      //i18n
      controlOptions.title = 'Zeichnet einen Linienzug.';
    }
    return new Legato.Control.DrawLineString(this.layer, controlOptions);
  },

  createGeoModifyControl : function(controlOptions) {
    if(Legato.Lang.ObjectUtils.isObject(controlOptions)){
      //i18n
      controlOptions.title = 'Ändert den Linienzug.';
    }
    return new Legato.Control.ModifyLineString(this.layer, controlOptions);
  },

  CLASS_NAME : 'WPS.Component.LineString'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.Polygon = OpenLayers.Class(WPS.Component.AbstractGeometry, {
  geometryType : 'Polygon',

  createGeoInputControl : function(controlOptions) {
    if(Legato.Lang.ObjectUtils.isObject(controlOptions)){
      //i18n
      controlOptions.title = 'Zeichnet eine freie Geometrie.';
    }
    return new Legato.Control.DrawPolygon(this.layer, controlOptions);
  },

  createGeoModifyControl : function(controlOptions) {
    if(Legato.Lang.ObjectUtils.isObject(controlOptions)){
      //i18n
      controlOptions.title = 'Ändert die freie Geometrie.';
    }
    return new Legato.Control.ModifyPolygon(this.layer, controlOptions);
  },

  CLASS_NAME : 'WPS.Component.Polygon'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.Process = OpenLayers
    .Class({

      EVENT_TYPES : [ 'geoInputActivation' ],

      processModel : null,

      processIdentifier : null,

      processTitle : null,

      processAbstract : null,

      componentFactory : null,

      components : null,

      container : null,

      titleElement : null,

      abstractElement : null,

      componentsElement : null,

      executeElement : null,

      map : null,

      currentComponentId : null,

      activated : false,

      valid : false,

      events : null,

      buttonsElement : null,

      executeButton : null,

      executeCallback : null,

      cancelCallback : null,

      validationErrorElement : null,

      validationErrorContainer : null,

      txtExecute : 'OK',

      txtCancel : 'Cancel',

      componentFactoryOptions : null,

      initialize : function(processModel, map, executeCallback, cancelCallback, options) {
        Legato.Util.Ensure.ensureExists(processModel, "model should be defined");
        Legato.Util.Ensure.ensureExists(map, "map should be defined");
        Legato.Util.Ensure.ensureFunction(executeCallback, "execute callback should be a function");
        Legato.Util.Ensure.ensureFunction(cancelCallback, "cancel callback should be a function");
        this.processModel = processModel;
        this.processIdentifier = processModel.processIdentifier;
        this.executeCallback = executeCallback;
        this.cancelCallback = cancelCallback;
        OpenLayers.Util.extend(this, options);
        this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES);

        if (!Legato.Lang.ObjectUtils.isObject(this.componentFactoryOptions)) {
          this.componentFactoryOptions = {};
        }

        if (processModel.processDescription.title) {
          this.processTitle = processModel.processDescription.title.value;
        }
        /*jslint sub:true */
        if (processModel.processDescription['abstract']) {
          /*jslint sub:true*/
          this.processAbstract = processModel.processDescription['abstract'].value;
        }
        this.map = map;
        if (!Legato.Lang.ObjectUtils.exists(this.componentFactory)) {
          this.componentFactory = new WPS.Component.Factory(map, this.componentFactoryOptions);
        }
        this.createProcessForm();
        this.validate();
        this.activate();
      },

      createProcessForm : function() {
        if (this.container === null) {
          this.container = document.createElement('div');
          this.container.className = 'wpsContainer';
        }

        this.titleElement = document.createElement('div');
        this.titleElement.className = 'wpsProcessTitle';
        this.titleElement.innerHTML = this.processModel.processDescription.title.value;
        this.container.appendChild(this.titleElement);

        this.abstractElement = document.createElement('div');
        this.abstractElement.className = 'wpsProcessAbstract';
        /*jslint sub:true*/
        this.abstractElement.innerHTML = this.processModel.processDescription['abstract'].value;
        this.container.appendChild(this.abstractElement);

        this.validationErrorContainer = document.createElement('div');
        this.validationErrorContainer.className = 'validationError';
        OpenLayers.Element.hide(this.validationErrorContainer);
        this.container.appendChild(this.validationErrorContainer);

        var validationErrorIcon = document.createElement('div');
        validationErrorIcon.className = 'validationErrorIcon';
        this.validationErrorContainer.appendChild(validationErrorIcon);

        this.validationErrorElement = document.createElement('div');
        this.validationErrorContainer.appendChild(this.validationErrorElement);

        this.validationErrorContainer.appendChild(this.validationErrorElement);

        this.components = [];
        this.componentsElement = document.createElement('div');
        this.componentsElement.className = 'wpsProcessInputsContainer';
        this.container.appendChild(this.componentsElement);

        for ( var index = 0; index < this.processModel.models.length; index++) {
          var component = this.componentFactory.createComponent(this.processModel.models[index]);
          this.components[index] = component;
          this.componentsElement.appendChild(component.container);
          component.events.on({
            'activate' : this.componentActivated,
            'deactivate' : this.componentDeactivated,
            'validitychange' : this.componentValidityChanged,
            scope : this
          });
        }

        this.buttonsElement = document.createElement('div');
        this.buttonsElement.className = 'wpsButtons';
        this.container.appendChild(this.buttonsElement);

        this.executeButton = document.createElement('input');
        this.executeButton.type = 'button';
        this.executeButton.value = this.txtExecute;
        this.executeButton.onclick = OpenLayers.Function.bindAsEventListener(this.executeButtonClicked, this);
        this.buttonsElement.appendChild(this.executeButton);

        var cancelButton = document.createElement('input');
        cancelButton.type = 'button';
        cancelButton.value = this.txtCancel;
        cancelButton.onclick = OpenLayers.Function.bindAsEventListener(this.cancelButtonClicked, this);
        this.buttonsElement.appendChild(cancelButton);
      },

      executeButtonClicked : function() {
        var executeRequest = this.processModel.getData();
        if (!Legato.Lang.ObjectUtils.exists(executeRequest.service)) {
          executeRequest.service = 'WPS';
        }
        if (!Legato.Lang.ObjectUtils.exists(executeRequest.version)) {
          executeRequest.version = '1.0.0';
        }
        this.deactivate();
        this.executeCallback(this, executeRequest);
      },

      cancelButtonClicked : function() {
        this.deactivate();
        this.cancelCallback(this);
      },

      activate : function() {
        var index = 0;
        var component = null;
        if (this.currentComponentId) {
          for (index = 0; index < this.components.length; index++) {
            component = this.components[index];
            if (this.currentComponentId === component.id) {
              component.activate();
            }
          }
        } else {
          for (index = 0; index < this.components.length; index++) {
            component = this.components[index];
            if (component.isAccessable()) {
              component.activate();
            }
          }
        }

        this.activated = true;
        return true;
      },

      deactivate : function() {
        this.activated = false;
        for ( var index = 0; index < this.components.length; index++) {
          var component = this.components[index];
          if (!(WPS.Component.STATUS_INACTIVE === component.status || WPS.Component.STATUS_INACTIVE === component.status)) {
            component.deactivate();
          }
        }
        return true;
      },

      validate : function() {
        OpenLayers.Element.hide(this.validationErrorContainer);
        var valid = true;
        var firstError = '';
        for ( var i = 0; i < this.components.length; i++) {
          if (!this.components[i].model.valid) {
            valid = false;
            firstError = this.components[i].model.validationMessages[0];
            break;
          }
        }
        this.valid = valid;
        this.executeButton.disabled = !this.valid;
        if (!valid && this.currentComponentId) {
          // show global validation
          // messages
          // only when a component is
          // already active
          this.validationErrorElement.innerHTML = firstError;
          OpenLayers.Element.show(this.validationErrorContainer);
        }
      },

      componentActivated : function(event) {
        var changedComponent = event.component;
        this.currentComponentId = changedComponent.id;
        for ( var index = 0; index < this.components.length; index++) {
          var component = this.components[index];
          if (!(WPS.Component.STATUS_INACTIVE === component.status || WPS.Component.STATUS_INACTIVE_HOVER === component.status || changedComponent.id === component.id)) {
            component.deactivate();
          }
        }
        if (changedComponent.CLASS_NAME === 'WPS.Component.Point' || changedComponent.CLASS_NAME === 'WPS.Component.LineString'
            || changedComponent.CLASS_NAME === 'WPS.Component.Polygon') {
          this.events.triggerEvent('geoInputActivation', {
            component : this
          });
        }
      },

      componentDeactivated : function(event) {
        var changedComponent = event.component;
        if (this.activated && changedComponent.id === this.currentComponentId) {
          this.currentComponentId = null;
        }
      },

      componentValidityChanged : function(event) {
        this.validate();
      },

      destroy : function() {
        this.deactivate();
        for ( var index = 0; index < this.processModel.models.length; index++) {
          var component = this.components[index];
          component.events.un({
            'activate' : this.componentActivated,
            'deactivate' : this.componentDeactivated,
            'validitychange' : this.componentValidityChanged,
            scope : this
          });
          component.destroy();
        }
        this.components = [];
        this.componentsElement.innerHTML = '';
        this.componentsElement = null;
        if (Legato.Lang.ObjectUtils.exists(this.events)) {
          this.events.destroy();
          this.events = null;
        }
        this.executeCallback = null;
        this.cancelCallback = null;
      },

      CLASS_NAME : 'WPS.Component.Process'
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Geometry = OpenLayers.Class(WPS.Result, {

  map : null,
  layer : null,

  initialize : function(id, map, options) {
    WPS.Result.prototype.initialize.apply(this, [ id, options ]);
    this.map = map;
  },

  execute : function() {
    var layerOptions = {
      isFeatureLayer: true,
      legatoIgnore: true,
      // indicate that the temp vector layer will never be out of range
      // without this, resolution properties must be specified at the
      // map-level for this temporary layer to init its resolutions
      // correctly
      calculateInRange : function() {
        return true;
      }
    };
    this.layer = new OpenLayers.Layer.Vector('Result geometry layer',
        layerOptions);
    this.layer.style = WPS.Feature.Style.ACTIVE;
    this.map.addLayer(this.layer);
    var feature = this.createFeature();
    this.layer.addFeatures([ feature ]);
  },

  createFeature : function() {
    var geojson_format = new OpenLayers.Format.GeoJSON();
    var resultGeometry = this.createResultGeometry();
    var feature = new OpenLayers.Feature.Vector(geojson_format.read(
        resultGeometry, 'Geometry'));
    feature.style = this.createGeometryStyle();
    return feature;
  },

  createGeometryStyle : function() {
    return WPS.Feature.Style.ACTIVE;
  },

  createResultGeometry : function() {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the createResultGeometry function from from abstract class ' +
        WPS.Result.Geometry.CLASS_NAME);
  },

  destroy : function() {
    this.map = null;
    this.layer = null;
    WPS.Result.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME : 'WPS.Result.Geometry'

});

WPS.Result.Geometry.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {
      schema : 'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Geometry',
      name : new Legato.XML.QName('http://www.opengis.net/gml', 'Geometry',
          'gml'),
      createResult : function(id, outputData, options) {
        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;
        var type = value.type;
        var coordinates = value.coordinates;
        switch (type) {
        case 'Polygon':
          return new WPS.Result.Polygon(id, this.map, coordinates, options);
        case 'LineString':
          return new WPS.Result.LineString(id, this.map, coordinates, options);
        case 'Point':
          return new WPS.Result.Point(id, this.map, coordinates, options);
        }
      },
      CLASS_NAME : 'WPS.Result.Geometry.ComplexFactory'
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Factory = OpenLayers.Class({

  literalFactory: null,

  boundingBoxFactory: null,

  exceptionReportFactory: null,

  complexFactories: null,

  initialize : function(map, form) {
    Legato.Util.Ensure.ensureExists(map, "map must be defined");
    this.literalFactory = new WPS.Result.Message.LiteralFactory(map);
    this.boundingBoxFactory = new WPS.Result.BoundingBox.BoundingBoxFactory(map);
    this.exceptionReportFactory = new WPS.Result.ExceptionReport.ExceptionReportFactory(map);
    this.complexFactories = [
      // WPS-PD
      new WPS.Result.Link.ComplexFactory(map),
      new WPS.Result.Message.ComplexFactory(map),
      new WPSPD.Result.Geometry.ComplexFactory(map),
      new WPSPD.Result.Marker.ComplexFactory(map, this),
      new WPS.Result.Group.ComplexFactory(map, this),
      // GML
      new WPS.Result.Point.ComplexFactory(map),
      new WPS.Result.LineString.ComplexFactory(map),
      new WPS.Result.Polygon.ComplexFactory(map),
      new WPS.Result.Geometry.ComplexFactory(map)
    ];
    // WPS
    if (Legato.Lang.ObjectUtils.isObject(form)) {
      this.complexFactories.push (new WPS.Result.ProcessDescription.ComplexFactory(map, form));
    }
  },

  createResult : function(executeResponse, popupCallback, errorCallback) {
    if ( Legato.Lang.ObjectUtils.exists(executeResponse.processOutputs)) {
      if (Legato.Lang.ObjectUtils.exists(executeResponse.status) && Legato.Lang.ObjectUtils.exists(executeResponse.status.processFailed)) {
        if (Legato.Lang.ObjectUtils.exists(executeResponse.status.processFailed.exceptionReport))
        {
          return this.createExceptionReportResult(executeResponse.status.processFailed.exceptionReport, popupCallback, errorCallback);
        }
        else
        {
          var report = {
              exception : [
                  {
                      exceptionText : [
                        'Der Prozess schlug fehl, es wurde aber keine Fehlermeldung zurückgegeben'
                      ],
                      exceptionCode : 'NoExceptionReport'
                  }
              ]
          };
          return this.createExceptionReportResult(report, popupCallback, errorCallback);
        }
      }
      else {
        var outputData = executeResponse.processOutputs.output[0];
        return this.createSingleNormalResult(outputData, popupCallback, errorCallback);
      }
    } else if (Legato.Lang.ObjectUtils.exists(executeResponse.exception)) {
      return this.createExceptionReportResult(executeResponse, popupCallback, errorCallback);
    } else {
      throw new Legato.Lang.Exception("Unknown executeResponse");
    }
  },

  createSingleNormalResult : function(outputData, popupCallback, errorCallback) {
    var currentId = OpenLayers.Util.createUniqueID('WPS_Result_');

    /* Create options */
    var options = {};

    if(Legato.Lang.ObjectUtils.isFunction(popupCallback)){
      options.popupCallback = popupCallback;
    }

    if(Legato.Lang.ObjectUtils.isFunction(errorCallback)){
      options.errorCallback = errorCallback;
    }

    if (Legato.Lang.ObjectUtils.exists(outputData.title)
        && Legato.Lang.ObjectUtils.isString(outputData.title.value)) {
      options.title = outputData.title.value;
    }

    /*jslint sub:true */
    if (Legato.Lang.ObjectUtils.exists(outputData['abstract'])
        && Legato.Lang.ObjectUtils.isString(outputData['abstract'].value)) {
      /*jslint sub:true */
      options.description = outputData['abstract'].value;
    }
    // Literal output
    if (Legato.Lang.ObjectUtils.exists(outputData.data.literalData)) {
      return this.literalFactory.createResult(currentId, outputData,
          options);
    }
    // Bounding box output
    else if (Legato.Lang.ObjectUtils
        .exists(outputData.data.boundingBoxData)) {
      return this.boundingBoxFactory.createResult(currentId, outputData,
          options);
    }
    // Complex output
    else if (Legato.Lang.ObjectUtils.exists(outputData.data.complexData)) {
      for ( var factoryIndex = 0; factoryIndex < this.complexFactories.length; factoryIndex++) {
        var currentFactory = this.complexFactories[factoryIndex];
        if (currentFactory.schema === outputData.data.complexData.schema) {
          return currentFactory
              .createResult(currentId, outputData, options);
        }
      }
      // TODO: Implement further factories for complexData if needed
      throw new Legato.Lang.Exception('Unsupported complex data: ' + outputData.data.complexData.schema);
    } else {
      throw new Legato.Lang.Exception('Unsupported output data.');
    }
  },

  createExceptionReportResult : function(exceptionReport, popupCallback, errorCallback) {
    var currentId = OpenLayers.Util.createUniqueID('WPS_ExceptionReport_');
    /* Create options */
    var options = {};
    if(Legato.Lang.ObjectUtils.isFunction(popupCallback)){
      options.popupCallback = popupCallback;
    }

    if(Legato.Lang.ObjectUtils.isFunction(errorCallback)){
      options.errorCallback = errorCallback;
    }

    return this.exceptionReportFactory.createResult(currentId, exceptionReport,
          options);
  },

  destroy : function() {
  },

  CLASS_NAME :'WPS.Result.Factory'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Link = OpenLayers.Class(WPS.Result, {
  href :null,
  show :null,
  actuate :null,
  contentType :null,

  initialize : function(id, href, options) {
    WPS.Result.prototype.initialize.apply(this, [ id,
        options ]);
    Legato.Util.Ensure.ensureString(href, "href should be defined");
    this.href = href;
  },

  destroy : function() {
    this.href = null;
    this.show = null;
    this.actuate = null;
    this.contentType = null;
    WPS.Result.prototype.destroy.apply(this, arguments);
  },

  createContent : function() {
    if (this.show === 'embed') {
      // If it is an image
      if (Legato.Lang.ObjectUtils.exists(this.contentType)
          && (this.contentType.substring(0, 6) === 'image/')) {
        var img = document.createElement('img');
        img.id = this.id;
        img.src = this.href;
        img.title = this.title;
        return img;
      }
      // If it is something else
      else {
        var iframe = document.createElement('iframe');
        iframe.id = this.id;
        iframe.src = this.href;
        iframe.title = this.title;
        return iframe;
      }
    } else {
      var a = document.createElement('a');
      a.id = this.id;
      a.href = this.href;
      a.innerHTML = this.title;
      a.target = this.show === 'new' ? '_blank' : '_self';
      return a;
    }
  },

  execute : function() {
    this.navigateToLocation(this.href);
  },

  navigateToLocation : function(location) {
    if (this.show === 'new')
    {
      window.open(location);
    }
    else if (this.show === 'replace')
    {
      window.location = location;
    }
    else
    {
      window.open(location);
    }
  },

  CLASS_NAME :'WPS.Result.Link'
});

WPS.Result.Link.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {
      schema :'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Link',
      name :new Legato.XML.QName('http://www.disy.net/pd', 'Link', 'pd'),
      createResult : function(id, outputData, options) {
        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;
        var href = value.href;
        options.show = value.show;
        options.actuate = value.actuate;
        options.contentType = value.contentType;
        return new WPS.Result.Link(id, href, options);

      },
      CLASS_NAME :'WPS.Result.Link.ComplexFactory'
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Message = OpenLayers.Class(WPS.Result, {
  message : null,
  initialize : function(id, message, options) {
    WPS.Result.prototype.initialize.apply(this, [ id, options ]);
    Legato.Util.Ensure.ensureExists(message, 'message should be defined');
    // Text
    if (Legato.Lang.ObjectUtils.isString(message)) {
      this.message = message;
    }
    // Hypertext
    else if (Legato.Lang.ObjectUtils.exists(message.nodeType)) {
      var format = new OpenLayers.Format.XML();
      this.message = format.write(message);
    } else {
      throw new Legato.Lang.Exception('Unsupported message content.');
    }
  },

  execute : function() {
    if (!Legato.Lang.ObjectUtils.isFunction(this.popupCallback)) {
      alert(this.message);
      return;
    }

    if (Legato.Lang.ObjectUtils.exists(this.type) && this.type === 'error') {
      this.errorCallback(this.createContent());
    }

    this.popupCallback(this.createContent());
  },

  createResultContainer: function(){
    var resultContainer = document.createElement('div');
    resultContainer.id = this.id;

    var resultTitle = document.createElement('div');
    resultTitle.className = 'wpsResultTitle';
    resultTitle.innerHTML = this.title;

    var resultAbstract = document.createElement('div');
    resultAbstract.className = 'wpsResultAbstract';
    resultAbstract.innerHTML = this.description;

    resultContainer.appendChild(resultTitle);
    resultContainer.appendChild(resultAbstract);

    return resultContainer;
  },

  createContent : function() {
    var resultContainer = this.createResultContainer();

    if (!Legato.Lang.ObjectUtils.isString(this.message)) {
      resultContainer.appendChild(this.message);
      return resultContainer;
    }

    var resultMessageContainer = document.createElement('div');
    resultMessageContainer.className = 'wpsResult';

    var resultMessage = document.createElement('textarea');
    resultMessage.value = this.message;
    resultMessage.readOnly = 'readOnly';
    resultMessage.cols = 68;
    resultMessage.rows = 10;
    resultMessage.onclick = function(){
      this.select();
    };

    if (Legato.Lang.ObjectUtils.exists(this.type)) {
      OpenLayers.Element.addClass(resultMessage, this.type);
    }

    resultMessageContainer.appendChild(resultMessage);
    resultContainer.appendChild(resultMessageContainer);

    return resultContainer;
  },

  destroy : function() {
    this.message = null;
    WPS.Result.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME : 'WPS.Result.Message'
});

WPS.Result.Message.LiteralFactory = OpenLayers.Class(
    WPS.Result.SimpleFactory, {

      createResult : function(id, outputData, options) {
        return new WPS.Result.Message(id, outputData.data.literalData.value,
            options);
      },

      CLASS_NAME : 'WPS.Result.Message.LiteralFactory'
    });

WPS.Result.Message.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {

      schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Message',

      name : new Legato.XML.QName('http://www.disy.net/pd', 'Message', 'pd'),

      createResult : function(id, outputData, options) {
        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;

        if (Legato.Lang.ObjectUtils.exists(value.type)
            && Legato.Lang.ObjectUtils.isString(value.type)) {
          options.type = value.type;
        } else {
          options.type = 'none';
        }

        return new WPS.Result.Message(id, value.content, options);
      },
      CLASS_NAME : 'WPS.Result.Message.ComplexFactory'
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.BoundingBox = OpenLayers.Class(WPS.Result,
  {
    map: null,
    bounds: null,
    closest: true,

    initialize : function(id, map, bounds, options) {
      WPS.Result.prototype.initialize.apply(
        this, [id, options ]
      );
      this.map = map;
      this.bounds = bounds;
      Legato.Util.Ensure.ensureExists(this.map, 'map should be defined');
      Legato.Util.Ensure.ensureExists(this.bounds, 'bounds should be defined');
    },

    zoomToExtent : function(extent) {
      if(!Legato.Lang.ObjectUtils.isObject(this.map) ||
         !Legato.Lang.ObjectUtils.isFunction(this.map.zoomToExtent)){
        throw new Legato.Lang.Exception('Could not execute the result because given map seems to be invalid');
      }

      this.map.zoomToExtent(extent, this.closest);
    },

    execute : function() {
      this.zoomToExtent(this.bounds);
      return;
    },

    destroy : function() {
      this.map = null;
      this.bounds = null;
      this.closest = null;
      WPS.Result.prototype.destroy.apply(this, arguments);
    },

    CLASS_NAME :'WPS.Result.BoundingBox'
  }
);

WPS.Result.BoundingBox.BoundingBoxFactory = OpenLayers.Class(
  WPS.Result.SimpleFactory, {

    createResult : function(id, outputData, options) {
      if(!Legato.Lang.ObjectUtils.isArray(outputData.data.boundingBoxData.lowerCorner) ||
         !Legato.Lang.ObjectUtils.isArray(outputData.data.boundingBoxData.upperCorner) ||
         outputData.data.boundingBoxData.lowerCorner.length !== 2 ||
         outputData.data.boundingBoxData.upperCorner.length !== 2){
        throw new Legato.Lang.Exception('outputData.data.boundingBoxData seems to be invalid');
      }

      var bounds = new OpenLayers.Bounds(
        outputData.data.boundingBoxData.lowerCorner[0],
        outputData.data.boundingBoxData.lowerCorner[1],
        outputData.data.boundingBoxData.upperCorner[0],
        outputData.data.boundingBoxData.upperCorner[1]);

      return new WPS.Result.BoundingBox(id, this.map, bounds, options);
    },

    CLASS_NAME :'WPS.Result.BoundingBox.BoundingBoxFactory'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.ExceptionReport = OpenLayers.Class(
  WPS.Result,
  {
    exceptionReport: null,

    initialize : function(id, exceptionReport, options) {
      Legato.Util.Ensure.ensureExists(exceptionReport, 'An exception report should be defined');
      WPS.Result.prototype.initialize.apply(
        this, [id, options ]
      );
      this.exceptionReport = exceptionReport;
    },

    showExceptionReport: function(report) {
      alert(this.createExceptionMessage(report, "\r\n"));
    },

    createExceptionMessage: function(report, lineBreak) {
      var message = 'Beim Ausführen des Dienstes ist ein Fehler aufgetreten.' + lineBreak;
      message += 'Fehler-Code: ' + report.exception[0].exceptionCode + lineBreak;
      message += 'Fehlernachricht: ';
      message += report.exception[0].exceptionText.join(' ');
      return message;
    },

    execute : function() {
      if (!Legato.Lang.ObjectUtils.isFunction(this.errorCallback)){
        this.showExceptionReport(this.exceptionReport);
        return;
      }
      this.errorCallback(this.createContent());
    },

    createContent : function() {
      var reportElement = document.createElement('div');
      reportElement.id = this.id;
      OpenLayers.Element.addClass(reportElement, 'error');
      reportElement.innerHTML = this.createExceptionMessage(this.exceptionReport, '<br />');
      return reportElement;
    },

    destroy : function() {
      this.report = null;
      WPS.Result.prototype.destroy.apply(this, arguments);
    },

    CLASS_NAME :'WPS.Result.ExceptionReport'
  }
);

WPS.Result.ExceptionReport.ExceptionReportFactory = OpenLayers.Class(
  WPS.Result.SimpleFactory, {

    createResult : function(id, exceptionReport, options) {
      return new WPS.Result.ExceptionReport(id, exceptionReport, options);
    },

    CLASS_NAME :'WPS.Result.ExceptionReport.ExceptionReportFactory'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Point = OpenLayers.Class(WPS.Result.Geometry, {
  coordinates : null,

  initialize : function(id, map, coordinates, options) {
    WPS.Result.Geometry.prototype.initialize.apply(this, [ id, map, options ]);
    Legato.Util.Ensure.ensureArray(coordinates,
        "coordinates should be defined as array");
    this.coordinates = coordinates;
  },

  destroy : function() {
    this.coordinates = null;
    WPS.Result.Geometry.prototype.destroy.apply(this, arguments);
  },

  createResultGeometry : function() {
    var geometryToRender = {
      "type" : "Point",
      "coordinates" : [ this.coordinates[0], this.coordinates[1]]
    };
    return geometryToRender;
  },

  CLASS_NAME : 'WPS.Result.Point'
});

WPS.Result.Point.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {
      schema : 'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Point',
      name : new Legato.XML.QName('http://www.opengis.net/gml', 'Point', 'gml'),
      createResult : function(id, outputData, options) {
        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;
        var type = value.type;
        var coordinates = value.coordinates;
        return new WPS.Result.Point(id, this.map, coordinates, options);

      },
      CLASS_NAME : 'WPS.Result.Point.ComplexFactory'
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.LineString = OpenLayers.Class(WPS.Result.Geometry, {
  coordinates :null,

  initialize : function(id, map, coordinates, options) {
    WPS.Result.Geometry.prototype.initialize.apply(this, [ id, map, options ]);
    Legato.Util.Ensure.ensureArray(coordinates, "coordinates should be defined as array");
    this.coordinates = coordinates;
  },

  destroy : function() {
    this.coordinates = null;
    WPS.Result.Geometry.prototype.destroy.apply(this, arguments);
  },

  createResultGeometry : function() {
    var geometryToRender = {
      "type" : "LineString",
      "coordinates" : this.coordinates
    };
    return geometryToRender;
  },

  CLASS_NAME :'WPS.Result.LineString'
});

WPS.Result.LineString.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {
      schema :'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#LineString',
      name : new Legato.XML.QName('http://www.opengis.net/gml', 'LineString', 'gml'),
      createResult : function(id, outputData, options) {
        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;
        var type = value.type;
        var coordinates = value.coordinates;
        return new WPS.Result.LineString(id, this.map, coordinates, options);

      },
      CLASS_NAME :'WPS.Result.LineString.ComplexFactory'
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Polygon = OpenLayers.Class(WPS.Result.Geometry, {
  coordinates :null,

  initialize : function(id, map, coordinates, options) {
    WPS.Result.Geometry.prototype.initialize.apply(this, [ id, map, options ]);
    Legato.Util.Ensure.ensureArray(coordinates, "coordinates should be defined as array");
    this.coordinates = coordinates;
  },

  destroy : function() {
    this.coordinates = null;
    WPS.Result.Geometry.prototype.destroy.apply(this, arguments);
  },

  createResultGeometry : function() {
    var geometryToRender = {
      "type" : "Polygon",
      "coordinates" : this.coordinates
    };
    return geometryToRender;
  },

  CLASS_NAME :'WPS.Result.Polygon'
});

WPS.Result.Polygon.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {
      schema :'http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#Polygon',
      name : new Legato.XML.QName('http://www.opengis.net/gml', 'Polygon', 'gml'),
      createResult : function(id, outputData, options) {
        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;
        var type = value.type;
        var coordinates = value.coordinates;
        return new WPS.Result.Polygon(id, this.map, coordinates, options);

      },
      CLASS_NAME :'WPS.Result.Polygon.ComplexFactory'
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Group = OpenLayers.Class(WPS.Result, {
  results : null,
  factory : null,

  initialize : function(id, results, options) {
    WPS.Result.prototype.initialize.apply(this, [ id, options ]);
    // TODO must be string or element
    Legato.Util.Ensure.ensureExists(results, 'results should be defined');
    this.results = results;
  },

  execute : function() {
    // TODO move to the factory
    for ( var index = 0; index < this.results.length; index++) {
      var result = this.results[index];
      result.execute();
    }
  },

  createContent : function() {
    throw new Legato.Lang.Exception('The method createContent is not supported by the class' + this.CLASS_NAME);
  },

  destroy : function() {
    this.items = null;
    WPS.Result.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME : 'WPS.Result.Group'
});

WPS.Result.Group.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {

      schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Group',

      name : new Legato.XML.QName('http://www.disy.net/pd', 'Group', 'pd'),

      factory : null,

      initialize : function(map, factory) {
        Legato.Util.Ensure.ensureExists(map, 'map should be defined');
        Legato.Util.Ensure.ensureExists(factory, 'factory should be defined');
        this.map = map;
        this.factory = factory;
      },

      createResult : function(id, outputData, options) {

        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;
        var items;
        if (Legato.Lang.ObjectUtils.isArray(value.presentationDirective)) {
          items = value.presentationDirective;
        } else {
          items = [];
        }
        var results = [];
        for ( var index = 0; index < items.length; index++) {
          var item = items[index];
          var itemOutputData = {
            data : {
              complexData : {
                schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#'
                    + item.name.localPart,
                mimeType : 'text/xml',
                encoding : 'utf-8',
                content : [ item ]

              }
            }
          };
          results.push(this.factory.createSingleNormalResult(itemOutputData,
              null, null));
        }

        return new WPS.Result.Group(id, results, options);
      },
      CLASS_NAME : 'WPS.Result.Group.ComplexFactory'
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.ProcessDescription = OpenLayers.Class(WPS.Result, {
  form : null,
  processDescription : null,
  initialize : function(id, form, processDescription, options) {
    WPS.Result.prototype.initialize.apply(this, [ id, options ]);
    Legato.Util.Ensure.ensureExists(form, 'form should be defined');
    Legato.Util.Ensure.ensureExists(processDescription,
        'process description should be defined');
    this.form = form;
    this.processDescription = processDescription;
  },

  execute : function() {
    this.form.activateProcessDescription(this.processDescription);
  },

  createContent : function() {
    throw new Legato.Lang.Exception("Not supported.");
  },

  destroy : function() {
    WPS.Result.prototype.destroy.apply(this, arguments);
    this.form = null;
    this.processDescription = null;
  },

  CLASS_NAME : 'WPS.Result.ProcessDescription'
});

WPS.Result.ProcessDescription.ComplexFactory = OpenLayers
    .Class(
        WPS.Result.ComplexFactory,
        {
          schema : 'http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd#ProcessDescription',
          name : new Legato.XML.QName('http://www.opengis.net/wps/1.0.0',
              'ProcessDescription', 'wps'),
          initialize : function(map, form) {
            Legato.Util.Ensure.ensureExists(map, 'map should be defined');
            Legato.Util.Ensure.ensureExists(form, 'form should be defined');
            this.map = map;
            this.form = form;
          },
          createResult : function(id, outputData, options) {
            return new WPS.Result.ProcessDescription(id, this.form,
                outputData.data.complexData.content[0].value, options);
          },
          destroy : function() {
            WPS.Result.ComplexFactory.prototype.destroy.apply(
                this, arguments);
            this.form = null;
          },
          CLASS_NAME : 'WPS.Result.ProcessDescription.ComplexFactory'
        });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPSPD.Result.Geometry = OpenLayers.Class(WPS.Result.Geometry, {

  symbolizer : null,
  layer : null,

  initialize : function(id, map, symbolizer, options) {
    WPS.Result.Geometry.prototype.initialize.apply(this, [ id, map, options ]);
    this.symbolizer = symbolizer;
  },

  createGeometryStyle : function() {
    var style = OpenLayers.Util.extend({}, WPS.Feature.Style.ACTIVE);
    if (Legato.Lang.ObjectUtils.exists(this.symbolizer)) {
      this.configureStyle(style);
    }
    return style;
  },

  configureStyle : function(style) {
    throw new Legato.Lang.Exception(this.CLASS_NAME + ' must implement the configureStyle function from from abstract class '
        + WPSPD.Result.Geometry.CLASS_NAME);
  },

  evaluateStyleConfiguration : function(styleConfig, style) {
    var declarationMap = {
      'stroke' : 'strokeColor',
      'stroke-width' : 'strokeWidth',
      'fill' : 'fillColor'
    };
    if (Legato.Lang.ObjectUtils.exists(styleConfig.svgParameter)) {
      for (index = 0; index < styleConfig.svgParameter.length; index++) {
        var svgParameter = styleConfig.svgParameter[index];
        if (Legato.Lang.ObjectUtils.exists(declarationMap[svgParameter.name])) {
          style[declarationMap[svgParameter.name]] = svgParameter.content[0];
        }
      }
    }
  },

  destroy : function() {
    this.map = null;
    this.layer = null;
    WPS.Result.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME : 'WPSPD.Result.Geometry'

});

WPSPD.Result.Geometry.ComplexFactory = OpenLayers.Class(WPS.Result.ComplexFactory, {
  schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Geometry',
  name : new Legato.XML.QName('http://www.disy.net/pd', 'Geometry', 'pd'),
  createResult : function(id, outputData, options) {
    var complexData = outputData.data.complexData;
    var value = complexData.content[0].value;
    var geometryValue = value.geometry.value;
    var symbolizer;
    if (Legato.Lang.ObjectUtils.exists(value.symbolizer) && Legato.Lang.ObjectUtils.exists(value.symbolizer.value)) {
      symbolizer = value.symbolizer.value;
    } else {
      symbolizer = null;
    }
    var type = geometryValue.type;
    var coordinates = geometryValue.coordinates;
    switch (type) {
    case 'Polygon':
      return new WPSPD.Result.Polygon(id, this.map, coordinates, symbolizer, options);
    case 'LineString':
      return new WPSPD.Result.LineString(id, this.map, coordinates, symbolizer, options);
    case 'Point':
      return new WPSPD.Result.Point(id, this.map, coordinates, symbolizer, options);
    }
  },
  CLASS_NAME : 'WPSPD.Result.Geometry.ComplexFactory'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPSPD.Result.Point = OpenLayers.Class(WPSPD.Result.Geometry, {
  point : null,

  initialize : function(id, map, coordinates, symbolizer, options) {
    WPSPD.Result.Geometry.prototype.initialize.apply(this, [ id, map, symbolizer, options ]);
    point = new WPS.Result.Point(id, map, coordinates, options);
  },

  destroy : function() {
    this.point = null;
    WPSPD.Result.Geometry.prototype.destroy.apply(this, arguments);
  },

  createResultGeometry : function() {
    return point.createResultGeometry();
  },

  configureStyle : function(style) {
    if (Legato.Lang.ObjectUtils.exists(this.symbolizer.graphic) && Legato.Lang.ObjectUtils.exists(this.symbolizer.graphic.externalGraphicOrMark)) {
      var externalGraphicOrMark = this.symbolizer.graphic.externalGraphicOrMark;
      for (index = 0; index < externalGraphicOrMark.size(); index++) {
        var graphicElement = externalGraphicOrMark[index];
        if (Legato.Lang.ObjectUtils.exists(graphicElement.stroke)) {
          this.evaluateStyleConfiguration(graphicElement.stroke, style);
        }
        if (Legato.Lang.ObjectUtils.exists(graphicElement.fill)) {
          this.evaluateStyleConfiguration(graphicElement.fill, style);
        }
      }
    }
  },

  CLASS_NAME : 'WPSPD.Result.Point'

});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPSPD.Result.Polygon = OpenLayers.Class(WPSPD.Result.Geometry, {
  polygon : null,

  initialize : function(id, map, coordinates, symbolizer, options) {
    WPSPD.Result.Geometry.prototype.initialize.apply(this, [ id, map, symbolizer, options ]);
    polygon = new WPS.Result.Polygon(id, map, coordinates, options);
  },

  destroy : function() {
    this.polygon = null;
    WPSPD.Result.Geometry.prototype.destroy.apply(this, arguments);
  },

  createResultGeometry : function() {
    return polygon.createResultGeometry();
  },

  configureStyle : function(style) {
    if (Legato.Lang.ObjectUtils.exists(this.symbolizer.stroke)) {
      this.evaluateStyleConfiguration(this.symbolizer.stroke, style);
    }
    if (Legato.Lang.ObjectUtils.exists(this.symbolizer.fill)) {
      this.evaluateStyleConfiguration(this.symbolizer.fill, style);
    }
  },

  CLASS_NAME : 'WPSPD.Result.Polygon'

});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPSPD.Result.LineString = OpenLayers.Class(WPSPD.Result.Geometry, {
  lineString : null, 
  
  initialize : function(id, map, coordinates, symbolizer, options) {
    WPSPD.Result.Geometry.prototype.initialize.apply(this, [ id, map, symbolizer, options ]);
    lineString = new WPS.Result.LineString(id, map, coordinates, options);
  },

  destroy : function() {
    this.lineString = null;
    WPSPD.Result.Geometry.prototype.destroy.apply(this, arguments);
  },

  createResultGeometry : function() {
    return lineString.createResultGeometry();
  },
  
  configureStyle : function(style) {
    if (Legato.Lang.ObjectUtils.exists(this.symbolizer.stroke)) {
      this.evaluateStyleConfiguration(this.symbolizer.stroke, style);
    }
  },

  CLASS_NAME : 'WPSPD.Result.LineString'
    
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPSPD.Result.Marker = OpenLayers.Class(
  WPS.Result,
  {
    map : null,
    factory : null,
    marker : null,
    selectControl : null,
    layer: null,
    feature: null,

    initialize : function(id, map, factory, marker, options) {
      WPS.Result.prototype.initialize.apply(this, [ id,
          options ]);
      Legato.Util.Ensure.ensureExists(map, 'map should be defined');
      Legato.Util.Ensure.ensureExists(factory,
          'factory should be defined');
      Legato.Util.Ensure.ensureExists(marker, 'marker should be defined');
      this.map = map;
      this.factory = factory;
      this.marker = marker;
    },

    createFeature : function() {
      if (Legato.Lang.ObjectUtils.exists(this.marker.geometry)) {
        var outputData = {
          data : {
            complexData : {
              schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Geometry',
              mimeType : 'text/xml',
              encoding : 'utf-8',
              content : [ this.marker.geometry ]
            }
          }
        };
        var geometryResult = this.factory.createSingleNormalResult(outputData,
            null, null);
        this.feature = geometryResult.createFeature();
        return this.feature;
      } else if (Legato.Lang.ObjectUtils.exists(this.marker.position)) {
        throw new Legato.Lang.Exception("Position markers are not yet supported.");
      }
    },

    createLayer : function(feature) {
      var layerOptions = {
        displayInLayerSwitcher : true,
        calculateInRange : function() {
          return true;
        }
      };
      //Should be configurable (i18n)
      this.layer = new OpenLayers.Layer.Vector('Result marker layer', layerOptions);
      this.layer.style = WPS.Feature.Style.ACTIVE;
      this.layer.addFeatures([ feature ]);
    },

    createSelectControl : function(layer, feature) {
      if (Legato.Lang.ObjectUtils.exists(this.marker.message)) {

        // Create message
        // Add message to feature
        var messageOutputData = {
          data : {
            complexData : {
              schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Message',
              mimeType : 'text/xml',
              encoding : 'utf-8',
              content : [ this.marker.message ]
            }
          }
        };

        feature.messageResult = this.factory.createSingleNormalResult(messageOutputData, null, null);

        var selectControlOptions = {
          scope: feature,
          hover: true,
          highlightOnly : true
        };

        // REVIEW AV Control pro marker?
        this.selectControl = new OpenLayers.Control.SelectFeature(layer, selectControlOptions);
        this.selectControl.events.register('beforefeaturehighlighted', this, this.onBeforefeaturehighlighted);
        this.selectControl.events.register('featurehighlighted', this, this.onFeaturehighlighted);
        this.selectControl.events.register('featureunhighlighted', this, this.onFeatureunhighlighted);
      }
    },

    onBeforefeaturehighlighted: function(options){
      return options.feature === this.feature;
    },

    onFeaturehighlighted: function(options){
      if(options.feature !== this.feature){
        return false;
      }

      if (Legato.Lang.ObjectUtils.exists(this.feature.messageResult.message) &&
          !Legato.Lang.ObjectUtils.exists(this.feature.popup)) {

        var centroid = this.feature.geometry.getCentroid();
        var lonlat = new OpenLayers.LonLat(centroid.x, centroid.y);

        var popup = new OpenLayers.Popup.AnchoredBubble(
          //ID
          this.feature.id + '.Message',
          //Center to Geometry
          lonlat,
          //AutoSize!
          null,
          //content
          this.feature.messageResult.message,
          //not needed
          null,
          //no close button
          false,
          //not needed
          null
        );
        popup.panMapIfOutOfView = false;
        popup.closeOnMove = true;
        popup.autoSize = true;
        this.feature.popup = popup;
      }
      this.map.addPopup(this.feature.popup);
      this.feature.popup.show();
    },

    onFeatureunhighlighted: function(options){
      if(options.feature !== this.feature){
        return false;
      }

      if (!Legato.Lang.ObjectUtils.isNullOrUndefined(this.feature.popup)) {
        this.map.removePopup(this.feature.popup);
      }
      this.feature.popup.hide();
    },

    addLayerAndSelectControl : function() {
      this.map.addLayer(this.layer);
      if (Legato.Lang.ObjectUtils.exists(this.selectControl)) {
        this.map.addControl(this.selectControl);
      }
    },

    execute : function() {
      this.createFeature();
      this.createLayer(this.feature);
      this.createSelectControl(this.layer, this.feature);
      this.addLayerAndSelectControl();
    },

    destroy : function() {
      this.layer.destroy();
      this.marker = null;
      WPS.Result.prototype.destroy.apply(this, arguments);
    },

    CLASS_NAME : 'WPSPD.Result.Marker'
  }
);

WPSPD.Result.Marker.ComplexFactory = OpenLayers.Class(
  WPS.Result.ComplexFactory,
  {
    schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Marker',

    name : new Legato.XML.QName('http://www.disy.net/pd', 'Marker', 'pd'),

    map : null,

    factory : null,

    initialize : function(map, factory) {
      Legato.Util.Ensure.ensureExists(map, 'map should be defined');
      Legato.Util.Ensure.ensureExists(factory, 'factory should be defined');
      this.map = map;
      this.factory = factory;
    },

    createResult : function(id, outputData, options) {
      var complexData = outputData.data.complexData;
      var value = complexData.content[0].value;

      return new WPSPD.Result.Marker(id, this.map, this.factory, value,
          options);

    },
    CLASS_NAME : 'WPSPD.Result.Marker.ComplexFactory'
  }
);
