/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Util.Logger
 */
Legato.Util.Logger = {

  /*
   * Property: target
   *
   * Target bean.
   */
  instance: null,

  getLogger: function(){
    /*
     * Beware:
     * Do not use Legato.Lang.ObjectUtils.isObject cause if we're handling
     * with the HTMLUnit Logger instance calling isObject would cause
     * an exception cause the HTMLUnit logger instance does not support
     * the typeof method.
     */
    if(Legato.Util.Logger.instance === null){
      Legato.Util.Logger.instance = Legato.Util.Logger.createLogger();
    }

    return Legato.Util.Logger.instance;
  },

  createLogger : function() {
    var l = null;

    /*
     * This implementation differ from the other mechanism because of HTMLUnit.
     * The defined logger instance does not support the typeof function which is used
     * by Legato.Lang.ObjectUtils.isObject. Therefore we assume that if an global
     * logger instance exists that this one is an object.
     */
    if(window.logger &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.trace) &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.debug) &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.info) &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.warn) &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.error) &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.fatal)){
      l = window.logger;
      return l;
    }

    //log4javascript Logger
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(window.log4javascript) &&
       Legato.Lang.ObjectUtils.isObject(window.log4javascript)){
      l = window.log4javascript.getLogger();

      // Create a PopUpAppender with default options
      var popUpAppender = new log4javascript.PopUpAppender();

      // Change the desired configuration options
      popUpAppender.setFocusPopUp(true);
      popUpAppender.setNewestMessageAtTop(true);

      // Add the appender to the logger
      l.addAppender(popUpAppender);
      return l;
    }

    //Console Logger
    if(Legato.Lang.ObjectUtils.isObject(window.console) &&
       Legato.Lang.ObjectUtils.isFunction(window.console.trace) &&
       Legato.Lang.ObjectUtils.isFunction(window.console.debug) &&
       Legato.Lang.ObjectUtils.isFunction(window.console.info) &&
       Legato.Lang.ObjectUtils.isFunction(window.console.warn) &&
       Legato.Lang.ObjectUtils.isFunction(window.console.error)){

      l = window.console;

      if(!Legato.Lang.ObjectUtils.isFunction(window.console.fatal)){
        //Fatal is not supported by console
        l.fatal = l.error;
      }

      return l;
    }

    //Nothing is defined so use alert if fatal errors may occur
    l = {};
    l.trace = function(msg){};
    l.debug = function(msg){};
    l.info  = function(msg){};
    l.warn  = function(msg){};
    l.error = function(msg){};
    l.fatal = function(msg){
      alert(msg);
    };

    return l;
  }
};
