/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Hack
OpenLayers.Layer.Vector.prototype.EVENT_TYPES.push('legato.sketchpointadded');
OpenLayers.Layer.Vector.prototype.EVENT_TYPES.push('legato.sketchupdated');

/**
 * Component: oll:Vector
 *
 * Used to render vector data from a variety of sources.
 * 
 * Inherits from:
 * - {<oll:Layer>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.Vector>}
 */
OpenLayers.Layer.Vector.Bean = OpenLayers.Layer.Bean.Extend(
		'OpenLayers.Layer.Vector',
		//
		Legato.OpenLayers.Layer.QName('Vector'),
		//
		{
			_constructor : OpenLayers.Layer.Vector,
			constructorArguments : {
				/**
				 * Element: name
				 * {String}
				 */
				name : Legato.Lang.String
			},
			constructorOrder : [ 'name' ],
			options : {
				/**
				 * Element: isFixed
				 * {Boolean} Whether the layer remains in one place while dragging the map.
				 */
				isFixed : Legato.Lang.Boolean,
				/**
				 * Element: isVector
				 * {Boolean} Whether the layer is a vector layer.
				 */
				isVector : Legato.Lang.Boolean,
				/**
				 * Element: features
				 * {Object []}
				 */
				features : Legato.Beans['Object[]'],
				/**
				 * Element: reportError
				 * {Boolean} Report friendly error message when loading of renderer fails.
				 */
				reportError : Legato.Lang.Boolean,
				/**
				 * Element: style
				 * {Object} Default style for the layer
				 */
				style: Legato.Lang['String{}'],
			    /**
			     * Element: rendererOptions
			     * {Object} Options for the renderer. See {<OpenLayers.Renderer>} for supported options.
			     */
				rendererOptions : Legato.Beans.Object,
				/**
				 * Element: geometryType
				 * {String} Allows limiting the types of geometries this layer supports. This should be set to something like "OpenLayers.Geometry.Point" to limit types.
				 */
				geometryType : Legato.Lang.String
			}
		});

OpenLayers.Layer.Vector.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : OpenLayers.Layer.Vector.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:Vector',
		new OpenLayers.Layer.Vector.LayerFactory());