/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires Legato.js
 * @requires OpenLayers/Control.js
 */

/**
 * Class: Legato.Util
 * Common utiltites for Legato
 *
 */
Legato.Util = {};
Legato.Util.NAMESPACE_URI = 'http://www.disy.net/legato/util';
Legato.Util.PREFIX = 'lu';
Legato.Util.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Util.NAMESPACE_URI, localPart,
      Legato.Util.PREFIX);
};

Legato.Util.extend = function(destination, source) {
  destination = destination || {};
  if (source) {
    /*jslint forin:true*/
    for ( var property in source) {
      var value = source[property];
      if (value !== undefined) {
        destination[property] = value;
      }
    }

    /**
     * IE doesn't include the toString property when iterating over an
     * object's properties with the for(property in object) syntax.
     * Explicitly check if the source has its own toString property.
     */

    /*
     * FF/Windows < 2.0.0.13 reports "Illegal operation on WrappedNative
     * prototype object" when calling hawOwnProperty if the source object is
     * an instance of window.Event.
     */
    var sourceIsEvt = (typeof window.Event == "function" && source instanceof window.Event);

    if (!sourceIsEvt && source.hasOwnProperty
        && source.hasOwnProperty('toString')) {
      destination.toString = source.toString;
    }
  }
  return destination;
};

Legato.Util.getElementById = function(id) {
  return document.getElementById(id);
};

Legato.Util.fireDOMEvent = function(obj, evt) {
  var fireOnThis = obj;
  if (document.createEvent) {
    var evObj = document.createEvent("MouseEvents");
    evObj.initEvent(evt, true, false);
    fireOnThis.dispatchEvent(evObj);
  } else if (document.createEventObject) {
    fireOnThis.fireEvent("on" + evt);
  }
};

Legato.Util.getUrlString = function(urlObject){
  if(!Legato.Lang.ObjectUtils.isObject(urlObject)){
    return false;
  }

  var urlString = urlObject.protocol + "//" + urlObject.host + ":" + urlObject.port + urlObject.pathname;

  if(Legato.Lang.ObjectUtils.isObject(urlObject.args)){
    urlString += "?" + OpenLayers.Util.getParameterString(urlObject.args);
  }

  return urlString;
};