/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Service
 * Abstract base class for all Legato Services
 */
Legato.Service = OpenLayers.Class({
  initialize: function (options) {
    OpenLayers.Util.extend(this, options);
    this.options = options;
  },

  CLASS_NAME: 'Legato.Service'
});

/*
 * Property: Legato.Service.BUSY
 *
 * Static const which indicates that the current <Legato.Service> is busy and
 * that you should try again later.
 */
Legato.Service.BUSY  = -99;
Legato.Service.ERROR = -999;

Legato.Service.NAMESPACE_URI = 'http://www.disy.net/legato/service';
Legato.Service.PREFIX = 'ls';
Legato.Service.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Service.NAMESPACE_URI, localPart,
      Legato.Service.PREFIX);
};