/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerLink
 */
Legato.Control.Legend.Plugin.LayerLink = OpenLayers.Class(
    Legato.Control.Legend.Plugin, {
      url :null,
      params: null,
      parameterName :'selectedLayer',
      target :null,
      create : function() {
        Legato.Control.Legend.Plugin.prototype.create.apply(this, arguments);
      },
      afterInitialized: function() {

        var questionMarkIndex = this.url.indexOf('?');
        var url;
        var params;
        if (questionMarkIndex > 0) {
          url = this.url.substring(0, questionMarkIndex);
          params = OpenLayers.Util.getParameters(this.url);
        } else {
          url = this.url;
          params = {};
        }
        params[this.parameterName] = Legato.Lang.ObjectUtils.exists(this.layer.layerId) ? this.layer.layerId
            : this.layer.name;
        this.url = url + '?' + OpenLayers.Util.getParameterString(params);
      },
      getURL: function()
      {
        return this.url;
      },
      onclick: function(event)
      {
        var url = this.getURL();
        if (Legato.Lang.ObjectUtils.isString(this.target))
        {
          window.open(url, this.target);
        }
        else
        {
          window.open(url);
        }
        if (Legato.Lang.ObjectUtils.exists(event)) {
          OpenLayers.Event.stop(event, true);
        }
      },
      /**
       * Function: afterSetup
       */
      afterSetup : function() {
        this.div.onclick = OpenLayers.Function.bindAsEventListener(this.onclick, this);
      },

      /**
       * Function: beforeDestroyed
       */
      beforeDestroyed : function() {
        this.div.onclick = null;
      },

      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerLink'
    });

/**
 * Class: Legato.Control.Legend.Plugin.LayerLink.Factory Factory class wich is
 * able to create a <Legato.Control.Legend.Plugin.LayerLink> instance.
 */
Legato.Control.Legend.Plugin.LayerLink.Factory = OpenLayers.Class(
    Legato.Control.Legend.Plugin.Factory, {

      /**
       * Function: create Factory method for creating a
       * <Legato.Control.Legend.Plugin.LayerLink> instance.
       */
      create : function(layer) {
        return new Legato.Control.Legend.Plugin.LayerLink(layer,
            this.pluginOptions);
      },
      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerLink.Factory'

    });

/**
 * Structure: lpp:LayerLink XML based config for
 * <Legato.Control.Legend.Plugin.LayerLink>.
 *
 * See Also: - <Legato.Control.Legend.Plugin> - <Legato.Beans.BeanFactory> -
 * <QName>
 *
 * A valid config example for a LayerLink Plugin would be:
 * (start code)
 * <llp:LayerLink />
 * (end)
 */
Legato.Control.Legend.Plugin.LayerLink.Bean = Legato.Control.Legend.Plugin.Bean
    .Extend('Legato.Control.Legend.Plugin.LayerLink.Factory',

    /**
     * Property: QName The qualified name for this control. Needed by XML config
     * to instantiate it.
     */
    Legato.Control.Legend.Plugin.QName('LayerLink'), {
      _constructor :Legato.Control.Legend.Plugin.LayerLink.Factory,
      options : {
        url :Legato.Lang.String,
        parameterName :Legato.Lang.String,
        target :Legato.Lang.String
      }
    });