/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.tools.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.disy.legato.tools.util.IListTransformer;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.lang.StringUtils;

public class MainScriptListTransformer
implements IListTransformer {
    private String prefix = "";
    public static final Pattern SCRIPTS_EXTRACT_PATTERN = Pattern.compile("(.*')([a-zA-Z0-9/]*\\.js)('.*)");

    @Override
    public List<String> transform(List<String> resource) {
        ArrayList<String> copy = new ArrayList<String>(resource);
        CollectionUtils.filter(copy, (Predicate)new Predicate<String>(){

            public boolean evaluate(String object) {
                return SCRIPTS_EXTRACT_PATTERN.matcher(object).matches();
            }
        });
        CollectionUtils.transform(copy, (Transformer)new Transformer<String, String>(){

            public String transform(String input) {
                Matcher matcher = SCRIPTS_EXTRACT_PATTERN.matcher(input);
                if (matcher.matches()) {
                    String transformed = StringUtils.isEmpty((String)MainScriptListTransformer.this.getPrefix()) ? "" : "/" + MainScriptListTransformer.this.getPrefix();
                    return transformed + "/" + matcher.group(2);
                }
                return null;
            }
        });
        return copy;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

