/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import com.vividsolutions.jts.geom.LinearRing;
import javax.xml.bind.JAXBElement;
import net.opengis.gml.v_3_1_1.AbstractRingPropertyType;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import net.opengis.gml.v_3_1_1.LinearRingType;
import org.jvnet.ogc.gml.v_3_1_1.ObjectFactoryInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.AbstractJTSToGML311Converter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311CoordinateConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311SRSReferenceGroupConverterInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTSToGML311LinearRingConverter
extends AbstractJTSToGML311Converter<LinearRingType, AbstractRingPropertyType, LinearRing> {
    private final JTSToGML311CoordinateConverter coordinateConverter;

    public JTSToGML311LinearRingConverter(ObjectFactoryInterface objectFactory, JTSToGML311SRSReferenceGroupConverterInterface srsReferenceGroupConverter, JTSToGML311CoordinateConverter coordinateConverter) {
        super(objectFactory, srsReferenceGroupConverter);
        this.coordinateConverter = coordinateConverter;
    }

    @Override
    protected LinearRingType doCreateGeometryType(LinearRing linearRing) {
        LinearRingType resultLinearRing = this.getObjectFactory().createLinearRingType();
        for (DirectPositionType directPosition : this.coordinateConverter.convertCoordinates(linearRing.getCoordinates())) {
            JAXBElement<DirectPositionType> pos = this.getObjectFactory().createPos(directPosition);
            resultLinearRing.getPosOrPointPropertyOrPointRep().add(pos);
        }
        return resultLinearRing;
    }

    @Override
    public AbstractRingPropertyType createPropertyType(LinearRing ring) {
        AbstractRingPropertyType abstractRingProperty = this.getObjectFactory().createAbstractRingPropertyType();
        abstractRingProperty.setRing(this.getObjectFactory().createLinearRing((LinearRingType)this.createGeometryType(ring)));
        return abstractRingProperty;
    }

    @Override
    public JAXBElement<LinearRingType> createElement(LinearRing linearRing) {
        return this.getObjectFactory().createLinearRing((LinearRingType)this.createGeometryType(linearRing));
    }
}

