/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.converter;

import net.disy.ogc.wps.v_1_0_0.converter.TypeConverter;

public class ReducedConverter<S, D>
implements TypeConverter<S, D> {
    private final Class<D> destinationClass;
    private final TypeConverter<S, ? super D> converter;

    public ReducedConverter(Class<D> destinationClass, TypeConverter<S, ? super D> converter) {
        this.destinationClass = destinationClass;
        this.converter = converter;
    }

    @Override
    public Class<S> getSourceClass() {
        return this.converter.getSourceClass();
    }

    @Override
    public Class<D> getDestinationClass() {
        return this.destinationClass;
    }

    @Override
    public D convertTo(S source) {
        D result = this.converter.convertTo(source);
        if (result == null) {
            return null;
        }
        if (!this.destinationClass.isAssignableFrom(result.getClass())) {
            throw new IllegalArgumentException("Object '" + result + "' is no instance of '" + this.destinationClass + "'.");
        }
        return result;
    }

    @Override
    public S convertFrom(D destination) {
        S result = this.converter.convertFrom(destination);
        if (result == null) {
            return null;
        }
        return result;
    }
}

