/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.converter;

import java.util.HashMap;
import java.util.Map;
import net.disy.ogc.wps.v_1_0_0.converter.IdenticalConverter;
import net.disy.ogc.wps.v_1_0_0.converter.TypeConverter;
import net.disy.ogc.wps.v_1_0_0.converter.TypeConverterForSource;
import net.disy.ogc.wps.v_1_0_0.util.Validate;

public class DefaultTypeConverterForSource<S>
implements TypeConverterForSource<S> {
    private final Map<Class<?>, TypeConverter<S, ?>> typeConverters = new HashMap();
    private final Class<S> sourceClass;

    public DefaultTypeConverterForSource(Class<S> sourceClass) {
        org.apache.commons.lang.Validate.notNull(sourceClass);
        this.sourceClass = sourceClass;
    }

    public void addConverter(TypeConverter<S, ?> typeConverter) {
        org.apache.commons.lang.Validate.notNull(typeConverter);
        Validate.notContains(this.typeConverters, typeConverter.getDestinationClass());
        this.typeConverters.put(typeConverter.getDestinationClass(), typeConverter);
    }

    @Override
    public Class<S> getSourceClass() {
        return this.sourceClass;
    }

    @Override
    public <D> D convertTo(Class<D> destinationClass, S object) {
        org.apache.commons.lang.Validate.notNull(destinationClass);
        TypeConverter<S, D> typeConverter = this.getRequiredTypeConverter(destinationClass);
        return typeConverter.convertTo(object);
    }

    @Override
    public <D> S convertFrom(Class<D> destinationClass, D object) {
        org.apache.commons.lang.Validate.notNull(destinationClass);
        TypeConverter<S, D> typeConverter = this.getRequiredTypeConverter(destinationClass);
        return typeConverter.convertFrom(object);
    }

    private <D> TypeConverter<S, D> getRequiredTypeConverter(Class<D> destinationClass) {
        if (!this.isConversionSupported(destinationClass)) {
            throw new IllegalArgumentException("Class '" + destinationClass.getName() + "' is not supported.");
        }
        return this.getTypeConverter(destinationClass);
    }

    private <D> TypeConverter<S, D> getTypeConverter(Class<D> destinationClass) {
        if (this.getSourceClass() == destinationClass) {
            return new IdenticalConverter<S>(this.getSourceClass());
        }
        if (this.typeConverters.containsKey(destinationClass)) {
            return this.typeConverters.get(destinationClass);
        }
        return null;
    }

    @Override
    public boolean isConversionSupported(Class<?> destinationClass) {
        org.apache.commons.lang.Validate.notNull(destinationClass);
        return this.getTypeConverter(destinationClass) != null;
    }
}

