/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import net.disy.ogc.ows.v_1_1_0.OwsException;
import net.disy.ogc.wps.v_1_0_0.WpsProcess;
import net.disy.ogc.wps.v_1_0_0.WpsProcessRegistry;
import net.disy.ogc.wps.v_1_0_0.procedure.WpsProcessContext;
import net.disy.ogc.wps.v_1_0_0.sample.AnnotationProcedureWpsProcess;
import org.apache.commons.lang.Validate;

public class ProcessForClassNameAdder {
    private final WpsProcessContext wpsProcessContext;
    private final WpsProcessRegistry wpsProcessRegistry;

    public ProcessForClassNameAdder(WpsProcessContext wpsProcessContext, WpsProcessRegistry wpsProcessRegistry) {
        Validate.notNull((Object)wpsProcessContext);
        Validate.notNull((Object)wpsProcessRegistry);
        this.wpsProcessContext = wpsProcessContext;
        this.wpsProcessRegistry = wpsProcessRegistry;
    }

    public void addProcessesForClassNames(List<String> processClassNames) {
        for (String processClassName : processClassNames) {
            this.addProcessForClassName(processClassName);
        }
    }

    private void addProcessForClassName(String processClassName) {
        block10: {
            try {
                if (processClassName == null) break block10;
                Class<?> processClass = Class.forName(processClassName.trim());
                Object draftProcess = null;
                try {
                    Constructor<?> defaultConstructor = processClass.getConstructor(WpsProcessContext.class);
                    draftProcess = defaultConstructor.newInstance(this.wpsProcessContext);
                }
                catch (NoSuchMethodException nsmex1) {
                    try {
                        Constructor<?> contextConstructor = processClass.getConstructor(new Class[0]);
                        draftProcess = contextConstructor.newInstance(new Object[0]);
                    }
                    catch (NoSuchMethodException nsmex2) {
                        throw new IllegalArgumentException(MessageFormat.format("Process class [{0}] must declare a default constructor or a constructor accepting and instance of [{1}].", processClass.getName(), WpsProcessContext.class.getName()));
                    }
                }
                WpsProcess wpsProcess = draftProcess instanceof WpsProcess ? (WpsProcess)draftProcess : new AnnotationProcedureWpsProcess(this.wpsProcessContext, (Object)draftProcess);
                this.wpsProcessRegistry.registerProcess(wpsProcess);
            }
            catch (ClassNotFoundException cnfex) {
                throw new IllegalArgumentException("Could not find process class [" + processClassName + "].", cnfex);
            }
            catch (InstantiationException iex) {
                throw new IllegalArgumentException("Could not instantiate process class [" + processClassName + "].", iex);
            }
            catch (InvocationTargetException itex) {
                throw new IllegalArgumentException("Could not instantiate process class [" + processClassName + "].", itex);
            }
            catch (IllegalAccessException iaex) {
                throw new IllegalArgumentException("Could not instantiate process class [" + processClassName + "].", iaex);
            }
            catch (OwsException owsException) {
                throw new IllegalArgumentException("Could not register the process [" + processClassName + "].", owsException);
            }
        }
    }
}

