/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.ows.v_1_1_0.util;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import net.opengis.ows.v_1_1_0.CodeType;
import net.opengis.ows.v_1_1_0.DCP;
import net.opengis.ows.v_1_1_0.HTTP;
import net.opengis.ows.v_1_1_0.Operation;
import net.opengis.ows.v_1_1_0.RequestMethodType;
import org.apache.commons.lang.Validate;

public class OwsUtils {
    private OwsUtils() {
    }

    public static String toString(CodeType code) {
        if (code == null) {
            return null;
        }
        return (code.getCodeSpace() == null ? "" : '{' + code.getCodeSpace() + '}') + code.getValue();
    }

    public static JAXBElement<RequestMethodType> createGet(String uri) {
        Validate.notNull((Object)uri);
        RequestMethodType requestMethodType = OwsUtils.createRequestMethodType(uri);
        return new JAXBElement(new QName("http://www.opengis.net/ows/1.1", "Get"), RequestMethodType.class, HTTP.class, (Object)requestMethodType);
    }

    public static JAXBElement<RequestMethodType> createPost(String uri) {
        Validate.notNull((Object)uri);
        RequestMethodType requestMethodType = OwsUtils.createRequestMethodType(uri);
        return new JAXBElement(new QName("http://www.opengis.net/ows/1.1", "Post"), RequestMethodType.class, HTTP.class, (Object)requestMethodType);
    }

    public static RequestMethodType createRequestMethodType(String uri) {
        RequestMethodType requestMethodType = new RequestMethodType();
        requestMethodType.setHref(uri);
        requestMethodType.setType("simple");
        return requestMethodType;
    }

    public static Operation createOperation(String name) {
        Validate.notNull((Object)name);
        Operation operation = new Operation();
        operation.setName(name);
        DCP dcp = new DCP();
        operation.getDCP().add(dcp);
        HTTP http = new HTTP();
        dcp.setHTTP(http);
        return operation;
    }
}

