/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.gml.v_3_1_1.dwr;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import net.disy.ogc.gml.v_3_1_1.dwr.AbstractGeometryTypeConverter;
import net.opengis.gml.v_3_1_1.AbstractGeometryType;
import net.opengis.gml.v_3_1_1.AbstractRingPropertyType;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import net.opengis.gml.v_3_1_1.LinearRingType;
import net.opengis.gml.v_3_1_1.PolygonType;
import org.directwebremoting.extend.MarshallException;
import org.jvnet.jaxb2_commons.locator.DefaultRootObjectLocator;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.ogc.gml.v_3_1_1.jts.ConversionFailedException;

public class PolygonTypeConverter
extends AbstractGeometryTypeConverter<PolygonType, double[][][]> {
    @Override
    protected double[][][] createCoordinates(PolygonType polygonType) throws MarshallException {
        try {
            Polygon polygon = (Polygon)this.getConverter().createGeometry((ObjectLocator)new DefaultRootObjectLocator((Object)polygonType), (AbstractGeometryType)polygonType);
            int interiorRingCount = polygon.getNumInteriorRing();
            int outerSize = 1 + interiorRingCount;
            double[][][] arrayForAllPositions = new double[outerSize][][];
            arrayForAllPositions[0] = this.extractPositions(polygon.getExteriorRing());
            for (int index = 0; index < interiorRingCount; ++index) {
                arrayForAllPositions[1 + index] = this.extractPositions(polygon.getInteriorRingN(index));
            }
            return arrayForAllPositions;
        }
        catch (ConversionFailedException cfex) {
            throw new MarshallException(PolygonType.class, (Throwable)cfex);
        }
    }

    private double[][] extractPositions(LineString ring) {
        Coordinate[] coordinates = ring.getCoordinates();
        double[][] positions = new double[coordinates.length][];
        for (int index = 0; index < coordinates.length; ++index) {
            Coordinate coordinate = coordinates[index];
            positions[index] = Double.isNaN(coordinate.z) ? new double[]{coordinate.x, coordinate.y} : new double[]{coordinate.x, coordinate.y, coordinate.z};
        }
        return positions;
    }

    @Override
    protected String getGeometryType() {
        return "Polygon";
    }

    @Override
    protected PolygonType createGeometry(double[][][] coordinates) {
        PolygonType polygon = new PolygonType();
        for (int index = 0; index < coordinates.length; ++index) {
            AbstractRingPropertyType ringPropertyType;
            double[][] posList = coordinates[index];
            LinearRingType linearRing = new LinearRingType();
            for (double[] pos : posList) {
                DirectPositionType position = new DirectPositionType();
                for (double coordinate : pos) {
                    position.getValue().add(coordinate);
                }
                linearRing.getPosOrPointPropertyOrPointRep().add(new JAXBElement(new QName("http://www.opengis.net/gml", "pos"), DirectPositionType.class, (Object)position));
            }
            if (index == 0) {
                ringPropertyType = new AbstractRingPropertyType();
                ringPropertyType.setRing(new JAXBElement(new QName("http://www.opengis.net/gml", "LinearRing"), LinearRingType.class, (Object)linearRing));
                polygon.setExterior(new JAXBElement(new QName("http://www.opengis.net/gml", "exterior"), AbstractRingPropertyType.class, (Object)ringPropertyType));
                continue;
            }
            ringPropertyType = new AbstractRingPropertyType();
            ringPropertyType.setRing(new JAXBElement(new QName("http://www.opengis.net/gml", "LinearRing"), LinearRingType.class, (Object)linearRing));
            polygon.getInterior().add(new JAXBElement(new QName("http://www.opengis.net/gml", "interior"), AbstractRingPropertyType.class, (Object)ringPropertyType));
        }
        return polygon;
    }

    @Override
    protected Class<double[][][]> getCoordinatesType() {
        return double[][][].class;
    }
}

