/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.httpclient.methods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.lang.Validate;

public class MarshallingRequestEntity
implements RequestEntity {
    private final Marshaller marshaller;
    private final Object object;
    private final String contentType;
    private final String charset;
    private final byte[] bytes;

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Object getObject() {
        return this.object;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public MarshallingRequestEntity(Marshaller marshaller, Object object) throws JAXBException {
        this(marshaller, object, "application/xml", "UTF-8");
    }

    public MarshallingRequestEntity(Marshaller marshaller, Object object, String contentType, String charset) throws JAXBException {
        Validate.notNull((Object)marshaller);
        Validate.notNull((Object)object);
        Validate.notNull((Object)contentType);
        Validate.notNull((Object)charset);
        this.object = object;
        this.marshaller = marshaller;
        this.contentType = contentType;
        this.charset = charset;
        this.bytes = this.createBytes();
    }

    public long getContentLength() {
        return this.bytes.length;
    }

    public boolean isRepeatable() {
        return false;
    }

    public void writeRequest(OutputStream out) throws IOException {
        out.write(this.bytes);
    }

    protected byte[] createBytes() throws JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, this.getCharset());
            StreamResult result = new StreamResult(writer);
            this.getMarshaller().marshal(this.getObject(), (Result)result);
            return out.toByteArray();
        }
        catch (UnsupportedEncodingException ueex) {
            throw new RuntimeException(ueex);
        }
    }
}

