/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Feature.Sketch = {};

Legato.Feature.Sketch.style = {
  'default' : {
    TEXT : {
      labelAlign : "cm",
      labelSelect : true,
      rotation : 0.0,
      fontColor : "#0000FF",
      fontFamily : "Arial",
      fontOpacity : 1,
      fontSize : 12,
      fontStyle : "normal",
      fontWeight : "bold",
      fillOpacity : 0,
      pointRadius : 6,
      strokeWidth : 0
    },
    POINT: {
      strokeColor : "#000000",
      strokeOpacity : 1,
      strokeWidth : 1,
      fillColor : "#FF0000",
      fillOpacity : 1,
      graphicName : "circle",
      pointRadius : 6
    },
    LINE: {
      strokeColor : "#FF0000",
      strokeOpacity : 1,
      strokeWidth : 6,
      strokeLinecap : "square",
      strokeDashstyle : "solid"
    },
    POLYGON: {
      fillColor: "#FF0000",
      fillOpacity: 0.4,
      strokeColor: "#0000FF",
      strokeOpacity: 1,
      strokeLinecap : "square",
      strokeWidth: 4
    }
  },
  'select' : {
    TEXT: {
      fontOpacity : 0.2
    },
    POINT: {
      fillOpacity : 0.2
    },
    LINE: {
      strokeOpacity : 0.2
    },
    POLYGON: {
      fillOpacity: 0.2,
      strokeOpacity: 0.2
    }
  }
};

Legato.Feature.Sketch.Attributes = {
  TEXT: [
    "x-label",
    "x-label-align",
    "rotation",
    "font-family",
    "font-size",
    "font-style",
    "font-weight",
    "font-color",
    "font-opacity"
  ],
  POINT: [
    "stroke",
    "stroke-opacity",
    "stroke-width",
    "fill",
    "fill-opacity",
    "x-graphic-name",
    "x-point-radius"
  ],
  LINE: [
    "stroke",
    "stroke-opacity",
    "stroke-width",
    "x-stroke-dashstyle"
  ],
  POLYGON: [
    "stroke",
    "stroke-opacity",
    "stroke-width",
    "x-stroke-dashstyle",
    "fill",
    "fill-opacity"
  ]
};

Legato.Feature.Sketch.AttributeStyleMap = {
  "x-label": "label",
  "x-label-align" : "labelAlign",
  "x-graphic-name" : "graphicName",
  "x-point-radius" : "pointRadius",
  "x-stroke-dashstyle"  : "strokeDashstyle",
  "rotation" : "rotation",
  "font-family" : "fontFamily",
  "font-size" : "fontSize",
  "font-style" : "fontStyle",
  "font-weight" : "fontWeight",
  "font-color" : "fontColor",
  "font-opacity" : "fontOpacity",
  "stroke" : "strokeColor",
  "stroke-opacity" : "strokeOpacity",
  "stroke-width" : "strokeWidth",
  "fill" : "fillColor",
  "fill-opacity" : "fillOpacity"
};