/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * MapAttribution (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 91043 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Control.MapAttribution
 * ValueProvider which gives you the possibility to be notified about every
 * change of the current BBox Selection. The notification could be a JS Callback
 * or a Object where its property will be overwritten each time the watched value
 * changes.
 *
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.MapAttribution = OpenLayers.Class(Legato.Control, {

    /**
     * {DOMElement}
     */
    element: null,

    /**
     * Property: text
     * {String} The MapAttribution text
     */
    text: null,

    /**
     * Property: url
     * {String} the MapAttribution hyperlink
     */
    url: null,

    /**
     * Property: image
     * {String} the url to the MapAttribution image
     */
    image: null,

    /**
     * Property: size
     * {Size} the size of the MapAttribution image
     */
    size: null,

    /**
     * Property: imageElement
     * {DOMElement}
     */
    imageElement: null,

    /**
     * Property: stopEvent
     * {Boolean} If configured the event propagation to other map control may be stoppe.
     */
    stopEvent: null,

    /**
     * Constructor: Legato.Control.MapAttribution
     *
     * Parameters:
     * options - {Object} Options for control.
     */
    initialize: function(options) {
        Legato.Control.prototype.initialize.apply(this, arguments);
    },

    /**
     * Method: destroy
     */
     destroy: function() {
         Legato.Control.prototype.destroy.apply(this, arguments);
     },

    /**
     * Method: draw
     * {DOMElement}
     */
    draw: function() {
        Legato.Control.prototype.draw.apply(this, arguments);

        if (!this.element) {
          //Use MapAttribution text
          if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.image)){
            this.div.innerHTML = this.text;
          }
          //Use image
          else {
            this.imageElement = document.createElement('img');
            this.imageElement.src = this.image;

            if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.text)){
              this.imageElement.alt = this.text;
            }

            if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.size)){
              this.imageElement.height = this.size.h;
              this.imageElement.width = this.size.w;
            }
            this.div.appendChild(this.imageElement);
          }

          this.div.onmouseup = OpenLayers.Function.bindAsEventListener(this.onclick, this);
          this.element = this.div;
        }

        return this.div;
    },

    /**
     * Function: onclick
     */
    onclick : function(event) {
      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.url)){
        window.open(this.url);
      }

      if (Legato.Lang.ObjectUtils.exists(event)) {
        //Stop event propagation if config option is set to true
        if(this.stopEvent === true){
          OpenLayers.Event.stop(event, true);
        }

        //Stop event propagation if config is not set and url is configured
        if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.stopEvent) &&
           !Legato.Lang.ObjectUtils.isNullOrUndefined(this.url)){
          OpenLayers.Event.stop(event, true);
        }
      }
    },

    /**
     * Method: setMap
     */
    setMap: function() {
      Legato.Control.prototype.setMap.apply(this, arguments);
    },

    CLASS_NAME: "Legato.Control.MapAttribution"
});

/**
 * Structure: lc:WMSGetFeatureInfo XML based config for a
 * <Legato.Control.WMSGetFeatureInfo>.
 *
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 *
 * A valid config example for a WMSGetFeatureInfo would be:
 * (start code)
 * <lc:MapAttribution>
 *   <text>My MapAttribution</text>
 *   <url>http://www.myServer.com/images/MapAttribution.png</url>
 *   <size><ol:Size w="100" h="50" /></size>
 * </lc:MapAttribution>
 * (end)
 */
Legato.Control.MapAttribution.Bean = Legato.Control.Bean.Extend(

'Legato.Control.MapAttribution',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Control.QName('MapAttribution'), {
  _constructor :Legato.Control.MapAttribution,
  options : {
    /*
     * Property: url
     * configures the URL of the MapAttribution image
     */
    url: Legato.Lang.String,

    /*
     * Property: text
     * configures the MapAttribution text
     */
    text: Legato.Lang.String,

    /*
     * Property: image
     * the url of the MapAttribution image
     */
    image: Legato.Lang.String,

    /*
     * Property: size
     *
     * Configures the size for the MapAttribution image
     */
    size: OpenLayers.Size.Bean,

    /*
     * Property: size
     *
     * Optional. If configured with true this control will stop the event propagation
     * to active map controls like the ZoomIn control.
     */
    stopEvent: Legato.Lang.Boolean
  }
});
