/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var Legato={singleFile:true};
(function(){var c=(typeof Legato=="object"&&Legato.singleFile);
var g=(!c)?"lib/Legato.js":"Legato.js";
var b=window.Legato;
window.Legato={_getScriptLocation:(function(){var p=new RegExp("(^|(.*?\\/))("+g+")(\\?|$)"),o=document.getElementsByTagName("script"),q,j,k="";
for(var n=0,h=o.length;
n<h;
n++){q=o[n].getAttribute("src");
if(q){j=q.match(p);
if(j){k=j[1];
break
}}}return(function(){return k
})
})()};
if(!c){b=["Legato/Feature.js","Legato/Feature/Sketch.js","Legato/Singleton.js","Legato/Util.js","Legato/Lang.js","Legato/Graph.js","Legato/Proj4js.js","Legato/XML.js","Legato/Lang/Class.js","Legato/Lang/ObjectUtils.js","Legato/Lang/ArrayUtils.js","Legato/Lang/CollectionUtils.js","Legato/Lang/NumberUtils.js","Legato/Lang/StringUtils.js","Legato/Lang/Exception.js","Legato/Lang/IllegalArgumentException.js","Legato/Lang/AnyType.js","Legato/Lang/AnySimpleType.js","Legato/Lang/List.js","Legato/Lang/Map.js","Legato/Lang/Null.js","Legato/Lang/Enum.js","Legato/Lang/Boolean.js","Legato/Lang/Integer.js","Legato/Lang/Number.js","Legato/Lang/Double.js","Legato/Lang/String.js","Legato/Lang/Element.js","Legato/Lang/Function.js","Legato/Lang/RGBColor.js","Legato/Util/Accessor.js","Legato/Util/ObjectValueAccessor.js","Legato/Util/ObjectFilter.js","Legato/Util/Ensure.js","Legato/Util/Matcher.js","Legato/Util/HashSet.js","Legato/Util/Tag.js","Legato/Util/DOM.js","Legato/Util/GeoLocation.js","Legato/Util/Logger.js","Legato/Util/Browser.js","Legato/Graph/DirectedGraph.js","Legato/Graph/Vertex.js","Legato/XML/QName.js","Legato/XML/ElementUtils.js","Legato/Beans.js","Legato/Beans/Property.js","Legato/Beans/BeanDefinition.js","Legato/Beans/ComplexType.js","Legato/Beans/Object.js","Legato/Beans/BeanFactory.js","Legato/Beans/XMLBeanFactory.js","Legato/Beans/Reference.js","Legato/Beans/Evaluate.js","Legato/Beans/Field.js","Legato/Predicate.js","Legato/Predicate/And.js","Legato/Predicate/Contains.js","Legato/Predicate/Equals.js","Legato/Predicate/False.js","Legato/Predicate/Or.js","Legato/Predicate/True.js","Legato/Lang/Library.js","Legato/Util/Library.js","Legato/Text.js","Legato/Text/Format.js","Legato/Text/DecimalFormat.js","Legato/Text/PrecisionScaleFormat.js","Legato/OpenLayers.js","Legato/OpenLayers/Bounds.js","Legato/OpenLayers/LonLat.js","Legato/OpenLayers/Projection.js","Legato/OpenLayers/Size.js","Legato/OpenLayers/Pixel.js","Legato/OpenLayers/Icon.js","Legato/OpenLayers/Layer.js","Legato/OpenLayers/Control.js","Legato/OpenLayers/Map.js","Legato/OpenLayers/Map/Util.js","Legato/OpenLayers/Patches/Popup.js","Legato/OpenLayers/Control/ArgParser.js","Legato/OpenLayers/Control/Attribution.js","Legato/OpenLayers/Control/DrawFeature.js","Legato/OpenLayers/Control/ModifyFeature.js","Legato/OpenLayers/Control/LayerSwitcher.js","Legato/OpenLayers/Control/LoadingPanel.js","Legato/OpenLayers/Control/Scale.js","Legato/OpenLayers/Control/ScaleLine.js","Legato/OpenLayers/Control/Navigation.js","Legato/OpenLayers/Control/NavigationHistory.js","Legato/OpenLayers/Control/OverviewMap.js","Legato/OpenLayers/Control/Panel.js","Legato/OpenLayers/Control/PanZoom.js","Legato/OpenLayers/Control/PanZoomBar.js","Legato/OpenLayers/Control/MouseDefaults.js","Legato/OpenLayers/Control/MousePosition.js","Legato/OpenLayers/Control/Zoom.js","Legato/OpenLayers/Control/ZoomBox.js","Legato/OpenLayers/Control/ZoomInBox.js","Legato/OpenLayers/Control/ZoomOutBox.js","Legato/OpenLayers/Control/ZoomOut.js","Legato/OpenLayers/Control/ZoomToMaxExtent.js","Legato/OpenLayers/Popup/MarginAwareFramedCloud.js","Legato/Service.js","Legato/Service/LayerCapabilities.js","Legato/Service/CapabilitiesURLs.js","Legato/Handler.js","Legato/Handler/Box.js","Legato/Handler/Path.js","Legato/Handler/Point.js","Legato/Handler/Polygon.js","Legato/Handler/RegularPolygon.js","Legato/Handler/MouseWheel.js","Legato/Handler/MultiPoint.js","Legato/Handler/MultiLineString.js","Legato/Handler/MultiPolygon.js","Legato/I18n.js","Legato/I18n/BrowserLocaleFactoryBean.js","Legato/I18n/Messages.js","Legato/I18n/MessageSource.js","Legato/I18n/Message.js","Legato/I18n/Messages/de.js","Legato/I18n/Messages/en.js","Legato/Popup.js","Legato/Layer.js","Legato/Layer/Predicate.js","Legato/Layer/Predicate/BaseLayer.js","Legato/Layer/Predicate/LayerId.js","Legato/Layer/Predicate/LayerWithAttribute.js","Legato/Layer/Predicate/Overlay.js","Legato/Layer/Predicate/SelectedLayer.js","Legato/Layer/Transformer.js","Legato/Layer/Transformer/SublayerFilteringTransformer.js","Legato/Marker.js","Legato/Marker/PopupMarker.js","Legato/Control.js","Legato/Control/ArgParser.js","Legato/Control/BBoxValueProvider.js","Legato/Control/ControlContainer.js","Legato/Control/ControlFunction.js","Legato/Control/ControlSwitcher.js","Legato/Control/DefaultBaseLayer.js","Legato/Control/DrawFeature.js","Legato/Control/DrawBox.js","Legato/Control/DrawPoint.js","Legato/Control/DrawLineString.js","Legato/Control/DrawPolygon.js","Legato/Control/DrawCircle.js","Legato/Control/DrawMultiPoint.js","Legato/Control/DrawMultiLineString.js","Legato/Control/DrawMultiPolygon.js","Legato/Control/DrawText.js","Legato/Control/ExtendedPanel.js","Legato/Control/FeatureSelector.js","Legato/Control/LayersValueProvider.js","Legato/Control/LayerSelection.js","Legato/Control/SketchLayerEditor.js","Legato/Control/Legend.js","Legato/Control/Legend/Plugin.js","Legato/Control/Legend/Plugin/Layer.js","Legato/Control/Legend/Plugin/LayerDescription.js","Legato/Control/Legend/Plugin/LayerFunction.js","Legato/Control/Legend/Plugin/LayerLink.js","Legato/Control/Legend/Plugin/LayerName.js","Legato/Control/Legend/Plugin/LayerPosition.js","Legato/Control/Legend/Plugin/LayerRemove.js","Legato/Control/Legend/Plugin/LayerVisibility.js","Legato/Control/Legend/Plugin/LayerZoomToVisibleScale.js","Legato/Control/Legend/Plugin/LayerDropDownMenu.js","Legato/Control/MapAttribution.js","Legato/Control/MeasureLine.js","Legato/Control/MeasurePolygon.js","Legato/Control/ModifyFeature.js","Legato/Control/ModifyPolygon.js","Legato/Control/ModifyPoint.js","Legato/Control/ModifyLineString.js","Legato/Control/ModifyMultiPoint.js","Legato/Control/ModifyMultiLineString.js","Legato/Control/ModifyMultiPolygon.js","Legato/Control/Navigation.js","Legato/Control/NavigationHistory.js","Legato/Control/AbstractNavigationHistoryButton.js","Legato/Control/NavigationHistoryNext.js","Legato/Control/NavigationHistoryPrevious.js","Legato/Control/OverviewBoundingBox.js","Legato/Control/PanZoom.js","Legato/Control/PanZoomBar.js","Legato/Control/SelectionBoxValueProvider.js","Legato/Control/SetMapSize.js","Legato/StyleProperties.js","Legato/StyleProperties/AbstractInputElement.js","Legato/StyleProperties/InputElement.js","Legato/StyleProperties/SelectElement.js","Legato/StyleProperties/Factory.js","Legato/Control/StylePropertiesEditor.js","Legato/Control/SyncMapDivSize.js","Legato/Control/ToggleDisplay.js","Legato/Control/ToggleDiv.js","Legato/Control/ToggleLayer.js","Legato/Control/WMSGetFeatureInfo.js","Legato/Control/ViewContextValueProvider.js","Legato/Control/ScaleInput.js","Legato/Control/SelectBounds.js","Legato/Control/SelectLonLat.js","Legato/Control/Separator.js","Legato/Control/GeoLocation.js","Legato/Control/CallbackLocker.js","Legato/Control/SynchronousSnappingResolver.js","Legato/Control/SnappingController.js","Legato/Control/SnappableLayerSelector.js","Legato/Format.js","Legato/Format/ArcXML.js","Legato/Format/GML3.js","Legato/Format/ExtendedWMC.js","Legato/Format/ExtendedWMC/Model.js","Legato/Format/ExtendedWMC/Parser.js","Legato/OpenLayers/Layer/Image.js","Legato/OpenLayers/Layer/Markers.js","Legato/OpenLayers/Layer/GeoRSS.js","Legato/OpenLayers/Layer/Grid.js","Legato/OpenLayers/Layer/Vector.js","Legato/OpenLayers/Layer/WMS.js","Legato/OpenLayers/Layer/WFS.js","Legato/OpenLayers/Layer/GML.js","Legato/OpenLayers/Layer/Yahoo.js","Legato/OpenLayers/Layer/ArcIMS.js","Legato/OpenLayers/Layer/Google.js","Legato/OpenLayers/Layer/ArcGIS93Rest.js","Legato/OpenLayers/Layer/XYZ.js","Legato/OpenLayers/Layer/OSM.js","Legato/Layer/Blank.js","Legato/Layer/VectorOSM.js","Legato/Layer/GetLegend.js","Legato/Layer/Legend.js","Legato/Layer/VectorUpdater.js","Legato/Layer/Library.js","Legato/OverviewMap.js","Legato/Style.js","Legato/BootLoader.js","Legato/Util/EventListener.js"];
var f=new Array(b.length);
var e=Legato._getScriptLocation()+"lib/";
for(var d=0,a=b.length;
d<a;
d++){f[d]="<script src='"+e+b[d]+"'><\/script>"
}if(f.length>0){document.write(f.join(""))
}}})();
Legato.VERSION_NUMBER="$Revision: 1163 $";
Legato.NAMESPACE_URI="http://www.disy.net/legato";
Legato.PREFIX="l";
Legato.QName=function(a){return new Legato.XML.QName(Legato.NAMESPACE_URI,a,Legato.PREFIX)
};
Legato.Feature={};
Legato.Feature.Style={DEFAULT_TEXT:{label:"",labelAlign:"cm",labelSelect:true,rotation:"0",fontColor:"#0000FF",fontFamily:"SansSerif",fontOpacity:"1",fontSize:"12",fontStyle:"normal",fontWeight:"bold",fillOpacity:"0",pointRadius:"6",strokeWidth:"0"},DEFAULT_POINT:{pointRadius:"4",graphicName:"square",fillColor:"white",fillOpacity:"1",strokeWidth:"1",strokeOpacity:"1",strokeColor:"#333333"},DEFAULT_LINE:{strokeWidth:"3",strokeOpacity:"1",strokeColor:"#666666",strokeDashstyle:"dash"},DEFAULT_POLYGON:{strokeWidth:"2",strokeOpacity:"1",strokeColor:"#666666",fillColor:"white",fillOpacity:"0.3"},HIGHLIGHT_POINT:{pointRadius:"4",fillColor:"#ff4500",fillOpacity:"1",strokeWidth:"1",strokeOpacity:"1",strokeColor:"#000"},HIGHLIGHT_LINE:{strokeWidth:"4",strokeOpacity:"1",strokeColor:"#000",fillColor:"#ff4500",strokeDashstyle:"dash"},HIGHLIGHT_POLYGON:{strokeWidth:"4",strokeOpacity:"1",strokeColor:"#000",fillColor:"#ff4500",fillOpacity:"0.4"}};
Legato.Feature.Sketch={};
Legato.Feature.Sketch.style={"default":{TEXT:{labelAlign:"cm",labelSelect:true,rotation:0,fontColor:"#0000FF",fontFamily:"Arial",fontOpacity:1,fontSize:12,fontStyle:"normal",fontWeight:"bold",fillOpacity:0,pointRadius:6,strokeWidth:0},POINT:{strokeColor:"#000000",strokeOpacity:1,strokeWidth:1,fillColor:"#FF0000",fillOpacity:1,graphicName:"circle",pointRadius:6},LINE:{strokeColor:"#FF0000",strokeOpacity:1,strokeWidth:6,strokeLinecap:"square",strokeDashstyle:"solid"},POLYGON:{fillColor:"#FF0000",fillOpacity:0.4,strokeColor:"#0000FF",strokeOpacity:1,strokeLinecap:"square",strokeWidth:4}},select:{TEXT:{fontOpacity:0.2},POINT:{fillOpacity:0.2},LINE:{strokeOpacity:0.2},POLYGON:{fillOpacity:0.2,strokeOpacity:0.2}}};
Legato.Feature.Sketch.Attributes={TEXT:["x-label","x-label-align","rotation","font-family","font-size","font-style","font-weight","font-color","font-opacity"],POINT:["stroke","stroke-opacity","stroke-width","fill","fill-opacity","x-graphic-name","x-point-radius"],LINE:["stroke","stroke-opacity","stroke-width","x-stroke-dashstyle"],POLYGON:["stroke","stroke-opacity","stroke-width","x-stroke-dashstyle","fill","fill-opacity"]};
Legato.Feature.Sketch.AttributeStyleMap={"x-label":"label","x-label-align":"labelAlign","x-graphic-name":"graphicName","x-point-radius":"pointRadius","x-stroke-dashstyle":"strokeDashstyle",rotation:"rotation","font-family":"fontFamily","font-size":"fontSize","font-style":"fontStyle","font-weight":"fontWeight","font-color":"fontColor","font-opacity":"fontOpacity",stroke:"strokeColor","stroke-opacity":"strokeOpacity","stroke-width":"strokeWidth",fill:"fillColor","fill-opacity":"fillOpacity"};
Legato.Singleton=OpenLayers.Class({initialize:function(){},_instance:null,getInstance:function(){if(this._instance===null){var a={};
OpenLayers.Util.extend(a,this);
a.initialize.apply(a);
this._instance=a
}return this._instance
},CLASS_NAME:"Legato.Singleton"});
Legato.Util={};
Legato.Util.NAMESPACE_URI="http://www.disy.net/legato/util";
Legato.Util.PREFIX="lu";
Legato.Util.QName=function(a){return new Legato.XML.QName(Legato.Util.NAMESPACE_URI,a,Legato.Util.PREFIX)
};
Legato.Util.extend=function(a,e){a=a||{};
if(e){for(var d in e){var c=e[d];
if(c!==undefined){a[d]=c
}}var b=(typeof window.Event=="function"&&e instanceof window.Event);
if(!b&&e.hasOwnProperty&&e.hasOwnProperty("toString")){a.toString=e.toString
}}return a
};
Legato.Util.getElementById=function(a){return document.getElementById(a)
};
Legato.Util.fireDOMEvent=function(c,a){var d=c;
if(document.createEvent){var b=document.createEvent("MouseEvents");
b.initEvent(a,true,false);
d.dispatchEvent(b)
}else{if(document.createEventObject){d.fireEvent("on"+a)
}}};
Legato.Util.getUrlString=function(b){if(!Legato.Lang.ObjectUtils.isObject(b)){return false
}var a=b.protocol+"//"+b.host+":"+b.port+b.pathname;
if(Legato.Lang.ObjectUtils.isObject(b.args)){a+="?"+OpenLayers.Util.getParameterString(b.args)
}return a
};
Legato.Lang={};
Legato.Lang.NAMESPACE_URI="http://www.disy.net/legato/lang";
Legato.Lang.PREFIX="ll";
Legato.Lang.QName=function(a){return new Legato.XML.QName(Legato.Lang.NAMESPACE_URI,a,Legato.Lang.PREFIX)
};
Legato.Graph={};
if(typeof(Proj4js)!="undefined"&&Proj4js.defs){Proj4js.defs["EPSG:31466"]="+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs";
Proj4js.defs["EPSG:31467"]="+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs";
Proj4js.defs["EPSG:31468"]="+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs";
Proj4js.defs["EPSG:31254"]="+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs";
Proj4js.defs["EPSG:31287"]="+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.33333333333333 +x_0=400000 +y_0=400000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs";
Proj4js.defs["EPSG:31284"]="+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=150000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs";
Proj4js.defs["EPSG:31251"]="+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +pm=ferro +units=m +no_defs";
Proj4js.defs["EPSG:31252"]="+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +pm=ferro +units=m +no_defs";
Proj4js.defs["EPSG:31253"]="+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +pm=ferro +units=m +no_defs";
Proj4js.defs["EPSG:31259"]="+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=750000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs"
};
Legato.XML={};
Legato.Lang.Class=function(){var c=function(){this.initialize.apply(this,arguments)
};
var b={};
var e;
for(var d=0,a=arguments.length;
d<a;
++d){if(typeof arguments[d]=="function"){e=arguments[d].prototype
}else{e=arguments[d]
}Legato.Util.extend(b,e)
}c.prototype=b;
return c
};
Legato.Lang.ObjectUtils={isNull:function(a){return(typeof a!="undefined"&&a===null)
},isUndefined:function(a){return(typeof a=="undefined")
},isNullOrUndefined:function(a){return(typeof a=="undefined"||a===null)
},exists:function(a){return(typeof a!="undefined"&&a!==null)
},isString:function(a){return(typeof a=="string")
},isBoolean:function(a){return(typeof a=="boolean")
},isTrue:function(a){return(typeof a=="boolean")&&a
},isFalse:function(a){return(typeof a=="boolean")&&!a
},isFunction:function(a){return(typeof a=="function")
},isRegExp:function(a){return a instanceof RegExp
},isDate:function(a){return a instanceof Date
},isArray:function(a){return(a instanceof Array)
},isNotEmptyArray:function(a){return(a instanceof Array)&&a.length>0
},isObject:function(a){return(typeof a=="object")&&(a!==null)
},isNumber:function(a){return(typeof a=="number")&&(a!==null)
},isEmptyObject:function(b){for(var a in b){if(b.hasOwnProperty(a)){return false
}}return true
}};
Legato.Lang.ArrayUtils={get:function(b,a){if(Legato.Lang.ObjectUtils.isArray(b)&&a>=0&&a<b.length){return b[a]
}else{return undefined
}}};
Legato.Lang.CollectionUtils={};
Legato.Lang.CollectionUtils.filter=function(d,c){Legato.Util.Ensure.ensureArray(d);
Legato.Util.Ensure.ensureFunction(c);
var a=[];
for(var b=0;
b<d.length;
b++){if(c(d[b])){a.push(d[b])
}}return a
};
Legato.Lang.CollectionUtils.filterObject=function(b,c){Legato.Util.Ensure.ensureObject(b);
Legato.Util.Ensure.ensureArray(c);
var a=[];
Legato.Lang.CollectionUtils.copyIfExists(b,a,c);
return a
};
Legato.Lang.CollectionUtils.transform=function(d,a){Legato.Util.Ensure.ensureArray(d);
Legato.Util.Ensure.ensureFunction(a);
var b=[];
for(var c=0;
c<d.length;
c++){b.push(a(d[c]))
}return b
};
Legato.Lang.CollectionUtils.each=function(c,b){Legato.Util.Ensure.ensureArray(c);
Legato.Util.Ensure.ensureFunction(b);
for(var a=0;
a<c.length;
a++){b(c[a])
}};
Legato.Lang.CollectionUtils.copyIfExists=function(c,a,b){Legato.Util.Ensure.ensureArray(b);
Legato.Lang.CollectionUtils.each(b,function(d){if(Legato.Lang.ObjectUtils.exists(c[d])){a[d]=c[d]
}})
};
Legato.Lang.NumberUtils={};
Legato.Lang.NumberUtils.toFloat=function(b){if(Legato.Lang.ObjectUtils.isNumber(b)){return b
}if(Legato.Lang.ObjectUtils.isNull(b)){return null
}if(Legato.Lang.ObjectUtils.isString(b)){var a=parseFloat(b);
if(isNaN(a)){throw Error("Given string is not parsable into a float")
}return a
}throw new Error("The object type '"+typeof b+"' is not supported")
};
Legato.Lang.NumberUtils.roundScale=function(b,d){Legato.Util.Ensure.ensureNumber(b);
var a=Math.round(d);
var c=Math.pow(10,a);
return Math.round(b*c)/c
};
Legato.Lang.StringUtils={startsWith:function(a,b){if(!Legato.Lang.ObjectUtils.isString(a)||!Legato.Lang.ObjectUtils.isString(b)){return false
}return(a.length>=b.length)&&(a.substring(0,b.length)==b)
},endsWith:function(a,b){if(!Legato.Lang.ObjectUtils.isString(a)||!Legato.Lang.ObjectUtils.isString(b)){return false
}return a.indexOf(b,a.length-b.length)!==-1
},trim:function(a){if(Legato.Lang.ObjectUtils.isUndefined(a)){return undefined
}else{if(Legato.Lang.ObjectUtils.isNull(a)){return null
}else{Legato.Util.Ensure.ensureString(a);
return a.replace(/^\s*(.*?)\s*$/,"$1")
}}},isEmpty:function(a){if(!Legato.Lang.ObjectUtils.exists(a)){return true
}else{Legato.Util.Ensure.ensureString(a);
if(a.length===0){return true
}else{return false
}}}};
Legato.Lang.Exception=Legato.Lang.Class({message:null,cause:null,initialize:function(a,b){if(Legato.Lang.ObjectUtils.exists(a)){Legato.Util.Ensure.ensureString(a);
this.message=a
}else{this.message=null
}if(Legato.Lang.ObjectUtils.exists(b)){this.cause=b
}else{this.cause=null
}},toString:function(){return this.CLASS_NAME+": "+this.message
},CLASS_NAME:"Exception"});
Legato.Lang.IllegalArgumentException=Legato.Lang.Class(Legato.Lang.Exception,{CLASS_NAME:"IllegalArgumentException"});
Legato.Lang.AnyType=Legato.Lang.Class({typeName:"Legato.Lang.AnyType",isList:false,isMap:false,isInstance:function(a){if(a){return true
}else{return false
}},initialize:function(){},List:function(){return new Legato.Lang.List(this)
},Map:function(){return new Legato.Lang.Map(this)
},Enum:function(b,a){return new Legato.Lang.Enum(this,b,a)
},toString:function(){return this.typeName
}});
Legato.Lang.AnySimpleType=Legato.Lang.Class(Legato.Lang.AnyType,{typeName:"Legato.Lang.AnySimpleType",fromString:function(b,a){Legato.Util.Ensure.ensureString(b);
return this.fromStringSafe(b,a)
},fromStringSafe:function(b,a){throw new Error("Cannot load an object from string, this class does not implement the fromStringSafe method.")
}});
Legato.Lang.List=Legato.Lang.Class(Legato.Lang.AnyType,{elementType:null,isList:true,isInstance:function(a){return(a instanceof Array)
},initialize:function(a){this.elementType=a;
this.typeName=a.typeName+"[]";
if(a.fromString){this.fromString=function(c,b){if((typeof c)!="string"){throw new Error("Argument is not a string.")
}else{return this.fromStringSafe(c,b)
}};
this.fromStringSafe=function(g,f){var c=[];
if(g.length!==0){var b=g.split(",");
for(var e=0;
e<b.length;
e++){var d=b[e];
c[e]=this.elementType.fromString(d,f)
}}return c
}
}}});
Legato.Lang.Map=Legato.Lang.Class(Legato.Lang.AnyType,{elementType:null,isMap:true,isInstance:function(a){return(typeof a=="object")
},initialize:function(a){this.elementType=a;
this.typeName=a.typeName+"{}"
}});
Legato.Lang.Null=Legato.Lang.Class({initialize:function(){},getInstance:function(a){return null
}});
Legato.Lang.Enum=Legato.Lang.Class(Legato.Lang.AnySimpleType,{elementType:null,values:null,isInstance:function(b){if(!this.elementType.isInstance(b)){return false
}else{for(var a in this.values){if(this.values[a]==b){return true
}}return false
}},fromStringSafe:function(a){if(Legato.Lang.ObjectUtils.exists(this.values[a])){return this.values[a]
}else{throw new Error("Value ["+a+"] could not be found in given enumeration.")
}},initialize:function(c,b,a){this.elementType=c;
this.typeName=b;
this.values=a
}});
Legato.Lang.Boolean=new (Legato.Lang.Class(Legato.Lang.AnySimpleType,{typeName:"Legato.Lang.Boolean",isInstance:function(a){return(typeof a)=="boolean"
},fromStringSafe:function(a){if(a=="true"){return true
}else{if(a=="false"){return false
}else{throw Error("Could not parse ["+a+"].")
}}}}))();
Legato.Lang["Boolean{}"]=Legato.Lang.Boolean.Map();
Legato.Lang["Boolean[]"]=Legato.Lang.Boolean.List();
Legato.Lang.Integer=new (Legato.Lang.Class(Legato.Lang.AnySimpleType,{typeName:"Legato.Lang.Integer",isInstance:function(a){return((typeof a)=="number"&&(a%1===0))
},fromStringSafe:function(b){var a=Number(b);
if(isNaN(a)){throw Error("Could not parse ["+b+"].")
}else{if((a%1)!==0){throw Error("Number is not an integer ["+b+"].")
}else{return a
}}}}))();
Legato.Lang["Integer{}"]=Legato.Lang.Integer.Map();
Legato.Lang["Integer[]"]=Legato.Lang.Integer.List();
Legato.Lang.Number=new (Legato.Lang.Class(Legato.Lang.AnySimpleType,{typeName:"Legato.Lang.Number",isInstance:function(a){return((typeof a)=="number")
},fromStringSafe:function(b){var a=Number(b);
if(isNaN(a)){throw Error("Could not parse ["+b+"].")
}else{return a
}}}))();
Legato.Lang["Number{}"]=Legato.Lang.Number.Map();
Legato.Lang["Number[]"]=Legato.Lang.Number.List();
Legato.Lang.Double=new (Legato.Lang.Class(Legato.Lang.AnySimpleType,{typeName:"Legato.Lang.Double",isInstance:function(a){return((typeof a)=="number"&&(!isNaN(a)))
},fromStringSafe:function(b){var a=Number(b);
if(isNaN(a)){throw Error("Could not parse ["+b+"].")
}else{return a
}}}))();
Legato.Lang["Double{}"]=Legato.Lang.Double.Map();
Legato.Lang["Double[]"]=Legato.Lang.Double.List();
Legato.Lang.String=new (Legato.Lang.Class(Legato.Lang.AnySimpleType,{typeName:"Legato.Lang.String",isInstance:function(a){return(typeof a)=="string"
},fromStringSafe:function(a){return a
}}))();
Legato.Lang["String{}"]=Legato.Lang.String.Map();
Legato.Lang["String[]"]=Legato.Lang.String.List();
Legato.Lang.Element=new (Legato.Lang.Class(Legato.Lang.AnySimpleType,{typeName:"Legato.Lang.Element",isInstance:function(a){return((typeof a)=="object"&&(a.nodeType==1)&&(typeof a.id!="undefined"))
},fromString:function(b){var a=Legato.Util.getElementById(b);
if(a){return a
}else{throw new Error("Could not find element by id ["+b+"].")
}}}))();
Legato.Lang.Function=new (Legato.Lang.Class(Legato.Lang.AnySimpleType,{typeName:"Legato.Lang.Function",isInstance:function(a){return((typeof a)=="function")
}}))();
Legato.Lang.RGBColor=Legato.Lang.Class({r:null,g:null,b:null,initialize:function(){},toString:function(){return this.CLASS_NAME+": r:"+this.r+", g:"+this.g+", b:"+this.b
},CLASS_NAME:"Legato.Lang.RGBColor"});
Legato.Util.Accessor=Legato.Lang.Class({target:null,field:null,setter:null,getter:null,initialize:function(a){this.target=a.target||null;
this.field=a.field||null;
this.setter=a.setter||null;
this.getter=a.getter||null;
if(typeof this.target=="undefined"){throw new Error("A target is needed")
}if(typeof this.field!="string"&&(typeof this.target[this.setter]!="function"||typeof this.target[this.getter]!="function")){throw new Error("You need to specifiy at least the used target field or a setter and getter function which exists in given target")
}},setValue:function(a){if(this.field){this.target[this.field]=a
}else{this.target[this.setter](a)
}},getValue:function(){var a=this.field?this.target[this.field]:this.target[this.getter]();
return a
},CLASS_NAME:"Legato.Util.Accessor"});
Legato.Util.ObjectValueAccessor=Legato.Lang.Class({target:null,field:null,setter:null,getter:null,objectProperty:null,objectFilter:null,initialize:function(a){this.target=a.target||null;
this.field=a.field||null;
this.setter=a.setter||null;
this.getter=a.getter||null;
this.objectProperty=a.objectProperty||null;
this.objectFilter=a.objectFilter||null;
if(typeof this.target===null){throw new Error("A target is needed")
}if(typeof this.layerProperty===null){throw new Error("A object Property is needed")
}if(typeof this.field!="string"&&(typeof this.target[this.setter]!="function"||typeof this.target[this.getter]!="function")){throw new Error("You need to specifiy at least the used target field or a setter and getter function which exists in given target")
}},getFilteredObjects:function(a){var c=a;
if(this.objectFilter!==null||Legato.Lang.ObjectUtils.isArray(this.objectFilter)){for(var b=0;
b<this.objectFilter.length;
b++){if(!Legato.Lang.ObjectUtils.isFunction(this.objectFilter[b].filter)){continue
}c=this.objectFilter[b].filter(c)
}}return c
},setValue:function(c){Legato.Util.Ensure.ensureArray(c);
var b=this.getFilteredObjects(c);
var a=this.getObjectValues(b,this.objectProperty);
if(this.field){this.target[this.field]=a.toString()
}else{this.target[this.setter](a.toString())
}},getObjectValues:function(d,c){var a=[];
for(var b=0;
b<d.length;
b++){if(!Legato.Lang.ObjectUtils.isObject(d[b])){throw new Error("Just an Array of object Instances is allowed")
}if(typeof d[b][c]!="undefined"){a.push(d[b][c])
}}return a
},getValue:function(){var a=this.field?this.target[this.field]:this.target[this.getter]();
return a
},CLASS_NAME:"Legato.Util.ObjectValueAccessor"});
Legato.Util.ObjectFilter=Legato.Lang.Class({property:null,value:null,initialize:function(a){this.property=a.property;
this.value=a.value
},filter:function(c){var a=[];
if(!Legato.Lang.ObjectUtils.isArray(c)){throw new Error("Just an Array of object Instances is allowed")
}for(var b=0;
b<c.length;
b++){if(Legato.Lang.ObjectUtils.isUndefined(c[b][this.property])||Legato.Lang.ObjectUtils.isFunction(c[b][this.property])){a.push(c[b]);
continue
}if(c[b][this.property]!=this.value){a.push(c[b])
}}return a
},CLASS_NAME:"Legato.Util.ObjectFilter"});
Legato.Util.Ensure={ensureTrue:function(b,a){if(b!==true){throw new Error(a)
}},ensureFalse:function(b,a){if(b!==false){throw new Error(a)
}},ensureExists:function(b,a){if(!Legato.Lang.ObjectUtils.exists(b)){throw new Error(a)
}},ensureString:function(b,a){if(typeof b!="string"){throw new Legato.Lang.IllegalArgumentException(a)
}},ensureNumber:function(b,a){if(typeof b!="number"){throw new Legato.Lang.IllegalArgumentException(a)
}},ensureNotEmptyString:function(b,a){if(typeof b!="string"){throw new Legato.Lang.IllegalArgumentException(a)
}else{if(Legato.Lang.StringUtils.isEmpty(b)){throw new Legato.Lang.IllegalArgumentException(a)
}}},ensureObject:function(b,a){if(typeof b!="object"||b===null){throw new Legato.Lang.IllegalArgumentException(a)
}},ensureArray:function(b,a){if(!(b instanceof Array)){throw new Legato.Lang.IllegalArgumentException(a)
}},ensureFunction:function(b,a){if(typeof b!="function"){throw new Legato.Lang.IllegalArgumentException(a)
}},ensureInstanceOf:function(c,b,a){Legato.Util.Ensure.ensureFunction(b);
if(!(c instanceof b)){throw new Legato.Lang.IllegalArgumentException(a)
}},ensureImplements:function(c,b,a){Legato.Util.Ensure.ensureExists(c,a);
Legato.Util.Ensure.ensureString(b,a);
Legato.Util.Ensure.ensureFunction(c[b],a)
}};
Legato.Util.Matcher={};
Legato.Util.Matcher.IS_TRUE={test:function(a){return a
}};
Legato.Util.Matcher.IS_FALSE={test:function(a){return !a
}};
Legato.Util.HashSet=Legato.Lang.Class({map:null,_size:0,initialize:function(){this.map={}
},size:function(){return this._size
},isEmpty:function(){return(this._size===0)
},contains:function(b){Legato.Util.Ensure.ensureString(b);
var a=this.map[b];
if(a){return true
}else{return false
}},add:function(b){Legato.Util.Ensure.ensureString(b);
var a=this.map[b];
if(a){return false
}else{this.map[b]=true;
this._size=this._size+1;
return true
}},addAll:function(f){Legato.Util.Ensure.ensureObject(f);
Legato.Util.Ensure.ensureFunction(f.toArray);
var e=f.toArray();
var d=false;
for(var a=0;
a<e.length;
a++){var c=e[a];
var b=this.add(c);
d=(d||b)
}return d
},remove:function(b){Legato.Util.Ensure.ensureString(b);
var a=this.map[b];
if(a){delete this.map[b];
this._size=this._size-1;
return true
}else{return false
}},toArray:function(){var b=[];
for(var a in this.map){if(this.map.hasOwnProperty(a)){b.push(a)
}}return b
},clear:function(){this.map={};
this._size=0
}});
Legato.Util.Tag=Legato.Lang.Class({name:null,value:null,initialize:function(a,b){Legato.Util.Ensure.ensureString(a);
this.name=a;
if(Legato.Lang.ObjectUtils.exists(b)){Legato.Util.Ensure.ensureString(b);
this.value=b
}else{this.value=null
}},toString:function(){return"["+this.name+(this.value===null?"":"="+this.value)+"]"
},equals:function(a){return(a!==null)&&(this.name==a.name&&this.value==a.value)
},CLASS_NAME:"Legato.Util.Tag"});
Legato.Util.DOM={unloadStack:[],oldUnLoad:null,done:false};
Legato.Util.DOM.addDOMLoadEvent=(function(){var load_events=[],load_timer,script,done,exec,old_onload,init=function(){done=true;
clearInterval(load_timer);
exec=load_events.shift();
while(exec){exec();
exec=load_events.shift()
}if(script){script.onreadystatechange=""
}if(!Legato.Util.DOM.done){Legato.Util.DOM.done=true;
Legato.Util.DOM.oldUnLoad=window.onunload;
window.onunload=OpenLayers.Function.bind(Legato.Util.DOM.unload,Legato.Util.DOM)
}};
return function(func){if(done){return func()
}if(!load_events[0]){if(document.addEventListener){document.addEventListener("DOMContentLoaded",init,false);
/*@cc_on
      @if (@_win32)
         document.write("<script id=__ie_onload defer src=//0><\/scr"+"ipt>");
         script = document.getElementById("__ie_onload");
         script.onreadystatechange = function() {
           if (this.readyState == "complete"){
             init();
           }
         };
      @end
      @*/
}if(/WebKit/i.test(navigator.userAgent)){load_timer=setInterval(function(){if(/loaded|complete/.test(document.readyState)){init()
}},10)
}old_onload=window.onload;
window.onload=function(){init();
if(old_onload){old_onload()
}}
}load_events.push(func)
}
})();
Legato.Util.DOM.unload=function(a){exec=this.unloadStack.shift();
while(exec){exec();
exec=this.unloadStack.shift()
}if(this.oldUnLoad){this.oldUnLoad()
}};
Legato.Util.DOM.addDOMUnLoadEvent=function(a){this.unloadStack.push(a)
};
if(document.addEventListener){document.addEventListener("DOMWindowClose",Legato.Util.DOM.unload,false)
};
Legato.Util.GeoLocation={};
Legato.Util.GeoLocation.isAvailable=function(){if(!Legato.Lang.ObjectUtils.isNullOrUndefined(navigator)&&!Legato.Lang.ObjectUtils.isNullOrUndefined(navigator.geolocation)){return true
}return false
};
Legato.Util.GeoLocation.getCurrentPosition=function(b,a){if(Legato.Util.GeoLocation.isAvailable()){navigator.geolocation.getCurrentPosition(b,a)
}};
Legato.Util.Logger={instance:null,getLogger:function(){if(Legato.Util.Logger.instance===null){Legato.Util.Logger.instance=Legato.Util.Logger.createLogger()
}return Legato.Util.Logger.instance
},createLogger:function(){var a=null;
if(window.logger&&Legato.Lang.ObjectUtils.isFunction(window.logger.trace)&&Legato.Lang.ObjectUtils.isFunction(window.logger.debug)&&Legato.Lang.ObjectUtils.isFunction(window.logger.info)&&Legato.Lang.ObjectUtils.isFunction(window.logger.warn)&&Legato.Lang.ObjectUtils.isFunction(window.logger.error)&&Legato.Lang.ObjectUtils.isFunction(window.logger.fatal)){a=window.logger;
return a
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(window.log4javascript)&&Legato.Lang.ObjectUtils.isObject(window.log4javascript)){a=window.log4javascript.getLogger();
var b=new log4javascript.PopUpAppender();
b.setFocusPopUp(true);
b.setNewestMessageAtTop(true);
a.addAppender(b);
return a
}if(Legato.Lang.ObjectUtils.isObject(window.console)&&Legato.Lang.ObjectUtils.isFunction(window.console.trace)&&Legato.Lang.ObjectUtils.isFunction(window.console.debug)&&Legato.Lang.ObjectUtils.isFunction(window.console.info)&&Legato.Lang.ObjectUtils.isFunction(window.console.warn)&&Legato.Lang.ObjectUtils.isFunction(window.console.error)){a=window.console;
if(!Legato.Lang.ObjectUtils.isFunction(window.console.fatal)){a.fatal=a.error
}return a
}a={};
a.trace=function(c){};
a.debug=function(c){};
a.info=function(c){};
a.warn=function(c){};
a.error=function(c){};
a.fatal=function(c){alert(c)
};
return a
}};
Legato.Util.Browser={isTouchCapable:function(){return"ontouchstart" in document&&"ontouchend" in document
}};
Legato.Graph.DirectedGraph=Legato.Lang.Class({vertices:null,initialize:function(){this.vertices={}
},getVertex:function(a){Legato.Util.Ensure.ensureString(a);
var b=this.vertices[a];
if(Legato.Lang.ObjectUtils.exists(b)){return b
}else{return null
}},getOrCreateVertex:function(a){Legato.Util.Ensure.ensureString(a);
var b=this.vertices[a];
if(!b){b=new Legato.Graph.Vertex(a);
this.vertices[a]=b
}return b
},addEdge:function(d,b){Legato.Util.Ensure.ensureString(d);
Legato.Util.Ensure.ensureString(b);
var a=this.getOrCreateVertex(d);
var c=this.getOrCreateVertex(b);
a.outgoing.add(b);
c.incoming.add(d)
},removeEdge:function(d,b){Legato.Util.Ensure.ensureString(d);
Legato.Util.Ensure.ensureString(b);
var a=this.getVertex(d);
if(a){a.outgoing.remove(b)
}var c=this.getVertex(b);
if(c){c.incoming.remove(d)
}},clone:function(){var b=new Legato.Graph.DirectedGraph();
for(var a in this.vertices){if(this.vertices.hasOwnProperty(a)){b.vertices[a]=this.vertices[a].clone()
}}return b
},toArray:function(){var j=this.clone();
var f=[];
var k=[];
for(var i in j.vertices){if(j.vertices.hasOwnProperty(i)){var d=j.vertices[i];
if(!d.hasIncomingEdges()){k.push(i)
}}}while(k.length>0){var a=k.shift();
var g=j.getVertex(a);
f.push(a);
var h=g.outgoing.toArray();
for(var e=0;
e<h.length;
e++){var b=h[e];
var c=j.getVertex(b);
j.removeEdge(a,b);
if(!c.hasIncomingEdges()){k.push(b)
}}}return f
}});
Legato.Graph.Vertex=Legato.Lang.Class({name:null,incoming:null,outgoing:null,initialize:function(a){Legato.Util.Ensure.ensureString(a);
this.name=a;
this.incoming=new Legato.Util.HashSet();
this.outgoing=new Legato.Util.HashSet()
},hasIncomingEdges:function(){return !this.incoming.isEmpty()
},clone:function(){var a=new Legato.Graph.Vertex(this.name);
a.incoming.addAll(this.incoming);
a.outgoing.addAll(this.outgoing);
return a
}});
Legato.XML.QName=Legato.Lang.Class({namespaceURI:null,localPart:null,prefix:null,initialize:function(d,c,e){var b;
var a;
var f;
if(typeof c=="undefined"){b="";
a=d;
f=""
}else{if(typeof e=="undefined"){b=d;
a=c;
f=""
}else{b=d;
a=c;
f=e
}}this.namespaceURI=b;
this.localPart=a;
this.prefix=f
},toString:function(){var a="";
if(this.namespaceURI!=""){a=a+"{"+this.namespaceURI+"}"
}if(this.prefix!=""){a=a+this.prefix+":"
}a=a+this.localPart;
return a
},clone:function(){return new Legato.XML.QName(this.namespaceURI,this.localPart,this.prefix)
},equals:function(a){if(!a){return false
}else{return(this.namespaceURI==a.namespaceURI)&&(this.localPart==a.localPart)
}},CLASS_NAME:"Legato.XML.QName"});
Legato.XML.QName.valueOf=function(h){var f=h.indexOf("{");
var d=h.lastIndexOf("}");
var c;
var e;
if((f===0)&&(d>0)&&(d<h.length)){c=h.substring(1,d);
e=h.substring(d+1)
}else{c="";
e=h
}var b=e.indexOf(":");
var g;
var a;
if(b>0&&b<e.length){g=e.substring(0,b);
a=e.substring(b+1)
}else{g="";
a=e
}return new Legato.XML.QName(c,a,g)
};
Legato.XML.ElementUtils={hide:function(a){a.style.display="none"
},show:function(a){a.style.display=""
},getAttributeNodeNS:function(c,b,a){var j=null;
if(c.getAttributeNodeNS){j=c.getAttributeNodeNS(b,a)
}else{var e=c.attributes;
var h,d;
for(var f=0,g=e.length;
f<g;
++f){h=e[f];
if(h.namespaceURI==b){d=(h.prefix)?(h.prefix+":"+a):a;
if(d==h.nodeName){j=h;
break
}}}}return j
},getAttributeNS:function(e,d,a){var b="";
if(e.getAttributeNS){b=e.getAttributeNS(d,a)||""
}else{var c=this.getAttributeNodeNS(e,d,a);
if(c){b=c.nodeValue
}}return b
},hasAttributeNS:function(c,b,a){var d=false;
if(c.hasAttributeNS){d=c.hasAttributeNS(b,a)
}else{d=!!this.getAttributeNodeNS(c,b,a)
}return d
},setAttributeNS:function(d,c,a,e){if(d.setAttributeNS){d.setAttributeNS(c,a,e)
}else{if(this.xmldom){if(c){var b=d.ownerDocument.createNode(2,a,c);
b.nodeValue=e;
d.setAttributeNode(b)
}else{d.setAttribute(a,e)
}}else{throw"setAttributeNS not implemented"
}}}};
Legato.Beans={};
Legato.Beans.NAMESPACE_URI="http://www.disy.net/legato/beans";
Legato.Beans.PREFIX="lb";
Legato.Beans.QName=function(a){return new Legato.XML.QName(Legato.Beans.NAMESPACE_URI,a,Legato.Beans.PREFIX)
};
Legato.Beans.Property=Legato.Lang.Class({type:null,setter:null,getter:null,initialize:function(b,c,a){Legato.Util.Ensure.ensureObject(b);
this.type=b;
if(Legato.Lang.ObjectUtils.exists(c)){Legato.Util.Ensure.ensureFunction(c);
this.setter=c
}else{this.setter=null
}if(Legato.Lang.ObjectUtils.exists(a)){Legato.Util.Ensure.ensureFunction(a);
this.getter=a
}else{this.getter=null
}},set:function(a,b){Legato.Util.Ensure.ensureExists(a);
if(Legato.Lang.ObjectUtils.exists(this.setter)){this.setter(a,b)
}else{throw new Legato.Lang.Exception("Could not set the value, setter function is not provided.")
}},get:function(a){Legato.Util.Ensure.ensureExists(a);
if(Legato.Lang.ObjectUtils.exists(this.getter)){this.getter(a)
}else{throw new Legato.Lang.Exception("Could not set the value, setter function is not provided.")
}}});
Legato.Beans.BeanDefinition=Legato.Lang.Class({type:null,definition:null,initialize:function(b,a){Legato.Util.Ensure.ensureObject(b);
this.type=b;
if(Legato.Lang.ObjectUtils.exists(a)){this.definition=a
}else{this.definition={}
}}});
Legato.Beans.ComplexType=Legato.Lang.Class(Legato.Lang.AnyType,{typeName:null,qName:null,_constructor:null,factoryFunction:null,constructorArguments:null,constructorOrder:null,options:null,fields:null,properties:null,components:null,afterInstancePopulated:null,initialize:function(b,f,e){if(typeof b!="string"){throw new Error("Name ["+b+"] must be string.")
}if(!(f instanceof Legato.XML.QName)){throw new Error("Qualified name ["+f.toString()+"] must be an instance of [Legato.XML.QName].")
}if(typeof e!="object"){throw new Error("Definition ["+e+"] must be an object.")
}this.typeName=b;
this.qName=f;
this._constructor=e._constructor;
this.factoryFunction=e.factoryFunction;
this.constructorArguments=e.constructorArguments;
this.constructorOrder=(e.constructorOrder)?e.constructorOrder:[];
this.options=(e.options)?e.options:null;
this.fields=e.fields;
this.properties=e.properties;
this.afterInstancePopulated=e.afterInstancePopulated;
this.components={};
for(var d in this.constructorArguments){if(this.constructorArguments.hasOwnProperty(d)){this.components[d]=this.constructorArguments[d]
}}for(var c in this.options){if(this.options.hasOwnProperty(c)){this.components[c]=this.options[c]
}}for(var g in this.fields){if(this.fields.hasOwnProperty(g)){this.components[g]=this.fields[g]
}}for(var a in this.properties){if(this.properties.hasOwnProperty(a)){this.components[a]=this.properties[a].type
}}Legato.Beans.ComplexType.registerTypeNS(this,this.qName.namespaceURI,this.qName.localPart)
},Extend:function(b,f,h){var c=this;
var d={};
if(h._constructor){d._constructor=h._constructor
}else{if(h.factoryFunction){d.factoryFunction=h.factoryFunction
}else{if(c._constructor){d._constructor=c._constructor
}else{if(c.factoryFunction){d.factoryFunction=c.factoryFunction
}}}}if(h.constructorArguments){d.constructorArguments=h.constructorArguments
}else{d.constructorArguments={};
for(var i in c.constructorArguments){if(c.constructorArguments.hasOwnProperty(i)){d.constructorArguments[i]=c.constructorArguments[i]
}}}if(h.constructorOrder){d.constructorOrder=h.constructorOrder
}else{d.constructorOrder=[];
for(var e=0;
e<c.constructorOrder.length;
e++){d.constructorOrder[e]=c.constructorOrder[e]
}}if(h.afterInstancePopulated){d.afterInstancePopulated=h.afterInstancePopulated
}else{if(c.afterInstancePopulated){d.afterInstancePopulated=c.afterInstancePopulated
}else{d.afterInstancePopulated=null
}}var a=function(k,l){for(var j in k){if(k.hasOwnProperty(j)){l[j]=k[j]
}}};
var g=function(k,l,j){if(k){a(k,j)
}if(l){a(l,j)
}};
if(c.options||h.options){d.options={};
g(c.options,h.options,d.options)
}else{d.options=null
}d.fields={};
g(c.fields,h.fields,d.fields);
d.properties={};
g(c.properties,h.properties,d.properties);
return new Legato.Beans.ComplexType(b,f,d)
},Components:function(){return new Legato.Beans.ComplexType.Components(this)
},define:function(a){return new Legato.Beans.BeanDefinition(this,a)
}});
Legato.Beans.ComplexType.Components=Legato.Lang.Class(Legato.Beans.ComplexType,{initialize:function(d){var b=d.typeName+".Components";
var e=new Legato.XML.QName(d.qName.namespaceURI,d.qName.localPart+"-Components",d.qName.prefix);
var c={_constructor:Object,constructorArguments:{},constructorOrder:[],fields:{},properties:{}};
for(var a in d.components){if(d.components.hasOwnProperty(a)){c.fields[a]=d.components[a]
}}Legato.Beans.ComplexType.prototype.initialize.apply(this,[b,e,c])
}});
Legato.Beans.ComplexType.types={};
Legato.Beans.ComplexType.registerTypeNS=function(c,b,a){var d=(b==""?"":"{"+b+"}")+a;
Legato.Beans.ComplexType.types[d]=c
};
Legato.Beans.ComplexType.getTypeNS=function(b,a){var c=(b==""?"":"{"+b+"}")+a;
return Legato.Beans.ComplexType.types[c]
};
Legato.Beans.Object=new Legato.Beans.ComplexType("Legato.Lang.Object",Legato.Beans.QName("Object"),{_constructor:Object,constructorArguments:{},constructorOrder:[],fields:{},properties:{}});
Legato.Beans["Object[]"]=Legato.Beans.Object.List();
Legato.Beans["Object{}"]=Legato.Beans.Object.Map();
Legato.Beans.BeanFactory=Legato.Lang.Class({beanDefinitions:null,beanNames:null,converters:{},instances:null,unloadDestroy:null,initialize:function(c,b,a){this.instances=this.createDefaultInstances();
if(Legato.Lang.ObjectUtils.exists(b)){Legato.Util.Ensure.ensureFunction(b)
}if(Legato.Lang.ObjectUtils.exists(c)){this.loadBeanDefinitions(c)
}this.unloadDestroy=OpenLayers.Function.bind(this.destroy,this);
OpenLayers.Event.observe(window,"unload",this.unloadDestroy)
},createDefaultInstances:function(){var a={};
return a
},loadBeanDefinitions:function(h,f,c){Legato.Util.Ensure.ensureObject(h);
var e;
if(Legato.Lang.ObjectUtils.exists(f)){Legato.Util.Ensure.ensureFunction(f);
e=f
}else{e=function(){}
}var b;
if(Legato.Lang.ObjectUtils.exists(c)){Legato.Util.Ensure.ensureFunction(c);
b=c
}else{b=function(){}
}this.setBeanDefinitions(h);
var g=this.beanNames;
var a=this.beanDefinitions;
var d=this;
this.createInstances(g,a,function(i){d.populateInstances();
d.afterInstancesPopulated();
e(d)
},function(i){Legato.Util.Logger.getLogger().fatal("Error creating bean instances.");
if(!b(i)){throw i
}})
},retrieveBean:function(b){var a=this.createInstance(b);
this.populateInstance(b,a);
this.afterInstancePopulated(b,a);
return a
},retrieveBeans:function(c){Legato.Util.Ensure.ensureObject(c);
var a={};
for(var b in c){if(c.hasOwnProperty(b)){a[b]=this.retrieveBean(c[b])
}}return a
},setBeanDefinitions:function(a){this.beanDefinitions=this.explodeBeanDefinitions(a);
this.beanNames=this.getBeanNames(this.beanDefinitions)
},explodeBeanDefinitions:function(a){var c={};
for(var b in a){if(a.hasOwnProperty(b)){this.explodeBeanDefinition(c,b,a[b])
}}return c
},explodeBeanDefinition:function(e,n,i){e[n]=i;
var j=i.type;
var c=i.definition;
for(var a in c){if(c.hasOwnProperty(a)){var k=c[a];
if(this.isBeanDefinition(k)){var h=n+"."+a;
e[h]=k;
c[a]=new Legato.Beans.Reference(h);
this.explodeBeanDefinition(e,h,k)
}else{if(Legato.Lang.ObjectUtils.isArray(k)){for(var g=0;
g<k.length;
g++){var m=k[g];
if(this.isBeanDefinition(m)){var l=n+"."+a+"["+g+"]";
e[l]=m;
k[g]=new Legato.Beans.Reference(l);
this.explodeBeanDefinition(e,l,m)
}}}else{if(Legato.Lang.ObjectUtils.isObject(k)){for(var f in k){if(k.hasOwnProperty(f)){var d=k[f];
if(this.isBeanDefinition(d)){var b=n+"."+a+"['"+f+"']";
e[b]=d;
k[f]=new Legato.Beans.Reference(b);
this.explodeBeanDefinition(e,b,d)
}}}}}}}}},getBeanNames:function(e){var k=new Legato.Graph.DirectedGraph();
var d=function(q,o,p){if(p instanceof Legato.Beans.Reference){q.addEdge(p.target,o)
}else{if(Legato.Lang.ObjectUtils.isArray(p)){for(var n=0;
n<p.length;
n++){d(q,o,p[n])
}}else{if(Legato.Lang.ObjectUtils.isObject(p)){for(var m in p){if(p.hasOwnProperty(m)){d(q,o,p[m])
}}}}}};
for(var b in e){if(e.hasOwnProperty(b)){var f=k.getOrCreateVertex(b);
var h=e[b];
var j=h.type;
var c=h.definition;
var i=Legato.Lang.ObjectUtils.exists(j.constructorOrder)?j.constructorOrder:[];
for(var g=0;
g<i.length;
g++){d(k,b,c[i[g]])
}var l=Legato.Lang.ObjectUtils.exists(j.options)?j.options:{};
for(var a in l){if(l.hasOwnProperty(a)){d(k,b,c[a])
}}}}return k.toArray()
},createInstances:function(g,f,e,d){Legato.Util.Ensure.ensureFunction(e);
Legato.Util.Ensure.ensureFunction(d);
for(var c=0;
c<this.beanNames.length;
c++){var b=g[c];
var a=f[b];
this.putBean(b,this.createInstance(a))
}e(this.instances)
},createInstance:function(p){var l=p.type;
var g=p.definition;
var f=l.constructorArguments;
var m=l.constructorOrder;
var b=[];
for(var i=0;
i<m.length;
i++){var q=m[i];
var h=f[q];
var e=this.convert(h,g[q]);
b[i]=e
}if(l.options){var c=null;
for(var a in l.options){if(Legato.Lang.ObjectUtils.exists(g[a])){var k=l.options[a];
var j=this.convert(k,g[a]);
if(c===null){c={}
}c[a]=j
}}if(c!==null){b.push(c)
}}var o;
if(l._constructor){o={};
for(var d in l._constructor.prototype){o[d]=l._constructor.prototype[d]
}l._constructor.apply(o,b)
}else{if(l.factoryFunction){o=l.factoryFunction.apply(null,b)
}else{throw new Error("Could not create an instance of type ["+l+"].")
}}if(Legato.Lang.ObjectUtils.isFunction(o.setBeanFactory)){o.setBeanFactory(this)
}return o
},populateInstances:function(){var e=this.beanNames;
for(var d=0;
d<e.length;
d++){var c=e[d];
var b=this.beanDefinitions[c];
var a=this.instances[c];
this.populateInstance(b,a)
}},populateInstance:function(b,a){this.setFields(b,a);
this.setProperties(b,a)
},setFields:function(d,b){var f=d.type;
var a=f.fields;
for(var h in a){if(a.hasOwnProperty(h)){var c=a[h];
var g=d.definition[h];
if(g){var e=this.convert(c,g);
b[h]=e
}}}},setProperties:function(h,i){var f=h.type;
var e=f.properties;
for(var d in e){if(e.hasOwnProperty(d)){var g=e[d];
var b=g.type;
var c=h.definition[d];
if(c){var a=this.convert(b,c);
g.set(i,a)
}}}},afterInstancesPopulated:function(){var e=this.beanNames;
for(var d=0;
d<e.length;
d++){var c=e[d];
var b=this.beanDefinitions[c];
var a=this.instances[c];
this.afterInstancePopulated(b,a)
}},afterInstancePopulated:function(b,a){var c=b.type;
if(c.afterInstancePopulated){c.afterInstancePopulated(a,this)
}if(a.afterInstancePopulated){a.afterInstancePopulated(this)
}},convert:function(g,j){if((typeof j)=="undefined"){return undefined
}else{if(j===null){return null
}else{if(this.isBeanDefinition(j)){return this.retrieveBean(j)
}else{if((typeof j)=="function"){return j(this)
}else{if(j instanceof Legato.Beans.Reference){return this.getBean(j.target)
}else{if(((typeof j)=="object")&&Legato.Lang.ObjectUtils.isFunction(j.getInstance)){return j.getInstance(this)
}else{if((typeof j)=="string"){if(g.isInstance(j)){return j
}else{if(this.converters[g.typeName]){var b=this.converters[g.typeName];
return b.convert(j)
}else{if(g.fromString){return g.fromString(j,this)
}else{return j
}}}}else{if(((typeof j)=="object")&&(g.isList||g.isMap)){var f=g.elementType;
if(g.isList){var c=[];
if(Legato.Lang.ObjectUtils.isArray(j)){for(var i=0;
i<j.length;
i++){c[i]=this.convert(f,j[i])
}}else{var k=0;
for(var h in j){if(j.hasOwnProperty(h)){c[k]=this.convert(f,j[h]);
k++
}}}return c
}else{var a={};
if(Legato.Lang.ObjectUtils.isArray(j)){for(var d=0;
d<j.length;
d++){a[d]=this.convert(f,j[d])
}}else{for(var e in j){if(j.hasOwnProperty(e)){a[e]=this.convert(f,j[e])
}}}return a
}}else{if(g.isInstance&&g.isInstance(j)){return j
}else{throw new Error("Conversion of ["+j+"] to ["+g.typeName+"] is not implemented.")
}}}}}}}}}},getBean:function(d){Legato.Util.Ensure.ensureNotEmptyString(d);
if(d.charAt(0)=="&"){var c=d.substring(1);
var b=this.instances[c];
if(Legato.Lang.ObjectUtils.exists(b)){return b
}else{throw new Legato.Lang.Exception("Bean ["+c+"] could not be found.")
}}else{var a=this.instances[d];
if(!Legato.Lang.ObjectUtils.exists(a)){throw new Legato.Lang.Exception("Bean ["+d+"] could not be found.")
}else{if(Legato.Lang.ObjectUtils.isFunction(a.getInstance)){return a.getInstance(this)
}else{return a
}}}},putBean:function(b,a){Legato.Util.Ensure.ensureString(b);
Legato.Util.Ensure.ensureExists(a);
this.instances[b]=a
},destroy:function(){if(!this.unloadDestroy){return false
}OpenLayers.Event.stopObserving(window,"unload",this.unloadDestroy);
this.unloadDestroy=null;
for(var b in this.instances){if(this.instances.hasOwnProperty(b)){var a=this.instances[b];
a=null
}}this.instances=null;
for(var d in this.beanDefinitions){if(this.beanDefinitions.hasOwnProperty(d)){var c=this.beanDefinitions[d];
if(Legato.Lang.ObjectUtils.isFunction(c.destroy)){c.destroy()
}c=null
}}this.beanDefinitions=null;
this.beanNames=null
},isBeanDefinition:function(a){return Legato.Lang.ObjectUtils.isObject(a)&&Legato.Lang.ObjectUtils.exists(a.type)&&Legato.Lang.ObjectUtils.isObject(a.definition)
},CLASS_NAME:"Legato.Beans.XMLBeanFactory"});
Legato.Beans.XMLBeanFactory=Legato.Lang.Class(Legato.Beans.BeanFactory,{options:null,initialize:function(){Legato.Beans.BeanFactory.prototype.initialize.apply(this,arguments);
this.options={}
},loadURL:function(c){Legato.Util.Ensure.ensureObject(c,"Options argument must be an object.");
Legato.Util.Ensure.ensureString(c.url,"Options must contain [url] string element.");
Legato.Util.Ensure.ensureFunction(c.onSuccess,"Options must contain [onSuccess] function element.");
if(Legato.Lang.ObjectUtils.exists(c.onFailure)){Legato.Util.Ensure.ensureFunction(c.onFailure,"Options element [onFailure] must be a function.")
}Legato.Util.extend(this.options,c);
var g=function(j){try{var m=j.responseText;
var o=new OpenLayers.Format.XML();
var p=o.read(m);
var n=p.documentElement;
var h=this.parse(n);
var k=this;
var i=function(){k.options.onSuccess(j)
};
this.loadBeanDefinitions(h,i)
}catch(l){Legato.Util.Logger.getLogger().fatal("Could not parse the resource ["+this.options.url+"].");
Legato.Util.Logger.getLogger().fatal(l);
throw l
}};
var d=function(h){if(typeof this.options.onFailure=="function"){this.options.onFailure(h);
return
}Legato.Util.Logger.getLogger().fatal("Could not load the resource ["+this.options.url+"].");
throw new Legato.Lang.Exception("Could not load the resource ["+this.options.url+"].")
};
var b;
var f;
var a=this.options.url.indexOf("?");
if(a>0){b=this.options.url.substring(0,a);
f=OpenLayers.Util.getParameters(this.options.url)
}else{b=this.options.url;
f=null
}var e=this;
OpenLayers.Request.GET({url:b,params:f,scope:e,success:g,failure:d})
},retrieveBeansFromElement:function(a){var b=this.parse(a);
return this.retrieveBeans(b)
},retrieveBeanFromElement:function(b,c){var a=this.parseBeanDefinition(b,c);
return this.retrieveBean(a)
},parse:function(h){var b=h.childNodes;
var k={};
for(var g=0;
g<b.length;
g++){var a=b[g];
if(a.nodeType==1){var e=a;
var c=e.namespaceURI;
var d=e.localName||e.nodeName.split(":").pop();
var j=Legato.XML.ElementUtils.getAttributeNS(e,Legato.Beans.NAMESPACE_URI,"name");
var i=(j===null||j==""?d:j);
var f=this.parseElement(e);
k[i]=f
}}return k
},parseElement:function(a){if(Legato.Lang.StringUtils.isEmpty(a.namespaceURI)){return this.parseSingleComponent(a,Legato.Lang.String)
}else{var b=this.getType(a);
return this.parseBeanDefinition(a,b)
}},parseBeanDefinition:function(h,l){var d={};
for(var b in l.components){if(l.components.hasOwnProperty(b)){var f=h.getAttribute(b);
if(!(f===null||f=="")){d[b]=f
}}}var c=h.childNodes;
for(var j=0;
j<c.length;
j++){var a=c[j];
if(a.nodeType==1){var g=a.localName||a.nodeName.split(":").pop();
if(l.components[g]){var k=g;
var e=l.components[k];
d[k]=this.parseComponent(a,e)
}}}var i=l.define(d);
return i
},parseComponent:function(b,a){if(a.isList){return this.parseListComponent(b,a)
}else{if(a.isMap){return this.parseMapComponent(b,a)
}else{return this.parseSingleComponent(b,a)
}}},parseListComponent:function(f,c){var g=[];
var e=f.childNodes;
for(var b=0;
b<e.length;
b++){var d=e[b];
if(d.nodeType==1){var a=this.parseElement(d);
g.push(a)
}}return g
},parseMapComponent:function(k,g){var c={};
var j=k.attributes;
for(var b=0;
b<j.length;
b++){var e=j[b];
if(e.namespaceURI===null||e.namespaceURI==""){var m=e.nodeName;
var h=e.nodeValue;
c[m]=h
}}var d=k.childNodes;
for(var f=0;
f<d.length;
f++){var a=d[f];
if(a.nodeType==1&&(a.namespaceURI===null||a.namespaceURI=="")){var i=a.nodeName;
var o=Legato.XML.ElementUtils.getAttributeNS(a,Legato.Beans.NAMESPACE_URI,"name");
var n=(o===null||o==""?i:o);
var l=this.parseSingleComponent(a,g.elementType);
c[n]=l
}}return c
},parseSingleComponent:function(e,b){var d=e.childNodes;
for(var a=0;
a<d.length;
a++){var c=d[a];
if(c.nodeType==1){return this.parseElement(c)
}else{if(c.nodeType==3&&(OpenLayers.String.trim(c.nodeValue)!="")){return c.nodeValue
}}}return null
},getType:function(c){var b=c.namespaceURI;
var a=c.localName||c.nodeName.split(":").pop();
var d=Legato.Beans.ComplexType.getTypeNS(b,a);
Legato.Util.Ensure.ensureExists(d,"Could not load the type for the element [{"+b+"}:"+a+"].");
return d
},CLASS_NAME:"Legato.Beans.XMLBeanFactory"});
Legato.Beans.Reference=Legato.Lang.Class({target:null,initialize:function(a){Legato.Util.Ensure.ensureString(a);
this.target=a
},getInstance:function(b){Legato.Util.Ensure.ensureObject(b);
var a=b.getBean(this.target);
return b.getBean(this.target)
},Field:function(a){Legato.Util.Ensure.ensureString(a);
return new Legato.Beans.Reference.Field(this,a)
},CLASS_NAME:"Legato.Beans.Reference"});
Legato.Beans.Reference.Field=Legato.Lang.Class({reference:null,field:null,initialize:function(a,b){Legato.Util.Ensure.ensureImplements(a,"getInstance");
this.reference=a;
Legato.Util.Ensure.ensureString(b);
this.field=b
},getInstance:function(b){var a=this.reference.getInstance(b);
return a[this.field]
}});
Legato.Beans.Ref=function(a){return new Legato.Beans.Reference(a)
};
$ref=Legato.Beans.Ref;
Legato.Beans.Reference.Bean=Legato.Beans.Object.Extend("Legato.Beans.Reference",Legato.Beans.QName("Reference"),{_constructor:Legato.Beans.Reference,constructorArguments:{target:Legato.Lang.String},constructorOrder:["target"]});
Legato.Beans.Evaluate=Legato.Lang.Class({expression:null,initialize:function(a){Legato.Util.Ensure.ensureString(a);
this.expression=a
},getInstance:function(beanFactory){return eval(this.expression)
}});
Legato.Beans.Evaluate.Bean=Legato.Beans.Object.Extend("Legato.Beans.Evaluate",Legato.Beans.QName("Evaluate"),{_constructor:Legato.Beans.Evaluate,constructorArguments:{expression:Legato.Lang.String},constructorOrder:["expression"]});
Legato.Beans.Field=Legato.Lang.Class({target:null,name:null,initialize:function(b,a){Legato.Util.Ensure.ensureObject(b);
this.target=b;
Legato.Util.Ensure.ensureString(a);
this.name=a
},getInstance:function(a){return this.target[this.name]
}});
Legato.Beans.Field.Bean=Legato.Beans.Object.Extend("Legato.Beans.Field",Legato.Beans.QName("Field"),{_constructor:Legato.Beans.Field,constructorArguments:{target:Legato.Beans.Object,name:Legato.Lang.String},constructorOrder:["target","name"]});
Legato.Predicate={};
Legato.Predicate.NAMESPACE_URI="http://www.disy.net/legato/predicate";
Legato.Predicate.PREFIX="lp";
Legato.Predicate.QName=function(a){return new Legato.XML.QName(Legato.Predicate.NAMESPACE_URI,a,Legato.Predicate.PREFIX)
};
Legato.Predicate.Bean=Legato.Beans.Object.Extend("Legato.Predicate",Legato.Predicate.QName("Bean"),{_constructor:Legato.Predicate});
Legato.Predicate.And=OpenLayers.Class({predicates:null,initialize:function(b){Legato.Util.Ensure.ensureArray(b,"Predicates must be an array.");
for(var a=0;
a<b.length;
a++){Legato.Util.Ensure.ensureObject(b[a],"Predicate must be an object.");
Legato.Util.Ensure.ensureFunction(b[a].evaluate,"Predicate must provide an [evaluate] function.")
}this.predicates=b
},destroy:function(){this.predicates=null
},evaluate:function(c){for(var b=0;
b<this.predicates.length;
b++){var a=this.predicates[b];
if(!a.evaluate(c)){return false
}}return true
},CLASS_NAME:"Legato.Predicate.And"});
Legato.Predicate.And.Bean=Legato.Predicate.Bean.Extend("Legato.Predicate.And",Legato.Predicate.QName("And"),{_constructor:Legato.Predicate.And,constructorArguments:{predicates:Legato.Beans["Object[]"]},constructorOrder:["predicates"]});
Legato.Predicate.Contains=OpenLayers.Class({value:null,initialize:function(a){Legato.Util.Ensure.ensureString(a,"Value must be a string.");
this.value=a
},destroy:function(){this.value=null
},evaluate:function(b){if(Legato.Lang.ObjectUtils.isString(b)){var c=b.split(" ");
for(var a=0;
a<c.length;
a++){if(c[a]===this.value){return true
}}}return false
},CLASS_NAME:"Legato.Predicate.Contains"});
Legato.Predicate.Contains.Bean=Legato.Predicate.Bean.Extend("Legato.Predicate.Contains",Legato.Predicate.QName("Contains"),{_constructor:Legato.Predicate.Contains,constructorArguments:{value:Legato.Lang.String},constructorOrder:["value"]});
Legato.Predicate.Equals=OpenLayers.Class({value:null,initialize:function(a){Legato.Util.Ensure.ensureString(a,"Value must be a string.");
this.value=a
},destroy:function(){this.value=null
},evaluate:function(a){return a===this.value
},CLASS_NAME:"Legato.Predicate.Equals"});
Legato.Predicate.Equals.Bean=Legato.Predicate.Bean.Extend("Legato.Predicate.Equals",Legato.Predicate.QName("Equals"),{_constructor:Legato.Predicate.Equals,constructorArguments:{value:Legato.Lang.String},constructorOrder:["value"]});
Legato.Predicate.False=OpenLayers.Class({initialize:function(){},destory:function(){},evaluate:function(a){return false
},CLASS_NAME:"Legato.Predicate.False"});
Legato.Predicate.False.Bean=Legato.Predicate.Bean.Extend("Legato.Predicate.False",Legato.Predicate.QName("False"),{_constructor:Legato.Predicate.False});
Legato.Predicate.Or=OpenLayers.Class({predicates:null,initialize:function(b){Legato.Util.Ensure.ensureArray(b,"Predicates must be an array.");
for(var a=0;
a<b.length;
a++){Legato.Util.Ensure.ensureObject(b[a],"Predicate must be an object.");
Legato.Util.Ensure.ensureFunction(b[a].evaluate,"Predicate must provide an [evaluate] function.")
}this.predicates=b
},destroy:function(){this.predicates=null
},evaluate:function(c){if(this.predicates.length===0){return true
}else{for(var b=0;
b<this.predicates.length;
b++){var a=this.predicates[b];
if(a.evaluate(c)){return true
}}return false
}},CLASS_NAME:"Legato.Predicate.Or"});
Legato.Predicate.Or.Bean=Legato.Predicate.Bean.Extend("Legato.Predicate.Or",Legato.Predicate.QName("Or"),{_constructor:Legato.Predicate.Or,constructorArguments:{predicates:Legato.Beans["Object[]"]},constructorOrder:["predicates"]});
Legato.Predicate.True=OpenLayers.Class({initialize:function(){},destory:function(){},evaluate:function(a){return true
},CLASS_NAME:"Legato.Predicate.True"});
Legato.Predicate.True.Bean=Legato.Predicate.Bean.Extend("Legato.Predicate.True",Legato.Predicate.QName("True"),{_constructor:Legato.Predicate.True});
Legato.Lang.RGBColor.Bean=Legato.Beans.Object.Extend("Legato.Lang.RGBColor",Legato.Lang.QName("RGBColor"),{_constructor:Legato.Lang.RGBColor,constructorArguments:{},constructorOrder:[],fields:{r:Legato.Lang.Integer,g:Legato.Lang.Integer,b:Legato.Lang.Integer}});
Legato.Lang.Null.Bean=Legato.Beans.Object.Extend("Legato.Lang.Null",Legato.Lang.QName("Null"),{_constructor:Legato.Lang.Null});
Legato.Util.Tag.Bean=Legato.Beans.Object.Extend("Legato.Util.Tag",Legato.Util.QName("Tag"),{_constructor:Legato.Util.Tag,constructorArguments:{name:Legato.Lang.String,value:Legato.Lang.String},constructorOrder:["name","value"]});
Legato.Text={};
Legato.Text.NAMESPACE_URI="http://www.disy.net/legato/text";
Legato.Text.PREFIX="lt";
Legato.Text.QName=function(a){return new Legato.XML.QName(Legato.Text.NAMESPACE_URI,a,Legato.Text.PREFIX)
};
Legato.Text.Format=OpenLayers.Class({initialize:function(a){},format:function(a){return a.toString()
},parse:function(a){return a
},destroy:function(){},CLASS_NAME:"Legato.Text.Format"});
Legato.Text.DecimalFormat=OpenLayers.Class(Legato.Text.Format,{formatSymbols:{groupingSeparator:".",decimalSeparator:","},initialize:function(a){},format:function(g){var i=10;
var b=3;
var c=(g>0)?1:(g<0?-1:0);
var l=Math.abs(g)%1;
var d=Math.abs(g)-l;
var k=(c<0)?"-":"";
var j=b>0?Math.pow(10,b):10;
var a=b>0?this.formatSymbols.groupingSeparator:"";
var f=this.calculateIntegerPartAsString(d,j,a);
var e=10;
var h=this.calculateFranctionalPartAsString(l,e);
return k+f+h
},calculateIntegerPartAsString:function(f,c,d){var b=f;
var e=0;
var a=(b===0)?"0":"";
while(b>0){e=b%c;
b=(b-e)/c;
if(b===0){a=e.toString()+a
}else{a=d+(c+e).toString().substring(1)+a
}}return a
},calculateFranctionalPartAsString:function(e,g){var b=Math.round(e*Math.pow(10,g));
var f=0;
var d=true;
var a="";
for(var c=0;
c<g;
c++){f=b%10;
b=(b-f)/10;
d=d&&(f===0);
if(!d){a=f+a
}}return(a.length===0?"":this.formatSymbols.decimalSeparator)+a
},parse:function(b){var c=b.replace(/\./g,"");
var a=c.replace(/,/,".");
return Number(a)
},destroy:function(){},CLASS_NAME:"Legato.Text.DecimalFormat"});
Legato.Text.PrecisionScaleFormat=OpenLayers.Class(Legato.Text.Format,{precision:20,scale:10,numberFormat:null,initialize:function(a,c,b){if(Legato.Lang.ObjectUtils.exists(a)){this.precision=a
}if(Legato.Lang.ObjectUtils.exists(c)){this.scale=c
}if(Legato.Lang.ObjectUtils.exists(b)){OpenLayers.Util.extend(this,b)
}if(!Legato.Lang.ObjectUtils.exists(this.numberFormat)){this.numberFormat=new Legato.Text.DecimalFormat()
}},format:function(c){var b;
if(this.precision>0){var e=Math.floor(Math.log(c)/Math.log(10));
var d=(Math.pow(10,e)<c?e+1:e);
b=Math.round(c*Math.pow(10,this.precision-d))*Math.pow(10,d-this.precision)
}else{b=c
}var a;
if(this.scale>=0){a=Math.round(b*Math.pow(10,this.scale))*Math.pow(10,-this.scale)
}else{a=b
}return this.numberFormat.format(a)
},parse:function(a){return this.numberFormat.parse(a)
},destroy:function(){},CLASS_NAME:"Legato.Text.DecimalFormat"});
Legato.Text.PrecisionScaleFormat.Bean=Legato.Beans.Object.Extend("Legato.Text.PrecisionScaleFormat",Legato.Text.QName("PrecisionScaleFormat"),{_constructor:Legato.Text.PrecisionScaleFormat,options:{precision:Legato.Lang.Integer,scale:Legato.Lang.Integer,format:Legato.Beans.Object}});
Legato.OpenLayers={};
Legato.OpenLayers.NAMESPACE_URI="http://www.openlayers.org";
Legato.OpenLayers.PREFIX="ol";
Legato.OpenLayers.QName=function(a,b){return new Legato.XML.QName(Legato.OpenLayers.NAMESPACE_URI,a,Legato.OpenLayers.PREFIX)
};
OpenLayers.Bounds.Bean=Legato.Beans.Object.Extend("OpenLayers.Bounds",Legato.OpenLayers.QName("Bounds"),{factoryFunction:function(d,a,b,c){return new OpenLayers.Bounds(d,a,b,c)
},constructorArguments:{left:Legato.Lang.Number,bottom:Legato.Lang.Number,right:Legato.Lang.Number,top:Legato.Lang.Number},constructorOrder:["left","bottom","right","top"]});
OpenLayers.LonLat.Bean=Legato.Beans.Object.Extend("OpenLayers.Bounds",Legato.OpenLayers.QName("LonLat"),{_constructor:OpenLayers.LonLat,constructorArguments:{lon:Legato.Lang.Number,lat:Legato.Lang.Number},constructorOrder:["lon","lat"]});
OpenLayers.Projection.Bean=Legato.Beans.Object.Extend("OpenLayers.Projection",Legato.OpenLayers.QName("Projection"),{factoryFunction:function(a){return new OpenLayers.Projection(a)
},constructorArguments:{projCode:Legato.Lang.String},constructorOrder:["projCode"],fromString:function(a){return new OpenLayers.Projection(a)
}});
OpenLayers.Size.Bean=Legato.Beans.Object.Extend("OpenLayers.Size",Legato.OpenLayers.QName("Size"),{_constructor:OpenLayers.Size,constructorArguments:{w:Legato.Lang.Number,h:Legato.Lang.Number},constructorOrder:["w","h"]});
OpenLayers.Pixel.Bean=Legato.Beans.Object.Extend("OpenLayers.Pixel",Legato.OpenLayers.QName("Pixel"),{_constructor:OpenLayers.Pixel,constructorArguments:{x:Legato.Lang.Number,y:Legato.Lang.Number},constructorOrder:["x","y"]});
OpenLayers.Icon.Bean=Legato.Beans.Object.Extend("OpenLayers.Icon",Legato.OpenLayers.QName("Icon"),{_constructor:OpenLayers.Icon,constructorArguments:{url:Legato.Lang.String,size:OpenLayers.Size.Bean,offset:OpenLayers.Pixel.Bean,calculateOffset:Legato.Lang.Function},constructorOrder:["url","size","offset","calculateOffset"]});
OpenLayers.Layer.prototype.selected=false;
OpenLayers.Layer.prototype.queryable=false;
OpenLayers.Layer.prototype.isFeatureLayer=false;
Legato.OpenLayers.Layer={};
Legato.OpenLayers.Layer.NAMESPACE_URI="http://www.openlayers.org/layer";
Legato.OpenLayers.Layer.PREFIX="oll";
Legato.OpenLayers.Layer.QName=function(a){return new Legato.XML.QName(Legato.OpenLayers.Layer.NAMESPACE_URI,a,Legato.OpenLayers.Layer.PREFIX)
};
OpenLayers.Layer.Bean=Legato.Beans.Object.Extend("OpenLayers.Layer",Legato.OpenLayers.QName("Layer"),{_constructor:OpenLayers.Layer,constructorArguments:{name:Legato.Lang.String},constructorOrder:["name"],options:{id:Legato.Lang.String,layerId:Legato.Lang.String,title:Legato.Lang.String,opacity:Legato.Lang.Number,alwaysInRange:Legato.Lang.Boolean,isBaseLayer:Legato.Lang.Boolean,isFeatureLayer:Legato.Lang.Boolean,alpha:Legato.Lang.Boolean,displayInLayerSwitcher:Legato.Lang.Boolean,visibility:Legato.Lang.Boolean,attribution:Legato.Lang.String,gutter:Legato.Lang.Integer,projection:OpenLayers.Projection.Bean,units:Legato.Lang.String,resolutions:Legato.Lang["Double[]"],maxExtent:OpenLayers.Bounds.Bean,minExtent:OpenLayers.Bounds.Bean,maxResolution:Legato.Lang.Number,minResolution:Legato.Lang.Number,numZoomLevels:Legato.Lang.Integer,maxScale:Legato.Lang.Number,minScale:Legato.Lang.Number,maxScaleDenominator:Legato.Lang.Number,minScaleDenominator:Legato.Lang.Number,displayOutsideMaxExtent:Legato.Lang.Boolean,wrapDateLine:Legato.Lang.Boolean,transitionEffect:Legato.Lang.String,legend:Legato.Beans.Object,selected:Legato.Lang.Boolean,queryable:Legato.Lang.Boolean,attributes:Legato.Beans.Object.Map(),formatList:Legato.Lang["String[]"]}});
Legato.OpenLayers.Control={};
Legato.OpenLayers.Control.NAMESPACE_URI="http://www.openlayers.org/control";
Legato.OpenLayers.Control.PREFIX="olc";
Legato.OpenLayers.Control.QName=function(a){return new Legato.XML.QName(Legato.OpenLayers.Control.NAMESPACE_URI,a,Legato.OpenLayers.Control.PREFIX)
};
Legato.Lang["OpenLayers.Control.TYPE"]=Legato.Lang.Integer.Enum("OpenLayers.Control.TYPE",{TYPE_BUTTON:1,TYPE_TOGGLE:2,TYPE_TOOL:3});
OpenLayers.Control.Bean=Legato.Beans.Object.Extend("OpenLayers.Control",Legato.OpenLayers.QName("Control"),{_constructor:OpenLayers.Control,options:{id:Legato.Lang.String,div:Legato.Lang.Element,type:Legato.Lang["OpenLayers.Control.TYPE"],allowSelection:Legato.Lang.Boolean,displayClass:Legato.Lang.String,title:Legato.Lang.String}});
OpenLayers.Map.prototype.Z_INDEX_BASE.BaseLayer=100;
OpenLayers.Map.prototype.Z_INDEX_BASE.Overlay=200;
OpenLayers.Map.prototype.Z_INDEX_BASE.Feature=500;
OpenLayers.Map.prototype.Z_INDEX_BASE.Markers=800;
OpenLayers.Map.prototype.Z_INDEX_BASE.Popup=900;
OpenLayers.Map.prototype.Z_INDEX_BASE.Control=1000;
OpenLayers.Map.prototype.setLayerZIndex=function(b,a){if(Legato.Lang.ObjectUtils.isTrue(b.isMarkersLayer)){b.setZIndex(this.Z_INDEX_BASE.Markers+a)
}else{if(Legato.Lang.ObjectUtils.isTrue(b.isFeatureLayer)){b.setZIndex(this.Z_INDEX_BASE.Feature+a)
}else{if(Legato.Lang.ObjectUtils.isTrue(b.isBaseLayer)){b.setZIndex(this.Z_INDEX_BASE.BaseLayer+a*5)
}else{b.setZIndex(this.Z_INDEX_BASE.Overlay+a*5)
}}}};
Legato.OpenLayers.Map={};
OpenLayers.Map.Bean=Legato.Beans.Object.Extend("OpenLayers.Map",Legato.OpenLayers.QName("Map"),{factoryFunction:function(b,a){if(!Legato.Lang.ObjectUtils.exists(a)){a={}
}if(!Legato.Lang.ObjectUtils.exists(a.controls)){a.controls=[]
}if(!Legato.Lang.ObjectUtils.exists(a.theme)){a.theme=null
}return new OpenLayers.Map(b,a)
},constructorArguments:{id:Legato.Lang.String},constructorOrder:["id"],options:{projection:OpenLayers.Projection.Bean,displayProjection:OpenLayers.Projection.Bean,initialExtent:OpenLayers.Bounds,tags:Legato.Util.Tag.Bean.List(),center:OpenLayers.LonLat.Bean,fractionalZoom:Legato.Lang.Boolean,div:Legato.Lang.Element,dragging:Legato.Lang.Boolean,size:OpenLayers.Size.Bean,viewPortDiv:Legato.Lang.Element,layerContainerDiv:Legato.Lang.Element,resolution:Legato.Lang.Double,zoom:Legato.Lang.Integer,panRatio:Legato.Lang.Double,viewRequestID:Legato.Lang.String,tileSize:OpenLayers.Size.Bean,units:Legato.Lang.String,dpi:Legato.Lang.Integer,resolutions:Legato.Lang["Double[]"],maxResolution:Legato.Lang.Double,minResolution:Legato.Lang.Double,maxScale:Legato.Lang.Double,minScale:Legato.Lang.Double,minExtent:OpenLayers.Bounds.Bean,maxExtent:OpenLayers.Bounds.Bean,restrictedExtent:OpenLayers.Bounds.Bean,numZoomLevels:Legato.Lang.Integer,fallThrough:Legato.Lang.Boolean},properties:{layers:new Legato.Beans.Property(OpenLayers.Layer.Bean.List(),function(b,a){b.addLayers(a)
}),controls:new Legato.Beans.Property(OpenLayers.Control.Bean.List(),function(c,a){for(var b=0;
b<a.length;
b++){c.addControl(a[b])
}})},afterInstancePopulated:function(a){if(Legato.Lang.ObjectUtils.exists(a.initialExtent)){a.zoomToExtent(a.initialExtent,true)
}a.events.triggerEvent("legato.refresh",{})
}});
Legato.OpenLayers.Map.Util={};
Legato.OpenLayers.Map.Util.getOverlays=function(a){return Legato.Lang.CollectionUtils.filter(a,function(b){return(!b.isBaseLayer)
})
};
Legato.OpenLayers.Map.Util.getSelectedLayers=function(a){return Legato.Lang.CollectionUtils.filter(a,function(b){return(b.selected)
})
};
Legato.OpenLayers.Map.Util.getQueryableLayers=function(a){return Legato.Lang.CollectionUtils.filter(a,function(b){return(Legato.Lang.ObjectUtils.isBoolean(b.queryable)&&b.queryable)
})
};
Legato.OpenLayers.Map.Util.getSnappableLayers=function(a){return Legato.Lang.CollectionUtils.filter(a,function(b){return(Legato.Lang.ObjectUtils.isObject(b.options)&&Legato.Lang.ObjectUtils.isObject(b.options.attributes)&&Legato.Lang.ObjectUtils.isString(b.options.attributes.snappable)&&Boolean(b.options.attributes.snappable))
})
};
Legato.OpenLayers.Map.Util.getUnselectedLayers=function(a){return Legato.Lang.CollectionUtils.filter(a,function(b){return(!b.selected)
})
};
Legato.OpenLayers.Map.Util.getLayerById=function(c,a){var b=Legato.Lang.CollectionUtils.filter(c,function(d){return d.layerId===a
});
return(b.length>0)?b[0]:null
};
Legato.OpenLayers.Map.Util.isVectorLayer=function(a){return Legato.Lang.ObjectUtils.exists(a.CLASS_NAME)&&a.CLASS_NAME==="OpenLayers.Layer.Vector"
};
Legato.OpenLayers.Map.Util.isIgnoredLayer=function(a){return Legato.Lang.ObjectUtils.isBoolean(a.options.legatoIgnore)&&a.options.legatoIgnore
};
Legato.OpenLayers.Map.Util.isListedLayer=function(a){return !((Legato.Lang.ObjectUtils.isBoolean(a.options.legatoIgnore)&&a.options.legatoIgnore)||(Legato.Lang.ObjectUtils.isBoolean(a.displayInLayerSwitcher)&&!a.displayInLayerSwitcher))
};
Legato.OpenLayers.Map.Util.isListedBaseLayer=function(a){return a.isBaseLayer&&Legato.OpenLayers.Map.Util.isListedLayer(a)
};
Legato.OpenLayers.Map.Util.isListedOverlay=function(a){return !a.isBaseLayer&&Legato.OpenLayers.Map.Util.isListedLayer(a)
};
Legato.OpenLayers.Map.Util.getListedBaseLayers=function(a){return Legato.Lang.CollectionUtils.filter(a,Legato.OpenLayers.Map.Util.isListedBaseLayer)
};
Legato.OpenLayers.Map.Util.getListedOverlays=function(a){return Legato.Lang.CollectionUtils.filter(a,Legato.OpenLayers.Map.Util.isListedOverlay)
};
Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore=function(a){return Legato.Lang.CollectionUtils.filter(a,function(b){return !Legato.OpenLayers.Map.Util.isIgnoredLayer(b)
})
};
Legato.OpenLayers.Map.Util.getLayersLegatoIgnore=function(a){return Legato.Lang.CollectionUtils.filter(a,function(b){return Legato.OpenLayers.Map.Util.isIgnoredLayer(b)
})
};
Legato.OpenLayers.Map.Util.getBaseLayers=function(a){return Legato.Lang.CollectionUtils.filter(a,function(b){return(b.isBaseLayer)
})
};
Legato.OpenLayers.Map.Util.getVisibleLayers=function(a){return Legato.Lang.CollectionUtils.filter(a,function(b){if(!Legato.OpenLayers.Map.Util.isListedLayer(b)){return false
}return b.visibility
})
};
Legato.OpenLayers.Map.Util.getInvisibleLayers=function(a){return Legato.Lang.CollectionUtils.filter(a,function(b){if(!Legato.OpenLayers.Map.Util.isListedLayer(b)){return true
}return !b.visibility
})
};
Legato.OpenLayers.Map.Util.getInvisibleBaseLayers=function(a){return Legato.OpenLayers.Map.Util.getInvisibleLayers(Legato.OpenLayers.Map.Util.getBaseLayers(a))
};
Legato.OpenLayers.Map.Util.getVisibleBaseLayers=function(a){return Legato.OpenLayers.Map.Util.getVisibleLayers(Legato.OpenLayers.Map.Util.getBaseLayers(a))
};
Legato.OpenLayers.Map.Util.getInvisibleOverlays=function(a){return Legato.OpenLayers.Map.Util.getInvisibleLayers(Legato.OpenLayers.Map.Util.getOverlays(a))
};
Legato.OpenLayers.Map.Util.getVisibleOverlays=function(a){return Legato.OpenLayers.Map.Util.getVisibleLayers(Legato.OpenLayers.Map.Util.getOverlays(a))
};
Legato.OpenLayers.Map.Util.getLayerIds=function(b){var d=[];
for(var a=0;
a<b.length;
a++){var c=Legato.Lang.ObjectUtils.isNullOrUndefined(b[a].layerId)?b[a].name:b[a].layerId;
d.push(c)
}return d
};
Legato.OpenLayers.Map.Util.getBoxSelectionAsVector=function(d,a){Legato.Util.Ensure.ensureObject(d);
Legato.Util.Ensure.ensureObject(a);
var c=d.getLonLatFromPixel(new OpenLayers.Pixel(a.left,a.bottom));
var e=d.getLonLatFromPixel(new OpenLayers.Pixel(a.right,a.top));
var b=new OpenLayers.Bounds(c.lon,c.lat,e.lon,e.lat);
return new OpenLayers.Feature.Vector(b.toGeometry())
};
Legato.OpenLayers.Map.Util.getPointSelectionAsVector=function(d,b){Legato.Util.Ensure.ensureObject(d);
Legato.Util.Ensure.ensureObject(b);
var c=d.getLonLatFromPixel(b);
var a=new OpenLayers.Geometry.Point(c.lon,c.lat);
return new OpenLayers.Feature.Vector(a)
};
Legato.OpenLayers.Map.Util.isValidBBox=function(a){if(!Legato.Lang.ObjectUtils.isObject(a)){return false
}if(Legato.Lang.ObjectUtils.isNullOrUndefined(a.left)||Legato.Lang.ObjectUtils.isNullOrUndefined(a.right)||Legato.Lang.ObjectUtils.isNullOrUndefined(a.top)||Legato.Lang.ObjectUtils.isNullOrUndefined(a.bottom)){return false
}if(((a.top-a.bottom)<=0.000001)||((a.right-a.left)<=0.000001)){return false
}return true
};
Legato.OpenLayers.Map.Util.getDummyLayer=function(){return new OpenLayers.Layer.WMS("dummy","http://www2.demis.nl/wms/wms.asp?wms=WorldMap&",{layers:"Bathymetry",format:"image/png"})
};
Legato.OpenLayers.Map.Util.moveLayer=function(f){var c=f.layer;
var e=c.map;
var d=Legato.OpenLayers.Map.Util.getOverlays(e.layers);
var b=OpenLayers.Util.indexOf(d,c);
if(f.up){--b
}else{++b
}if(b<0||b>d.length-1){return
}OpenLayers.Util.removeItem(d,c);
d.splice(b,0,c);
for(var a=0;
a<d.length;
a++){e.removeLayer(d[a])
}e.addLayers(d)
};
Legato.OpenLayers.Map.Util.getViewPortPxFromLonLat=function(d,a,c){var b=null;
if(d!==null){b=new OpenLayers.Pixel((1/a*(d.lon-c.left)),(1/a*(c.top-d.lat)))
}return b
};
OpenLayers.Popup.prototype.getSafeContentSize=function(n){var f=n.clone();
var l=this.getContentDivPadding();
var g=this.getContentDivMargin();
var e=g.left+g.right;
var b=g.top+g.bottom;
var m=l.left+l.right;
var j=l.top+l.bottom;
this.fixPadding();
m+=this.padding.left+this.padding.right;
j+=this.padding.top+this.padding.bottom;
if(this.closeDiv){var d=parseInt(this.closeDiv.style.width,10);
m+=d+l.right
}if(this.minSize){f.w=Math.max(f.w,(this.minSize.w-m-e));
f.h=Math.max(f.h,(this.minSize.h-j-b))
}if(this.maxSize){f.w=Math.min(f.w,(this.maxSize.w-m-e));
f.h=Math.min(f.h,(this.maxSize.h-j-b))
}if(this.map&&this.map.size){var i=0,h=0;
if(this.keepInMap&&!this.panMapIfOutOfView){var k=this.map.getPixelFromLonLat(this.lonlat);
switch(this.relativePosition){case"tr":i=k.x;
h=this.map.size.h-k.y;
break;
case"tl":i=this.map.size.w-k.x;
h=this.map.size.h-k.y;
break;
case"bl":i=this.map.size.w-k.x;
h=k.y;
break;
case"br":i=k.x;
h=k.y;
break;
default:i=k.x;
h=this.map.size.h-k.y;
break
}}var a=this.map.size.h-this.map.paddingForPopups.top-this.map.paddingForPopups.bottom-j-h;
var c=this.map.size.w-this.map.paddingForPopups.left-this.map.paddingForPopups.right-m-i;
f.w=Math.min(f.w,c);
f.h=Math.min(f.h,a)
}return f
};
OpenLayers.Popup.prototype.getContentDivMargin=function(){if(this.div.parentNode===null){this.div.style.display="none";
document.body.appendChild(this.div)
}contentDivMargin=new OpenLayers.Bounds(OpenLayers.Element.getStyle(this.contentDiv,"margin-left"),OpenLayers.Element.getStyle(this.contentDiv,"margin-bottom"),OpenLayers.Element.getStyle(this.contentDiv,"margin-right"),OpenLayers.Element.getStyle(this.contentDiv,"margin-top"));
if(this.div.parentNode==document.body){document.body.removeChild(this.div);
this.div.style.display=""
}return contentDivMargin
};
OpenLayers.Control.ArgParser.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.ArgParser",Legato.OpenLayers.Control.QName("ArgParser"),{_constructor:OpenLayers.Control.ArgParser,options:{displayProjection:OpenLayers.Projection.Bean}});
OpenLayers.Control.Attribution.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.Attribution",Legato.OpenLayers.Control.QName("Attribution"),{_constructor:OpenLayers.Control.Attribution,options:{separator:Legato.Lang.String}});
OpenLayers.Control.DrawFeature.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.DrawFeature",Legato.OpenLayers.Control.QName("DrawFeature"),{_constructor:OpenLayers.Control.DrawFeature,constructorArguments:{layer:OpenLayers.Layer.Bean,handler:Legato.Lang.Function},constructorOrder:["layer","handler"],options:{featureAdded:Legato.Lang.Function,handlerOptions:Legato.Beans.Object}});
OpenLayers.Control.ModifyFeature.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.ModifyFeature",Legato.OpenLayers.Control.QName("ModifyFeature"),{_constructor:OpenLayers.Control.ModifyFeature,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"],options:{featureAdded:Legato.Lang.Function,handlerOptions:Legato.Beans.Object,geometryTypes:Legato.Lang["String[]"],clickout:Legato.Lang.Boolean,toggle:Legato.Lang.Boolean,deleteCodes:Legato.Lang["Integer[]"],virtualStyle:Legato.Beans.Object,mode:Legato.Lang.Integer}});
OpenLayers.Control.LayerSwitcher.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.LayerSwitcher",Legato.OpenLayers.Control.QName("LayerSwitcher"),{options:{ascending:Legato.Lang.Boolean,activeColor:"darkblue"},_constructor:OpenLayers.Control.LayerSwitcher});
OpenLayers.Control.LoadingPanel.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.LoadingPanel",Legato.OpenLayers.Control.QName("LoadingPanel"),{_constructor:OpenLayers.Control.LoadingPanel});
OpenLayers.Control.Scale.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.Scale",Legato.OpenLayers.Control.QName("Scale"),{_constructor:OpenLayers.Control.Scale,constructorArguments:{div:Legato.Lang.Element},constructorOrder:["div"]});
OpenLayers.Control.ScaleLine.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.ScaleLine",Legato.OpenLayers.Control.QName("ScaleLine"),{factoryFunction:function(a){if(!Legato.Lang.ObjectUtils.exists(a)){a=[]
}if(!Legato.Lang.ObjectUtils.exists(a.bottomInUnits)){a.bottomInUnits=""
}if(!Legato.Lang.ObjectUtils.exists(a.bottomOutUnits)){a.bottomOutUnits=""
}var b=new OpenLayers.Control.ScaleLine(a);
return b
},options:{maxWidth:Legato.Lang.Integer,topOutUnits:Legato.Lang.String,topInUnits:Legato.Lang.String,bottomOutUnits:Legato.Lang.String,bottomInUnits:Legato.Lang.String,eTop:Legato.Lang.Element,eBottom:Legato.Lang.Element}});
OpenLayers.Control.Navigation.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.Navigation",Legato.OpenLayers.Control.QName("Navigation"),{_constructor:OpenLayers.Control.Navigation,options:{zoomWheelEnabled:Legato.Lang.Boolean,handleRightClicks:Legato.Lang.Boolean}});
OpenLayers.Control.NavigationHistory.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.NavigationHistory",Legato.OpenLayers.Control.QName("NavigationHistory"),{factoryFunction:function(b,a){return new OpenLayers.Control.NavigationHistory({nextOptions:{title:b},previousOptions:{title:a}})
},constructorArguments:{nextTitle:Legato.Lang.String,previousTitle:Legato.Lang.String},constructorOrder:["nextTitle","previousTitle"]});
OpenLayers.Control.OverviewMap.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.OverviewMap",Legato.OpenLayers.Control.QName("OverviewMap"),{factoryFunction:function(a){if(!Legato.Lang.ObjectUtils.exists(a)){a={}
}if(!Legato.Lang.ObjectUtils.exists(a.mapOptions)){a.mapOptions={}
}if(!Legato.Lang.ObjectUtils.exists(a.mapOptions.theme)){a.mapOptions.theme=null
}return new OpenLayers.Control.OverviewMap(a)
},fields:{size:OpenLayers.Size.Bean,ovmap:OpenLayers.Map.Bean}});
OpenLayers.Control.Panel.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.Panel",Legato.OpenLayers.Control.QName("Panel"),{_constructor:OpenLayers.Control.Panel,fields:{defaultControl:OpenLayers.Control.Bean,activeControls:OpenLayers.Control.Bean.List()},properties:{controls:new Legato.Beans.Property(OpenLayers.Control.Bean.List(),function(a,b){a.addControls(b)
})},afterInstancePopulated:function(a){if(Legato.Lang.ObjectUtils.exists(a.activeControls)){for(var b=0;
b<a.activeControls.length;
b++){a.activateControl(a.activeControls[b])
}}if(Legato.Lang.ObjectUtils.exists(a.defaultControl)){a.activateControl(a.defaultControl)
}}});
OpenLayers.Control.PanZoom.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.PanZoom",Legato.OpenLayers.Control.QName("PanZoom"),{_constructor:OpenLayers.Control.PanZoom,options:{slideFactor:Legato.Lang.Integer,buttons:Legato.Lang["Element[]"],position:OpenLayers.Pixel.Bean}});
OpenLayers.Control.PanZoomBar.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.PanZoomBar",Legato.OpenLayers.Control.QName("PanZoomBar"),{_constructor:OpenLayers.Control.PanZoomBar,options:{zoomStopWidth:Legato.Lang.Integer,zoomStopHeight:Legato.Lang.Integer,zoomWorldIcon:Legato.Lang.Boolean}});
OpenLayers.Control.MouseDefaults.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.MouseDefaults",Legato.OpenLayers.Control.QName("MouseDefaults"),{_constructor:OpenLayers.Control.MouseDefaults});
OpenLayers.Control.MousePosition.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.MousePosition",Legato.OpenLayers.Control.QName("MousePosition"),{_constructor:OpenLayers.Control.MousePosition,options:{element:Legato.Lang.Element,prefix:Legato.Lang.String,separator:Legato.Lang.String,suffix:Legato.Lang.String,numDigits:Legato.Lang.Integer,granularity:Legato.Lang.Integer,displayProjection:OpenLayers.Projection.Bean}});
OpenLayers.Control.Zoom.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.Zoom",Legato.OpenLayers.Control.QName("Zoom"),{_constructor:OpenLayers.Control.Zoom,options:{zoomInId:Legato.Lang.String,zoomOutId:Legato.Lang.String}});
OpenLayers.Control.ZoomBox.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.ZoomBox",Legato.OpenLayers.Control.QName("ZoomBox"),{_constructor:OpenLayers.Control.ZoomBox,options:{out:Legato.Lang.Boolean}});
OpenLayers.Control.ZoomInBox=OpenLayers.Class(OpenLayers.Control.ZoomBox,{out:false,CLASS_NAME:"OpenLayers.Control.ZoomInBox"});
OpenLayers.Control.ZoomInBox.Bean=OpenLayers.Control.ZoomBox.Bean.Extend("OpenLayers.Control.ZoomInBox",Legato.OpenLayers.Control.QName("ZoomInBox"),{_constructor:OpenLayers.Control.ZoomInBox});
OpenLayers.Control.ZoomOutBox=OpenLayers.Class(OpenLayers.Control.ZoomBox,{out:true,CLASS_NAME:"OpenLayers.Control.ZoomOutBox"});
OpenLayers.Control.ZoomOutBox.Bean=OpenLayers.Control.ZoomBox.Bean.Extend("OpenLayers.Control.ZoomOutBox",Legato.OpenLayers.Control.QName("ZoomOutBox"),{_constructor:OpenLayers.Control.ZoomOutBox});
OpenLayers.Control.ZoomOut.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.ZoomOut",Legato.OpenLayers.Control.QName("ZoomOut"),{_constructor:OpenLayers.Control.ZoomOut});
OpenLayers.Control.ZoomToMaxExtent.Bean=OpenLayers.Control.Bean.Extend("OpenLayers.Control.ZoomToMaxExtent",Legato.OpenLayers.Control.QName("ZoomToMaxExtent"),{_constructor:OpenLayers.Control.ZoomToMaxExtent});
OpenLayers.Popup.MarginAwareFramedCloud=OpenLayers.Class(OpenLayers.Popup.FramedCloud,{getContentDivPadding:function(){var b=this._contentDivPadding;
if(!b){if(this.div.parentNode===null){this.div.style.display="none";
document.body.appendChild(this.div)
}var c=new OpenLayers.Bounds(OpenLayers.Element.getStyle(this.contentDiv,"padding-left"),OpenLayers.Element.getStyle(this.contentDiv,"padding-bottom"),OpenLayers.Element.getStyle(this.contentDiv,"padding-right"),OpenLayers.Element.getStyle(this.contentDiv,"padding-top"));
var a=new OpenLayers.Bounds(OpenLayers.Element.getStyle(this.contentDiv,"margin-left"),OpenLayers.Element.getStyle(this.contentDiv,"margin-bottom"),OpenLayers.Element.getStyle(this.contentDiv,"margin-right"),OpenLayers.Element.getStyle(this.contentDiv,"margin-top"));
b=new OpenLayers.Bounds(c.left+a.left,c.bottom+a.bottom,c.right+a.right,c.top+a.top);
this._contentDivPadding=b;
if(this.div.parentNode===document.body){document.body.removeChild(this.div);
this.div.style.display=""
}}return b
},CLASS_NAME:"OpenLayers.Popup.MarginAwareFramedCloud"});
Legato.Service=OpenLayers.Class({initialize:function(a){OpenLayers.Util.extend(this,a);
this.options=a
},CLASS_NAME:"Legato.Service"});
Legato.Service.BUSY=-99;
Legato.Service.ERROR=-999;
Legato.Service.NAMESPACE_URI="http://www.disy.net/legato/service";
Legato.Service.PREFIX="ls";
Legato.Service.QName=function(a){return new Legato.XML.QName(Legato.Service.NAMESPACE_URI,a,Legato.Service.PREFIX)
};
Legato.Service.LayerCapabilities=OpenLayers.Class(Legato.Singleton,Legato.Service,{cache:null,initialize:function(a){Legato.Service.prototype.initialize.apply(this,arguments);
this.cache=[]
},validateArguments:function(a){if(typeof a.layer!="object"||typeof a.layer.CLASS_NAME=="undefined"||a.layer.CLASS_NAME!="OpenLayers.Layer.WMS"){throw ("Need a valid argument layer which needs to be an OpenLayers.Layer.WMS instance")
}if(typeof a.onComplete!="function"){throw ("Missing needed argument onComplete which has to be a function")
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(a.result)){throw new Legato.Lang.IllegalArgumentException("Given arguments allready contain a result. Please ensure that the key result is never used")
}},loadCapabilitites:function(a){if(typeof this.cache[a.layer.url]=="undefined"){this.cache[a.layer.url]=Legato.Service.BUSY;
try{var b=this;
OpenLayers.Request.GET({url:a.layer.url,params:({REQUEST:"GetCapabilities",SERVICE:"WMS"}),scope:b,success:function(e){var d=new OpenLayers.Format.WMSCapabilities();
var f=d.read(e.responseText);
this.cache[a.layer.url]=f;
a.onComplete(this.cache[a.layer.url])
},failure:function(d){if(typeof a.onError!="function"){OpenLayers.Console.warn(d);
return
}a.onError(d)
}});
return
}catch(c){this.cache[a.layer.url]=null;
if(typeof a.onError!="function"){OpenLayers.Console.warn(c);
return
}a.onError(c)
}}a.onComplete(this.cache[a.layer.url])
},getCapabilitites:function(a){this.validateArguments(a);
this.loadCapabilitites({layer:a.layer,onComplete:OpenLayers.Function.bind(function(c){var b=c===Legato.Service.BUSY?this.createResultContext(Legato.Service.BUSY,a):this.createResultContext({capabilitites:c},a);
a.onComplete(b);
return
},this),onError:a.onError})
},createResultContext:function(a,c){var b={};
OpenLayers.Util.extend(b,c);
b.result=a;
return b
},getLegendUrl:function(a){this.validateArguments(a);
this.loadCapabilitites({layer:a.layer,onComplete:OpenLayers.Function.bind(function(d){if(d===Legato.Service.BUSY){OpenLayers.Console.debug("I am busy right now. Try again later");
a.onComplete(this.createResultContext(d,a));
return
}var c=null;
if(Legato.Lang.ObjectUtils.isNullOrUndefined(d)||Legato.Lang.ObjectUtils.isNullOrUndefined(d.capability)||Legato.Lang.ObjectUtils.isNullOrUndefined(d.capability.layers)){return
}for(var b=0;
b<d.capability.layers.length;
b++){if(d.capability.layers[b].name!=a.layer.name){continue
}c=d.capability.layers[b]
}if(c===null||c.styles.length===0){OpenLayers.Console.debug("There is no legendUrl");
a.onComplete(this.createResultContext({legendUrl:null},a));
return
}OpenLayers.Console.debug("There is a legendUrl");
a.onComplete(this.createResultContext({legendUrl:c.styles[0].legend},a));
return
},this),onError:a.onError})
},CLASS_NAME:"Legato.Service.LayerCapabilities"});
Legato.Service.CapabilitiesURLs={};
Legato.Service.CapabilitiesURLs.Bean=Legato.Beans.Object.Extend("Legato.Service.CapabilitiesURLs",Legato.Service.QName("CapabilitiesURLs"),{factoryFunction:function(a){return a
},constructorArguments:{urls:Legato.Lang["String[]"]},constructorOrder:["urls"],afterInstancePopulated:function(b){for(var a=0;
a<b.length;
a++){}}});
Legato.Handler={};
Legato.Handler.NAMESPACE_URI="http://www.disy.net/legato/handler";
Legato.Handler.PREFIX="lla";
Legato.Handler.QName=function(a){return new Legato.XML.QName(Legato.Handler.NAMESPACE_URI,a,Legato.Handler.PREFIX)
};
Legato.Handler.Bean=Legato.Beans.Object.Extend("Legato.Handler",Legato.Handler.QName("Bean"),{_constructor:Legato.Handler});
Legato.Handler.Box=OpenLayers.Class(OpenLayers.Handler.Box,{endBox:function(e){var l;
if(Math.abs(this.dragHandler.start.x-e.x)>5||Math.abs(this.dragHandler.start.y-e.y)>5){var c=this.dragHandler.start;
var h=Math.min(c.y,e.y);
var b=Math.max(c.y,e.y);
var d=Math.min(c.x,e.x);
var i=Math.max(c.x,e.x);
var j=this.map.getLonLatFromPixel(new OpenLayers.Pixel(d,b));
var f=this.map.getLonLatFromPixel(new OpenLayers.Pixel(i,h));
var a=new OpenLayers.Bounds(j.lon,j.lat,f.lon,f.lat);
l=a.toGeometry()
}else{var k=this.dragHandler.start.clone();
var g=this.map.getLonLatFromPixel(k);
l=new OpenLayers.Geometry.Point(g.lon,g.lat)
}this.removeBox();
this.callback("done",[l])
},CLASS_NAME:"Legato.Handler.Box"});
Legato.Handler.Path=OpenLayers.Class(OpenLayers.Handler.Path,{initialize:function(d,c,a){var b=a;
if(!a){b={}
}if(!b.layerOptions){b.layerOptions={}
}b.layerOptions.legatoIgnore=true;
OpenLayers.Handler.Path.prototype.initialize.apply(this,[d,c,b])
},mousedown:function(a){if(this.drawing&&a.ctrlKey){OpenLayers.Handler.Path.prototype.mousedown.apply(this,arguments);
this.dblclick(a);
return false
}else{return OpenLayers.Handler.Path.prototype.mousedown.apply(this,arguments)
}},geometryClone:function(){var c=this.line&&this.line.geometry;
if(c){var b=c.id;
c.id=OpenLayers.Util.createUniqueID(c.CLASS_NAME+"_");
var a=c.clone();
a.id=b;
this.line.geometry=a;
if(this.multi){return new OpenLayers.Geometry.MultiLineString([c])
}else{return c
}}return c
},CLASS_NAME:"Legato.Handler.Path"});
Legato.Handler.Point=OpenLayers.Class(OpenLayers.Handler.Point,{initialize:function(d,c,a){var b=a;
if(!a){b={}
}if(!b.layerOptions){b.layerOptions={}
}b.layerOptions.legatoIgnore=true;
OpenLayers.Handler.Point.prototype.initialize.apply(this,[d,c,b])
},geometryClone:function(){var c=this.point&&this.point.geometry;
if(c){var b=c.id;
c.id=OpenLayers.Util.createUniqueID(c.CLASS_NAME+"_");
var a=c.clone();
a.id=b;
this.point.geometry=a;
if(this.multi){return new OpenLayers.Geometry.MultiPoint([c])
}else{return c
}}return c
},CLASS_NAME:"Legato.Handler.Point"});
Legato.Handler.Polygon=OpenLayers.Class(OpenLayers.Handler.Polygon,{initialize:function(d,c,a){var b=a;
if(!a){b={}
}if(!b.layerOptions){b.layerOptions={}
}b.layerOptions.legatoIgnore=true;
OpenLayers.Handler.Polygon.prototype.initialize.apply(this,[d,c,b])
},mousedown:function(a){if(this.drawing&&a.ctrlKey){OpenLayers.Handler.Polygon.prototype.mousedown.apply(this,arguments);
this.dblclick(a);
return false
}else{return OpenLayers.Handler.Polygon.prototype.mousedown.apply(this,arguments)
}},geometryClone:function(){var c=this.polygon&&this.polygon.geometry;
if(c){var b=c.id;
c.id=OpenLayers.Util.createUniqueID(c.CLASS_NAME+"_");
var a=c.clone();
a.id=b;
this.polygon.geometry=a;
if(this.multi){return new OpenLayers.Geometry.MultiPolygon([c])
}else{return c
}}return c
},CLASS_NAME:"Legato.Handler.Polygon"});
Legato.Handler.RegularPolygon=OpenLayers.Class(OpenLayers.Handler.RegularPolygon,{initialize:function(d,c,a){var b=a;
if(!a){b={}
}if(!b.layerOptions){b.layerOptions={}
}b.layerOptions.legatoIgnore=true;
OpenLayers.Handler.RegularPolygon.prototype.initialize.apply(this,[d,c,b])
},mousedown:function(a){if(this.drawing&&a.ctrlKey){OpenLayers.Handler.RegularPolygon.prototype.mousedown.apply(this,arguments);
this.dblclick(a);
return false
}else{return OpenLayers.Handler.RegularPolygon.prototype.mousedown.apply(this,arguments)
}},geometryClone:function(){var c=this.feature&&this.feature.geometry;
if(c){var b=c.id;
c.id=OpenLayers.Util.createUniqueID(c.CLASS_NAME+"_");
var a=c.clone();
a.id=b;
this.feature.geometry=a;
if(this.multi){return new OpenLayers.Geometry.MultiPolygon([c])
}else{return c
}}return c
},CLASS_NAME:"Legato.Handler.RegularPolygon"});
Legato.Handler.MouseWheel=OpenLayers.Class(OpenLayers.Handler.MouseWheel,{interval:100,initialize:function(c,b,a){OpenLayers.Handler.prototype.initialize.apply(this,arguments);
this.wheelListener=OpenLayers.Function.bindAsEventListener(this.onWheelEvent,this)
},onWheelEvent:function(k){if(!this.map||!this.checkModifiers(k)){return
}var g=false;
var m=false;
var f=false;
var b=OpenLayers.Event.element(k);
while((b!==null)&&!f&&!g){if(!g){try{var c=null;
if(b.currentStyle){c=b.currentStyle.overflow
}else{var a=document.defaultView.getComputedStyle(b,null);
c=a.getPropertyValue("overflow")
}g=(c&&((c==="auto")||(c==="scroll")))
}catch(d){}}if(!m){for(var h=0,j=this.map.layers.length;
h<j;
h++){if(b===this.map.layers[h].div||b===this.map.layers[h].pane||b===this.map.div){m=true;
break
}}}f=(b===this.map.div);
b=b.parentNode
}if(!g&&f){if(m){var l=0;
if(!k){k=window.event
}if(k.wheelDelta){l=k.wheelDelta/120;
if(window.opera&&window.opera.version()<9.2){l=-l
}}else{if(k.detail){l=-k.detail/3
}}this.delta=this.delta+l;
if(this.interval){window.clearTimeout(this._timeoutId);
this._timeoutId=window.setTimeout(OpenLayers.Function.bind(function(){this.wheelZoom(k)
},this),this.interval)
}else{this.wheelZoom(k)
}}OpenLayers.Event.stop(k)
}},CLASS_NAME:"Legato.Handler.MouseWheel"});
Legato.Handler.MultiPoint=OpenLayers.Class(Legato.Handler.Point,{multi:true,CLASS_NAME:"Legato.Handler.MultiPoint"});
Legato.Handler.MultiLineString=OpenLayers.Class(Legato.Handler.Path,{multi:true,CLASS_NAME:"Legato.Handler.MultiLineString"});
Legato.Handler.MultiPolygon=OpenLayers.Class(Legato.Handler.Polygon,{multi:true,CLASS_NAME:"Legato.Handler.MultiPolygon"});
Legato.I18n={};
Legato.I18n.NAMESPACE_URI="http://www.disy.net/legato/i18n";
Legato.I18n.PREFIX="li18n";
Legato.I18n.LOCALE=null;
Legato.I18n.MESSAGE_SOURCE=null;
Legato.I18n.QName=function(a){return new Legato.XML.QName(Legato.I18n.NAMESPACE_URI,a,Legato.I18n.PREFIX)
};
Legato.I18n.setLocale=function(a){Legato.Util.Ensure.ensureNotEmptyString(a);
Legato.I18n.LOCALE=a;
OpenLayers.Lang.setCode(a)
};
Legato.I18n.getMessage=function(b,a){if(!Legato.Lang.ObjectUtils.exists(Legato.I18n.MESSAGE_SOURCE)){Legato.I18n.MESSAGE_SOURCE=new Legato.I18n.MessageSource({locale:Legato.I18n.LOCALE,messages:Legato.I18n.Messages})
}return Legato.I18n.MESSAGE_SOURCE.getMessage(b,a)
};
Legato.I18n.BrowserLocaleFactoryBean=OpenLayers.Class({defaultLocale:"en",supportedLocales:null,supportedLocalesSet:null,initialize:function(b){OpenLayers.Util.extend(this,b);
if(!Legato.Lang.ObjectUtils.exists(this.supportedLocales)){this.supportedLocales=Legato.I18n.Messages.supportedLocales
}this.supportedLocalesSet=new Legato.Util.HashSet();
for(var a=0;
a<this.supportedLocales.length;
a++){this.supportedLocalesSet.add(this.supportedLocales[a])
}},getInstance:function(){var c=[];
c.push(this.defaultLocale);
var b=(OpenLayers.Util.getBrowserName()=="msie")?navigator.userLanguage:navigator.language;
var d=b.split("-");
if(d.length>=1){c.push(d[0].toLowerCase())
}if(d.length>=2){c.push(d[0].toLowerCase()+"-"+d[1].toUpperCase())
}if(d.length>=3){c.push(d[0].toLowerCase()+"-"+d[1].toUpperCase()+"-"+d[2])
}for(var a=c.length-1;
a>=0;
--a){if(this.supportedLocalesSet.contains(c[a])){return c[a]
}}return this.defaultLocale
},CLASS_NAME:"Legato.I18n.BrowserLocaleFactoryBean"});
Legato.I18n.BrowserLocaleFactoryBean.Bean=Legato.Beans.Object.Extend("Legato.I18n.BrowserLocaleFactoryBean",Legato.I18n.QName("BrowserLocale"),{_constructor:Legato.I18n.BrowserLocaleFactoryBean,options:{defaultLocale:Legato.Lang.String,supportedLocales:Legato.Lang.String.List()}});
Legato.I18n.Messages={};
Legato.I18n.Messages.dictionaries={};
Legato.I18n.Messages.supportedLocales=[];
Legato.I18n.MessageSource=OpenLayers.Class({locale:null,messages:null,initialize:function(a){OpenLayers.Util.extend(this,a);
if(!Legato.Lang.ObjectUtils.exists(this.locale)){this.locale=(new Legato.I18n.BrowserLocaleFactoryBean()).getInstance()
}if(!Legato.Lang.ObjectUtils.exists(this.messages)){this.messages=Legato.I18n.Messages
}},containsMessage:function(a){var c=this.messages.dictionaries[this.locale];
if(Legato.Lang.ObjectUtils.exists(c)){var b=c[a];
if(Legato.Lang.ObjectUtils.exists(b)){return true
}else{return false
}}else{return false
}},getMessage:function(b,a){var d=this.messages.dictionaries[this.locale];
if(Legato.Lang.ObjectUtils.exists(d)){var c=d[b];
if(Legato.Lang.ObjectUtils.exists(c)){return OpenLayers.String.format(c,a)
}else{return"???"+b+"???"
}}else{return"???"+b+"???"
}},CLASS_NAME:"Legato.I18n.MessageSource"});
Legato.I18n.MessageSource.Bean=Legato.Beans.Object.Extend("Legato.I18n.MessageSource",Legato.I18n.QName("MessageSource"),{_constructor:Legato.I18n.MessageSource,options:{locale:Legato.Lang.String}});
Legato.I18n.Message=OpenLayers.Class({message:"",context:null,messageSource:null,initialize:function(a){OpenLayers.Util.extend(this,a);
if(!Legato.Lang.ObjectUtils.exists(this.messageSource)){this.messageSource=new Legato.I18n.MessageSource()
}},getInstance:function(){return this.messageSource.getMessage(this.message,this.context)
},CLASS_NAME:"Legato.I18n.Message"});
Legato.I18n.Message.Bean=Legato.Beans.Object.Extend("Legato.I18n.Message",Legato.I18n.QName("Message"),{_constructor:Legato.I18n.Message,options:{message:Legato.Lang.String,messageSource:Legato.I18n.MessageSource.Bean,context:Legato.Beans.Object}});
Legato.I18n.Messages.dictionaries.de=OpenLayers.Lang.de;
Legato.I18n.Messages.dictionaries.de["Legato.Control.SetMapSize"]="Setzt die Kartengr\u00f6\u00dfe";
Legato.I18n.Messages.dictionaries.de["OpenLayers.Control.ZoomToMaxExtent"]="Auf maximal Ausschnitt vergr\u00f6\u00dfern";
Legato.I18n.Messages.dictionaries.de["Legato.Control.DrawText.TextPrompt"]="Geben Sie bitte den Text für das Text-Zeichenobjekt ein.";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.LayerName"]="Zeichenthema";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.Title"]="Zeichenwerkzeuge";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.Abstract"]="Bitte wählen Sie das Zeichenwerkzeug und erfassen oder modifizieren Sie mit der Maus die Geometrie.";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.ControlsPanel.Title"]="Zeichenwerkzeug";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.Text"]="Text";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.Point"]="Punkt";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.Line"]="Linienzug";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.Polygon"]="Polygon";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.Circle"]="Kreis";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.Edit"]="Bearbeiten";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.Delete"]="Löschen";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.Execute"]="Erfassung abschließen";
Legato.I18n.Messages.dictionaries.de["Legato.Control.SketchLayerEditor.Cancel"]="Abbrechen";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.AbstractInputElement.fontFamily"]="Schriftart";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.AbstractInputElement.fontColor"]="Schriftfarbe";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.AbstractInputElement.fontSize"]="Schriftgrad";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.AbstractInputElement.fontStyle"]="Schriftschnitt";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.AbstractInputElement.fontWeight"]="Schriftstärke";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.AbstractInputElement.fillColor"]="Füllfarbe";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.AbstractInputElement.pointRadius"]="Radius";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.AbstractInputElement.strokeWidth"]="Linienstärke";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.AbstractInputElement.strokeColor"]="Linienfarbe";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.AbstractInputElement.strokeDashstyle"]="Linientyp";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.Factory.fontStyle.normal"]="normal";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.Factory.fontStyle.italic"]="kursiv";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.Factory.fontWeight.normal"]="normal";
Legato.I18n.Messages.dictionaries.de["Legato.StyleProperties.Factory.fontWeight.bold"]="fett";
Legato.I18n.Messages.supportedLocales.push("de");
Legato.I18n.Messages.dictionaries.en=OpenLayers.Lang.en;
Legato.I18n.Messages.dictionaries.en["Legato.Control.SetMapSize"]="Sets map size";
Legato.I18n.Messages.dictionaries.en["OpenLayers.Control.ZoomToMaxExtent"]="Zoom to maximum extent";
Legato.I18n.Messages.dictionaries.en["Legato.Control.DrawText.TextPrompt"]="Please enter the text for the text object.";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.LayerName"]="Sketch layer";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.Title"]="Drawing tools";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.Abstract"]="Please select the drawing tool and capture or modify the geometry with the mouse.";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.ControlsPanel.Title"]="Drawing tool";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.Text"]="Text";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.Point"]="Point";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.Line"]="Line";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.Polygon"]="Polygon";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.Circle"]="Circle";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.Edit"]="Edit";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.Delete"]="Delete";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.Execute"]="Complete capture";
Legato.I18n.Messages.dictionaries.en["Legato.Control.SketchLayerEditor.Cancel"]="Cancel";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.AbstractInputElement.fontFamily"]="Font family";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.AbstractInputElement.fontColor"]="Color";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.AbstractInputElement.fontSize"]="Size";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.AbstractInputElement.fontStyle"]="Style";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.AbstractInputElement.fontWeight"]="Weight";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.AbstractInputElement.fillColor"]="Fill color";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.AbstractInputElement.pointRadius"]="Radius";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.AbstractInputElement.strokeWidth"]="Stroke width";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.AbstractInputElement.strokeColor"]="Stroke color";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.AbstractInputElement.strokeDashstyle"]="Dashstyle";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.Factory.fontStyle.normal"]="normal";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.Factory.fontStyle.italic"]="italic";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.Factory.fontWeight.normal"]="normal";
Legato.I18n.Messages.dictionaries.en["Legato.StyleProperties.Factory.fontWeight.bold"]="bold";
Legato.I18n.Messages.supportedLocales.push("en");
Legato.Popup=OpenLayers.Class({title:null,size:null,position:null,zIndex:null,initialize:function(a){Legato.Util.Ensure.ensureExists(a.title,"title should be defined");
OpenLayers.Util.extend(this,a)
},openUrl:function(a){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the openUrl function from from abstract class "+Legato.Popup.CLASS_NAME)
},open:function(a){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the open function from from abstract class "+Legato.Popup.CLASS_NAME)
},close:function(){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the close function from from abstract class "+Legato.Popup.CLASS_NAME)
},setPosition:function(a){if(!Legato.Lang.ObjectUtils.isNullOrUndefined(a)){if((Legato.Lang.ObjectUtils.isNullOrUndefined(this.maintainPosition)||Legato.Lang.ObjectUtils.isFalse(this.maintainPosition))){this.position=a;
this.dialog.dialog("option","position",[this.position.x,this.position.y])
}}},getPosition:function(){return this.position
},CLASS_NAME:"Legato.Popup"});
Legato.Popup.NAMESPACE_URI="http://www.disy.net/legato/popup";
Legato.Popup.PREFIX="lpo";
Legato.Popup.QName=function(a){return new Legato.XML.QName(Legato.Popup.NAMESPACE_URI,a,Legato.Popup.PREFIX)
};
Legato.Popup.Bean=Legato.Beans.Object.Extend("Legato.Popup",Legato.Popup.QName("Popup"),{_constructor:Legato.Popup,options:{title:Legato.Lang.String,size:OpenLayers.Size,position:OpenLayers.Pixel,zIndex:Legato.Lang.Integer,maxHeight:Legato.Lang.Integer,height:Legato.Lang.Integer,width:Legato.Lang.Integer,maintainPosition:Legato.Lang.Boolean}});
Legato.Layer={};
Legato.Layer.NAMESPACE_URI="http://www.disy.net/legato/layer";
Legato.Layer.PREFIX="lla";
Legato.Layer.QName=function(a){return new Legato.XML.QName(Legato.Layer.NAMESPACE_URI,a,Legato.Layer.PREFIX)
};
Legato.Layer.Bean=Legato.Beans.Object.Extend("Legato.Layer",Legato.Layer.QName("Bean"),{_constructor:Legato.Layer});
Legato.Layer.Predicate=OpenLayers.Class({initialize:function(a){OpenLayers.Util.extend(this,a)
},evaluate:function(a){return true
},CLASS_NAME:"Legato.Layer.Predicate"});
Legato.Layer.Predicate.NAMESPACE_URI="http://www.disy.net/legato/layer/predicate";
Legato.Layer.Predicate.PREFIX="llpr";
Legato.Layer.Predicate.QName=function(a){return new Legato.XML.QName(Legato.Layer.Predicate.NAMESPACE_URI,a,Legato.Layer.Predicate.PREFIX)
};
Legato.Layer.Predicate.Bean=Legato.Beans.Object.Extend("Legato.Layer.Predicate",Legato.Layer.Predicate.QName("Predicate"),{_constructor:Legato.Layer.Predicate});
Legato.Layer.Predicate.BaseLayer=OpenLayers.Class({initialize:function(a){OpenLayers.Util.extend(this,a)
},evaluate:function(a){return a.isBaseLayer
},CLASS_NAME:"Legato.Layer.Predicate.BaseLayer"});
Legato.Layer.Predicate.BaseLayer.Bean=Legato.Layer.Predicate.Bean.Extend("Legato.Layer.Predicate.BaseLayer",Legato.Layer.Predicate.QName("BaseLayer"),{_constructor:Legato.Layer.Predicate.BaseLayer});
Legato.Layer.Predicate.LayerId=OpenLayers.Class({initialize:function(a){OpenLayers.Util.extend(this,a)
},evaluate:function(a){return a.layerId===this.value
},CLASS_NAME:"Legato.Layer.Predicate.LayerId"});
Legato.Layer.Predicate.LayerId.Bean=Legato.Layer.Predicate.Bean.Extend("Legato.Layer.Predicate.LayerId",Legato.Layer.Predicate.QName("LayerId"),{_constructor:Legato.Layer.Predicate.LayerId,options:{value:Legato.Lang.String}});
Legato.Layer.Predicate.LayerWithAttribute=OpenLayers.Class({name:null,value:null,predicate:null,initialize:function(a){Legato.Util.Ensure.ensureString(a.name,"Attribute name must be a string.");
this.name=a.name;
if(Legato.Lang.ObjectUtils.isObject(a.predicate)){Legato.Util.Ensure.ensureFunction(a.predicate.evaluate,"Predicate must define the [evaluate] function.");
this.predicate=a.predicate
}else{if(Legato.Lang.ObjectUtils.isString(a.value)){this.predicate=new Legato.Predicate.Equals(a.value)
}else{this.predicate=null
}}},evaluate:function(b){if(Legato.Lang.ObjectUtils.isString(this.name)){var a=b.attributes;
if(Legato.Lang.ObjectUtils.isObject(a)){if(Legato.Lang.ObjectUtils.exists(this.predicate)){return Legato.Lang.ObjectUtils.exists(a[this.name])&&this.predicate.evaluate(a[this.name])
}else{return Legato.Lang.ObjectUtils.exists(a[this.name])
}}else{return false
}}else{return true
}},CLASS_NAME:"Legato.Layer.Predicate.LayerWithAttribute"});
Legato.Layer.Predicate.LayerWithAttribute.Bean=Legato.Layer.Predicate.Bean.Extend("Legato.Layer.Predicate.LayerWithAttribute",Legato.Layer.Predicate.QName("LayerWithAttribute"),{_constructor:Legato.Layer.Predicate.LayerWithAttribute,options:{name:Legato.Lang.String,value:Legato.Lang.String,predicate:Legato.Beans.Object}});
Legato.Layer.Predicate.Overlay=OpenLayers.Class({initialize:function(a){OpenLayers.Util.extend(this,a)
},evaluate:function(a){return !a.isBaseLayer
},CLASS_NAME:"Legato.Layer.Predicate.Overlay"});
Legato.Layer.Predicate.Overlay.Bean=Legato.Layer.Predicate.Bean.Extend("Legato.Layer.Predicate.Overlay",Legato.Layer.Predicate.QName("Overlay"),{_constructor:Legato.Layer.Predicate.Overlay});
Legato.Layer.Predicate.SelectedLayer=OpenLayers.Class({initialize:function(a){OpenLayers.Util.extend(this,a)
},evaluate:function(a){return Legato.Lang.ObjectUtils.isTrue(a.selected)
},CLASS_NAME:"Legato.Layer.Predicate.SelectedLayer"});
Legato.Layer.Predicate.SelectedLayer.Bean=Legato.Layer.Predicate.Bean.Extend("Legato.Layer.Predicate.SelectedLayer",Legato.Layer.Predicate.QName("SelectedLayer"),{_constructor:Legato.Layer.Predicate.SelectedLayer});
Legato.Layer.Transformer=Legato.Lang.Class({initialize:function(){},transform:function(a){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the transform function from from abstract class "+Legato.Layer.Transformer.CLASS_NAME)
},CLASS_NAME:"Legato.Layer.Transformer"});
Legato.Layer.Transformer.NAMESPACE_URI="http://www.disy.net/legato/layer/transformer";
Legato.Layer.Transformer.PREFIX="lltr";
Legato.Layer.Transformer.QName=function(a){return new Legato.XML.QName(Legato.Layer.Transformer.NAMESPACE_URI,a,Legato.Layer.Transformer.PREFIX)
};
Legato.Layer.Transformer.Bean=Legato.Beans.Object.Extend("Legato.Layer.Transformer",Legato.Layer.Transformer.QName("Transformer"),{_constructor:Legato.Layer.Transformer});
Legato.Layer.Transformer.SublayerFilteringTransformer=OpenLayers.Class(Legato.Layer.Transformer,{predicate:null,initialize:function(a){Legato.Layer.Transformer.prototype.initialize.apply(this);
Legato.Util.Ensure.ensureObject(a);
this.predicate=a
},transform:function(c){var f=c.layerId.split(",");
if(f.length===1){if(this.predicate.evaluate(c)){return c
}return null
}var e=[];
var a=c.clone();
for(var b=0;
b<f.length;
b++){a.layerId=f[b];
a.params.LAYERS=f[b];
if(this.predicate.evaluate(a)){e.push(f[b])
}}if(e.length!==0){var d=e.join(",");
a.layerId=d;
a.params.LAYERS=d;
return a
}return null
},CLASS_NAME:"Legato.Layer.Transformer.SublayerFilteringTransformer"});
Legato.Layer.Transformer.SublayerFilteringTransformer.Bean=Legato.Layer.Transformer.Bean.Extend("Legato.Layer.Transformer.SublayerFilteringTransformer",Legato.Layer.QName("SublayerFilteringTransformer"),{_constructor:Legato.Layer.Transformer.SublayerFilteringTransformer,options:{predicate:Legato.Predicate}});
Legato.Marker={};
Legato.Marker.PopupMarker=OpenLayers.Class(OpenLayers.Marker,{popup:null,initialize:function(c,b,a){OpenLayers.Marker.prototype.initialize.apply(this,arguments);
Legato.Util.Ensure.ensureExists(a,"popup should be defined");
this.popup=a
},destroy:function(){OpenLayers.Marker.prototype.destroy.apply(this,arguments);
this.popup=null
},draw:function(b){var a=OpenLayers.Marker.prototype.draw.apply(this,arguments);
if(this.map!==null){this.map.addPopup(this.popup)
}return a
},moveTo:function(b){var a=OpenLayers.Marker.prototype.moveTo.apply(this,arguments);
this.popup.moveTo(b);
return a
},erase:function(){var a=OpenLayers.Marker.prototype.erase.apply(this,arguments);
if(this.map!==null){this.map.removePopup(this.popup)
}return a
},CLASS_NAME:"Legato.Marker.PopupMarker"});
Legato.Control=OpenLayers.Class(OpenLayers.Control,{CLASS_NAME:"Legato.Control"});
Legato.Control.NAMESPACE_URI="http://www.disy.net/legato/control";
Legato.Control.PREFIX="lc";
Legato.Control.QName=function(a){return new Legato.XML.QName(Legato.Control.NAMESPACE_URI,a,Legato.Control.PREFIX)
};
Legato.Control.Bean=OpenLayers.Control.Bean.Extend("Legato.Control",Legato.Control.QName("Control"),{_constructor:Legato.Control});
Legato.Control.ArgParser=OpenLayers.Class(OpenLayers.Control.ArgParser,{bounds:null,initialize:function(a){OpenLayers.Control.ArgParser.prototype.initialize.apply(this,arguments)
},setMap:function(b){OpenLayers.Control.ArgParser.prototype.setMap.apply(this,arguments);
var a=this.getBounds();
if(Legato.OpenLayers.Map.Util.isValidBBox(a)){this.bounds=a;
this.map.events.register("legato.refresh",this,this.setBounds);
this.setBounds()
}else{this.bounds=null
}},getBounds:function(){var a=OpenLayers.Util.getParameters();
if(Legato.Lang.ObjectUtils.isNullOrUndefined(a.BBOX)||!Legato.Lang.ObjectUtils.isArray(a.BBOX)||a.BBOX.length!==4){return null
}try{return new OpenLayers.Bounds(Legato.Lang.NumberUtils.toFloat(a.BBOX[0]),Legato.Lang.NumberUtils.toFloat(a.BBOX[1]),Legato.Lang.NumberUtils.toFloat(a.BBOX[2]),Legato.Lang.NumberUtils.toFloat(a.BBOX[3]))
}catch(b){Legato.Util.Logger.getLogger().warn("Could not parse given parameter BBOX: "+a.BBOX+" into a valid Bounds object.");
Legato.Util.Logger.getLogger().warn(b);
return null
}},setBounds:function(){if(this.map.baseLayer){this.map.events.unregister("legato.refresh",this,this.setBounds);
this.map.setCenter(this.bounds.getCenterLonLat(),this.map.getZoomForExtent(this.bounds,true))
}},CLASS_NAME:"Legato.Control.ArgParser"});
Legato.Control.ArgParser.Bean=OpenLayers.Control.ArgParser.Bean.Extend("Legato.Control.ArgParser",Legato.Control.QName("ArgParser"),{_constructor:Legato.Control.ArgParser,options:{displayProjection:OpenLayers.Projection.Bean}});
Legato.Control.BBoxValueProvider=OpenLayers.Class(Legato.Control,{initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments)
},destroy:function(){this.map.events.un({moveend:this.propagateValue,scope:this});
OpenLayers.Control.prototype.destroy.apply(this,arguments)
},setMap:function(a){OpenLayers.Control.prototype.setMap.apply(this,arguments);
this.map.events.on({moveend:this.propagateValue,"legato.refresh":this.examineValue,scope:this})
},draw:function(){this.examineValue();
this.propagateValue();
return this.div
},examineValue:function(){if(!Legato.Lang.ObjectUtils.isFunction(this.getValue)){return
}var a=this.getValue();
if(Legato.OpenLayers.Map.Util.isValidBBox(a)&&Legato.OpenLayers.Map.Util.getBaseLayers(this.map.layers).length>0){this.map.zoomToExtent(a)
}},propagateValue:function(){if(!Legato.Lang.ObjectUtils.isFunction(this.setValue)){return
}var a=this.map.calculateBounds();
this.setValue(a)
},CLASS_NAME:"Legato.Control.BBoxValueProvider"});
Legato.Control.BBoxValueProvider.Bean=Legato.Control.Bean.Extend("Legato.Control.BBoxValueProvider",Legato.Control.QName("BBoxValueProvider"),{factoryFunction:function(e,a,b,d){var h=null;
var c=null;
var f=null;
var g=null;
if(Legato.Lang.ObjectUtils.isString(e)){h=OpenLayers.Util.getElement(e);
Legato.Util.Ensure.ensureExists(h,"BBoxValueProvider: The configured DOMElement with the id"+e+" could not been found.")
}if(Legato.Lang.ObjectUtils.isString(a)){c=OpenLayers.Util.getElement(a);
Legato.Util.Ensure.ensureExists(c,"BBoxValueProvider: The configured DOMElement with the id"+a+" could not been found.")
}if(Legato.Lang.ObjectUtils.isString(b)){f=OpenLayers.Util.getElement(b);
Legato.Util.Ensure.ensureExists(f,"BBoxValueProvider: The configured DOMElement with the id"+b+" could not been found.")
}if(Legato.Lang.ObjectUtils.isString(d)){g=OpenLayers.Util.getElement(d);
Legato.Util.Ensure.ensureExists(g,"BBoxValueProvider: The configured DOMElement with the id"+d+" could not been found.")
}return new Legato.Control.BBoxValueProvider({elements:{left:h,bottom:c,right:f,top:g},setValue:function(i){OpenLayers.Console.debug("BBoxValueProvider.setValue:"+i);
if(!Legato.Lang.ObjectUtils.exists(i)){return
}this.elements.left.value=i.left;
this.elements.right.value=i.right;
this.elements.top.value=i.top;
this.elements.bottom.value=i.bottom
},getValue:function(){OpenLayers.Console.debug("BBoxValueProvider.getValue");
try{var m=Legato.Lang.NumberUtils.toFloat(this.elements.left.value);
var k=Legato.Lang.NumberUtils.toFloat(this.elements.right.value);
var l=Legato.Lang.NumberUtils.toFloat(this.elements.top.value);
var i=Legato.Lang.NumberUtils.toFloat(this.elements.bottom.value);
return new OpenLayers.Bounds(m,i,k,l)
}catch(j){OpenLayers.Console.warn(j);
return new OpenLayers.Bounds(null,null,null,null)
}}})
},constructorArguments:{left:Legato.Lang.String,right:Legato.Lang.String,top:Legato.Lang.String,bottom:Legato.Lang.String},constructorOrder:["left","bottom","right","top"]});
Legato.Control.ControlContainer=OpenLayers.Class(Legato.Control,{type:OpenLayers.Control.TYPE_BUTTON,controls:null,panel_div:null,panel_div_ul:null,parentPanel:null,drawMode:null,menuDrawOptions:null,showActiveControl:false,activeControl:null,childControlActivateDeactivate:{activate:function(){},deactivate:function(){}},initialize:function(b){OpenLayers.Control.prototype.initialize.apply(this,[b]);
this.active=false;
if(!Legato.Lang.ObjectUtils.exists(this.drawMode)){this.drawMode=Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR
}if(Legato.Lang.StringUtils.isEmpty(b.displayClass)&&Legato.Lang.ObjectUtils.exists(this.controls)&&this.controls.length>0){this.activeControl=this.controls[0];
this.displayClass=this.activeControl.displayClass
}this.menuDrawOptions=OpenLayers.Util.extend({headerVisible:true,headerPropertyName:"title",iconVisible:true,iconPropertyName:"icon",titleVisible:true,titlePropertyName:"title",descriptionVisible:true,descriptionPropertyName:"description"},this.menuDrawOptions);
if(this.showActiveControl&&this.drawMode===Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR){var a=this;
this.childControlActivateDeactivate={activate:function(){var c=this.displayClass;
var f=this.panel_div;
var e=a.panel_div;
var d=a.displayClass;
e.className=e.className.replace(d,c);
a.displayClass=c;
a.activate();
a.activeControl=this
},deactivate:function(){a.deactivate()
}}
}this.createPanelDiv();
this.appendChildControls(this.controls)
},addControls:function(a){this.controls=this.controls.concat(a);
this.appendChildControls(a);
if(Legato.Lang.ObjectUtils.exists(this.parentPanel)){if(this.parentPanel.map){this.parentPanel.controls=this.parentPanel.controls.concat(a);
this.parentPanel.addControlsToMap(a)
}}},getPanelDiv:function(){return this.panel_div
},setParentPanel:function(a){this.parentPanel=a
},createPanelDiv:function(){this.panel_div=this.createControlPanelDiv(this);
OpenLayers.Element.addClass(this.panel_div,"ControlContainer");
var a=document.createElement("div");
a.style.display="none";
this.panel_div.appendChild(a);
switch(this.drawMode){case Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR:OpenLayers.Element.addClass(a,"ToolbarControlContainer");
break;
case Legato.Control.ControlContainer.DRAW_MODE_MENU:OpenLayers.Element.addClass(a,"MenuControlContainer");
this.appendHeader(a);
break
}this.panel_div_ul=document.createElement("ul");
a.appendChild(this.panel_div_ul);
this.onHoverPanelDiv(this.panel_div)
},createControlPanelDiv:function(a){var b=document.createElement("div");
OpenLayers.Element.addClass(b,a.displayClass+"ItemInactive");
OpenLayers.Element.addClass(b,"ItemInactive");
OpenLayers.Element.addClass(b,"olButton");
if(a.title!=""&&!b.title){b.title=a.title
}return b
},onHoverPanelDiv:function(a){a.onmouseover=function(){for(var b=0,c=this.children.length;
b<c;
b++){this.children[b].style.display="block"
}};
a.onmouseout=function(){for(var b=0,c=this.children.length;
b<c;
b++){this.children[b].style.display="none"
}}
},appendHeader:function(b){if(this.menuDrawOptions.headerVisible){var a=this[this.menuDrawOptions.headerPropertyName];
if(!Legato.Lang.StringUtils.isEmpty(a)){var c=document.createElement("div");
OpenLayers.Element.addClass(c,"MenuHeaderTitle");
c.innerHTML=a;
b.appendChild(c)
}}},appendChildControls:function(a){var d;
for(var b=0;
b<a.length;
b++){d=a[b];
d.events.on(this.childControlActivateDeactivate);
var c=this.createChildControlLi(d);
this.panel_div_ul.appendChild(c)
}},createChildControlLi:function(f){var e=document.createElement("li");
var d=null;
switch(this.drawMode){case Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR:d=this.createControlPanelDiv(f);
OpenLayers.Element.addClass(d,"ControlContainerToolbarItem");
break;
case Legato.Control.ControlContainer.DRAW_MODE_MENU:d=document.createElement("div");
OpenLayers.Element.addClass(d,"ControlContainerMenuItem");
OpenLayers.Element.addClass(d,f.displayClass);
OpenLayers.Element.addClass(d,"olButton");
var g=document.createElement("span");
OpenLayers.Element.addClass(g,"MenuIcon");
if(f.hasOwnProperty(this.menuDrawOptions.iconPropertyName)&&f[this.menuDrawOptions.iconPropertyName]!==null){g.style.backgroundImage="url("+f[this.menuDrawOptions.iconPropertyName]+")";
OpenLayers.Element.addClass(g,"CustomMenuIcon")
}d.appendChild(g);
var b=document.createElement("span");
if(this.menuDrawOptions.titleVisible&&f.hasOwnProperty(this.menuDrawOptions.titlePropertyName)){OpenLayers.Element.addClass(b,"MenuTitle");
b.innerHTML=f[this.menuDrawOptions.titlePropertyName];
d.appendChild(b)
}if(this.menuDrawOptions.descriptionVisible&&f.hasOwnProperty(this.menuDrawOptions.descriptionPropertyName)){var a=document.createElement("span");
OpenLayers.Element.addClass(a,"MenuSubTitle");
a.innerHTML=f[this.menuDrawOptions.descriptionPropertyName];
d.appendChild(a)
}else{OpenLayers.Element.addClass(b,"WithoutSubTitle")
}break;
default:throw new Legato.Lang.Exception("Invalid ControlContainer.drawMode = ["+this.drawMode+"].")
}f.panel_div=d;
e.appendChild(d);
var c=this;
e.onmouseup=function(){c.hideChildren(c.panel_div)
};
return e
},destroy:function(){for(var b=0,a=this.controls.length;
b<a;
b++){if(Legato.Lang.ObjectUtils.exists(this.controls[b].events)){this.controls[b].events.un(this.childControlActivateDeactivate)
}}OpenLayers.Control.prototype.destroy.apply(this,arguments)
},trigger:function(){if(Legato.Lang.ObjectUtils.exists(this.activeControl)){this.parentPanel.activateControl(this.activeControl);
if(!Legato.Util.Browser.isTouchCapable()){this.hideChildren(this.panel_div)
}}},hideChildren:function(b){for(var a=0,c=b.children.length;
a<c;
a++){b.children[a].style.display="none"
}},CLASS_NAME:"Legato.Control.ControlContainer"});
Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR="TOOLBAR";
Legato.Control.ControlContainer.DRAW_MODE_MENU="MENU";
Legato.Control.ControlContainer.Bean=Legato.Control.Bean.Extend("Legato.Control.ControlContainer",Legato.Control.QName("ControlContainer"),{_constructor:Legato.Control.ControlContainer,options:{displayClass:Legato.Lang.String,controls:OpenLayers.Control.Bean.List(),drawMode:Legato.Lang.String.Enum("Legato.Control.ControlContainer.DRAW_MODE",{TOOLBAR:Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR,MENU:Legato.Control.ControlContainer.DRAW_MODE_MENU}),menuDrawOptions:Legato.Beans.Object.Map(),showActiveControl:Legato.Lang.Boolean}});
Legato.Control.ControlFunction=OpenLayers.Class(Legato.Control,{type:OpenLayers.Control.TYPE_BUTTON,initialize:function(a){Legato.Control.prototype.initialize.apply(this,arguments);
Legato.Util.Ensure.ensureFunction(this.callback,"To use "+this.CLASS_NAME+" you must specify a callback function.")
},trigger:function(){this.callback(this.map)
},CLASS_NAME:"Legato.Control.ControlFunction"});
Legato.Control.ControlFunction.Bean=Legato.Control.Bean.Extend("Legato.Control.ControlFunction",Legato.Control.QName("ControlFunction"),{_constructor:Legato.Control.ControlFunction,options:{callback:Legato.Lang.Function,displayClass:Legato.Lang.String}});
Legato.Control.ControlSwitcher=OpenLayers.Class(Legato.Control,{initialize:function(a,c,b){this.controls=a;
this.defaultControl=c;
OpenLayers.Control.prototype.initialize.apply(this,[b])
},destroy:function(){for(var a=0;
a<this.controls.length;
a++){this.controls[a].events.un({activate:this.onControlActivate,deactivate:this.onControlDeactivate,scope:this})
}OpenLayers.Control.prototype.destroy.apply(this,arguments)
},onControlActivate:function(b){for(var a=0;
a<this.controls.length;
a++){if(this.controls[a].active&&this.controls[a].id!=b.object.id){this.controls[a].deactivate()
}}},onControlDeactivate:function(b){if(Legato.Lang.ObjectUtils.exists(this.defaultControl)){var c=false;
for(var a=0;
a<this.controls.length;
a++){if(this.controls[a].active){c=true;
break
}}if(!c){this.defaultControl.activate()
}}},setMap:function(b){OpenLayers.Control.prototype.setMap.apply(this,arguments);
for(var a=0;
a<this.controls.length;
a++){this.controls[a].events.on({activate:this.onControlActivate,deactivate:this.onControlDeactivate,scope:this})
}if(Legato.Lang.ObjectUtils.exists(this.defaultControl)){this.defaultControl.activate()
}},draw:function(){return this.div
},CLASS_NAME:"Legato.Control.ControlSwitcher"});
Legato.Control.ControlSwitcher.Bean=Legato.Control.Bean.Extend("Legato.Control.ControlSwitcher",Legato.Control.QName("ControlSwitcher"),{factoryFunction:function(a,d,b){Legato.Util.Ensure.ensureExists(a,"ControlSwitcher: To use the ControlSwitcher control you must configure at least one legato control.");
if(Legato.Lang.ObjectUtils.isArray(a)){for(var c=0;
c<a.length;
c++){Legato.Util.Ensure.ensureObject(a[c],"ControlSwitcher: All configured controls which are passed to the ControlSwitcher Class must be objetcs.")
}}if(Legato.Lang.ObjectUtils.exists(d)){Legato.Util.Ensure.ensureObject(d,"ControlSwitcher: If a defaultControl has been configured it needs to be a legato control as well.")
}OpenLayers.Console.debug("Creating ControlSwitcher with: "+a);
return new Legato.Control.ControlSwitcher(a,d,b)
},constructorArguments:{controls:OpenLayers.Control.Bean.List(),defaultControl:OpenLayers.Control.Bean},constructorOrder:["controls","defaultControl"]});
Legato.Control.DefaultBaseLayer=OpenLayers.Class(Legato.Control,{defaultLayerAdded:false,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments);
Legato.Util.Ensure.ensureExists(this.layer);
this.layer.options.legatoIgnore=true;
this.defaultLayerAdded=false
},destroy:function(){this.map.events.un({addlayer:this.ensureBaseLayer,removelayer:this.ensureBaseLayer,scope:this});
OpenLayers.Control.prototype.destroy.apply(this,arguments)
},setMap:function(a){OpenLayers.Control.prototype.setMap.apply(this,arguments);
this.map.events.on({addlayer:this.ensureBaseLayer,removelayer:this.ensureBaseLayer,scope:this})
},draw:function(){this.ensureBaseLayer();
return this.div
},ensureBaseLayer:function(a){var b=Legato.OpenLayers.Map.Util.getBaseLayers(this.map.layers);
if(!this.defaultLayerAdded&&b.length!==0){if(Legato.Lang.ObjectUtils.exists(a)&&Legato.Lang.ObjectUtils.exists(a.layer)&&a.layer.isBaseLayer){this.layer.projection=a.layer.projection
}return
}if(this.defaultLayerAdded&&b.length!=1){this.map.removeLayer(this.layer);
this.defaultLayerAdded=false;
return
}if(this.defaultLayerAdded===false){this.map.addLayer(this.layer);
this.defaultLayerAdded=true
}},CLASS_NAME:"Legato.Control.DefaultBaseLayer"});
Legato.Control.DefaultBaseLayer.Bean=Legato.Control.Bean.Extend("Legato.Control.DefaultBaseLayer",Legato.Control.QName("DefaultBaseLayer"),{_constructor:Legato.Control.DefaultBaseLayer,options:{layer:OpenLayers.Layer.Bean}});
Legato.Control.DrawFeature=OpenLayers.Class(OpenLayers.Control.DrawFeature,{mode:1,callback:null,style:null,attributes:{},handlerConstructor:null,initialize:function(b,a){this.callbacks=OpenLayers.Util.extend({point:function(c,d){this.layer.events.triggerEvent("legato.sketchpointadded",{layer:this.layer,vertex:c,geometry:d})
}},this.callbacks);
this.handlerOptions=OpenLayers.Util.extend({freehandToggle:null,layerOptions:{isFeatureLayer:true}},a.handlerOptions);
this.style=a.style||null;
this.attributes=a.attributes||{};
OpenLayers.Control.DrawFeature.prototype.initialize.apply(this,[b,this.handlerConstructor,a]);
b.events.on({"legato.sketchupdated":this.onSketchUpdated,scope:this})
},destroy:function(){OpenLayers.Control.DrawFeature.prototype.destroy.apply(this,arguments)
},setMap:function(a){OpenLayers.Control.DrawFeature.prototype.setMap.apply(this,arguments)
},drawFeature:function(e){var a=OpenLayers.Util.extend({},this.attributes);
var c=!Legato.Lang.ObjectUtils.isEmptyObject(this.style)?OpenLayers.Util.extend({},this.style):null;
var b=new OpenLayers.Feature.Vector(e,a,c);
var d=this.layer.events.triggerEvent("sketchcomplete",{feature:b});
if(d!==false){b.state=OpenLayers.State.INSERT;
if(this.mode==1){this.layer.addFeatures([b]);
this.featureAdded(b);
this.events.triggerEvent("featureadded",{feature:b})
}if(this.mode==2){this.layer.destroyFeatures();
this.layer.addFeatures([b]);
this.featureAdded(b);
this.events.triggerEvent("featureadded",{feature:b})
}}if(Legato.Lang.ObjectUtils.isFunction(this.callback)){this.callback(e)
}},onSketchUpdated:function(a){if(this.handler.drawing){this.handler.drawFeature()
}else{this.layer.redraw()
}},CLASS_NAME:"Legato.Control.DrawFeature"});
Legato.Control.DrawFeature.MODE_ADD_FEATURE=1;
Legato.Control.DrawFeature.MODE_REPLACE_FEATURE=2;
Legato.Control.DrawFeature.Bean=OpenLayers.Control.DrawFeature.Bean.Extend("Legato.Control.DrawFeature",Legato.Control.QName("DrawFeature"),{_constructor:Legato.Control.DrawFeature,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"],options:{mode:Legato.Lang.Integer.Enum("Legato.Control.DrawFeature.MODE",{MODE_ADD_FEATURE:1,MODE_REPLACE_FEATURE:2}),callback:Legato.Lang.Function}});
Legato.Control.DrawBox=OpenLayers.Class(Legato.Control.DrawFeature,{handlerConstructor:Legato.Handler.Box,CLASS_NAME:"Legato.Control.DrawBox"});
Legato.Control.DrawBox.Bean=Legato.Control.DrawFeature.Bean.Extend("Legato.Control.DrawBox",Legato.Control.QName("DrawBox"),{_constructor:Legato.Control.DrawBox,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"]});
Legato.Control.DrawPoint=OpenLayers.Class(Legato.Control.DrawFeature,{handlerConstructor:Legato.Handler.Point,initialize:function(b,a){var c=this;
this.callbacks={done:function(d){this.layer.events.triggerEvent("legato.sketchpointadded",{layer:this.layer,vertex:this.handler.point.geometry,geometry:d});
c.drawFeature(d)
}};
Legato.Control.DrawFeature.prototype.initialize.apply(this,[b,a])
},CLASS_NAME:"Legato.Control.DrawPoint"});
Legato.Control.DrawPoint.Bean=Legato.Control.DrawFeature.Bean.Extend("Legato.Control.DrawPoint",Legato.Control.QName("DrawPoint"),{_constructor:Legato.Control.DrawPoint,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"]});
Legato.Control.DrawLineString=OpenLayers.Class(Legato.Control.DrawFeature,{handlerConstructor:Legato.Handler.Path,CLASS_NAME:"Legato.Control.DrawLineString"});
Legato.Control.DrawLineString.Bean=Legato.Control.DrawFeature.Bean.Extend("Legato.Control.DrawLineString",Legato.Control.QName("DrawLineString"),{_constructor:Legato.Control.DrawLineString,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"]});
Legato.Control.DrawPolygon=OpenLayers.Class(Legato.Control.DrawFeature,{handlerConstructor:Legato.Handler.Polygon,CLASS_NAME:"Legato.Control.DrawPolygon"});
Legato.Control.DrawPolygon.Bean=Legato.Control.DrawFeature.Bean.Extend("Legato.Control.DrawPolygon",Legato.Control.QName("DrawPolygon"),{_constructor:Legato.Control.DrawPolygon,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"]});
Legato.Control.DrawCircle=OpenLayers.Class(Legato.Control.DrawFeature,{handlerConstructor:Legato.Handler.RegularPolygon,measureDiv:null,initialize:function(b,a){if(a.measureDiv){this.showLength=a.showLength;
var c={move:this.measureRadius};
this.callbacks=OpenLayers.Util.extend(c,this.callbacks)
}if(Legato.Lang.ObjectUtils.exists(a.handlerOptions)){if(!Legato.ObjectUtils.exists(a.handlerOptions.sides)){a.handlerOptions=OpenLayers.Util.extend(a.handlerOptions,{sides:100})
}}else{a.handlerOptions={sides:100}
}Legato.Control.DrawFeature.prototype.initialize.apply(this,[b,a])
},measureRadius:function(c){var a=this.getRadius(c);
var b="Radius "+a[0]+" "+a[1];
this.measureDiv.innerHTML=b
},getRadius:function(g){var c=["km","m"];
var f,e,b;
for(var d=0,a=c.length;
d<a;
++d){f=c[d];
e=this.getLength(g,f);
b=(e/(2*Math.PI));
if(b>1){break
}}return[OpenLayers.Number.format(e/(2*Math.PI),3,".",","),f]
},getLength:function(f,a){var b=f.getLength();
var c=this.map.getUnits();
var e=OpenLayers.INCHES_PER_UNIT[a];
if(e){var d=OpenLayers.INCHES_PER_UNIT[c];
b*=(d/e)
}return b
},deactivate:function(){if(this.measureDiv){this.measureDiv.innerHTML=""
}Legato.Control.DrawFeature.prototype.deactivate.apply(this,arguments)
},CLASS_NAME:"Legato.Control.DrawCircle"});
Legato.Control.DrawCircle.Bean=Legato.Control.DrawFeature.Bean.Extend("Legato.Control.DrawCircle",Legato.Control.QName("DrawCircle"),{_constructor:Legato.Control.DrawCircle,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"]});
Legato.Control.DrawMultiPoint=OpenLayers.Class(Legato.Control.DrawFeature,{handlerConstructor:Legato.Handler.MultiPoint,mode:1,initialize:function(b,a){var c=this;
this.callbacks={done:function(d){this.layer.events.triggerEvent("legato.sketchpointadded",{layer:this.layer,vertex:this.handler.point.geometry,geometry:d});
c.drawFeature(d)
}};
Legato.Control.DrawFeature.prototype.initialize.apply(this,[b,a])
},CLASS_NAME:"Legato.Control.DrawMultiPoint"});
Legato.Control.DrawMultiPoint.Bean=Legato.Control.DrawFeature.Bean.Extend("Legato.Control.DrawMultiPoint",Legato.Control.QName("DrawMultiPoint"),{_constructor:Legato.Control.DrawMultiPoint,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"]});
Legato.Control.DrawMultiLineString=OpenLayers.Class(Legato.Control.DrawFeature,{handlerConstructor:Legato.Handler.MultiLineString,mode:1,initialize:function(b,a){var c=this;
this.callbacks={done:function(d){this.layer.events.triggerEvent("legato.sketchpointadded",{layer:this.layer,vertex:this.handler.point.geometry,geometry:d});
c.drawFeature(d)
}};
Legato.Control.DrawFeature.prototype.initialize.apply(this,[b,a])
},CLASS_NAME:"Legato.Control.DrawMultiLineString"});
Legato.Control.DrawMultiLineString.Bean=Legato.Control.DrawFeature.Bean.Extend("Legato.Control.DrawMultiLineString",Legato.Control.QName("DrawMultiLineString"),{_constructor:Legato.Control.DrawMultiLineString,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"]});
Legato.Control.DrawMultiPolygon=OpenLayers.Class(Legato.Control.DrawFeature,{handlerConstructor:Legato.Handler.MultiPolygon,mode:1,initialize:function(b,a){var c=this;
this.callbacks={done:function(d){this.layer.events.triggerEvent("legato.sketchpointadded",{layer:this.layer,vertex:this.handler.point.geometry,geometry:d});
c.drawFeature(d)
}};
Legato.Control.DrawFeature.prototype.initialize.apply(this,[b,a])
},CLASS_NAME:"Legato.Control.DrawMultiPolygon"});
Legato.Control.DrawMultiPolygon.Bean=Legato.Control.DrawFeature.Bean.Extend("Legato.Control.DrawMultiPolygon",Legato.Control.QName("DrawMultiPolygon"),{_constructor:Legato.Control.DrawMultiPolygon,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"]});
Legato.Control.DrawText=OpenLayers.Class(Legato.Control.DrawPoint,{handlerConstructor:Legato.Handler.Point,textPrompt:function(b){var a=prompt(Legato.I18n.getMessage("Legato.Control.DrawText.TextPrompt"),"TEXT");
b(a)
},initialize:function(b,a){Legato.Control.DrawPoint.prototype.initialize.apply(this,[b,a])
},drawFeature:function(b){var a=this;
this.textPrompt(function(d){if(!Legato.Lang.StringUtils.isEmpty(d)){var c=OpenLayers.Util.extend({},a.attributes);
var f=a.style!==null?OpenLayers.Util.extend({},a.style):null;
var e=new OpenLayers.Feature.Vector(b,c,f);
e.style.label=d;
var g=a.layer.events.triggerEvent("sketchcomplete",{feature:e});
if(g!==false){e.state=OpenLayers.State.INSERT;
if(a.mode==1){a.layer.addFeatures([e]);
a.featureAdded(e);
a.events.triggerEvent("featureadded",{feature:e})
}if(a.mode==2){a.layer.destroyFeatures();
a.layer.addFeatures([e]);
a.featureAdded(e);
a.events.triggerEvent("featureadded",{feature:e})
}}if(Legato.Lang.ObjectUtils.isFunction(this.callback)){a.callback(b)
}}})
},CLASS_NAME:"Legato.Control.DrawText"});
Legato.Control.DrawPoint.Bean=Legato.Control.DrawFeature.Bean.Extend("Legato.Control.DrawText",Legato.Control.QName("DrawText"),{_constructor:Legato.Control.DrawPoint,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"]});
Legato.Control.ExtendedPanel=OpenLayers.Class(OpenLayers.Control.Panel,{visibleControls:[],addControls:function(b){if(!(OpenLayers.Util.isArray(b))){b=[b]
}var d=[];
this.visibleControls=this.visibleControls.concat(b);
this.controls=this.controls.concat(b);
for(var c=0,a=b.length;
c<a;
c++){var e=b[c];
if(this.isControlContainer(e)){e.setParentPanel(this);
this.controls=this.controls.concat(e.controls);
d=d.concat(e.controls)
}else{e.panel_div=this.createControlPanelDiv(e)
}}if(this.map){this.addControlsToMap(b.concat(d));
this.redraw()
}},iconOn:function(){OpenLayers.Control.Panel.prototype.iconOn.apply(this,arguments);
OpenLayers.Element.removeClass(this.panel_div,"ItemInactive");
OpenLayers.Element.addClass(this.panel_div,"ItemActive")
},iconOff:function(){OpenLayers.Control.Panel.prototype.iconOff.apply(this,arguments);
OpenLayers.Element.removeClass(this.panel_div,"ItemActive");
OpenLayers.Element.addClass(this.panel_div,"ItemInactive")
},redraw:function(){for(var b=this.div.childNodes.length,d=b-1;
d>=0;
d--){this.div.removeChild(this.div.childNodes[d])
}this.div.innerHTML="";
if(this.active){for(var c=0,a=this.visibleControls.length;
c<a;
c++){this.div.appendChild(this.visibleControls[c].panel_div)
}}},createControlPanelDiv:function(a){var b=document.createElement("div");
OpenLayers.Element.addClass(b,a.displayClass+"ItemInactive");
OpenLayers.Element.addClass(b,"ItemInactive");
OpenLayers.Element.addClass(b,"olButton");
if(a.title!=""&&!b.title){b.title=a.title
}return b
},isControlContainer:function(a){return"Legato.Control.ControlContainer"===a.CLASS_NAME||"LegatoJQuery.Control.ControlContainer"===a.CLASS_NAME
},CLASS_NAME:"Legato.Control.ExtendedPanel"});
Legato.Control.ExtendedPanel.Bean=OpenLayers.Control.Panel.Bean.Extend("Legato.Control.ExtendedPanel",Legato.Control.QName("ExtendedPanel"),{_constructor:Legato.Control.ExtendedPanel});
Legato.Control.FeatureSelector=OpenLayers.Class(Legato.Control,{type:OpenLayers.Control.TYPE_TOOL,eventTypes:["addlayer","removelayer","changebaselayer","legato.selectlayer","legato.deselectlayer"],layerPredicate:null,controller:null,callback:null,exceptionHandler:null,handlerConstructor:Legato.Handler.Box,enabled:false,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments);
if(!Legato.Lang.ObjectUtils.isFunction(this.callback)){this.callback=function(b){}
}if(!Legato.Lang.ObjectUtils.isFunction(this.exceptionHandler)){this.exceptionHandler=function(c,b){alert(c)
}
}if(!Legato.Lang.ObjectUtils.isFunction(this.controller)){this.controller=function(c,e,d,b){return b.callback({layers:c,selectionGeometry:e,mode:d})
}
}if(!Legato.Lang.ObjectUtils.isObject(this.layerPredicate)){this.layerPredicate=new Legato.Predicate.True()
}},createHandlers:function(){this.handlers={};
this.handlers.clickNone=new this.handlerConstructor(this,{done:OpenLayers.Function.bind(this.selectGeometry,this,OpenLayers.Handler.MOD_NONE)},{keyMask:OpenLayers.Handler.MOD_NONE});
this.handlers.clickShift=new this.handlerConstructor(this,{done:OpenLayers.Function.bind(this.selectGeometry,this,OpenLayers.Handler.MOD_SHIFT)},{keyMask:OpenLayers.Handler.MOD_SHIFT});
this.handlers.clickCtrl=new this.handlerConstructor(this,{done:OpenLayers.Function.bind(this.selectGeometry,this,OpenLayers.Handler.MOD_CTRL)},{keyMask:OpenLayers.Handler.MOD_CTRL})
},destroy:function(){for(var a=0;
a<this.eventTypes.length;
a++){var b=this.eventTypes[a];
this.map.events.unregister(b,this,this.refresh)
}this.layerPredicate=null;
this.controller=null;
this.handlerConstructor=null;
this.enabled=false;
this.handlers.clickNone.destroy();
this.handlers.clickCtrl.destroy();
this.handlers.clickShift.destroy();
OpenLayers.Control.prototype.destroy.apply(this,arguments)
},getLayers:function(){var c=[];
for(var a=0;
a<this.map.layers.length;
a++){var b=this.map.layers[a];
if(this.layerPredicate.evaluate(b)){c.push(b)
}}return c
},selectGeometry:function(b,a){this.controller(this.getLayers(),a,b,{callback:this.callback,exceptionHandler:this.exceptionHandler})
},addStatusCssClass:function(a){if(this.enabled){OpenLayers.Element.addClass(a,"enabled")
}else{OpenLayers.Element.addClass(a,"disabled")
}},removeStatusCssClass:function(a){if(this.enabled){OpenLayers.Element.removeClass(a,"enabled")
}else{OpenLayers.Element.removeClass(a,"disabled")
}},refresh:function(){var a=this.getLayers();
this.enabled=(a.length>0);
if(!this.enabled){OpenLayers.Element.removeClass(this.panel_div,"enabled");
OpenLayers.Element.addClass(this.panel_div,"disabled");
this.deactivate()
}else{OpenLayers.Element.removeClass(this.panel_div,"disabled");
OpenLayers.Element.addClass(this.panel_div,"enabled")
}},activate:function(){this.removeStatusCssClass(this.panel_div);
if(this.enabled){this.handlers.clickNone.activate();
this.handlers.clickCtrl.activate();
this.handlers.clickShift.activate();
OpenLayers.Control.prototype.activate.apply(this,arguments)
}this.addStatusCssClass(this.panel_div)
},deactivate:function(){this.removeStatusCssClass(this.panel_div);
this.handlers.clickNone.deactivate();
this.handlers.clickCtrl.deactivate();
this.handlers.clickShift.deactivate();
OpenLayers.Control.prototype.deactivate.apply(this,arguments);
this.addStatusCssClass(this.panel_div)
},setMap:function(c){OpenLayers.Control.prototype.setMap.apply(this,arguments);
if(!Legato.Lang.ObjectUtils.isObject(this.handlers)){this.createHandlers()
}for(var a=0;
a<this.eventTypes.length;
a++){var b=this.eventTypes[a];
this.map.events.register(b,this,this.refresh)
}this.refresh()
},CLASS_NAME:"Legato.Control.FeatureSelector"});
Legato.Control.FeatureSelector.Bean=Legato.Control.Bean.Extend("Legato.Control.FeatureSelector",Legato.Control.QName("FeatureSelector"),{_constructor:Legato.Control.FeatureSelector,options:{layerPredicate:Legato.Beans.Object,controller:Legato.Lang.Function,callback:Legato.Lang.Function,exceptionHandler:Legato.Lang.Function,eventTypes:Legato.Lang["String[]"]}});
Legato.Control.LayersValueProvider=OpenLayers.Class(Legato.Control,{initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments)
},destroy:function(){this.map.events.un({addlayer:this.propagateValue,changelayer:this.propagateValue,removelayer:this.propagateValue,changebaselayer:this.propagateValue,scope:this});
OpenLayers.Control.prototype.destroy.apply(this,arguments)
},setMap:function(a){OpenLayers.Control.prototype.setMap.apply(this,arguments);
this.map.events.on({addlayer:this.propagateValue,changelayer:this.propagateValue,removelayer:this.propagateValue,changebaselayer:this.propagateValue,scope:this})
},draw:function(){this.propagateValue();
return this.div
},propagateValue:function(){if(!Legato.Lang.ObjectUtils.isFunction(this.setValue)){return
}this.setValue(this.map.layers)
},CLASS_NAME:"Legato.Control.LayersValueProvider"});
Legato.Control.LayersValueProvider.Bean=Legato.Control.Bean.Extend("Legato.Control.LayersValueProvider",Legato.Control.QName("LayersValueProvider"),{factoryFunction:function(e,b,f){var d=null;
var c=null;
var a=null;
if(Legato.Lang.ObjectUtils.isString(e)){d=OpenLayers.Util.getElement(e);
Legato.Util.Ensure.ensureExists(d,"LayersValueProvider: The configured DOMElement with the id"+e+" could not been found.")
}if(Legato.Lang.ObjectUtils.isString(b)){c=OpenLayers.Util.getElement(b);
Legato.Util.Ensure.ensureExists(c,"LayersValueProvider: The configured DOMElement with the id"+b+" could not been found.")
}if(Legato.Lang.ObjectUtils.isString(f)){a=OpenLayers.Util.getElement(f);
Legato.Util.Ensure.ensureExists(a,"LayersValueProvider: The configured DOMElement with the id"+f+" could not been found.")
}return new Legato.Control.LayersValueProvider({elements:{layerList:d,layerListVisible:c,layerListInvisible:a},setValue:function(g){if(!Legato.Lang.ObjectUtils.exists(g)){return
}this.elements.layerList.value=Legato.Lang.CollectionUtils.transform(g,function(h){return h.name
}).toString();
this.elements.layerListVisible.value=Legato.Lang.CollectionUtils.transform(Legato.OpenLayers.Map.Util.getVisibleLayers(g),function(h){return h.name
}).toString();
this.elements.layerListInvisible.value=Legato.Lang.CollectionUtils.transform(Legato.OpenLayers.Map.Util.getInvisibleLayers(g),function(h){return h.name
}).toString()
}})
},constructorArguments:{layerList:Legato.Lang.String,layerListVisible:Legato.Lang.String,layerListInvisible:Legato.Lang.String},constructorOrder:["layerList","layerListVisible","layerListInvisible"]});
Legato.Control.LayerSelection=OpenLayers.Class({map:null,initialize:function(a){this.map=a;
this.map.selectLayer=OpenLayers.Function.bind(this.selectLayer,this);
this.map.deselectLayer=OpenLayers.Function.bind(this.deselectLayer,this)
},selectLayer:function(a){for(var c=0;
c<this.map.layers.length;
c++){var b=this.map.layers[c];
if(Legato.Lang.ObjectUtils.isTrue(b.selected)){b.selected=false;
this.map.events.triggerEvent("legato.deselectlayer",{layer:b})
}}if(Legato.Lang.ObjectUtils.exists(a)){if(Legato.Lang.ObjectUtils.isFalse(a.selected)){a.selected=true;
this.map.events.triggerEvent("legato.selectlayer",{layer:a})
}}},deselectLayer:function(a){if(Legato.Lang.ObjectUtils.exists(a)){if(Legato.Lang.ObjectUtils.isTrue(a.selected)){a.selected=false;
this.map.events.triggerEvent("legato.deselectlayer",{layer:a})
}}},destroy:function(){this.map.selectLayer=null
},CLASS_NAME:"Legato.Control.LayerSelection"});
Legato.Control.LayerSelection.Bean=Legato.Beans.Object.Extend("Legato.Control.LayerSelection",Legato.Control.QName("LayerSelection"),{_constructor:Legato.Control.LayerSelection,constructorArguments:{map:OpenLayers.Map.Bean},constructorOrder:["map"]});
Legato.Control.SketchLayerEditor=OpenLayers.Class(Legato.Control,{map:null,layer:null,styles:null,div:null,measureDiv:null,container:null,controlsPanel:null,stylePropertiesEditor:null,executeCallback:null,cancelCallback:null,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments)
},destroy:function(){OpenLayers.Control.prototype.destroy.apply(this,arguments);
this.unregisterLayerEvents()
},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);
return this.div
},getStyles:function(){var a=Legato.Feature.Sketch.style["default"];
if(this.styles){for(var b=0;
b<this.styles.length;
b++){var d=this.styles[b];
var c=d.name.toUpperCase();
if(a[c]){OpenLayers.Util.extend(a[c],d.styles)
}}}return a
},execute:function(e,d,a){this.executeCallback=e;
this.cancelCallback=d;
if(this.layer!==null){return
}var c={calculateInRange:function(){return true
},legatoIgnore:true,isFeatureLayer:true};
var b=Legato.I18n.getMessage("Legato.Control.SketchLayerEditor.LayerName");
this.layer=new OpenLayers.Layer.Vector(b,c);
this.registerLayerEvents();
this.map.addLayer(this.layer);
this.createForm(e,d,a)
},createForm:function(q,l,a){if(this.container===null){this.container=document.createElement("div");
this.container.className="sketchLayerEditorContainer"
}var j=document.createElement("div");
j.className="sketchLayerEditorAbstract";
j.innerHTML=Legato.I18n.getMessage("Legato.Control.SketchLayerEditor.Abstract");
this.container.appendChild(j);
this.controls=[];
var e=document.createElement("div");
e.className="sketchLayerEditorControlsContainer";
this.container.appendChild(e);
var f=document.createElement("div");
OpenLayers.Element.addClass(f,"olControlPanel");
e.appendChild(f);
if(Legato.Lang.ObjectUtils.exists(this.stylePropertiesEditor)){var g=document.createElement("div");
OpenLayers.Element.addClass(g,"legatoStylesPanel");
e.appendChild(g);
this.stylePropertiesEditor.setLayer(this.layer);
g.appendChild(this.stylePropertiesEditor.div);
var c=document.createElement("div");
c.className="radiusMeasureStatus";
e.appendChild(c);
this.measureDiv=c
}var o=this.createDrawControl("TEXT",Legato.I18n.getMessage("Legato.Control.SketchLayerEditor.Text"),Legato.Control.DrawText);
var s=this.createDrawControl("POINT",Legato.I18n.getMessage("Legato.Control.SketchLayerEditor.Point"),Legato.Control.DrawPoint);
var t=this.createDrawControl("LINE",Legato.I18n.getMessage("Legato.Control.SketchLayerEditor.Line"),Legato.Control.DrawMultiLineString);
var n=this.createDrawControl("POLYGON",Legato.I18n.getMessage("Legato.Control.SketchLayerEditor.Polygon"),Legato.Control.DrawPolygon);
var d=this.createDrawCircleControl("POLYGON",Legato.I18n.getMessage("Legato.Control.SketchLayerEditor.Circle"));
var k=new Legato.Control.ModifyMultiPolygon(this.layer,{title:Legato.I18n.getMessage("Legato.Control.SketchLayerEditor.Edit"),mode:Legato.Control.ModifyFeature.MODE_RESHAPE,type:OpenLayers.Control.TYPE_TOOL});
var m=new OpenLayers.Control.DeleteFeature(this.layer,this.onDeleteFeatureSelect,this.onDeleteFeatureUnselect,{title:Legato.I18n.getMessage("Legato.Control.SketchLayerEditor.Delete"),type:OpenLayers.Control.TYPE_TOOL});
var p={div:f,defaultControl:s};
this.controlsPanel=new OpenLayers.Control.Panel(p);
this.controlsPanel.addControls([o,s,t,n,d,k,m]);
for(var r=0;
r<this.controlsPanel.controls.length;
r++){this.controlsPanel.controls[r].events.on({activate:this.onActivate,deactivate:this.onDeactivate,scope:this})
}this.map.addControl(this.controlsPanel);
var u=document.createElement("div");
u.className="sketchLayerEditorButtons";
this.container.appendChild(u);
var b=document.createElement("input");
b.type="button";
b.value=Legato.I18n.getMessage("Legato.Control.SketchLayerEditor.Execute");
b.onclick=OpenLayers.Function.bindAsEventListener(this.executeButtonClicked,this);
u.appendChild(b);
if(!a){var h=document.createElement("input");
h.type="button";
h.value=Legato.I18n.getMessage("Legato.Control.SketchLayerEditor.Cancel");
h.onclick=OpenLayers.Function.bindAsEventListener(this.cancelButtonClicked,this);
u.appendChild(h)
}this.div.appendChild(this.container)
},createDrawControl:function(c,e,d){var b=this.createStyle(c);
var a=this.createAttributesMap(c);
return new d(this.layer,{title:e,type:OpenLayers.Control.TYPE_TOOL,style:b,attributes:a})
},createDrawCircleControl:function(c,d){var b=this.createStyle(c);
var a=this.createAttributesMap(c);
return new Legato.Control.DrawCircle(this.layer,{title:d,type:OpenLayers.Control.TYPE_TOOL,style:b,attributes:a,measureDiv:this.measureDiv})
},createStyle:function(b){var a=this.getStyles();
return OpenLayers.Util.extend({"x-type":b},a[b])
},createAttributesMap:function(c){var d=Legato.Feature.Sketch.Attributes[c];
var a={"x-type":c};
for(var b=0;
b<d.length;
b++){a[d[b]]=null
}return a
},onDeactivate:function(a){this.events.triggerEvent("deactivate",{component:this});
if(Legato.Lang.ObjectUtils.exists(this.stylePropertiesEditor)){this.stylePropertiesEditor.deactivate()
}},onActivate:function(b){this.events.triggerEvent("activate",{component:this});
var a=b.object.style;
if(Legato.Lang.ObjectUtils.exists(this.stylePropertiesEditor)){if(Legato.Lang.ObjectUtils.exists(a)){this.stylePropertiesEditor.setStyle(a);
this.stylePropertiesEditor.activate()
}else{this.stylePropertiesEditor.deactivate()
}}},activate:function(){if(this.controlsPanel){this.controlsPanel.activate()
}},deactivate:function(){if(this.controlsPanel){for(var a=0;
a<this.controlsPanel.controls.length;
a++){this.controlsPanel.controls[a].deactivate()
}this.controlsPanel.redraw()
}},executeButtonClicked:function(){var a=this.getSketchLayerAsGeoJSON();
this.executeCallback(a)
},cancelButtonClicked:function(){this.cancelCallback()
},onDeleteFeatureSelect:function(b){var c=b.attributes["x-type"];
var a=Legato.Feature.Sketch.style.select;
OpenLayers.Util.extend(b.style,a[c]);
this.layer.redraw()
},onDeleteFeatureUnselect:function(b){var c=b.attributes["x-type"];
var a=Legato.Feature.Sketch.style["default"];
OpenLayers.Util.extend(b.style,a[c]);
this.layer.redraw()
},onBeforeFeatureModified:function(b){var a=b.feature.style;
if(Legato.Lang.ObjectUtils.exists(this.stylePropertiesEditor)){if(Legato.Lang.ObjectUtils.exists(a)){this.stylePropertiesEditor.setStyle(a);
this.stylePropertiesEditor.activate()
}else{this.stylePropertiesEditor.deactivate()
}}},registerLayerEvents:function(){this.layer.events.on({beforefeaturemodified:this.onBeforeFeatureModified,scope:this})
},unregisterLayerEvents:function(){this.layer.events.un({beforefeaturemodified:this.onBeforeFeatureModified,scope:this})
},getSketchLayerAsGeoJSON:function(){var f=new OpenLayers.Format.GeoJSON();
for(var c=0;
c<this.layer.features.length;
c++){var b=this.layer.features[c];
var d=b.style;
var a=b.attributes;
for(var e in a){if(a.hasOwnProperty(e)){var g=Legato.Feature.Sketch.AttributeStyleMap[e];
a[e]=d[g]
}}}return f.write(this.layer.features,true)
},reset:function(){if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.layer)&&!Legato.Lang.ObjectUtils.isNullOrUndefined(this.container)){this.deactivate();
this.div.removeChild(this.container);
this.map.removeLayer(this.layer);
this.map.removeControl(this.controlsPanel);
this.controlsPanel.destroy();
this.controlsPanel=null;
this.layer=null;
this.container=null
}},CLASS_NAME:"Legato.Control.SketchLayerEditor"});
Legato.Control.SketchLayerEditor.Bean=Legato.Control.Bean.Extend("Legato.Control.SketchLayerEditor",Legato.Control.QName("SketchLayerEditor"),{_constructor:Legato.Control.SketchLayerEditor,options:{map:OpenLayers.Map,div:Legato.Lang.Element,measureDiv:Legato.Lang.Element,styles:Legato.Beans.Object.List(),stylePropertiesEditor:Legato.Control}});
Legato.Control.Legend=OpenLayers.Class(OpenLayers.Control,{div:null,legendDiv:null,baseLayersDiv:null,overlaysDiv:null,containerPlugin:null,plugins:null,baseLayerContainers:null,overlayContainers:null,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments);
if(!Legato.Lang.ObjectUtils.exists(this.containerPlugin)){this.containerPlugin=new Legato.Control.Legend.Plugin.Layer.Factory()
}if(!Legato.Lang.ObjectUtils.exists(this.plugins)){this.plugins=[]
}if(!Legato.Lang.ObjectUtils.isBoolean(this.showBaseLayers)){this.showBaseLayers=false
}if(this.showBaseLayers){this.baseLayerContainers=[]
}this.overlayContainers=[]
},setMap:function(a){OpenLayers.Control.prototype.setMap.apply(this,arguments);
this.map.events.on({addlayer:this.layerAdded,changelayer:this.layerChanged,removelayer:this.layerRemoved,scope:this})
},destroy:function(){this.map.events.un({addlayer:this.layerAdded,changelayer:this.layerChanged,removelayer:this.layerRemoved,scope:this});
this.div.removeChild(this.legendDiv);
if(this.showBaseLayers){this.legendDiv.removeChild(this.baseLayersDiv);
this.destroyContainers(this.baseLayerContainers);
this.baseLayerContainers=null;
this.baseLayersDiv=null
}this.legendDiv.removeChild(this.overlaysDiv);
this.destroyContainers(this.overlayContainers);
this.overlayContainers=null;
this.overlaysDiv=null;
OpenLayers.Control.prototype.destroy.apply(this,arguments);
this.div=null;
this.legendDiv=null;
this.plugins=null;
this.containerPlugin=null
},layerAdded:function(b){var a=b.layer;
if(this.showBaseLayers&&this.isListedBaseLayer(a)){this.doAddLayer(a,this.baseLayerContainers,this.baseLayersDiv)
}if(this.isListedOverlay(a)){this.doAddLayer(a,this.overlayContainers,this.overlaysDiv)
}},doAddLayer:function(c,d,b){var a=this.createContainer(c);
d.push(a);
this.addContainer(b,a)
},layerRemoved:function(b){var a=b.layer;
if(this.showBaseLayers&&this.isListedBaseLayer(a)){this.doRemoveLayer(a,this.baseLayerContainers,this.baseLayersDiv)
}if(this.isListedOverlay(a)){this.doRemoveLayer(a,this.overlayContainers,this.overlaysDiv)
}},doRemoveLayer:function(b,d,a){var c=this.findContainerIndex(d,b);
if(c>=0){this.removeContainer(a,d[c]);
d.splice(c,1)
}},layerChanged:function(a){var b=a.property;
if("order"==a.property){this.layerChangedOrder(a)
}},layerChangedOrder:function(b){var a=b.layer;
if(this.showBaseLayers&&this.isListedBaseLayer(a)){this.doChangeLayerOrder(a,this.baseLayerContainers,this.baseLayersDiv)
}if(this.isListedOverlay(a)){this.doChangeLayerOrder(a,this.overlayContainers,this.overlaysDiv)
}},doChangeLayerOrder:function(c,e,b){var d=this.findContainerIndex(e,c);
if(d>=0){var f=this.findNewContainerIndex(e,c);
if(d!=f){var a=e[d];
b.removeChild(a.div);
e.splice(d,1);
if(f<d){e.splice(f,0,a);
if(f-1>=0){b.insertBefore(a.div,e[f-1].div)
}else{b.appendChild(a.div)
}}else{e.splice(f-1,0,a);
if(f-2>=0){b.insertBefore(a.div,e[f-2].div)
}else{b.appendChild(a.div)
}}}}},findNewContainerIndex:function(d,c){var b=0;
var a=0;
while((b<this.map.layers.length)&&(a<d.length)){if(this.map.layers[b]===c){return a
}if(this.map.layers[b]===d[a].layer){b++;
a++
}else{if(d[a].layer===c){a++
}else{b++
}}}return a
},findContainerIndex:function(c,b){for(var a=0;
a<c.length;
a++){if(c[a].layer===b){return a
}}return -1
},createContainers:function(c){var b=[];
for(var a=0;
a<c.length;
a++){b[a]=this.createContainer(c[a])
}return b
},createContainer:function(f){var d=[];
for(var e=0;
e<this.plugins.length;
e++){d.push(this.plugins[e])
}var b=[];
for(var c=0;
c<d.length;
c++){if(d[c].supports(f)){b.push(d[c].create(f))
}}var g=this.containerPlugin;
var a=g.create(f,b);
return a
},getListedBaseLayers:function(){return Legato.OpenLayers.Map.Util.getListedBaseLayers(this.map.layers)
},getListedOverlays:function(){return Legato.OpenLayers.Map.Util.getListedOverlays(this.map.layers)
},isListedBaseLayer:function(a){return Legato.OpenLayers.Map.Util.isListedBaseLayer(a)
},isListedOverlay:function(a){return Legato.OpenLayers.Map.Util.isListedOverlay(a)
},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);
this.legendDiv=document.createElement("div");
this.legendDiv.id=this.id+"_Legend";
this.legendDiv.className=this.displayClass+"Container";
this.overlaysDiv=document.createElement("div");
this.overlaysDiv.id=this.id+"_Overlays";
this.overlaysDiv.className=this.displayClass+"Overlays";
this.legendDiv.appendChild(this.overlaysDiv);
if(this.showBaseLayers){this.baseLayersDiv=document.createElement("div");
this.baseLayersDiv.id=this.id+"_BaseLayers";
this.baseLayersDiv.className=this.displayClass+"BaseLayers";
this.legendDiv.appendChild(this.baseLayersDiv)
}this.div.appendChild(this.legendDiv);
this.update();
return this.div
},update:function(){if(this.showBaseLayers){this.removeContainers(this.baseLayersDiv,this.baseLayerContainers)
}this.removeContainers(this.overlaysDiv,this.overlayContainers);
if(this.showBaseLayers){this.baseLayerContainers=this.createContainers(this.getListedBaseLayers());
this.addContainers(this.baseLayersDiv,this.baseLayerContainers)
}this.overlayContainers=this.createContainers(this.getListedOverlays());
this.addContainers(this.overlaysDiv,this.overlayContainers)
},addContainer:function(b,a){var c=a.draw();
if(b.childNodes.length===0){b.appendChild(c)
}else{b.insertBefore(c,b.childNodes[0])
}},addContainers:function(b,c){for(var a=0;
a<c.length;
a++){this.addContainer(b,c[a])
}},removeContainer:function(b,a){b.removeChild(a.div);
a.destroy()
},removeContainers:function(b,c){for(var a=0;
a<c.length;
a++){this.removeContainer(b,c[a])
}},destroyContainer:function(a){a.destroy()
},destroyContainers:function(b){for(var a=0;
a<b.length;
a++){this.destroyContainer(b[a])
}},CLASS_NAME:"Legato.Control.Legend"});
Legato.Control.Legend.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.Legend",Legato.Control.QName("Legend"),{_constructor:Legato.Control.Legend,options:{div:Legato.Lang.Element,showBaseLayers:Legato.Lang.Boolean,containerPlugin:Legato.Beans.Object,plugins:Legato.Beans.Object.List()}});
Legato.Control.Legend.Plugin=OpenLayers.Class({EVENT_TYPES:["legato.plugin.visibility.changed"],id:null,map:null,layer:null,div:null,displayClass:"",title:"",renderWithTitle:false,events:null,initialize:function(b,a){Legato.Util.Ensure.ensureObject(b);
this.map=b.map;
this.layer=b;
this.displayClass=this.CLASS_NAME.replace(/\./g,"");
OpenLayers.Util.extend(this,a);
if(this.id===null){this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_")+":"+this.layer.id
}this.events=new OpenLayers.Events(this,null,this.EVENT_TYPES);
this.afterInitialized()
},afterInitialized:function(){},draw:function(){this.setup();
return this.div
},setup:function(){if(this.div===null){this.create()
}this.update();
this.afterSetup()
},setRenderWithTitle:function(a){this.renderWithTitle=a
},create:function(){var d=document.createElement("div");
d.id=this.id;
d.title=this.title;
d.className=this.displayClass;
if(this.renderWithTitle){var a=document.createElement("div");
a.className="LegatoControlLegendPluginContainer";
var c=d;
c.style.clear="left";
var b=document.createElement("div");
b.innerHTML=this.title;
b.className="LegatoControlLegendPluginContainerTitle";
a.appendChild(c);
a.appendChild(b);
this.div=a
}else{this.div=d
}},update:function(){},afterSetup:function(){},destroy:function(){this.beforeDestroyed();
this.layer=null;
this.div=null
},beforeDestroyed:function(){},isListedBaseLayer:function(a){return Legato.OpenLayers.Map.Util.isListedBaseLayer(a)
},isListedOverlay:function(a){return Legato.OpenLayers.Map.Util.isListedOverlay(a)
},isVisible:function(){return OpenLayers.Element.visible(this.div)
},setVisible:function(b){var a=this.isVisible();
if(Legato.Lang.ObjectUtils.isTrue(b)){Legato.XML.ElementUtils.show(this.div)
}else{Legato.XML.ElementUtils.hide(this.div)
}if(a!==b){this.events.triggerEvent("legato.plugin.visibility.changed")
}},CLASS_NAME:"Legato.Control.Legend.Plugin"});
Legato.Control.Legend.Plugin.Factory=OpenLayers.Class({pluginOptions:null,predicate:null,initialize:function(a){var b={};
OpenLayers.Util.extend(b,a);
if(Legato.Lang.ObjectUtils.isObject(b.supports)&&Legato.Lang.ObjectUtils.isFunction(b.supports.evaluate)){this.predicate=b.supports;
delete b.supports
}this.pluginOptions=b
},destroy:function(){this.pluginOptions=null
},create:function(a){return new Legato.Control.Legend.Plugin(a,this.pluginOptions)
},supports:function(a){if(!Legato.Lang.ObjectUtils.exists(a)){return false
}else{if(Legato.Lang.ObjectUtils.isObject(this.predicate)&&Legato.Lang.ObjectUtils.isFunction(this.predicate.evaluate)){return this.predicate.evaluate(a)
}else{return true
}}},CLASS_NAME:"Legato.Control.Legend.Plugin.Factory"});
Legato.Control.Legend.Plugin.NAMESPACE_URI="http://www.disy.net/legato/legend/plugin";
Legato.Control.Legend.Plugin.PREFIX="llp";
Legato.Control.Legend.Plugin.QName=function(a){return new Legato.XML.QName(Legato.Control.Legend.Plugin.NAMESPACE_URI,a,Legato.Control.Legend.Plugin.PREFIX)
};
Legato.Control.Legend.Plugin.Bean=Legato.Beans.Object.Extend("Legato.Control.Legend.Plugin.Factory",Legato.Control.Legend.Plugin.QName("Plugin"),{_constructor:Legato.Control.Legend.Plugin.Factory,options:{supports:Legato.Beans.Object,displayClass:Legato.Lang.String,title:Legato.Lang.String}});
Legato.Control.Legend.Plugin.Layer=OpenLayers.Class(Legato.Control.Legend.Plugin,{plugins:null,create:function(){Legato.Control.Legend.Plugin.prototype.create.apply(this,arguments);
for(var b=0;
b<this.plugins.length;
b++){var a=this.plugins[b].draw();
if(Legato.Lang.ObjectUtils.exists(a)){this.div.appendChild(a)
}}var c=document.createElement("div");
c.style.clear="both";
this.div.appendChild(c)
},update:function(){this.div.className=this.displayClass+" "+(this.layer.isBaseLayer?this.displayClass+"BaseLayer":this.displayClass+"Overlay")+" "+(this.layer.selected?this.displayClass+"Selected":this.displayClass+"Deselected")
},onclick:function(a){if(Legato.Lang.ObjectUtils.isFalse(this.layer.selected)){this.map.selectLayer(this.layer)
}else{if(Legato.Lang.ObjectUtils.isTrue(this.layer.selected)){this.map.deselectLayer(this.layer)
}}if(Legato.Lang.ObjectUtils.exists(a)){OpenLayers.Event.stop(a,true)
}},afterSetup:function(){if(Legato.Lang.ObjectUtils.isFunction(this.map.selectLayer)){this.div.onclick=OpenLayers.Function.bindAsEventListener(this.onclick,this)
}this.map.events.on({"legato.selectlayer":this.update,"legato.deselectlayer":this.update,scope:this})
},beforeDestroyed:function(){this.div.onclick=null;
this.map.events.un({"legato.selectlayer":this.update,"legato.deselectlayer":this.update,scope:this})
},destroy:function(){for(var a=0;
a<this.plugins.length;
a++){this.plugins[a].destroy()
}this.plugins=null;
Legato.Control.Legend.Plugin.prototype.destroy.apply(this,arguments)
},CLASS_NAME:"Legato.Control.Legend.Plugin.Layer"});
Legato.Control.Legend.Plugin.Layer.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.Factory,{create:function(b,a){var c=OpenLayers.Util.extend({},this.pluginOptions);
c.plugins=Legato.Lang.ObjectUtils.exists(a)?a:[];
return new Legato.Control.Legend.Plugin.Layer(b,c)
},CLASS_NAME:"Legato.Control.Legend.Plugin.Layer.Factory"});
Legato.Control.Legend.Plugin.Layer.Bean=Legato.Control.Legend.Plugin.Bean.Extend("Legato.Control.Legend.Plugin.Layer.Factory",Legato.Control.Legend.Plugin.QName("Layer"),{_constructor:Legato.Control.Legend.Plugin.Layer.Factory});
Legato.Control.Legend.Plugin.LayerDescription=OpenLayers.Class(Legato.Control.Legend.Plugin,{image:null,create:function(){Legato.Control.Legend.Plugin.prototype.create.apply(this,arguments);
this.image=document.createElement("img");
this.image.className=this.displayClass+"Image";
this.div.appendChild(this.image)
},update:function(){if(!this.layer.visibility||!this.layer.inRange){Legato.XML.ElementUtils.hide(this.div)
}else{var a=this.layer.legend.getURL(this.layer);
this.image.src=a;
Legato.XML.ElementUtils.show(this.div)
}},updateVisibility:function(a){if(a.layer&&a.layer===this.layer&&a.property&&a.property==="visibility"){this.update()
}},afterSetup:function(){this.map.events.on({changelayer:this.updateVisibility,scope:this});
this.layer.events.on({moveend:this.update,scope:this});
this.layer.events.on({visibilitychanged:this.updateVisibility,scope:this})
},beforeDestroyed:function(){this.map.events.un({changelayer:this.updateVisibility,scope:this});
this.layer.events.un({moveend:this.update,scope:this});
this.layer.events.un({visibilitychanged:this.updateVisibility,scope:this})
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerDescription"});
Legato.Control.Legend.Plugin.LayerDescription.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.Factory,{create:function(a){return new Legato.Control.Legend.Plugin.LayerDescription(a,this.pluginOptions)
},supports:function(a){return Legato.Control.Legend.Plugin.Factory.prototype.supports.apply(this,arguments)&&Legato.Lang.ObjectUtils.exists(a.legend)&&Legato.Lang.ObjectUtils.isFunction(a.legend.getURL)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerDescription.Factory"});
Legato.Control.Legend.Plugin.LayerDescription.Bean=Legato.Control.Legend.Plugin.Bean.Extend("Legato.Control.Legend.Plugin.LayerDescription.Factory",Legato.Control.Legend.Plugin.QName("LayerDescription"),{_constructor:Legato.Control.Legend.Plugin.LayerDescription.Factory});
Legato.Control.Legend.Plugin.LayerFunction=OpenLayers.Class(Legato.Control.Legend.Plugin,{afterInitialized:function(){Legato.Util.Ensure.ensureFunction(this.callback,"To use "+this.CLASS_NAME+" you must specify a callback function.")
},afterSetup:function(){this.div.onclick=OpenLayers.Function.bindAsEventListener(this.onclick,this)
},beforeDestroy:function(){this.div.onclick=null
},onclick:function(b){var a=this.callback(this.layer);
if(Legato.Lang.ObjectUtils.exists(b)){OpenLayers.Event.stop(b,true)
}return a
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerFunction"});
Legato.Control.Legend.Plugin.LayerFunction.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.Factory,{create:function(a){return new Legato.Control.Legend.Plugin.LayerFunction(a,this.pluginOptions)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerFunction.Factory"});
Legato.Control.Legend.Plugin.LayerFunction.Bean=Legato.Control.Legend.Plugin.Bean.Extend("Legato.Control.Legend.Plugin.LayerFunction.Factory",Legato.Control.Legend.Plugin.QName("LayerFunction"),{_constructor:Legato.Control.Legend.Plugin.LayerFunction.Factory,options:{callback:Legato.Lang.Function}});
Legato.Control.Legend.Plugin.LayerLink=OpenLayers.Class(Legato.Control.Legend.Plugin,{url:null,params:null,parameterName:"selectedLayer",target:null,create:function(){Legato.Control.Legend.Plugin.prototype.create.apply(this,arguments)
},afterInitialized:function(){var a=this.url.indexOf("?");
var b;
var c;
if(a>0){b=this.url.substring(0,a);
c=OpenLayers.Util.getParameters(this.url)
}else{b=this.url;
c={}
}c[this.parameterName]=Legato.Lang.ObjectUtils.exists(this.layer.layerId)?this.layer.layerId:this.layer.name;
this.url=b+"?"+OpenLayers.Util.getParameterString(c)
},getURL:function(){return this.url
},onclick:function(b){var a=this.getURL();
if(Legato.Lang.ObjectUtils.isString(this.target)){window.open(a,this.target)
}else{window.open(a)
}if(Legato.Lang.ObjectUtils.exists(b)){OpenLayers.Event.stop(b,true)
}},afterSetup:function(){this.div.onclick=OpenLayers.Function.bindAsEventListener(this.onclick,this)
},beforeDestroyed:function(){this.div.onclick=null
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerLink"});
Legato.Control.Legend.Plugin.LayerLink.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.Factory,{create:function(a){return new Legato.Control.Legend.Plugin.LayerLink(a,this.pluginOptions)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerLink.Factory"});
Legato.Control.Legend.Plugin.LayerLink.Bean=Legato.Control.Legend.Plugin.Bean.Extend("Legato.Control.Legend.Plugin.LayerLink.Factory",Legato.Control.Legend.Plugin.QName("LayerLink"),{_constructor:Legato.Control.Legend.Plugin.LayerLink.Factory,options:{url:Legato.Lang.String,parameterName:Legato.Lang.String,target:Legato.Lang.String}});
Legato.Control.Legend.Plugin.LayerName=OpenLayers.Class(Legato.Control.Legend.Plugin,{update:function(){if(Legato.Lang.ObjectUtils.isString(this.layer.title)){this.div.innerHTML=this.layer.title
}else{this.div.innerHTML=this.layer.name
}if(this.layer.inRange){this.div.className=this.displayClass
}else{this.div.className=this.displayClass+"Disabled"
}},afterSetup:function(){this.map.events.on({changelayer:this.update,scope:this})
},beforeDestroyed:function(){this.map.events.un({changelayer:this.update,scope:this})
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerName"});
Legato.Control.Legend.Plugin.LayerName.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.Factory,{create:function(a){return new Legato.Control.Legend.Plugin.LayerName(a,this.pluginOptions)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerName.Factory"});
Legato.Control.Legend.Plugin.LayerName.Bean=Legato.Control.Legend.Plugin.Bean.Extend("Legato.Control.Legend.Plugin.LayerName.Factory",Legato.Control.Legend.Plugin.QName("LayerName"),{_constructor:Legato.Control.Legend.Plugin.LayerName.Factory});
Legato.Control.Legend.Plugin.LayerPosition=OpenLayers.Class(Legato.Control.Legend.Plugin,{afterSetup:function(){this.div.onclick=OpenLayers.Function.bindAsEventListener(this.onclick,this)
},beforeDestroyed:function(){this.div.onclick=null
},onclick:function(a){if(Legato.Lang.ObjectUtils.exists(a)){OpenLayers.Event.stop(a,true)
}},raiseLayer:function(b,d,c){var f=this.map;
var e=this.map.layers;
var a=f.getLayerIndex(b)+d;
while(a>=0&&a<e.length){if(c(e[a])){f.setLayerIndex(b,a);
return
}else{a=a+d
}}},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerPosition"});
Legato.Control.Legend.Plugin.LayerPosition.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.Factory,{create:function(a){return new Legato.Control.Legend.Plugin.LayerPosition(a,this.pluginOptions)
},supports:function(a){return Legato.Control.Legend.Plugin.Factory.prototype.supports.apply(this,arguments)&&!a.isBaseLayer
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerPositionUp.Factory"});
Legato.Control.Legend.Plugin.LayerPositionUp=OpenLayers.Class(Legato.Control.Legend.Plugin.LayerPosition,{onclick:function(a){this.raiseLayer(this.layer,1,(this.layer.isBaseLayer?this.isListedBaseLayer:this.isListedOverlay));
OpenLayers.Event.stop(a)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerPositionUp"});
Legato.Control.Legend.Plugin.LayerPositionUp.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.LayerPosition.Factory,{create:function(a){return new Legato.Control.Legend.Plugin.LayerPositionUp(a,this.pluginOptions)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerPositionUp.Factory"});
Legato.Control.Legend.Plugin.LayerPositionDown=OpenLayers.Class(Legato.Control.Legend.Plugin.LayerPosition,{onclick:function(a){this.raiseLayer(this.layer,-1,(this.layer.isBaseLayer?this.isListedBaseLayer:this.isListedOverlay));
OpenLayers.Event.stop(a)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerPositionDown"});
Legato.Control.Legend.Plugin.LayerPositionDown.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.LayerPosition.Factory,{create:function(a){return new Legato.Control.Legend.Plugin.LayerPositionDown(a,this.pluginOptions)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerPositionDown.Factory"});
Legato.Control.Legend.Plugin.LayerPositionUp.Bean=Legato.Control.Legend.Plugin.Bean.Extend("Legato.Control.Legend.Plugin.LayerPositionUp.Factory",Legato.Control.Legend.Plugin.QName("LayerPositionUp"),{_constructor:Legato.Control.Legend.Plugin.LayerPositionUp.Factory});
Legato.Control.Legend.Plugin.LayerPositionDown.Bean=Legato.Control.Legend.Plugin.Bean.Extend("Legato.Control.Legend.Plugin.LayerPositionDown.Factory",Legato.Control.Legend.Plugin.QName("LayerPositionDown"),{_constructor:Legato.Control.Legend.Plugin.LayerPositionDown.Factory});
Legato.Control.Legend.Plugin.LayerRemove=OpenLayers.Class(Legato.Control.Legend.Plugin,{afterSetup:function(){this.div.onclick=OpenLayers.Function.bindAsEventListener(this.onclick,this)
},beforeDestroyed:function(){this.div.onclick=null
},onclick:function(a){this.layer.destroy(true);
if(Legato.Lang.ObjectUtils.exists(a)){OpenLayers.Event.stop(a,true)
}},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerRemove"});
Legato.Control.Legend.Plugin.LayerRemove.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.Factory,{create:function(a){return new Legato.Control.Legend.Plugin.LayerRemove(a,this.pluginOptions)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerRemove.Factory"});
Legato.Control.Legend.Plugin.LayerRemove.Bean=Legato.Control.Legend.Plugin.Bean.Extend("Legato.Control.Legend.Plugin.LayerRemove.Factory",Legato.Control.Legend.Plugin.QName("LayerRemove"),{_constructor:Legato.Control.Legend.Plugin.LayerRemove.Factory});
Legato.Control.Legend.Plugin.LayerVisibility=OpenLayers.Class(Legato.Control.Legend.Plugin,{input:null,create:function(){Legato.Control.Legend.Plugin.prototype.create.apply(this,arguments);
this.input=document.createElement("input");
this.input.value=this.layer.name;
if(this.layer.isBaseLayer){this.input.type="radio";
this.input.name="baseLayer";
this.input.className=this.displayClass+"Input "+this.displayClass+"InputBaseLayer"
}else{this.input.type="checkbox";
this.input.name="overlay";
this.input.className=this.displayClass+"Input "+this.displayClass+"InputOverlay"
}this.div.appendChild(this.input);
this.input.value=this.layer.name;
this.input.defaultChecked=this.layer.visibility
},update:function(){this.input.value=this.layer.name;
this.input.checked=this.layer.visibility
},afterSetup:function(){this.input.onclick=OpenLayers.Function.bindAsEventListener(this.onclick,this);
this.layer.events.on({visibilitychanged:this.update,scope:this});
if(this.layer.isBaseLayer){this.map.events.on({changebaselayer:this.update,scope:this})
}},beforeDestroyed:function(){this.input.onclick=null;
this.layer.events.un({visibilitychanged:this.update,scope:this});
this.map.events.un({changebaselayer:this.update,scope:this})
},onclick:function(a){if(this.layer.isBaseLayer&&this.input.checked){this.layer.map.setBaseLayer(this.layer)
}else{this.layer.setVisibility(this.input.checked)
}if(Legato.Lang.ObjectUtils.exists(a)){OpenLayers.Event.stop(a,true)
}},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerVisibility"});
Legato.Control.Legend.Plugin.LayerVisibility.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.Factory,{create:function(a){return new Legato.Control.Legend.Plugin.LayerVisibility(a,this.pluginOptions)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerVisibility.Factory"});
Legato.Control.Legend.Plugin.LayerVisibility.Bean=Legato.Control.Legend.Plugin.Bean.Extend("Legato.Control.Legend.Plugin.LayerVisibility.Factory",Legato.Control.Legend.Plugin.QName("LayerVisibility"),{_constructor:Legato.Control.Legend.Plugin.LayerVisibility.Factory});
Legato.Control.Legend.Plugin.LayerZoomToVisibleScale=OpenLayers.Class(Legato.Control.Legend.Plugin,{afterInitialized:function(){},onclick:function(a){var c=this.map.getScale();
if(Legato.Lang.ObjectUtils.isNull(c)){return
}var b=c;
if(c>this.layer.minScale){b=this.layer.minScale-0.000001
}else{if(c<this.layer.maxScale){b=this.layer.maxScale+0.000001
}}this.map.zoomToScale(b);
if(Legato.Lang.ObjectUtils.exists(a)){OpenLayers.Event.stop(a,true)
}},afterSetup:function(){this.map.events.on({moveend:this.update,scope:this});
this.div.onclick=OpenLayers.Function.bindAsEventListener(this.onclick,this)
},beforeDestroyed:function(){this.map.events.un({moveend:this.update,scope:this});
this.div.onclick=null
},update:function(){var a=this.map.getScale();
if(Legato.Lang.ObjectUtils.isNull(a)){this.setVisible(false);
return
}if(a>this.layer.minScale||a<this.layer.maxScale){this.setVisible(true);
this.div.style.display="block"
}else{this.setVisible(false)
}},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerZoomToVisibleScale"});
Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.Factory,{create:function(a){return new Legato.Control.Legend.Plugin.LayerZoomToVisibleScale(a,this.pluginOptions)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory"});
Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Bean=Legato.Control.Legend.Plugin.Bean.Extend("Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory",Legato.Control.Legend.Plugin.QName("LayerZoomToVisibleScale"),{_constructor:Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory});
Legato.Control.Legend.Plugin.LayerDropDownMenu=OpenLayers.Class(Legato.Control.Legend.Plugin,{plugins:[],dropDownMenuContainer:null,create:function(){Legato.Control.Legend.Plugin.prototype.create.apply(this,arguments);
var b=document.createElement("div");
b.className="LegatoControlLegendPluginLayerDropDownMenuDiv";
this.dropDownMenuContainer=document.createElement("div");
this.dropDownMenuContainer.className="LegatoControlLegendPluginLayerDropDownMenuDivContainer";
b.appendChild(this.div);
b.appendChild(this.dropDownMenuContainer);
this.div=b;
for(var a=0;
a<this.plugins.length;
a++){this.dropDownMenuContainer.appendChild(this.plugins[a].draw());
this.plugins[a].insideDropDownMenu=true;
this.plugins[a].events.on({"legato.plugin.visibility.changed":this.update,scope:this})
}Legato.XML.ElementUtils.hide(this.dropDownMenuContainer)
},afterSetup:function(){var a=this;
this.div.onclick=OpenLayers.Function.bindAsEventListener(this.onclick,this);
this.div.onmouseout=function(){a.timeOut=setTimeout(function(){Legato.XML.ElementUtils.hide(a.dropDownMenuContainer)
},500)
};
this.div.onmouseover=function(){clearTimeout(a.timeOut)
};
this.map.events.on({moveend:this.update,scope:this});
this.layer.events.on({visibilitychanged:this.update,scope:this});
if(this.layer.isBaseLayer){this.map.events.on({changebaselayer:this.update,scope:this})
}},beforeDestroyed:function(){this.div.onclick=null;
this.map.events.un({moveend:this.update,scope:this});
this.layer.events.un({visibilitychanged:this.update,scope:this});
this.map.events.un({changebaselayer:this.update,scope:this})
},update:function(){var b=this.map.getScale();
if((Legato.Lang.ObjectUtils.isNull(b)||!(b>this.layer.minScale||b<this.layer.maxScale))&&this.layer.getVisibility()){for(var a=0;
a<this.plugins.length;
a++){if(this.plugins[a].isVisible()){this.setVisible(true);
return
}}}this.setVisible(false)
},onclick:function(a){OpenLayers.Element.toggle(this.dropDownMenuContainer);
if(Legato.Lang.ObjectUtils.exists(a)){OpenLayers.Event.stop(a,true)
}},destroy:function(){Legato.Control.Legend.Plugin.prototype.destroy.apply(this,arguments);
for(var a=0;
a<this.plugins.length;
a++){this.plugins[a].events.un({"legato.plugin.visibility.changed":this.update,scope:this});
this.plugins[a].destroy()
}this.plugins=[]
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerDropDownMenu"});
Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory=OpenLayers.Class(Legato.Control.Legend.Plugin.Factory,{create:function(c){var e=OpenLayers.Util.extend({},this.pluginOptions);
e.plugins=[];
var b=this.pluginOptions.plugins;
if(Legato.Lang.ObjectUtils.isNotEmptyArray(b)){for(var a=0;
a<b.length;
a++){if(b[a].supports(c)){var d=b[a].create(c);
d.setRenderWithTitle(true);
e.plugins.push(d)
}}}return new Legato.Control.Legend.Plugin.LayerDropDownMenu(c,e)
},CLASS_NAME:"Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory"});
Legato.Control.Legend.Plugin.LayerDropDownMenu.Bean=Legato.Control.Legend.Plugin.Bean.Extend("Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory",Legato.Control.Legend.Plugin.QName("LayerDropDownMenu"),{_constructor:Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory,options:{plugins:Legato.Beans.Object.List()}});
Legato.Control.MapAttribution=OpenLayers.Class(Legato.Control,{element:null,text:null,url:null,image:null,size:null,imageElement:null,stopEvent:null,initialize:function(a){Legato.Control.prototype.initialize.apply(this,arguments)
},destroy:function(){Legato.Control.prototype.destroy.apply(this,arguments)
},draw:function(){Legato.Control.prototype.draw.apply(this,arguments);
if(!this.element){if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.image)){this.div.innerHTML=this.text
}else{this.imageElement=document.createElement("img");
this.imageElement.src=this.image;
if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.text)){this.imageElement.alt=this.text
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.size)){this.imageElement.height=this.size.h;
this.imageElement.width=this.size.w
}this.div.appendChild(this.imageElement)
}this.div.onmouseup=OpenLayers.Function.bindAsEventListener(this.onclick,this);
this.element=this.div
}return this.div
},onclick:function(a){if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.url)){window.open(this.url)
}if(Legato.Lang.ObjectUtils.exists(a)){if(this.stopEvent===true){OpenLayers.Event.stop(a,true)
}if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.stopEvent)&&!Legato.Lang.ObjectUtils.isNullOrUndefined(this.url)){OpenLayers.Event.stop(a,true)
}}},setMap:function(){Legato.Control.prototype.setMap.apply(this,arguments)
},CLASS_NAME:"Legato.Control.MapAttribution"});
Legato.Control.MapAttribution.Bean=Legato.Control.Bean.Extend("Legato.Control.MapAttribution",Legato.Control.QName("MapAttribution"),{_constructor:Legato.Control.MapAttribution,options:{url:Legato.Lang.String,text:Legato.Lang.String,image:Legato.Lang.String,size:OpenLayers.Size.Bean,stopEvent:Legato.Lang.Boolean}});
Legato.Control.MeasureLine=OpenLayers.Class(OpenLayers.Control.Measure,{initialize:function(b){if(!Legato.Lang.ObjectUtils.exists(b)){b=[]
}var a={Point:Legato.Feature.Style.DEFAULT_POINT,Line:Legato.Feature.Style.DEFAULT_LINE,Polygon:Legato.Feature.Style.DEFAULT_POLYGON};
if(Legato.Lang.ObjectUtils.isArray(b.styles)){for(var c=0;
c<b.styles.length;
c++){var e=b.styles[c];
switch(e.name.toUpperCase()){case"POINT":OpenLayers.Util.extend(a.Point,e.styles);
break;
case"LINE":OpenLayers.Util.extend(a.Line,e.styles);
break;
case"POLYGON":OpenLayers.Util.extend(a.Polygon,e.styles);
break;
default:break
}}}var d=new OpenLayers.Style();
d.addRules([new OpenLayers.Rule({symbolizer:a})]);
var f=new OpenLayers.StyleMap({"default":d});
b.handlerOptions={layerOptions:{styleMap:f,legatoIgnore:true}};
OpenLayers.Control.Measure.prototype.initialize.apply(this,[OpenLayers.Handler.Path,b]);
this.events.on({measure:this.handleMeasurements,measurepartial:this.handleMeasurements})
},destroy:function(){this.events.un({measure:this.handleMeasurements,measurepartial:this.handleMeasurements});
OpenLayers.Control.Measure.prototype.destroy.apply(this,arguments)
},deactivate:function(){this.div.innerHTML="";
OpenLayers.Control.Measure.prototype.deactivate.apply(this,arguments)
},handleMeasurements:function(e){var f=e.geometry;
var b=e.units;
var a=e.order;
var d=e.measure;
var c=d.toFixed(3)+" "+b;
this.div.innerHTML=c
},CLASS_NAME:"Legato.Control.MeasureLine"});
Legato.Control.MeasureLine.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.MeasureLine",Legato.Control.QName("MeasureLine"),{_constructor:Legato.Control.MeasureLine,options:{persist:Legato.Lang.Boolean,styles:Legato.Beans.Object.List()}});
Legato.Control.MeasurePolygon=OpenLayers.Class(OpenLayers.Control.Measure,{initialize:function(b){if(!Legato.Lang.ObjectUtils.exists(b)){b=[]
}var a={Point:Legato.Feature.Style.DEFAULT_POINT,Line:Legato.Feature.Style.DEFAULT_LINE,Polygon:Legato.Feature.Style.DEFAULT_POLYGON};
if(Legato.Lang.ObjectUtils.isArray(b.styles)){for(var c=0;
c<b.styles.length;
c++){var e=b.styles[c];
switch(e.name.toUpperCase()){case"POINT":OpenLayers.Util.extend(a.Point,e.styles);
break;
case"LINE":OpenLayers.Util.extend(a.Line,e.styles);
break;
case"POLYGON":OpenLayers.Util.extend(a.Polygon,e.styles);
break;
default:break
}}}var d=new OpenLayers.Style();
d.addRules([new OpenLayers.Rule({symbolizer:a})]);
var f=new OpenLayers.StyleMap({"default":d});
b.handlerOptions={layerOptions:{styleMap:f,legatoIgnore:true}};
OpenLayers.Control.Measure.prototype.initialize.apply(this,[OpenLayers.Handler.Polygon,b]);
this.events.on({measure:this.handleMeasurements,measurepartial:this.handleMeasurements})
},destroy:function(){this.events.un({measure:this.handleMeasurements,measurepartial:this.handleMeasurements});
OpenLayers.Control.Measure.prototype.destroy.apply(this,arguments)
},deactivate:function(){this.div.innerHTML="";
OpenLayers.Control.Measure.prototype.deactivate.apply(this,arguments)
},handleMeasurements:function(e){var f=e.geometry;
var b=e.units;
var a=e.order;
var d=e.measure;
var c=d.toFixed(3)+" "+b+"<sup>2</sup>";
this.div.innerHTML=c
},CLASS_NAME:"Legato.Control.MeasurePolygon"});
Legato.Control.MeasurePolygon.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.MeasurePolygon",Legato.Control.QName("MeasurePolygon"),{_constructor:Legato.Control.MeasurePolygon,options:{persist:Legato.Lang.Boolean,styles:Legato.Beans.Object.List()}});
Legato.Control.ModifyFeature=OpenLayers.Class(OpenLayers.Control.ModifyFeature,{vertexModifiedPoint:null,initialize:function(b,a){b.events.on({vertexmodified:this.onVertexModified,featuremodified:this.onFeatureModified,"legato.sketchupdated":this.onSketchUpdated,scope:this});
OpenLayers.Control.ModifyFeature.prototype.initialize.apply(this,[b,a]);
this.configureVirtualStyle()
},destroy:function(){this.layer.events.un({vertexmodified:this.onVertexModified,featuremodified:this.onFeatureModified,"legato.sketchupdated":this.onSketchUpdated,scope:this});
OpenLayers.Control.prototype.destroy.apply(this,arguments)
},activate:function(){var a=OpenLayers.Control.ModifyFeature.prototype.activate.apply(this,arguments);
if(this.layer&&this.layer.features&&(this.layer.features.length===1)){this.selectControl.clickFeature(this.layer.features[0])
}return a
},onVertexModified:function(a){this.vertexModifiedPoint=a.vertex
},onFeatureModified:function(a){this.layer.events.triggerEvent("legato.sketchpointadded",{layer:a.feature.layer,geometry:a.feature.geometry,vertex:this.vertexModifiedPoint})
},onSketchUpdated:function(){if(this.feature){this.layer.drawFeature(this.feature,this.selectControl.renderIntent);
this.resetVertices()
}},configureVirtualStyle:function(){},CLASS_NAME:"Legato.Control.ModifyFeature"});
Legato.Control.ModifyFeature.MODE_RESHAPE=OpenLayers.Control.ModifyFeature.RESHAPE;
Legato.Control.ModifyFeature.MODE_AFFINE=OpenLayers.Control.ModifyFeature.RESIZE|OpenLayers.Control.ModifyFeature.ROTATE|OpenLayers.Control.ModifyFeature.DRAG;
Legato.Control.ModifyFeature.Bean=OpenLayers.Control.ModifyFeature.Bean.Extend("Legato.Control.ModifyFeature",Legato.Control.QName("ModifyFeature"),{_constructor:Legato.Control.ModifyFeature,constructorArguments:{layer:OpenLayers.Layer.Bean},constructorOrder:["layer"],options:{mode:Legato.Lang.Integer.Enum("Legato.Control.ModifyFeature.MODE",{RESHAPE:Legato.Control.ModifyFeature.MODE_RESHAPE,AFFINE:Legato.Control.ModifyFeature.MODE_AFFINE})}});
Legato.Control.ModifyPolygon=OpenLayers.Class(Legato.Control.ModifyFeature,{CLASS_NAME:"Legato.Control.ModifyPolygon"});
Legato.Control.ModifyPolygon.Bean=Legato.Control.ModifyFeature.Bean.Extend("Legato.Control.ModifyPolygon",Legato.Control.QName("ModifyPolygon"),{_constructor:Legato.Control.ModifyPolygon});
Legato.Control.ModifyPoint=OpenLayers.Class(Legato.Control.ModifyFeature,{CLASS_NAME:"Legato.Control.ModifyPoint"});
Legato.Control.ModifyPoint.Bean=Legato.Control.ModifyFeature.Bean.Extend("Legato.Control.ModifyPoint",Legato.Control.QName("ModifyPoint"),{_constructor:Legato.Control.ModifyPoint});
Legato.Control.ModifyLineString=OpenLayers.Class(Legato.Control.ModifyFeature,{CLASS_NAME:"Legato.Control.ModifyLineString"});
Legato.Control.ModifyLineString.Bean=Legato.Control.ModifyFeature.Bean.Extend("Legato.Control.ModifyLineString",Legato.Control.QName("ModifyLineString"),{_constructor:Legato.Control.ModifyLineString});
Legato.Control.ModifyMultiPoint=OpenLayers.Class(Legato.Control.ModifyFeature,{CLASS_NAME:"Legato.Control.ModifyMultiPoint"});
Legato.Control.ModifyMultiPoint.Bean=Legato.Control.ModifyFeature.Bean.Extend("Legato.Control.ModifyMultiPoint",Legato.Control.QName("ModifyMultiPoint"),{_constructor:Legato.Control.ModifyMultiPoint});
Legato.Control.ModifyMultiLineString=OpenLayers.Class(Legato.Control.ModifyFeature,{CLASS_NAME:"Legato.Control.ModifyMultiLineString"});
Legato.Control.ModifyMultiLineString.Bean=Legato.Control.ModifyFeature.Bean.Extend("Legato.Control.ModifyMultiLineString",Legato.Control.QName("ModifyMultiLineString"),{_constructor:Legato.Control.ModifyMultiLineString});
Legato.Control.ModifyMultiPolygon=OpenLayers.Class(Legato.Control.ModifyFeature,{CLASS_NAME:"Legato.Control.ModifyMultiPolygon"});
Legato.Control.ModifyMultiPolygon.Bean=Legato.Control.ModifyFeature.Bean.Extend("Legato.Control.ModifyMultiPolygon",Legato.Control.QName("ModifyMultiPolygon"),{_constructor:Legato.Control.ModifyMultiPolygon});
Legato.Control.Navigation=OpenLayers.Class(OpenLayers.Control.Navigation,{draw:function(){if(this.handleRightClicks){this.map.viewPortDiv.oncontextmenu=OpenLayers.Function.False
}var a={click:this.defaultClick,dblclick:this.defaultDblClick,dblrightclick:this.defaultDblRightClick};
var b={"double":true,stopDouble:true};
this.handlers.click=new OpenLayers.Handler.Click(this,a,b);
this.dragPan=new OpenLayers.Control.DragPan(OpenLayers.Util.extend({map:this.map,documentDrag:this.documentDrag},this.dragPanOptions));
this.zoomBox=new OpenLayers.Control.ZoomBox({map:this.map,keyMask:this.zoomBoxKeyMask});
this.dragPan.draw();
this.zoomBox.draw();
this.handlers.wheel=new Legato.Handler.MouseWheel(this,{up:this.wheelUp,down:this.wheelDown},this.mouseWheelOptions);
if(OpenLayers.Control.PinchZoom){this.pinchZoom=new OpenLayers.Control.PinchZoom(OpenLayers.Util.extend({map:this.map},this.pinchZoomOptions))
}},CLASS_NAME:"Legato.Control.Navigation"});
Legato.Control.Navigation.Bean=Legato.Control.Bean.Extend("Legato.Control.Navigation",Legato.Control.QName("Navigation"),{_constructor:Legato.Control.Navigation,options:{zoomWheelEnabled:Legato.Lang.Boolean,handleRightClicks:Legato.Lang.Boolean}});
Legato.Control.NavigationHistory=OpenLayers.Class(OpenLayers.Control.NavigationHistory,{EVENT_TYPES:["previousChange","nextChange"],onPreviousChange:function(b,a){this.events.triggerEvent("previousChange",{state:b,length:a})
},onNextChange:function(b,a){this.events.triggerEvent("nextChange",{state:b,length:a})
},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);
if(this.activateOnDraw){this.activate()
}},setMap:function(a){this.map=a
},CLASS_NAME:"Legato.Control.NavigationHistory"});
Legato.Control.NavigationHistory.Bean=Legato.Control.Bean.Extend("Legato.Control.NavigationHistory",Legato.Control.QName("NavigationHistory"),{_constructor:Legato.Control.NavigationHistory,options:{limit:Legato.Lang.Integer,activateOnDraw:Legato.Lang.Boolean,clearOnDeactivate:Legato.Lang.Boolean}});
Legato.Control.AbstractNavigationHistoryButton=OpenLayers.Class(OpenLayers.Control.Button,{history:null,initialize:function(b,a){OpenLayers.Control.Button.prototype.initialize.apply(this,[a]);
Legato.Util.Ensure.ensureExists(b,"The history parameter doesn't exist.");
this.history=b
},destroy:function(){OpenLayers.Control.Button.prototype.destroy.apply(this);
this.history=null
},CLASS_NAME:"Legato.Control.AbstractNavigationHistoryButton"});
Legato.Control.NavigationHistoryNext=OpenLayers.Class(Legato.Control.AbstractNavigationHistoryButton,{title:"Next",initialize:function(b,a){Legato.Control.AbstractNavigationHistoryButton.prototype.initialize.apply(this,[b,a]);
this.history.events.register("nextChange",this,this.onNextChange)
},onNextChange:function(a){var b=a.state;
if(b&&!this.active){this.activate()
}else{if(!b&&this.active){this.deactivate()
}}},trigger:function(){var a=this.history.nextStack.shift();
if(!Legato.Lang.ObjectUtils.isUndefined(a)){this.history.previousStack.unshift(a);
this.history.restoring=true;
this.history.restore(a);
this.history.restoring=false;
this.history.onPreviousChange(this.history.previousStack[1],this.history.previousStack.length-1);
this.history.onNextChange(this.history.nextStack[0],this.history.nextStack.length)
}return a
},CLASS_NAME:"Legato.Control.NavigationHistoryNext"});
Legato.Control.NavigationHistoryNext.Bean=Legato.Control.Bean.Extend("Legato.Control.NavigationHistoryNext",Legato.Control.QName("NavigationHistoryNext"),{factoryFunction:function(b,a){return new Legato.Control.NavigationHistoryNext(b,a)
},constructorArguments:{history:Legato.Control.NavigationHistory.Bean},constructorOrder:["history"]});
Legato.Control.NavigationHistoryPrevious=OpenLayers.Class(Legato.Control.AbstractNavigationHistoryButton,{title:"Previous",initialize:function(b,a){Legato.Control.AbstractNavigationHistoryButton.prototype.initialize.apply(this,[b,a]);
this.history.events.register("previousChange",this,this.onPreviousChange)
},onPreviousChange:function(a){var b=a.state;
if(b&&!this.active){this.activate()
}else{if(!b&&this.active){this.deactivate()
}}},trigger:function(){var b=this.history.previousStack.shift();
var a=this.history.previousStack.shift();
if(!Legato.Lang.ObjectUtils.isUndefined(a)){this.history.nextStack.unshift(b);
this.history.previousStack.unshift(a);
this.history.restoring=true;
this.history.restore(a);
this.history.restoring=false;
this.history.onNextChange(this.history.nextStack[0],this.history.nextStack.length);
this.history.onPreviousChange(this.history.previousStack[1],this.history.previousStack.length-1)
}else{this.history.previousStack.unshift(b)
}return a
},CLASS_NAME:"Legato.Control.NavigationHistoryPrevious"});
Legato.Control.NavigationHistoryPrevious.Bean=Legato.Control.Bean.Extend("Legato.Control.NavigationHistoryPrevious",Legato.Control.QName("NavigationHistoryPrevious"),{factoryFunction:function(b,a){return new Legato.Control.NavigationHistoryPrevious(b,a)
},constructorArguments:{history:Legato.Control.NavigationHistory.Bean},constructorOrder:["history"]});
Legato.Control.OverviewBoundingBox=OpenLayers.Class(Legato.Control,{handlers:null,parentMap:null,extentRectangle:null,initialize:function(a){this.handlers={};
Legato.Control.prototype.initialize.apply(this,[a])
},destroy:function(){if(!this.mapDiv){return
}if(this.handlers.click){this.handlers.click.destroy()
}if(this.handlers.zoom){this.handlers.zoom.destroy()
}this.map.viewPortDiv.removeChild(this.extentRectangle);
this.extentRectangle=null;
this.mapDiv=null;
this.map.events.un({moveend:this.update,scope:this});
if(this.parentMap&&this.parentMap.events){this.parentMap.events.un({moveend:this.update,scope:this})
}Legato.Control.prototype.destroy.apply(this,arguments)
},draw:function(){if(!this.parentMap){throw new Legato.Lang.Exception("parent map is not defined")
}Legato.Control.prototype.draw.apply(this,arguments);
this.mapDiv=this.map.div;
this.extentRectangle=document.createElement("div");
this.extentRectangle.style.position="absolute";
this.extentRectangle.style.zIndex=this.map.Z_INDEX_BASE.Popup-1;
this.extentRectangle.className=this.displayClass+"ExtentRectangle";
this.map.viewPortDiv.appendChild(this.extentRectangle);
if(!(this.mapDiv.style.position==="absolute"||this.mapDiv.style.position==="relative")){this.mapDiv.style.position="relative"
}this.wComp=parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-left-width"),10)+parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-right-width"),10);
this.wComp=(this.wComp)?this.wComp:2;
this.hComp=parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-top-width"),10)+parseInt(OpenLayers.Element.getStyle(this.extentRectangle,"border-bottom-width"),10);
this.hComp=(this.hComp)?this.hComp:2;
if(this.parentMap.getExtent()){this.update()
}this.parentMap.events.register("moveend",this,this.update);
this.map.events.register("moveend",this,this.update);
this.handlers.click=new OpenLayers.Handler.Click(this,{click:this.mapDivClick},{single:true,"double":false,stopSingle:true,stopDouble:true,pixelTolerance:1,map:this.map});
this.handlers.click.activate();
this.handlers.zoom=new OpenLayers.Handler.Box(this,{done:this.handleZoomBox},{keyMask:this.keyMask});
this.handlers.zoom.activate();
return this.div
},mapDivClick:function(i){var b=this.rectPxBounds.getCenterPixel();
var e=i.xy.x-b.x;
var d=i.xy.y-b.y;
var g=this.rectPxBounds.top;
var c=this.rectPxBounds.left;
var j=Math.abs(this.rectPxBounds.getHeight());
var a=this.rectPxBounds.getWidth();
var f=Math.max(0,(g+d));
f=Math.min(f,this.map.size.h-j);
var h=Math.max(0,(c+e));
h=Math.min(h,this.map.size.w-a);
this.setRectPxBounds(new OpenLayers.Bounds(h,f+j,h+a,f));
this.updateMapToRect(false)
},update:function(){this.updateRectToMap()
},updateRectToMap:function(){var b;
if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.map.getProjection())||Legato.Lang.ObjectUtils.isNullOrUndefined(this.parentMap.getProjection())){return
}if(this.map.getProjection()!=this.parentMap.getProjection()){b=this.parentMap.getExtent().transform(this.parentMap.getProjectionObject(),this.map.getProjectionObject())
}else{b=this.parentMap.getExtent()
}if(!this.map.getExtent().containsBounds(b,true,true)){b=null
}var a=this.getRectBoundsFromMapBounds(b);
this.setRectPxBounds(a)
},updateMapToRect:function(b){var a=this.getMapBoundsFromRectBounds(this.rectPxBounds);
if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.map.getProjection())||Legato.Lang.ObjectUtils.isNullOrUndefined(this.parentMap.getProjection())){return
}if(this.map.getProjection()!=this.parentMap.getProjection()){a=a.transform(this.map.getProjectionObject(),this.parentMap.getProjectionObject())
}if(!b){this.parentMap.panTo(a.getCenterLonLat())
}else{this.parentMap.zoomToExtent(a,true)
}},setRectPxBounds:function(d){if(d){this.extentRectangle.className=this.displayClass+"ExtentRectangle"
}else{this.extentRectangle.className=this.displayClass+"ExtentRectangleOutside";
d=new OpenLayers.Bounds(0,this.map.size.h,this.map.size.w,0)
}var g=Math.max(d.top,0);
var f=Math.max(d.left,0);
var b=Math.min(d.top+Math.abs(d.getHeight()),this.map.size.h-this.hComp);
var c=Math.min(d.left+d.getWidth(),this.map.size.w-this.wComp);
var e=Math.max(c-f,0);
var a=Math.max(b-g,0);
this.extentRectangle.style.top=Math.round(g)+"px";
this.extentRectangle.style.left=Math.round(f)+"px";
this.extentRectangle.style.height=Math.round(a)+"px";
this.extentRectangle.style.width=Math.round(e)+"px";
this.rectPxBounds=new OpenLayers.Bounds(Math.round(f),Math.round(b),Math.round(c),Math.round(g))
},getRectBoundsFromMapBounds:function(d){var e=null;
if(d){var a=new OpenLayers.LonLat(d.left,d.bottom);
var f=new OpenLayers.LonLat(d.right,d.top);
var c=this.getOverviewPxFromLonLat(a);
var b=this.getOverviewPxFromLonLat(f);
if(c&&b){e=new OpenLayers.Bounds(c.x,c.y,b.x,b.y)
}}return e
},getMapBoundsFromRectBounds:function(d){var c=new OpenLayers.Pixel(d.left,d.bottom);
var b=new OpenLayers.Pixel(d.right,d.top);
var a=this.getLonLatFromOverviewPx(c);
var e=this.getLonLatFromOverviewPx(b);
return new OpenLayers.Bounds(a.lon,a.lat,e.lon,e.lat)
},getLonLatFromOverviewPx:function(j){var l=this.map.size;
var k=l.w-this.wComp;
var g=l.h-this.hComp;
var i=this.map.getExtent().getWidth();
var h=this.map.getExtent().getHeight();
var d=this.map.getExtent().left;
var a=this.map.getExtent().top;
var e=(j.x/k)*i;
var c=(j.y/g)*h;
var b=d+e;
var f=a-c;
return new OpenLayers.LonLat(b,f)
},getOverviewPxFromLonLat:function(d){var b=this.map.getResolution();
var c=this.map.getExtent();
var a=null;
if(c){a=new OpenLayers.Pixel(Math.round(1/b*(d.lon-c.left)),Math.round(1/b*(c.top-d.lat)))
}return a
},handleZoomBox:function(a){if(a instanceof OpenLayers.Bounds){this.setRectPxBounds(a);
this.updateMapToRect(true)
}else{}},CLASS_NAME:"Legato.Control.OverviewBoundingBox"});
Legato.Control.OverviewBoundingBox.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.OverviewBoundingBox",Legato.Control.QName("OverviewBoundingBox"),{_constructor:Legato.Control.OverviewBoundingBox,options:{parentMap:OpenLayers.Map}});
Legato.Control.PanZoom=OpenLayers.Class(OpenLayers.Control.PanZoom,{initialize:function(a){OpenLayers.Control.PanZoom.prototype.initialize.apply(this,arguments)
},cssDerivations:{panup:"Up",panleft:"Left",panright:"Right",pandown:"Down",zoomin:"In",zoomworld:"World",zoomout:"Out"},_addButton:function(e,a,d,c){var b=OpenLayers.Control.PanZoom.prototype._addButton.apply(this,arguments);
b.className=b.className+" "+this.displayClass+this.cssDerivations[e];
if(b.hasChildNodes()){while(b.childNodes.length>=1){b.removeChild(b.firstChild)
}}return b
},CLASS_NAME:"Legato.Control.PanZoom"});
Legato.Control.PanZoom.Bean=OpenLayers.Control.PanZoom.Bean.Extend("Legato.Control.PanZoom",Legato.Control.QName("PanZoom"),{_constructor:Legato.Control.PanZoom});
Legato.Control.PanZoomBar=OpenLayers.Class(OpenLayers.Control.PanZoomBar,{initialize:function(a){OpenLayers.Control.PanZoomBar.prototype.initialize.apply(this,arguments)
},cssDerivations:{panup:"Up",panleft:"Left",panright:"Right",pandown:"Down",zoomin:"In",zoomworld:"World",zoomout:"Out"},removeChildrenAndAddClass:function(b,a){b.className=b.className+" "+this.displayClass+a;
if(b.hasChildNodes()){while(b.childNodes.length>=1){b.removeChild(b.firstChild)
}}},_addZoomBar:function(b){var a=OpenLayers.Control.PanZoomBar.prototype._addZoomBar.apply(this,arguments);
this.removeChildrenAndAddClass(this.slider,"Slider");
this.removeChildrenAndAddClass(this.zoombarDiv,"Scroller");
return a
},_addButton:function(e,a,d,c){var b=OpenLayers.Control.PanZoom.prototype._addButton.apply(this,arguments);
this.removeChildrenAndAddClass(b,this.cssDerivations[e]);
return b
},CLASS_NAME:"Legato.Control.PanZoomBar"});
Legato.Control.PanZoomBar.Bean=OpenLayers.Control.PanZoomBar.Bean.Extend("Legato.Control.PanZoomBar",Legato.Control.QName("PanZoomBar"),{_constructor:Legato.Control.PanZoomBar});
Legato.Control.SelectionBoxValueProvider=OpenLayers.Class(Legato.Control,{type:OpenLayers.Control.TYPE_TOOL,selectionLayer:null,styleMap:null,defaultLayerName:"Selection",defaultOpacity:1,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments);
this.layerName=this.layerName||this.defaultLayerName;
try{this.opacity=Legato.Lang.NumberUtils.toFloat(this.opacity)
}catch(b){this.opacity=this.defaultOpacity
}},destroy:function(){OpenLayers.Control.prototype.destroy.apply(this,arguments)
},draw:function(){this.initVectorLayer();
this.handler=new OpenLayers.Handler.Box(this,{done:this.onSelectionBoxDrawn},{keyMask:this.keyMask})
},initVectorLayer:function(){if(!Legato.Lang.ObjectUtils.isFunction(this.getValue)){return
}var a=this.getValue();
if(Legato.OpenLayers.Map.Util.isValidBBox(a)){this.createVectorLayer();
this.selectionLayer.addFeatures(new OpenLayers.Feature.Vector(a.toGeometry()))
}},createVectorLayer:function(){var b={};
if(Legato.Lang.ObjectUtils.exists(this.styleMap)){b.styleMap=this.styleMap
}else{b.styleMap=new OpenLayers.StyleMap({"default":new OpenLayers.Style({fillColor:"#ffffff",fillOpacity:"0.5",strokeColor:"#ff0000",strokeWidth:"2"})})
}this.selectionLayer=new OpenLayers.Layer.Vector(this.layerName,b);
this.selectionLayer.setOpacity(this.opacity);
this.selectionLayer.options.legatoIgnore=true;
this.map.addLayer(this.selectionLayer);
var a=Math.max(this.map.Z_INDEX_BASE.Feature-1,this.selectionLayer.getZIndex())+1;
this.selectionLayer.setZIndex(a);
this.selectionLayer.events.on({featureadded:this.propagateValue,featureremoved:this.propagateValue,featuremodified:this.propagateValue,scope:this})
},onSelectionBoxDrawn:function(a){if(this.selectionLayer===null){this.createVectorLayer()
}if(this.selectionLayer.features.length>0){this.selectionLayer.destroyFeatures()
}var b=Legato.OpenLayers.Map.Util.getBoxSelectionAsVector(this.map,a);
this.selectionLayer.addFeatures(b)
},propagateValue:function(){if(!Legato.Lang.ObjectUtils.isFunction(this.setValue)){return
}var a=new OpenLayers.Bounds(null,null,null,null);
if(this.selectionLayer.features.length==1){a=this.selectionLayer.features[0].geometry.getBounds()
}this.setValue(a)
},CLASS_NAME:"Legato.Control.SelectionBoxValueProvider"});
Legato.Control.SelectionBoxValueProvider.Bean=Legato.Control.Bean.Extend("Legato.Control.SelectionBoxValueProvider",Legato.Control.QName("SelectionBoxValueProvider"),{factoryFunction:function(b,a,g,f,i){var e=null;
var c=null;
var h=null;
var d=null;
if(Legato.Lang.ObjectUtils.isString(b)){e=OpenLayers.Util.getElement(b);
Legato.Util.Ensure.ensureExists(e,"SelectionBoxValueProvider: The configured DOMElement with the id"+b+" could not been found.")
}if(Legato.Lang.ObjectUtils.isString(a)){c=OpenLayers.Util.getElement(a);
Legato.Util.Ensure.ensureExists(c,"SelectionBoxValueProvider: The configured DOMElement with the id"+a+" could not been found.")
}if(Legato.Lang.ObjectUtils.isString(g)){h=OpenLayers.Util.getElement(g);
Legato.Util.Ensure.ensureExists(h,"SelectionBoxValueProvider: The configured DOMElement with the id"+g+" could not been found.")
}if(Legato.Lang.ObjectUtils.isString(f)){d=OpenLayers.Util.getElement(f);
Legato.Util.Ensure.ensureExists(d,"SelectionBoxValueProvider: The configured DOMElement with the id"+f+" could not been found.")
}return new Legato.Control.SelectionBoxValueProvider({opacity:i.opacity,layerName:i.layerName,elements:{left:e,bottom:c,right:h,top:d},setValue:function(j){if(!Legato.Lang.ObjectUtils.exists(j)){return
}this.elements.left.value=j.left;
this.elements.right.value=j.right;
this.elements.top.value=j.top;
this.elements.bottom.value=j.bottom
},getValue:function(){try{var n=Legato.Lang.NumberUtils.toFloat(this.elements.left.value);
var l=Legato.Lang.NumberUtils.toFloat(this.elements.right.value);
var m=Legato.Lang.NumberUtils.toFloat(this.elements.top.value);
var j=Legato.Lang.NumberUtils.toFloat(this.elements.bottom.value);
return new OpenLayers.Bounds(n,j,l,m)
}catch(k){OpenLayers.Console.warn(k);
return new OpenLayers.Bounds(null,null,null,null)
}}})
},options:{opacity:Legato.Lang.Number,layerName:Legato.Lang.String},constructorArguments:{left:Legato.Lang.String,right:Legato.Lang.String,top:Legato.Lang.String,bottom:Legato.Lang.String},constructorOrder:["left","bottom","right","top"]});
Legato.Control.SetMapSize=OpenLayers.Class(OpenLayers.Control,{type:OpenLayers.Control.TYPE_BUTTON,selectElement:null,customMapSizeName:null,mapSizes:null,mapSizeOptionElements:null,maintainExtent:false,zoomToClosest:true,widthDifference:0,heightDifference:0,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,[a]);
if(!Legato.Lang.ObjectUtils.exists(this.mapSizes)){this.mapSizes={}
}this.mapSizeOptionElements={}
},draw:function(){var e=OpenLayers.Control.prototype.draw.apply(this,arguments);
if(!Legato.Lang.ObjectUtils.exists(this.selectElement)){this.selectElement=document.createElement("select");
this.selectElement.id=this.id+"_SelectElement";
this.selectElement.name=this.id+"_SelectElement";
this.selectElement.title=this.title;
for(var d in this.mapSizes){if(this.mapSizes.hasOwnProperty(d)){var c=this.mapSizes[d];
this.addOptionElement(d,c)
}}this.selectElement.className=this.displayClass+"SelectElement";
var b=this;
var a=function(){var f=b.map.size;
var g=b.getMatchingSizeName(f);
if(g===null){b.addOptionElement(b.customMapSizeName,f);
b.mapSizes[b.customMapSizeName]=f;
b.selectElement.value=b.customMapSizeName;
b.widthDifference=0;
b.heightDifference=0;
b.updateSize()
}};
this.map.events.on({"legato.refresh":a});
this.updateSize();
this.selectElement.onchange=OpenLayers.Function.bindAsEventListener(this.onChange,this);
this.div.appendChild(this.selectElement);
this.ready=true
}return e
},addOptionElement:function(b,c){var a=document.createElement("option");
a.value=b;
a.innerHTML=b;
this.selectElement.appendChild(a);
this.mapSizeOptionElements[b]=a;
return a
},removeOptionElement:function(b){var a=this.mapSizeOptionElements[b];
if(Legato.Lang.ObjectUtils.exists(a)){this.selectElement.removeChild(a);
delete this.mapSizeOptionElements[b]
}},getMatchingSizeName:function(a){for(var c in this.mapSizes){if(this.mapSizes.hasOwnProperty(c)){var b=this.mapSizes[c];
if(Legato.Lang.ObjectUtils.exists(a)&&b.equals(a)){return c
}}}return null
},updateSize:function(){if(!this.ready){return
}var b={w:this.map.size.w-this.widthDifference,h:this.map.size.h-this.heightDifference};
var c=this.getMatchingSizeName(b);
if(c!==null){if(c!=this.selectElement.value){this.selectElement.value=c
}}var a=this.mapSizes[this.selectElement.value];
this.widthDifference=b.w-a.w;
this.heightDifference=b.h-a.h
},onChange:function(){var c=this.selectElement.value;
if(Legato.Lang.ObjectUtils.exists(c)){var b=this.mapSizes[c];
if(Legato.Lang.ObjectUtils.exists(b)){var a=this.maintainExtent?this.map.getExtent():null;
this.map.div.style.width=(b.w+this.widthDifference)+"px";
this.map.div.style.height=(b.h+this.heightDifference)+"px";
if(Legato.Lang.ObjectUtils.exists(a)){this.map.zoomToExtent(a,this.zoomToClosest)
}this.map.updateSize()
}}},setMap:function(a){OpenLayers.Control.prototype.setMap.apply(this,arguments);
this.map.events.on({moveend:this.updateSize,scope:this})
},destroy:function(){if(this.selectElement!==null){this.selectElement.onchange=null
}this.map.events.un({moveend:this.updateSize,scope:this});
this.selectElement=null;
this.mapSizes=null;
this.mapSizeOptionElements=null;
this.otherMapSizeName=null;
OpenLayers.Control.prototype.destroy.apply(this,arguments)
},CLASS_NAME:"Legato.Control.SetMapSize"});
Legato.Control.SetMapSize.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.SetMapSize",Legato.Control.QName("SetMapSize"),{_constructor:Legato.Control.SetMapSize,options:{mapSizes:OpenLayers.Size.Bean.Map(),maintainExtent:Legato.Lang.Boolean,customMapSizeName:Legato.Lang.String,zoomToClosest:Legato.Lang.Boolean}});
Legato.StyleProperties={STYLE_PROPERTIES:{TEXT:["fontFamily","fontColor","fontSize","fontStyle","fontWeight"],POINT:["pointRadius","fillColor","strokeWidth","strokeColor"],LINE:["strokeWidth","strokeColor","strokeDashstyle"],POLYGON:["fillColor","strokeWidth","strokeColor","strokeDashstyle"]}};
Legato.StyleProperties.NAMESPACE_URI="http://www.disy.net/legato/styleproperties";
Legato.StyleProperties.PREFIX="lsp";
Legato.StyleProperties.QName=function(a){return new Legato.XML.QName(Legato.StyleProperties.NAMESPACE_URI,a,Legato.StyleProperties.PREFIX)
};
Legato.StyleProperties.AbstractInputElement=OpenLayers.Class({propertyName:null,propertyValue:null,style:null,layer:null,titleClass:"StylePropertyTitle",inputClass:"StylePropertyInput",container:null,initialize:function(b,a,e,d,c){this.propertyName=b;
this.propertyValue=a;
this.style=e;
this.layer=d;
this.create()
},create:function(){this.container=document.createElement("div");
var b=document.createElement("div");
OpenLayers.Element.addClass(b,this.titleClass);
b.innerHTML=this.getTitle()+": ";
this.container.appendChild(b);
var a=this.createInput();
OpenLayers.Element.addClass(a,this.inputClass);
this.container.appendChild(a);
return this.container
},appendTo:function(a){a.appendChild(this.container)
},createInput:function(){throw new Legato.Lang.Exception(this.CLASS_NAME+" must implement the createInput function from from abstract class "+Legato.StyleProperties.AbstractInputElement.CLASS_NAME)
},getTitle:function(){return Legato.I18n.getMessage("Legato.StyleProperties.AbstractInputElement."+this.propertyName)
},onInputValueChanged:function(a){this.style[this.propertyName]=a;
this.layer.redraw()
},CLASS_NAME:"Legato.StyleProperties.AbstractInputElement"});
Legato.StyleProperties.InputElement=OpenLayers.Class(Legato.StyleProperties.AbstractInputElement,{createInput:function(){var a=document.createElement("input");
OpenLayers.Element.addClass(a,this.inputClass);
a.value=this.propertyValue;
a.onchange=OpenLayers.Function.bindAsEventListener(this.onInputValueChanged,this);
return a
},CLASS_NAME:"Legato.StyleProperties.InputElement"});
Legato.StyleProperties.SelectElement=OpenLayers.Class(Legato.StyleProperties.AbstractInputElement,{selectOptions:[],initialize:function(b,a,e,d,c){if(Legato.Lang.ObjectUtils.exists(c.selectOptions)){this.selectOptions=c.selectOptions
}Legato.StyleProperties.AbstractInputElement.prototype.initialize.apply(this,arguments)
},createInput:function(){var c=document.createElement("select");
for(var d=0;
d<this.selectOptions.length;
d++){var b=document.createElement("option");
var a=this.selectOptions[d];
if(Legato.Lang.ObjectUtils.exists(a.label)){b.value=a.value;
if(Legato.Lang.ObjectUtils.isFunction(a.label)){b.innerHTML=a.label()
}else{b.innerHTML=a.label
}}else{b.value=a;
b.innerHTML=a
}c.appendChild(b)
}c.value=this.propertyValue;
c.onchange=OpenLayers.Function.bindAsEventListener(this.onInputValueChanged,this);
return c
},CLASS_NAME:"Legato.StyleProperties.SelectElement"});
Legato.StyleProperties.Factory=OpenLayers.Class({SELECT_OPTIONS:{fontFamily:["Arial","Arial Black","Comic Sans MS","Courier New","Georgia","Impact","Lucida Console","Lucida Sans Unicode","Tahoma","Times New Roman","Verdana"],fontStyle:[{value:"normal",label:function(){return Legato.I18n.getMessage("Legato.StyleProperties.Factory.fontStyle.normal")
}},{value:"italic",label:function(){return Legato.I18n.getMessage("Legato.StyleProperties.Factory.fontStyle.italic")
}}],fontWeight:[{value:"normal",label:function(){return Legato.I18n.getMessage("Legato.StyleProperties.Factory.fontWeight.normal")
}},{value:"bold",label:function(){return Legato.I18n.getMessage("Legato.StyleProperties.Factory.fontWeight.bold")
}}],fontSize:["9","10","11","12","14","16","18","20","22","24","26","28"],pointRadius:["2","3","4","5","6","7","8","9","10","12","14","16","18","20","22"],strokeWidth:["1","2","3","4","5","6","7","8","9","10","12","14"],strokeDashstyle:[{value:"solid",label:"&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;"},{value:"dot",label:"&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;"},{value:"dash",label:"&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;"},{value:"dashdot",label:"&mdash;&nbsp;&middot;&nbsp;&mdash;&nbsp;&middot;&nbsp;&mdash;&nbsp;&middot;&nbsp;&mdash;&nbsp;&nbsp;&middot;&nbsp;&mdash;&nbsp;&nbsp;&middot;&nbsp;"}]},SPINNER_OPTIONS:{},initialize:function(a){},createElement:function(a,d,c,b){if(this.isSelectProperty(a)){return this.createSelectElement(a,d,c,b,this.SELECT_OPTIONS[a])
}else{if(this.isColorProperty(a)){return this.createColorElement(a,d.replace("#",""),c,b)
}else{if(this.isSpinnerProperty(a)){return this.createSpinnerElement(a,d,c,b,this.SPINNER_OPTIONS[a])
}else{return this.createInputElement(a,d,c,b)
}}}},createInputElement:function(a,d,c,b){return new Legato.StyleProperties.InputElement(a,d,c,b)
},createSelectElement:function(a,e,d,c,b){return new Legato.StyleProperties.SelectElement(a,e,d,c,{selectOptions:b})
},createSpinnerElement:function(a,e,d,c,b){return new Legato.StyleProperties.SelectElement(a,e,d,c,{spinnerOptions:b})
},createColorElement:function(a,d,c,b){return new Legato.StyleProperties.InputElement(a,d,c,b)
},isSelectProperty:function(a){return this.SELECT_OPTIONS.hasOwnProperty(a)
},isSpinnerProperty:function(a){return this.SPINNER_OPTIONS.hasOwnProperty(a)
},isColorProperty:function(a){var b="Color";
return a.indexOf(b,a.length-b.length)!==-1
},CLASS_NAME:"Legato.StyleProperties.Factory"});
Legato.StyleProperties.Factory.Bean=Legato.Beans.Object.Extend("Legato.StyleProperties.Factory",Legato.StyleProperties.QName("Factory"),{_constructor:Legato.StyleProperties.Factory,options:{}});
Legato.Control.StylePropertiesEditor=OpenLayers.Class(Legato.Control,{style:null,factory:null,layer:null,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,[a]);
this.createDiv()
},setStyle:function(a){this.style=a;
this.refresh()
},setLayer:function(a){this.layer=a
},refresh:function(){this.div.innerHTML="";
var f=this.style["x-type"];
var e=Legato.StyleProperties.STYLE_PROPERTIES[f];
for(var c=0;
c<e.length;
c++){var b=e[c];
var d=this.style[b];
var a=this.factory.createElement(b,d,this.style,this.layer);
a.appendTo(this.div)
}},createDiv:function(){this.div=OpenLayers.Util.createDiv(this.id);
this.div.className=this.displayClass;
this.div.style.position="relative"
},deactivate:function(){Legato.Control.prototype.deactivate.apply(this,[arguments]);
this.div.style.display="none"
},activate:function(){Legato.Control.prototype.activate.apply(this,[arguments]);
this.div.style.display=""
},draw:function(a){if(this.div===null){this.createDiv()
}if(Legato.Lang.ObjectUtils.exists(a)){this.position=a.clone()
}this.moveTo(this.position);
return this.div
},CLASS_NAME:"Legato.Control.StylePropertiesEditor"});
Legato.Control.StylePropertiesEditor.Bean=Legato.Control.Bean.Extend("Legato.Control.StylePropertiesEditor",Legato.Control.QName("StylePropertiesEditor"),{_constructor:Legato.Control.StylePropertiesEditor,options:{factory:Legato.StyleProperties.Factory}});
Legato.Control.SyncMapDivSize=OpenLayers.Class(OpenLayers.Control,{syncHeight:false,syncWidth:false,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,[a])
},updateSize:function(){if(this.syncHeight){var b=this.map.div.style.height;
if(Legato.Lang.ObjectUtils.exists(b)){this.div.style.height=b
}}if(this.syncWidth){var a=this.map.div.style.width;
if(Legato.Lang.ObjectUtils.exists(a)){this.div.style.width=a
}}},setMap:function(a){OpenLayers.Control.prototype.setMap.apply(this,arguments);
this.map.events.on({moveend:this.updateSize,scope:this})
},destroy:function(){this.map.events.un({moveend:this.updateSize,scope:this});
OpenLayers.Control.prototype.destroy.apply(this,arguments)
},CLASS_NAME:"Legato.Control.SyncMapDivSize"});
Legato.Control.SyncMapDivSize.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.SyncMapDivSize",Legato.Control.QName("SyncMapDivSize"),{_constructor:Legato.Control.SyncMapDivSize,options:{syncWidth:Legato.Lang.Boolean,syncHeight:Legato.Lang.Boolean}});
Legato.Control.ToggleDisplay=OpenLayers.Class(Legato.Control,{control:null,type:OpenLayers.Control.TYPE_TOGGLE,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments);
if(!Legato.Lang.ObjectUtils.exists(a.displayClass)&&Legato.Lang.ObjectUtils.exists(a.control.displayClass)){this.displayClass=a.control.displayClass+"Toggle"
}},activate:function(){if(Legato.Lang.ObjectUtils.exists(this.control.div)){Legato.XML.ElementUtils.show(this.control.div)
}this.active=true;
Legato.Control.prototype.activate.apply(this,arguments)
},deactivate:function(){if(Legato.Lang.ObjectUtils.exists(this.control.div)){Legato.XML.ElementUtils.hide(this.control.div)
}this.active=false;
Legato.Control.prototype.deactivate.apply(this,arguments)
},CLASS_NAME:"Legato.Control.ToggleDisplay"});
Legato.Control.ToggleDisplay.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.ToggleDisplay",Legato.Control.QName("ToggleDisplay"),{_constructor:Legato.Control.ToggleDisplay,options:{control:OpenLayers.Control.Bean}});
Legato.Control.ToggleDiv=OpenLayers.Class(Legato.Control,{control:null,type:OpenLayers.Control.TYPE_TOGGLE,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments)
},activate:function(){if(Legato.Lang.ObjectUtils.exists(this.div)){Legato.XML.ElementUtils.show(this.div)
}this.active=true;
Legato.Control.prototype.activate.apply(this,arguments)
},deactivate:function(){if(Legato.Lang.ObjectUtils.exists(this.div)){Legato.XML.ElementUtils.hide(this.div)
}this.active=false;
Legato.Control.prototype.deactivate.apply(this,arguments)
},CLASS_NAME:"Legato.Control.ToggleDiv"});
Legato.Control.ToggleDiv.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.ToggleDiv",Legato.Control.QName("ToggleDiv"),{_constructor:Legato.Control.ToggleDiv});
Legato.Control.ToggleLayer=OpenLayers.Class(Legato.Control,{layerId:null,type:OpenLayers.Control.TYPE_TOGGLE,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments);
if(Legato.Lang.ObjectUtils.exists(a.layerId)){this.layerId=a.layerId
}},activate:function(){this.toggleVisibility();
this.active=true;
Legato.Control.prototype.activate.apply(this,arguments)
},deactivate:function(){this.toggleVisibility();
this.active=false;
Legato.Control.prototype.deactivate.apply(this,arguments)
},toggleVisibility:function(){var a=Legato.OpenLayers.Map.Util.getLayerById(this.map.layers,this.layerId);
if(Legato.Lang.ObjectUtils.isObject(a)){a.setVisibility(!a.visibility)
}},CLASS_NAME:"Legato.Control.ToggleLayer"});
Legato.Control.ToggleLayer.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.ToggleLayer",Legato.Control.QName("ToggleLayer"),{_constructor:Legato.Control.ToggleLayer,options:{layerId:Legato.Lang.String}});
Legato.Control.WMSGetFeatureInfo=OpenLayers.Class(Legato.Control,{reverseSelectedLayers:true,wmsGetFeatureInfo:null,wmsGetFeatureInfoGml:null,openLayersPopup:null,popup:null,initialPopupPosition:null,popupType:"",autoActive:false,popupBackgroundColor:"",popupMinSize:null,popupMaxSize:null,popupAutoSize:true,popupPanMapIfOutOfView:true,popupKeepInMap:true,popupCloseOnMove:false,popupOpacity:null,renderIfNoPopupExists:false,layerFilter:null,layerTransformer:null,highlightGeometry:false,highlightGeometryLayerName:"legato.internal.highlightedFeatures",scriptedLayerIdTagName:"map:scriptedLayerId",initialize:function(a){if(!a.delay){a.delay=500
}if(!a.popupBackgroundColor){a.popupBackgroundColor="#fafad2"
}a.handlerOptions={click:a.delay,hover:a.delay};
Legato.Control.prototype.initialize.apply(this,[a]);
this.wmsGetFeatureInfo=new OpenLayers.Control.WMSGetFeatureInfo(a);
if(this.highlightGeometry===true){a.infoFormat="application/vnd.ogc.gml";
a.legatoIgnore=true;
this.wmsGetFeatureInfoGml=new OpenLayers.Control.WMSGetFeatureInfo(a)
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.layerFilter)){this.layerTransformer=new Legato.Layer.Transformer.SublayerFilteringTransformer(this.layerFilter)
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){this.initialPopupPosition=this.popup.getPosition()
}},draw:function(){OpenLayers.Control.prototype.draw.apply(this)
},enableAutoActive:function(){if(!this.wmsGetFeatureInfo.active){this.activate()
}},destroy:function(){if(this.autoActive){this.map.events.un({mouseover:this.enableAutoActive,scope:this})
}if(this.hover){this.map.events.un({mousemove:this.hidePopup,scope:this})
}this.map.events.un({"legato.selectlayer":this.updateSelectedLayers,"legato.deselectlayer":this.updateSelectedLayers,addlayer:this.updateQueryLayers,removelayer:this.updateQueryLayers,scope:this});
this.wmsGetFeatureInfo.events.un({getfeatureinfo:this.renderGetFeatureInfo,scope:this});
this.wmsGetFeatureInfo.destroy();
if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){this.wmsGetFeatureInfoGml.events.un({getfeatureinfo:this.hightlightFeatureInfoGeometry,scope:this});
this.wmsGetFeatureInfoGml.destroy()
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.highlightLayer)){this.highlightLayer.destroy()
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.openLayersPopup)){this.map.removePopup(this.openLayersPopup);
this.openLayersPopup.destroy()
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){this.popup.close()
}OpenLayers.Control.prototype.destroy.apply(this,arguments)
},activate:function(){OpenLayers.Control.prototype.activate.apply(this,arguments);
this.updateQueryLayers();
this.updateSelectedLayers();
this.updateScriptedLayers();
this.wmsGetFeatureInfo.activate();
if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){this.wmsGetFeatureInfoGml.activate()
}},deactivate:function(){this.wmsGetFeatureInfo.deactivate();
if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){this.wmsGetFeatureInfoGml.deactivate()
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.highlightLayer)){this.highlightLayer.destroyFeatures()
}this.hidePopup();
OpenLayers.Control.prototype.deactivate.apply(this,arguments)
},hidePopup:function(){if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.openLayersPopup)){this.openLayersPopup.hide()
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){this.popup.close()
}},getSelectedLayers:function(){return Legato.Lang.CollectionUtils.filter(this.map.layers,function(a){return Legato.OpenLayers.Map.Util.isListedLayer(a)&&Legato.Lang.ObjectUtils.isTrue(a.selected)&&Legato.Lang.ObjectUtils.isTrue(a.queryable)
})
},getQueryAbleLayers:function(){return Legato.Lang.CollectionUtils.filter(this.map.layers,function(a){return Legato.OpenLayers.Map.Util.isListedLayer(a)&&Legato.Lang.ObjectUtils.isTrue(a.queryable)
})
},getListedLayers:function(){return Legato.Lang.CollectionUtils.filter(this.map.layers,function(a){return Legato.OpenLayers.Map.Util.isListedLayer(a)
})
},getScriptedLayerIds:function(){var d=[];
var c=this.map.tags;
if(Legato.Lang.ObjectUtils.isArray(c)){for(var b=0;
b<c.length;
b++){var a=c[b];
if(a.name===this.scriptedLayerIdTagName&&Legato.Lang.ObjectUtils.isString(a.value)){d.push(a.value)
}}}return d
},updateSelectedLayers:function(){if(this.active!==true){return
}var a=this.getSelectedLayers();
if(this.reverseSelectedLayers){a.reverse()
}var b=Legato.OpenLayers.Map.Util.getLayerIds(a);
this.wmsGetFeatureInfo.vendorParams.selected_layers=b;
if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){this.wmsGetFeatureInfoGml.vendorParams.selected_layers=b
}},updateScriptedLayers:function(){if(this.active!==true){return
}var a=this.getScriptedLayerIds();
this.wmsGetFeatureInfo.vendorParams.scripted_layers=a;
if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){this.wmsGetFeatureInfoGml.vendorParams.scripted_layers=a
}},updateQueryLayers:function(){if(this.active!==true){return
}var b=this.getQueryAbleLayers();
if(this.reverseSelectedLayers){b.reverse()
}if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.layerTransformer)){this.wmsGetFeatureInfo.layers=b;
if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){this.wmsGetFeatureInfoGml.layers=this.wmsGetFeatureInfo.layers
}}else{var a=[];
for(var c=0;
c<b.length;
c++){var d=this.layerTransformer.transform(b[c]);
if(!Legato.Lang.ObjectUtils.isNullOrUndefined(d)){a.push(d)
}}this.wmsGetFeatureInfo.layers=a;
if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){this.wmsGetFeatureInfoGml.layers=a
}}},setMap:function(a){this.wmsGetFeatureInfo.setMap(a);
if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){this.wmsGetFeatureInfoGml.setMap(a)
}OpenLayers.Control.prototype.setMap.apply(this,arguments);
if(this.autoActive){this.map.events.on({mouseover:this.enableAutoActive,scope:this})
}if(this.hover){this.map.events.on({mousemove:this.hidePopup,scope:this})
}this.map.events.on({"legato.selectlayer":this.updateSelectedLayers,"legato.deselectlayer":this.updateSelectedLayers,addlayer:this.updateQueryLayers,removelayer:this.updateQueryLayers,scope:this});
this.wmsGetFeatureInfo.events.on({getfeatureinfo:this.renderGetFeatureInfo,beforegetfeatureinfo:this.updateScriptedLayers,scope:this});
if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){this.wmsGetFeatureInfoGml.events.on({getfeatureinfo:this.hightlightFeatureInfoGeometry,beforegetfeatureinfo:this.updateScriptedLayers,scope:this})
}},hightlightFeatureInfoGeometry:function(b){if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.highlightLayer)){var a=this.getStyleMap();
this.highlightLayer=new OpenLayers.Layer.Vector(this.highlightGeometryLayerName,{legatoIgnore:true,displayInLayerSwitcher:false,isBaseLayer:false,styleMap:a});
this.map.addLayer(this.highlightLayer)
}this.highlightLayer.destroyFeatures();
if(b.features&&b.features.length){this.highlightLayer.addFeatures(b.features);
this.highlightLayer.redraw()
}},getStyleMap:function(){var a={Point:Legato.Feature.Style.HIGHLIGHT_POINT,Line:Legato.Feature.Style.HIGHLIGHT_LINE,Polygon:Legato.Feature.Style.HIGHLIGHT_POLYGON};
var b=new OpenLayers.Style();
b.addRules([new OpenLayers.Rule({symbolizer:a})]);
return b
},renderGetFeatureInfo:function(a){if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){this.popup.close()
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.openLayersPopup)){this.map.removePopup(this.openLayersPopup)
}if(a.text.length===0){return
}if(this.renderIfNoPopupExists&&(this.map.popups.length>0||!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup))){return
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){if(Legato.Lang.ObjectUtils.isNull(this.initialPopupPosition)){this.popup.setPosition(a.xy)
}this.popup.open(a.text,"wmsFeatureInfo",OpenLayers.Function.bind(this.onClosePopup,this));
return
}switch(this.popupType.toLowerCase()){case"anchored":this.openLayersPopup=new OpenLayers.Popup.Anchored("getFeatureInfo",this.map.getLonLatFromPixel(a.xy),null,a.text,null,!(this.autoActive||this.hover),OpenLayers.Function.bind(this.onClosePopup,this));
break;
case"anchoredbubble":this.openLayersPopup=new OpenLayers.Popup.AnchoredBubble("getFeatureInfo",this.map.getLonLatFromPixel(a.xy),null,a.text,null,!(this.autoActive||this.hover),OpenLayers.Function.bind(this.onClosePopup,this));
break;
default:this.openLayersPopup=new OpenLayers.Popup.MarginAwareFramedCloud("getFeatureInfo",this.map.getLonLatFromPixel(a.xy),null,a.text,null,!(this.autoActive||this.hover),OpenLayers.Function.bind(this.onClosePopup,this));
break
}this.openLayersPopup.autoSize=this.popupAutoSize;
this.openLayersPopup.setBackgroundColor(this.popupBackgroundColor);
if(this.popupMinSize){this.openLayersPopup.minSize=this.popupMinSize
}if(this.popupMaxSize){this.openLayersPopup.maxSize=this.popupMaxSize
}if(this.popupOpacity){this.openLayersPopup.setOpacity(this.popupOpacity)
}this.openLayersPopup.panMapIfOutOfView=this.popupPanMapIfOutOfView;
this.openLayersPopup.keepInMap=this.popupKeepInMap;
this.openLayersPopup.closeOnMove=this.popupCloseOnMove;
this.map.addPopup(this.openLayersPopup)
},onClosePopup:function(a){if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){this.popup.close()
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.highlightLayer)){this.highlightLayer.destroyFeatures()
}if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.map)&&!Legato.Lang.ObjectUtils.isNullOrUndefined(this.openLayersPopup)){this.map.removePopup(this.openLayersPopup)
}},CLASS_NAME:"Legato.Control.WMSGetFeatureInfo"});
Legato.Control.WMSGetFeatureInfo.Bean=Legato.Control.Bean.Extend("Legato.Control.WMSGetFeatureInfo",Legato.Control.QName("WMSGetFeatureInfo"),{_constructor:Legato.Control.WMSGetFeatureInfo,options:{hover:Legato.Lang.Boolean,maxFeatures:Legato.Lang.Integer,queryVisible:Legato.Lang.Boolean,url:Legato.Lang.String,infoFormat:Legato.Lang.String,autoActive:Legato.Lang.Boolean,renderIfNoPopupExists:Legato.Lang.Boolean,delay:Legato.Lang.Integer,popupType:Legato.Lang.String,popupBackgroundColor:Legato.Lang.String,popupMinSize:OpenLayers.Size.Bean,popupMaxSize:OpenLayers.Size.Bean,popupAutoSize:Legato.Lang.Boolean,popupPanMapIfOutOfView:Legato.Lang.Boolean,popupKeepInMap:Legato.Lang.Boolean,popupCloseOnMove:Legato.Lang.Boolean,popupOpacity:Legato.Lang.Number,popup:Legato.Popup,layerFilter:Legato.Predicate,highlightGeometry:Legato.Lang.Boolean,reverseSelectedLayers:Legato.Lang.Boolean}});
Legato.Control.ViewContextValueProvider=OpenLayers.Class(Legato.Control,{lastUpdate:null,frequency:null,delayedPropagation:null,url:null,method:null,initialize:function(a){Legato.Control.prototype.initialize.apply(this,arguments);
this.lastUpdate=new Date();
Legato.Util.Ensure.ensureNotEmptyString(this.url,"To use the ViewContextValueProvider you have to specify at least an url.");
if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.frequency)||!Legato.Lang.ObjectUtils.isNumber(this.frequency)||this.frequency<500){this.frequency=2000
}if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.method)||!Legato.Lang.ObjectUtils.isString(this.method)){this.method="POST"
}},destroy:function(){this.map.events.un({move:this.propagateValue,addlayer:this.propagateValue,removelayer:this.propagateValue,moveend:this.propagateValueFreqControl,changebaselayer:this.propagateValue,"legato.selectlayer":this.propagateValue,"legato.deselectlayer":this.propagateValue,resize:this.propagateValue,scope:this});
OpenLayers.Control.prototype.destroy.apply(this,arguments)
},setMap:function(a){OpenLayers.Control.prototype.setMap.apply(this,arguments);
this.map.events.on({addlayer:this.propagateValue,removelayer:this.propagateValue,changelayer:this.propagateValue,changebaselayer:this.propagateValue,moveend:this.propagateValueFreqControl,"legato.selectlayer":this.propagateValue,"legato.deselectlayer":this.propagateValue,resize:this.propagateValue,scope:this})
},draw:function(){return this.div
},propagateValueFreqControl:function(){if(Legato.Lang.ObjectUtils.exists(this.lastUpdate)&&(new Date().getTime()-this.lastUpdate.getTime()<this.frequency)){if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.delayedPropagation)){this.delayedPropagation=window.setTimeout(OpenLayers.Function.bind(function(){this.propagateValue()
},this),this.frequency)
}return
}this.propagateValue()
},propagateValue:function(){if(this.map.calculateBounds()===null){return
}if(Legato.Lang.ObjectUtils.exists(this.delayedPropagation)){window.clearTimeout(this.delayedPropagation);
this.delayedPropagation=null
}this.lastUpdate=new Date();
var a={boundingbox:this.map.calculateBounds().toBBOX(),layers:Legato.OpenLayers.Map.Util.getLayerIds(Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore(this.map.layers)),hiddenlayers:Legato.OpenLayers.Map.Util.getLayerIds(Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore(Legato.OpenLayers.Map.Util.getInvisibleLayers(this.map.layers))),"mapsize.width":this.map.getSize().w,"mapsize.height":this.map.getSize().h,selectedlayer:Legato.OpenLayers.Map.Util.getLayerIds(Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore(Legato.OpenLayers.Map.Util.getSelectedLayers(this.map.layers))).toString()};
var b;
if(this.method=="GET"){b=new OpenLayers.Request.GET({url:this.url,params:a})
}else{b=new OpenLayers.Request.POST({url:this.url,data:OpenLayers.Util.getParameterString(a),headers:{"Content-Type":"application/x-www-form-urlencoded"}})
}},CLASS_NAME:"Legato.Control.ViewContextValueProvider"});
Legato.Control.ViewContextValueProvider.Bean=Legato.Control.Bean.Extend("Legato.Control.ViewContextValueProvider",Legato.Control.QName("ViewContextValueProvider"),{_constructor:Legato.Control.ViewContextValueProvider,options:{url:Legato.Lang.String,method:Legato.Lang.String.Enum("HTTPMETHOD",{POST:"POST",GET:"GET"}),frequency:Legato.Lang.Double}});
Legato.Control.ScaleInput=OpenLayers.Class(OpenLayers.Control,{element:null,labelElement:null,inputElement:null,format:null,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,[a]);
if(!Legato.Lang.ObjectUtils.exists(this.format)){this.format=new Legato.Text.PrecisionScaleFormat(3,0)
}},draw:function(){var a=OpenLayers.Control.prototype.draw.apply(this,arguments);
if(!Legato.Lang.ObjectUtils.exists(this.element)){this.element=document.createElement("div");
this.element.id=this.id+"_Element";
this.element.className=this.displayClass+"Element";
a.appendChild(this.element)
}if(!Legato.Lang.ObjectUtils.exists(this.labelElement)){this.labelElement=document.createElement("span");
this.labelElement.id=this.id+"_LabelElement";
this.labelElement.className=this.displayClass+"LabelElement";
this.labelElement.innerHTML="1:";
this.element.appendChild(this.labelElement)
}if(!Legato.Lang.ObjectUtils.exists(this.inputElement)){this.inputElement=document.createElement("input");
this.inputElement.id=this.id+"_InputElement";
this.inputElement.name=this.id+"_InputElement";
this.inputElement.className=this.displayClass+"InputElement";
this.inputElement.type="text";
this.element.appendChild(this.inputElement)
}this.updateInput();
this.inputElement.onchange=OpenLayers.Function.bindAsEventListener(this.updateMap,this);
OpenLayers.Event.observe(this.inputElement,"keypress",OpenLayers.Function.bindAsEventListener(function(b){if(b.keyCode==OpenLayers.Event.KEY_RETURN){this.updateMap()
}},this));
return a
},updateInput:function(){var a=this.getScale();
if(Legato.Lang.ObjectUtils.exists(a)){this.inputElement.value=a
}},updateMap:function(){var a=this.inputElement.value;
var b=this.format.parse(a);
if(isNaN(b)){}else{this.setScale(b,true)
}this.updateInput()
},getScale:function(){var a=this.map.getScale();
if(Legato.Lang.ObjectUtils.isNumber(a)){return this.format.format(a)
}else{return null
}},setScale:function(a){this.map.zoomToScale(a,true)
},setMap:function(a){OpenLayers.Control.prototype.setMap.apply(this,arguments);
this.map.events.on({zoomend:this.updateInput,changebaselayer:this.updateInput,scope:this})
},destroy:function(){if(this.inputElement!==null){this.inputElement.onchange=null
}this.map.events.un({zoomend:this.updateInput,changebaselayer:this.updateInput,scope:this});
this.inputElement=null;
this.labelElement=null;
OpenLayers.Control.prototype.destroy.apply(this,arguments)
},CLASS_NAME:"Legato.Control.ScaleInput"});
Legato.Control.ScaleInput.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.ScaleInput",Legato.Control.QName("ScaleInput"),{_constructor:Legato.Control.ScaleInput,options:{labelElement:Legato.Lang.Element,inputElement:Legato.Lang.Element,scale:Legato.Lang.Integer}});
Legato.Control.SelectBounds=OpenLayers.Class(Legato.Control,{type:OpenLayers.Control.TYPE_TOOL,callback:null,handler:null,initialize:function(a){Legato.Control.prototype.initialize.apply(this,arguments)
},draw:function(){this.handler=new OpenLayers.Handler.Box(this,{done:this.select})
},select:function(a){if(a instanceof OpenLayers.Bounds){var c=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.left,a.bottom));
var d=this.map.getLonLatFromPixel(new OpenLayers.Pixel(a.right,a.top));
var b=new OpenLayers.Bounds(c.lon,c.lat,d.lon,d.lat);
if(Legato.Lang.ObjectUtils.isFunction(this.callback)){this.callback(b)
}}},destroy:function(){if(Legato.Lang.ObjectUtils.exists(this.handler)){this.handler.destroy()
}},CLASS_NAME:"Legato.Control.SelectBounds"});
Legato.Control.SelectBounds.Bean=Legato.Control.Bean.Extend("Legato.Control.SelectBounds",Legato.Control.QName("SelectBounds"),{_constructor:Legato.Control.SelectBounds,options:{callback:Legato.Lang.Function,displayClass:Legato.Lang.String}});
Legato.Control.SelectLonLat=OpenLayers.Class(Legato.Control,{type:OpenLayers.Control.TYPE_TOOL,callback:null,handler:null,initialize:function(a){Legato.Control.prototype.initialize.apply(this,arguments)
},draw:function(){this.handler=new OpenLayers.Handler.Point(this,{done:this.select},{persist:true})
},select:function(b){if(b instanceof OpenLayers.Geometry.Point){var a=new OpenLayers.LonLat(b.x,b.y);
if(Legato.Lang.ObjectUtils.isFunction(this.callback)){this.callback(a)
}}},destroy:function(){if(Legato.Lang.ObjectUtils.exists(this.handler)){this.handler.destroy()
}},CLASS_NAME:"Legato.Control.SelectLonLat"});
Legato.Control.SelectLonLat.Bean=Legato.Control.Bean.Extend("Legato.Control.SelectLonLat",Legato.Control.QName("SelectLonLat"),{_constructor:Legato.Control.SelectLonLat,options:{callback:Legato.Lang.Function,displayClass:Legato.Lang.String}});
Legato.Control.Separator=OpenLayers.Class(OpenLayers.Control,{initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,[a])
},CLASS_NAME:"Legato.Control.Separator"});
Legato.Control.Separator.Bean=Legato.Control.Bean.Extend("Legato.Control.Separator",Legato.Control.QName("Separator"),{factoryFunction:function(a){return new Legato.Control.Separator(a)
},constructorOrder:[]});
Legato.Control.GeoLocation=OpenLayers.Class(Legato.Control,{currentPositionLayer:null,zoomLevel:null,icon:null,iconUrl:null,iconHeight:null,iconWidth:null,name:"My Position",zoomToCurrentPosition:true,showInLegend:true,initialize:function(a){Legato.Control.prototype.initialize.apply(this,[a]);
if(this.iconUrl!==null&&this.iconHeight!==null&&this.iconWidth!==null){var b=new OpenLayers.Size(this.iconWidth,this.iconHeight);
var c=new OpenLayers.Pixel(-(b.w/2),-b.h);
this.icon=new OpenLayers.Icon(this.iconUrl,b,c)
}},setMap:function(a){OpenLayers.Control.prototype.setMap.apply(this,arguments);
if(this.zoomLevel===null){this.zoomLevel=this.map.getNumZoomLevels()-1
}},draw:function(){OpenLayers.Control.prototype.draw.apply(this)
},destroy:function(){OpenLayers.Control.prototype.destroy.apply(this,arguments)
},activate:function(){if(!Legato.Util.GeoLocation.isAvailable()){return false
}OpenLayers.Control.prototype.activate.apply(this,arguments);
if(this.currentPositionLayer!==null&&this.map.getLayer(this.currentPositionLayer.id)===null){this.currentPositionLayer.setVisibility(true);
this.map.addLayer(this.currentPositionLayer)
}if(this.currentPositionLayer===null){Legato.Util.GeoLocation.getCurrentPosition(this.onPositionDefined.bind(this),this.onPositionError.bind(this))
}if(this.zoomToCurrentPosition&&this.map.isValidLonLat(this.currentPosition)){if(this.map.isValidZoomLevel(this.zoomLevel)){this.map.setCenter(this.currentPosition,this.zoomLevel)
}this.map.setCenter(this.currentPosition)
}},deactivate:function(){OpenLayers.Control.prototype.deactivate.apply(this,arguments)
},onPositionError:function(a){switch(a.code){case a.PERMISSION_DENIED:break;
case a.POSITION_UNAVAILABLE:break;
case a.TIMEOUT:break;
default:break
}this.deactivate()
},onPositionDefined:function(a){this.currentPosition=new OpenLayers.LonLat(a.coords.longitude,a.coords.latitude);
if(this.zoomToCurrentPosition){this.map.setCenter(this.currentPosition,this.zoomLevel)
}if(this.icon===null){this.currentPositionLayer=new OpenLayers.Layer.Vector(this.name,{styleMap:new OpenLayers.StyleMap({externalGraphic:"http://openlayers.org/dev/img/marker-gold.png",backgroundGraphic:"http://openlayers.org/dev/examples/marker_shadow.png",backgroundXOffset:0,backgroundYOffset:-7,graphicZIndex:11,backgroundGraphicZIndex:10,pointRadius:10}),isBaseLayer:false,rendererOptions:{yOrdering:true}});
var b=[];
b.push(new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(a.coords.longitude,a.coords.latitude)));
this.currentPositionLayer.addFeatures(b);
this.currentPositionLayer.options.legatoIgnore=!this.showInLegend;
this.map.addLayer(this.currentPositionLayer)
}else{this.currentPositionLayer=new OpenLayers.Layer.Markers(this.name);
this.currentPositionLayer.options.legatoIgnore=!this.showInLegend;
this.map.addLayer(this.currentPositionLayer);
this.currentPositionLayer.addMarker(new OpenLayers.Marker(this.currentPosition,this.icon))
}},CLASS_NAME:"Legato.Control.GeoLocation"});
Legato.Control.GeoLocation.Bean=Legato.Control.Bean.Extend("Legato.Control.GeoLocation",Legato.Control.QName("GeoLocation"),{_constructor:Legato.Control.GeoLocation,options:{zoomLevel:Legato.Lang.Integer,iconUrl:Legato.Lang.String,iconHeight:Legato.Lang.Integer,iconWidth:Legato.Lang.Integer,name:Legato.Lang.String,zoomToCurrentPosition:Legato.Lang.Boolean,showInLegend:Legato.Lang.Boolean}});
Legato.Control.CallbackLocker=OpenLayers.Class(OpenLayers.Control,{targetElement:null,lock:null,unlock:null,initialize:function(a){Legato.Util.Ensure.ensureExists(a.targetElement);
Legato.Util.Ensure.ensureFunction(a.lock);
Legato.Util.Ensure.ensureFunction(a.unlock);
OpenLayers.Control.prototype.initialize.apply(this,arguments)
},lockElement:function(){this.lock(this.targetElement)
},unlockElement:function(){this.unlock(this.targetElement)
},CLASS_NAME:"Legato.Control.CallbackLocker"});
Legato.Control.CallbackLocker.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.CallbackLocker",Legato.Control.QName("CallbackLocker"),{_constructor:Legato.Control.CallbackLocker,options:{targetElement:Legato.Lang.Element,lock:Legato.Lang.Function,unlock:Legato.Lang.Function}});
Legato.Control.SynchronousSnappingResolver=OpenLayers.Class(Legato.Control,{logger:null,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,[a]);
this.logger=Legato.Util.Logger.getLogger()
},getSnapPoint:function(h,b,d,g){var e=this;
var f=function(i){return e.onSuccess(i,g)
};
var c=function(j,i){return e.onFailure(j,i)
};
this.locker.lockElement();
var a=e.snappingResolver.getSnapPoint(h,b,d,{callback:f,exceptionHandler:c})
},getSnapPoints:function(b,c,g,d,h){var e=this;
var f=function(j){return e.onSuccess(j,h)
};
var a=function(k,j){return e.onFailure(k,j)
};
this.locker.lockElement();
var i=this.snappingResolver.getSnapPoints(b,c,g,d,{callback:f,exceptionHandler:a})
},onSuccess:function(a,b){this.locker.unlockElement();
return b(a)
},onFailure:function(b,a){this.locker.unlockElement()
},CLASS_NAME:"Legato.Control.SynchronousSnappingResolver"});
Legato.Control.SynchronousSnappingResolver.Bean=Legato.Control.Bean.Extend("Legato.Control.SynchronousSnappingResolver",Legato.Control.QName("SynchronousSnappingResolver"),{_constructor:Legato.Control.SynchronousSnappingResolver,options:{snappingResolver:Legato.Lang.Function,locker:Legato.Beans.Object}});
Legato.Control.SnappingController=OpenLayers.Class(Legato.Control,{map:null,snappingResolver:null,snappingLayer:null,layerId:null,logger:null,format:new OpenLayers.Format.GeoJSON(),initialize:function(a){this.logger=Legato.Util.Logger.getLogger();
OpenLayers.Control.prototype.initialize.apply(this,arguments);
this.map.events.on({addlayer:this.registerFeatureLayerDrawEvents,removelayer:this.deregisterFeatureLayerDrawEvents,scope:this})
},destroy:function(){this.map.events.un({addlayer:this.registerFeatureLayerDrawEvents,removelayer:this.deregisterFeatureLayerDrawEvents,scope:this});
OpenLayers.Control.prototype.destroy.apply(this,arguments)
},deregisterFeatureLayerDrawEvents:function(a){if(Legato.OpenLayers.Map.Util.isVectorLayer(a.layer)){a.layer.events.un({"legato.sketchpointadded":this.onSketchpointAdded,scope:this})
}if(Legato.Lang.ObjectUtils.exists(a.layer.layerId)&&a.layer.layerId===this.layerId){this.layerId=null;
this.snappingLayer=null
}},registerFeatureLayerDrawEvents:function(a){if(Legato.OpenLayers.Map.Util.isVectorLayer(a.layer)){a.layer.events.on({"legato.sketchpointadded":this.onSketchpointAdded,scope:this})
}},setLayerId:function(a){var b=this.map.getLayersBy("layerId",a);
this.snappingLayer=b.length===1?b[0]:null;
this.layerId=this.snappingLayer!==null?a:null
},getLayerId:function(){return this.layerId
},onSketchpointAdded:function(b){if(!this.isSnappingActive()){return
}var a=b.layer;
var d=b.geometry;
var c=b.vertex.clone(null);
this.snappingResolver.getSnapPoint(this.layerId,this.map.getResolution(),this.format.extract.geometry.call(this.format,c),OpenLayers.Function.bind(function(e){e=this.format.parseGeometry(e);
if(c.equals(e)){}else{if(this.updateGeometry(d,c,e)){a.events.triggerEvent("legato.sketchupdated",{layer:a,geometry:d})
}}},this))
},isSnappingActive:function(){if(this.snappingLayer===null&&this.layerId!==null){this.setLayerId(this.layerId)
}return this.snappingLayer!==null
},updateGeometry:function(e,d,a){var b=e.getVertices();
for(var c=0;
c<b.length;
c++){if(b[c].equals(d)){b[c].x=a.x;
b[c].y=a.y;
return true
}}return false
},CLASS_NAME:"Legato.Control.SnappingController"});
Legato.Control.SnappingController.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.SnappingController",Legato.Control.QName("SnappingController"),{_constructor:Legato.Control.SnappingController,options:{map:OpenLayers.Map,snappingResolver:Legato.Control,layerId:Legato.Lang.String}});
Legato.Control.SnappableLayerSelector=OpenLayers.Class(Legato.Control,{map:null,targetSnappingController:null,div:null,selectElement:null,selectLabel:null,txtSelect:"Please choose an option",txtNoSnapping:"No snapping",initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments)
},setMap:function(a){OpenLayers.Control.prototype.setMap.apply(this,arguments);
this.map.events.on({addlayer:this.layerAdded,removelayer:this.layerRemoved,scope:this})
},destroy:function(){this.map.events.un({addlayer:this.layerAdded,removelayer:this.layerRemoved,scope:this})
},draw:function(){if(this.selectLabel!==null){this.div.removeChild(this.selectLabel)
}this.selectLabel=document.createElement("span");
this.selectLabel.innerHTML=this.txtSelect+" ";
this.div.appendChild(this.selectLabel);
if(this.selectElement!==null){this.div.removeChild(this.selectElement)
}this.selectElement=document.createElement("select");
this.selectElement.className="snappableLayerSelectionDropDown";
this.selectElement.onchange=OpenLayers.Function.bindAsEventListener(this.selectionChanged,this);
this.selectElement.appendChild(this.createOption(this.txtNoSnapping,null,false));
this.div.appendChild(this.selectElement);
var a=this.targetSnappingController.getLayerId();
var d=Legato.OpenLayers.Map.Util.getSnappableLayers(this.map.layers);
for(var b=0;
b<d.length;
b++){var c=d[b];
this.selectElement.appendChild(this.createOption(c.title,c.layerId,(a===c.layerId)))
}return this.div
},selectionChanged:function(b){var a=(b.target||b.srcElement).value;
this.targetSnappingController.setLayerId(a)
},createOption:function(a,d,c){var b=document.createElement("option");
b.value=d;
b.selected=c;
b.innerHTML=a;
return b
},layerAdded:function(a){this.draw()
},layerRemoved:function(a){this.draw()
},CLASS_NAME:"Legato.Control.SnappableLayerSelector"});
Legato.Control.SnappableLayerSelector.Bean=OpenLayers.Control.Bean.Extend("Legato.Control.SnappableLayerSelector",Legato.Control.QName("SnappableLayerSelector"),{_constructor:Legato.Control.SnappableLayerSelector,options:{map:OpenLayers.Map,div:Legato.Lang.Element,targetSnappingController:Legato.Control.SnappingController.Bean,txtSelect:Legato.Lang.String,txtNoSnapping:Legato.Lang.String}});
Legato.Format={};
Legato.Format.NAMESPACE_URI="http://www.disy.net/legato/format";
Legato.Format.PREFIX="lf";
Legato.Format.QName=function(a){return new Legato.XML.QName(Legato.Format.NAMESPACE_URI,a,Legato.Format.PREFIX)
};
Legato.Format.Bean=Legato.Beans.Object.Extend("Legato.Format",Legato.Control.QName("Format"),{_constructor:Legato.Format});
OpenLayers.Format.ArcXML=OpenLayers.Class(OpenLayers.Format.XML,{fontStyleKeys:["antialiasing","blockout","font","fontcolor","fontsize","fontstyle","glowing","interval","outline","printmode","shadow","transparency"],request:null,response:null,initialize:function(a){this.request=new OpenLayers.Format.ArcXML.Request();
this.response=new OpenLayers.Format.ArcXML.Response();
if(a){if(a.requesttype=="feature"){this.request.get_image=null;
var c=this.request.get_feature.query;
this.addCoordSys(c.featurecoordsys,a.featureCoordSys);
this.addCoordSys(c.filtercoordsys,a.filterCoordSys);
if(a.polygon){c.isspatial=true;
c.spatialfilter.polygon=a.polygon
}else{if(a.envelope){c.isspatial=true;
c.spatialfilter.envelope={minx:0,miny:0,maxx:0,maxy:0};
this.parseEnvelope(c.spatialfilter.envelope,a.envelope)
}}}else{if(a.requesttype=="image"){this.request.get_feature=null;
var b=this.request.get_image.properties;
this.parseEnvelope(b.envelope,a.envelope);
this.addLayers(b.layerlist,a.layers);
this.addImageSize(b.imagesize,a.tileSize);
this.addBackground(b.background,a.background);
this.addCoordSys(b.featurecoordsys,a.featureCoordSys);
this.addCoordSys(b.filtercoordsys,a.filterCoordSys)
}else{this.request=null
}}}OpenLayers.Format.XML.prototype.initialize.apply(this,[a])
},parseEnvelope:function(b,a){if(a&&a.length==4){b.minx=a[0];
b.miny=a[1];
b.maxx=a[2];
b.maxy=a[3]
}},addLayers:function(d,c){for(var b=0,a=c.length;
b<a;
b++){d.push(c[b])
}},addImageSize:function(b,a){if(a!==null){b.width=a.w;
b.height=a.h;
b.printwidth=a.w;
b.printheight=a.h
}},addBackground:function(a,b){if(b!==null){a.color.r=b.color.r;
a.color.g=b.color.g;
a.color.b=b.color.b;
if(b.transcolor!==null){a.transcolor.r=b.transcolor.r;
a.transcolor.g=b.transcolor.g;
a.transcolor.b=b.transcolor.b
}else{a.transcolor=null
}}else{this.request.get_image.properties.background=null
}},addCoordSys:function(a,b){if(typeof b=="string"){a.id=parseInt(b,10);
a.string=b
}else{if(typeof b=="object"&&b.proj!==null){a.id=b.proj.srsProjNumber;
a.string=b.proj.srsCode
}else{a=b
}}},iserror:function(c){var a=null;
if(!c){a=(this.response.error!=="")
}else{c=OpenLayers.Format.XML.prototype.read.apply(this,[c]);
var b=c.documentElement.getElementsByTagName("ERROR");
a=(b!==null&&b.length>0)
}return a
},read:function(f){if(typeof f=="string"){f=OpenLayers.Format.XML.prototype.read.apply(this,[f])
}var a=null;
if(f&&f.documentElement){if(f.documentElement.nodeName=="ARCXML"){a=f.documentElement
}else{a=f.documentElement.getElementsByTagName("ARCXML")[0]
}}if(!a){var c,e;
try{c=f.firstChild.nodeValue;
e=f.firstChild.childNodes[1].firstChild.nodeValue
}catch(d){}throw {message:"Error parsing the ArcXML request",error:c,source:e}
}var b=this.parseResponse(a);
return b
},write:function(c){if(!c){c=this.request
}var q=this.createElementNS("","ARCXML");
q.setAttribute("version","1.1");
var h=this.createElementNS("","REQUEST");
var k;
if(c.get_image!==null){k=this.createElementNS("","GET_IMAGE");
h.appendChild(k);
var j=this.createElementNS("","PROPERTIES");
k.appendChild(j);
var b=c.get_image.properties;
if(b.featurecoordsys!==null){var o=this.createElementNS("","FEATURECOORDSYS");
j.appendChild(o);
if(b.featurecoordsys.id===0){o.setAttribute("string",b.featurecoordsys.string)
}else{o.setAttribute("id",b.featurecoordsys.id)
}}if(b.filtercoordsys!==null){var m=this.createElementNS("","FILTERCOORDSYS");
j.appendChild(m);
if(b.filtercoordsys.id===0){m.setAttribute("string",b.filtercoordsys.string)
}else{m.setAttribute("id",b.filtercoordsys.id)
}}if(b.envelope!==null){var u=this.createElementNS("","ENVELOPE");
j.appendChild(u);
u.setAttribute("minx",b.envelope.minx);
u.setAttribute("miny",b.envelope.miny);
u.setAttribute("maxx",b.envelope.maxx);
u.setAttribute("maxy",b.envelope.maxy)
}var s=this.createElementNS("","IMAGESIZE");
j.appendChild(s);
s.setAttribute("height",b.imagesize.height);
s.setAttribute("width",b.imagesize.width);
if(b.imagesize.height!=b.imagesize.printheight||b.imagesize.width!=b.imagesize.printwidth){s.setAttribute("printheight",b.imagesize.printheight);
s.setArrtibute("printwidth",b.imagesize.printwidth)
}if(b.background!==null){var a=this.createElementNS("","BACKGROUND");
j.appendChild(a);
a.setAttribute("color",b.background.color.r+","+b.background.color.g+","+b.background.color.b);
if(b.background.transcolor!==null){a.setAttribute("transcolor",b.background.transcolor.r+","+b.background.transcolor.g+","+b.background.transcolor.b)
}}if(b.layerlist!==null&&b.layerlist.length>0){var g=this.createElementNS("","LAYERLIST");
j.appendChild(g);
for(var p=0;
p<b.layerlist.length;
p++){var n=this.createElementNS("","LAYERDEF");
g.appendChild(n);
n.setAttribute("id",b.layerlist[p].id);
n.setAttribute("visible",b.layerlist[p].visible);
if(typeof b.layerlist[p].query=="object"){var f=b.layerlist[p].query;
if(f.where.length<0){continue
}var x=null;
if(typeof f.spatialfilter=="boolean"&&f.spatialfilter){x=this.createElementNS("","SPATIALQUERY")
}else{x=this.createElementNS("","QUERY")
}x.setAttribute("where",f.where);
if(typeof f.accuracy=="number"&&f.accuracy>0){x.setAttribute("accuracy",f.accuracy)
}if(typeof f.featurelimit=="number"&&f.featurelimit<2000){x.setAttribute("featurelimit",f.featurelimit)
}if(typeof f.subfields=="string"&&f.subfields!="#ALL#"){x.setAttribute("subfields",f.subfields)
}if(typeof f.joinexpression=="string"&&f.joinexpression.length>0){x.setAttribute("joinexpression",f.joinexpression)
}if(typeof f.jointables=="string"&&f.jointables.length>0){x.setAttribute("jointables",f.jointables)
}n.appendChild(x)
}if(typeof b.layerlist[p].renderer=="object"){this.addRenderer(n,b.layerlist[p].renderer)
}}}}else{if(c.get_feature!==null){k=this.createElementNS("","GET_FEATURES");
k.setAttribute("outputmode","newxml");
k.setAttribute("checkesc","true");
if(c.get_feature.geometry){k.setAttribute("geometry",c.get_feature.geometry)
}else{k.setAttribute("geometry","false")
}if(c.get_feature.compact){k.setAttribute("compact",c.get_feature.compact)
}if(c.get_feature.featurelimit=="number"){k.setAttribute("featurelimit",c.get_feature.featurelimit)
}k.setAttribute("globalenvelope","true");
h.appendChild(k);
if(c.get_feature.layer!==null&&c.get_feature.layer.length>0){var v=this.createElementNS("","LAYER");
v.setAttribute("id",c.get_feature.layer);
k.appendChild(v)
}var r=c.get_feature.query;
if(r!==null){var t=null;
if(r.isspatial){t=this.createElementNS("","SPATIALQUERY")
}else{t=this.createElementNS("","QUERY")
}k.appendChild(t);
if(typeof r.accuracy=="number"){t.setAttribute("accuracy",r.accuracy)
}if(r.featurecoordsys!==null){var e=this.createElementNS("","FEATURECOORDSYS");
if(r.featurecoordsys.id===0){e.setAttribute("string",r.featurecoordsys.string)
}else{e.setAttribute("id",r.featurecoordsys.id)
}t.appendChild(e)
}if(r.filtercoordsys!==null){var d=this.createElementNS("","FILTERCOORDSYS");
if(r.filtercoordsys.id===0){d.setAttribute("string",r.filtercoordsys.string)
}else{d.setAttribute("id",r.filtercoordsys.id)
}t.appendChild(d)
}if(r.buffer>0){var l=this.createElementNS("","BUFFER");
l.setAttribute("distance",r.buffer);
t.appendChild(l)
}if(r.isspatial){var i=this.createElementNS("","SPATIALFILTER");
i.setAttribute("relation",r.spatialfilter.relation);
t.appendChild(i);
if(r.spatialfilter.envelope){var w=this.createElementNS("","ENVELOPE");
w.setAttribute("minx",r.spatialfilter.envelope.minx);
w.setAttribute("miny",r.spatialfilter.envelope.miny);
w.setAttribute("maxx",r.spatialfilter.envelope.maxx);
w.setAttribute("maxy",r.spatialfilter.envelope.maxy);
i.appendChild(w)
}else{if(typeof r.spatialfilter.polygon=="object"){i.appendChild(this.writePolygonGeometry(r.spatialfilter.polygon))
}}}if(r.where!==null&&r.where.length>0){t.setAttribute("where",r.where)
}}}}q.appendChild(h);
return OpenLayers.Format.XML.prototype.write.apply(this,[q])
},addGroupRenderer:function(b,a){var e=this.createElementNS("","GROUPRENDERER");
b.appendChild(e);
for(var c=0;
c<a.length;
c++){var d=a[c];
this.addRenderer(e,d)
}},addRenderer:function(c,b){if(b instanceof Array){this.addGroupRenderer(c,b)
}else{var a=this.createElementNS("",b.type.toUpperCase()+"RENDERER");
c.appendChild(a);
if(a.tagName=="VALUEMAPRENDERER"){this.addValueMapRenderer(a,b)
}else{if(a.tagName=="VALUEMAPLABELRENDERER"){this.addValueMapLabelRenderer(a,b)
}else{if(a.tagName=="SIMPLELABELRENDERER"){this.addSimpleLabelRenderer(a,b)
}else{if(a.tagName=="SCALEDEPENDENTRENDERER"){this.addScaleDependentRenderer(a,b)
}}}}}},addScaleDependentRenderer:function(a,b){if(typeof b.lower=="string"||typeof b.lower=="number"){a.setAttribute("lower",b.lower)
}if(typeof b.upper=="string"||typeof b.upper=="number"){a.setAttribute("upper",b.upper)
}this.addRenderer(a,b.renderer)
},addValueMapLabelRenderer:function(h,g){h.setAttribute("lookupfield",g.lookupfield);
h.setAttribute("labelfield",g.labelfield);
if(typeof g.exacts=="object"){for(var a=0,k=g.exacts.length;
a<k;
a++){var e=g.exacts[a];
var d=this.createElementNS("","EXACT");
if(typeof e.value=="string"){d.setAttribute("value",e.value)
}if(typeof e.label=="string"){d.setAttribute("label",e.label)
}if(typeof e.method=="string"){d.setAttribute("method",e.method)
}h.appendChild(d);
if(typeof e.symbol=="object"){var b=null;
if(e.symbol.type=="text"){b=this.createElementNS("","TEXTSYMBOL")
}if(b!==null){var l=this.fontStyleKeys;
for(var c=0,f=l.length;
c<f;
c++){var j=l[c];
if(symbol[j]){b.setAttribute(j,g[j])
}}d.appendChild(b)
}}}}},addValueMapRenderer:function(j,i){var d;
j.setAttribute("lookupfield",i.lookupfield);
if(typeof i.ranges=="object"){for(var a=0,b=i.ranges.length;
a<b;
a++){var g=i.ranges[a];
var e=this.createElementNS("","RANGE");
e.setAttribute("lower",g.lower);
e.setAttribute("upper",g.upper);
j.appendChild(e);
if(typeof g.symbol=="object"){d=null;
if(g.symbol.type=="simplepolygon"){d=this.createElementNS("","SIMPLEPOLYGONSYMBOL")
}if(d!==null){if(typeof g.symbol.boundarycolor=="string"){d.setAttribute("boundarycolor",g.symbol.boundarycolor)
}if(typeof g.symbol.fillcolor=="string"){d.setAttribute("fillcolor",g.symbol.fillcolor)
}if(typeof g.symbol.filltransparency=="number"){d.setAttribute("filltransparency",g.symbol.filltransparency)
}e.appendChild(d)
}}}}else{if(typeof i.exacts=="object"){for(var c=0,k=i.exacts.length;
c<k;
c++){var h=i.exacts[c];
var f=this.createElementNS("","EXACT");
if(typeof h.value=="string"){f.setAttribute("value",h.value)
}if(typeof h.label=="string"){f.setAttribute("label",h.label)
}if(typeof h.method=="string"){f.setAttribute("method",h.method)
}j.appendChild(f);
if(typeof h.symbol=="object"){d=null;
if(h.symbol.type=="simplemarker"){d=this.createElementNS("","SIMPLEMARKERSYMBOL")
}if(d!==null){if(typeof h.symbol.antialiasing=="string"){d.setAttribute("antialiasing",h.symbol.antialiasing)
}if(typeof h.symbol.color=="string"){d.setAttribute("color",h.symbol.color)
}if(typeof h.symbol.outline=="string"){d.setAttribute("outline",h.symbol.outline)
}if(typeof h.symbol.overlap=="string"){d.setAttribute("overlap",h.symbol.overlap)
}if(typeof h.symbol.shadow=="string"){d.setAttribute("shadow",h.symbol.shadow)
}if(typeof h.symbol.transparency=="number"){d.setAttribute("transparency",h.symbol.transparency)
}if(typeof h.symbol.usecentroid=="string"){d.setAttribute("usecentroid",h.symbol.usecentroid)
}if(typeof h.symbol.width=="number"){d.setAttribute("width",h.symbol.width)
}f.appendChild(d)
}}}}}},addSimpleLabelRenderer:function(f,h){f.setAttribute("field",h.field);
var e=["featureweight","howmanylabels","labelbufferratio","labelpriorities","labelweight","linelabelposition","rotationalangles"];
var d;
for(var c=0,a=e.length;
c<a;
c++){d=e[c];
if(h[d]){f.setAttribute(d,h[d])
}}if(h.symbol.type=="text"){var g=h.symbol;
var b=this.createElementNS("","TEXTSYMBOL");
f.appendChild(b);
e=this.fontStyleKeys;
for(c=0,a=e.length;
c<a;
c++){d=e[c];
if(g[d]){b.setAttribute(d,h[d])
}}}},writePolygonGeometry:function(g){if(!(g instanceof OpenLayers.Geometry.Polygon)){throw {message:"Cannot write polygon geometry to ArcXML with an "+g.CLASS_NAME+" object.",geometry:g}
}var b=this.createElementNS("","POLYGON");
for(var e=0,c=g.components.length;
e<c;
e++){var a=g.components[e];
var i=this.createElementNS("","RING");
for(var d=0,j=a.components.length;
d<j;
d++){var h=a.components[d];
var f=this.createElementNS("","POINT");
f.setAttribute("x",h.x);
f.setAttribute("y",h.y);
i.appendChild(f)
}b.appendChild(i)
}return b
},parseResponse:function(z){if(typeof z=="string"){var n=new OpenLayers.Format.XML();
z=n.read(z)
}var a=new OpenLayers.Format.ArcXML.Response();
var A=z.getElementsByTagName("ERROR");
if(A!==null&&A.length>0){a.error=this.getChildValue(A,"Unknown error.")
}else{var r=z.getElementsByTagName("RESPONSE");
if(r===null||r.length===0){a.error="No RESPONSE tag found in ArcXML response.";
return a
}var q=r[0].firstChild.nodeName;
if(q=="#text"){q=r[0].firstChild.nextSibling.nodeName
}if(q=="IMAGE"){var c=z.getElementsByTagName("ENVELOPE");
var w=z.getElementsByTagName("OUTPUT");
if(c===null||c.length===0){a.error="No ENVELOPE tag found in ArcXML response."
}else{if(w===null||w.length===0){a.error="No OUTPUT tag found in ArcXML response."
}else{var u=this.parseAttributes(c[0]);
var v=this.parseAttributes(w[0]);
if(typeof v.type=="string"){a.image={envelope:u,output:{type:v.type,data:this.getChildValue(w[0])}}
}else{a.image={envelope:u,output:v}
}}}}else{if(q=="FEATURES"){var i=r[0].getElementsByTagName("FEATURES");
var p=i[0].getElementsByTagName("FEATURECOUNT");
a.features.featurecount=p[0].getAttribute("count");
if(a.features.featurecount>0){var d=i[0].getElementsByTagName("ENVELOPE");
a.features.envelope=this.parseAttributes(d[0],typeof(0));
var x=i[0].getElementsByTagName("FEATURE");
for(var m=0;
m<x.length;
m++){var h=new OpenLayers.Feature.Vector();
var s=x[m].getElementsByTagName("FIELD");
for(var f=0;
f<s.length;
f++){var g=s[f].getAttribute("name");
var k=s[f].getAttribute("value");
h.attributes[g]=k
}var t=x[m].getElementsByTagName("POLYGON");
if(t.length>0){var j=t[0].getElementsByTagName("RING");
var e=[];
for(var o=0;
o<j.length;
o++){var y=[];
y.push(this.parsePointGeometry(j[o]));
var l=j[o].getElementsByTagName("HOLE");
for(var b=0;
b<l.length;
b++){y.push(this.parsePointGeometry(l[b]))
}l=null;
e.push(new OpenLayers.Geometry.Polygon(y));
y=null
}j=null;
if(e.length==1){h.geometry=e[0]
}else{h.geometry=new OpenLayers.Geometry.MultiPolygon(e)
}}a.features.feature.push(h)
}}}else{a.error="Unidentified response type."
}}}return a
},parseAttributes:function(d,c){var b={};
for(var a=0;
a<d.attributes.length;
a++){if(c=="number"){b[d.attributes[a].nodeName]=parseFloat(d.attributes[a].nodeValue)
}else{b[d.attributes[a].nodeName]=d.attributes[a].nodeValue
}}return b
},parsePointGeometry:function(d){var b=[];
var e=d.getElementsByTagName("COORDS");
if(e.length>0){var f=this.getChildValue(e[0]);
f=f.split(/;/);
for(var h=0;
h<f.length;
h++){var g=f[h].split(/ /);
b.push(new OpenLayers.Geometry.Point(parseFloat(g[0]),parseFloat(g[1])))
}e=null
}else{var a=d.getElementsByTagName("POINT");
if(a.length>0){for(var c=0;
c<a.length;
c++){b.push(new OpenLayers.Geometry.Point(parseFloat(a[c].getAttribute("x")),parseFloat(a[c].getAttribute("y"))))
}}a=null
}return new OpenLayers.Geometry.LinearRing(b)
},CLASS_NAME:"OpenLayers.Format.ArcXML"});
OpenLayers.Format.ArcXML.Request=OpenLayers.Class({initialize:function(b){var a={get_image:{properties:{background:{color:{r:255,g:255,b:255},transcolor:{r:255,g:255,b:255}},draw:true,envelope:{minx:0,miny:0,maxx:0,maxy:0},featurecoordsys:{id:0,string:"",datumtransformid:0,datumtransformstring:""},filtercoordsys:{id:0,string:"",datumtransformid:0,datumtransformstring:""},imagesize:{height:0,width:0,dpi:96,printheight:0,printwidth:0,scalesymbols:false},layerlist:[],output:{baseurl:"",legendbaseurl:"",legendname:"",legendpath:"",legendurl:"",name:"",path:"",type:"jpg",url:""}}},get_feature:{layer:"",query:{isspatial:false,featurecoordsys:{id:0,string:"",datumtransformid:0,datumtransformstring:""},filtercoordsys:{id:0,string:"",datumtransformid:0,datumtransformstring:""},buffer:0,where:"",spatialfilter:{relation:"envelope_intersection",envelope:null}}},environment:{separators:{cs:" ",ts:";"}},layer:[],workspaces:[]};
return OpenLayers.Util.extend(this,a)
},CLASS_NAME:"OpenLayers.Format.ArcXML.Request"});
OpenLayers.Format.ArcXML.Response=OpenLayers.Class({initialize:function(b){var a={image:{envelope:null,output:""},features:{featurecount:0,envelope:null,feature:[]},error:""};
return OpenLayers.Util.extend(this,a)
},CLASS_NAME:"OpenLayers.Format.ArcXML.Response"});
Legato.Format.GML3=OpenLayers.Class(OpenLayers.Format.GML.v3,{featureNS:"http://www.opengis.net/gml/simple",featureName:"Feature",featureCollectionName:"FeatureCollection",featureGeometryName:"geometry",initialize:function(a){OpenLayers.Format.GML.v3.prototype.initialize.apply(this,[a]);
this.featureType=this.featureName;
this.geometryName=this.featureGeometryName;
this.namespaces.feature=this.featureNS;
this.namespaceAlias[this.featureNS]="feature";
this.writers.feature[this.featureCollectionName]=OpenLayers.Function.bind(this.writeFeatures,this);
this.readers.feature[this.featureCollectionName]=OpenLayers.Function.bind(this.readFeatures,this)
},writeFeatures:function(c){var d=this.createElementNSPlus("feature:"+this.featureCollectionName);
for(var b=0,a=c.length;
b<a;
++b){this.writeNode("gml:featureMember",c[b],d)
}return d
},readFeatures:function(a,b){this.readChildNodes(a,b)
},write:function(b){var a=this.writeNode("feature:"+this.featureCollectionName,b);
return OpenLayers.Format.XML.prototype.write.apply(this,[a])
},CLASS_NAME:"Legato.Format.GML3"});
Legato.Format.GML3.Bean=Legato.Format.Bean.Extend("Legato.Format.GML3",Legato.Format.QName("GML3"),{_constructor:Legato.Format.GML3});
Legato.Format.ExtendedWMC=OpenLayers.Class({parser:null,layerFactories:null,initialize:function(a){this.layerFactories={};
for(var b in Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES){if(Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES.hasOwnProperty(b)){this.layerFactories[b]=Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES[b]
}}if(Legato.Lang.ObjectUtils.isObject(a)&&Legato.Lang.ObjectUtils.exists(a.layerFactories)){Legato.Util.Ensure.ensureObject(a.layerFactories);
for(b in a.layerFactories){if(a.layerFactories.hasOwnProperty(b)){this.layerFactories[b]=a.layerFactories[b]
}}}this.parser=new Legato.Format.ExtendedWMC.Parser({layerFactories:this.layerFactories})
},beanFactory:null,setBeanFactory:function(a){this.beanFactory=a;
this.parser.setBeanFactory(a)
},getBeanFactory:function(){if(this.beanFactory===null){this.beanFactory=new Legato.Beans.XMLBeanFactory()
}return this.beanFactory
},read:function(d,c){var b=this.parser.read(d);
var a=this.modelToResult(b,c);
return a
},modelToResult:function(c,b){var a=new Legato.Format.ExtendedWMC.Result();
a.model=c;
var d=this.processLayers(c,b);
a.layers=d;
return a
},processLayers:function(f,j){var d=[];
if(f.layerList){if(!Legato.Lang.ObjectUtils.exists(j)){j={}
}if(!Legato.Lang.ObjectUtils.exists(j.transparent)){j.transparent=true
}var b=j.transparent;
for(var e=0;
e<f.layerList.length;
e++){var h=f.layerList[e];
var a="OGC:WMS";
if(h.server&&h.server.service){a=h.server.service
}var c=this.layerFactories[a];
if(!Legato.Lang.ObjectUtils.exists(c)){throw new Legato.Lang.Exception("Layer factory for the layer type ["+a+"] is not registered.")
}else{j.formatList=h.formatList;
if(h.currentFormat==="image/jpeg"){j.transparent="false"
}else{j.transparent=b
}var g=c.createLayer(h,j,this.getBeanFactory());
d.push(g)
}}}return d
},CLASS_NAME:"Legato.Format.ExtendedWMC"});
Legato.Format.ExtendedWMC.Bean=Legato.Format.Bean.Extend("Legato.Format.ExtendedWMC",Legato.Format.QName("ExtendedWMC"),{_constructor:Legato.Format.ExtendedWMC});
Legato.Format.ExtendedWMC.Result=OpenLayers.Class({initialize:function(){this.layers=[]
},layers:null,model:null,CLASS_NAME:"Legato.Format.ExtendedWMC.Result"});
Legato.Format.ExtendedWMCLoader=Legato.Lang.Class({map:null,url:null,params:null,defaultOptions:null,createDefaultBaseLayer:false,zoomToBoundingBox:true,resizeToWindow:true,initialize:function(c){this.format=new Legato.Format.ExtendedWMC();
this.map=c.map;
var b=c.url;
var a=b.indexOf("?");
if(a>0){this.url=b.substring(0,a);
this.params=OpenLayers.Util.getParameters(b)
}else{this.url=b;
this.params=null
}this.defaultOptions=Legato.Lang.ObjectUtils.exists(c.defaultOptions)?c.defaultOptions:{};
this.zoomToBoundingBox=Legato.Lang.ObjectUtils.exists(c.zoomToBoundingBox)?c.zoomToBoundingBox:true;
this.resizeToWindow=Legato.Lang.ObjectUtils.exists(c.resizeToWindow)?c.resizeToWindow:true;
this.createDefaultBaseLayer=Legato.Lang.ObjectUtils.exists(c.createDefaultBaseLayer)?c.createDefaultBaseLayer:false
},load:function(){var c=function(f){try{var n=this.format.read(f.responseText,this.defaultOptions);
if(this.resizeToWindow&&n.model.window){this.map.updateSize()
}if(Legato.Lang.ObjectUtils.exists(n.model.extension)){Legato.Lang.CollectionUtils.copyIfExists(n.model.extension,this.map,["minExtent","maxExtent","minScale","maxScale","minResolution","maxResolution","units","tags"]);
if(Legato.Lang.ObjectUtils.exists(n.model.extension.maxExtent)){var o=n.model.extension.maxExtent;
var t=this.map.getSize();
var l=o.getWidth()/t.w;
var j=o.getHeight()/t.h;
this.map.maxResolution=Math.max(l,j)
}if(Legato.Lang.ObjectUtils.exists(n.model.extension.minExtent)){var k=n.model.extension.minExtent;
var s=this.map.getSize();
var g=k.getWidth()/s.w;
var d=k.getHeight()/s.h;
this.map.minResolution=Math.min(g,d)
}if(Legato.Lang.ObjectUtils.exists(n.model.extension.dpi)){OpenLayers.DOTS_PER_INCH=n.model.extension.dpi
}}var m=n.layers;
for(var q=0;
q<m.length;
q++){var w=m[q];
if(this.map.fractionalZoom&&Legato.Lang.ObjectUtils.exists(w.minScale)&&Legato.Lang.ObjectUtils.exists(w.maxScale)&&w.minScale/w.maxScale<2){w.options.numZoomLevels=2
}this.map.addLayer(w)
}if(!Legato.Lang.ObjectUtils.exists(this.map.baseLayer)&&this.createDefaultBaseLayer&&m.length>0){var p=m[0];
var u=p.projection;
var v={};
if(Legato.Lang.ObjectUtils.exists(u)){v.projection=u
}v.layerId="Legato.Layer.Blank";
v.legatoIgnore=true;
v.alpha=false;
v.isBaseLayer=true;
v.displayOutsideMaxExtent=false;
v.ratio=1;
var h=new OpenLayers.Layer.WMS("Default base layer",OpenLayers.Util.getImagesLocation()+"blank.gif?",null,v);
this.map.addLayer(h)
}if((this.map.getExtent()===null||Legato.Lang.ObjectUtils.isTrue(this.zoomToBoundingBox))&&Legato.Lang.ObjectUtils.exists(n.model.boundingBox)&&Legato.Lang.ObjectUtils.exists(n.model.boundingBox.bounds)){this.map.zoomToExtent(n.model.boundingBox.bounds,true)
}this.map.events.triggerEvent("legato.refresh",{})
}catch(r){Legato.Util.Logger.getLogger().fatal("Could not parse ExtendedWMC from ["+this.url+"].");
Legato.Util.Logger.getLogger().fatal(r);
throw r
}};
var a=function(d){Legato.Util.Logger.getLogger().fatal("Could not read ExtendedWMC from ["+this.url+"].");
throw new Legato.Lang.Exception("Could not read ExtendedWMC from ["+this.url+"].")
};
var b=this;
OpenLayers.Request.GET({url:b.url,params:b.params,scope:b,success:c,failure:a})
},synchronize:function(a,e){var d=function(j){try{var f=false;
var q=this.format.read(j.responseText,this.defaultOptions);
var m=new Legato.Util.HashSet();
var h=new Legato.Util.HashSet();
var o=Legato.OpenLayers.Map.Util.getLayerIds(Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore(this.map.layers));
for(var k=0;
k<o.length;
k++){m.add(o[k])
}o=Legato.OpenLayers.Map.Util.getLayerIds(Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore(q.layers));
for(k=0;
k<o.length;
k++){h.add(o[k])
}var p=Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore(q.layers);
var l,g;
for(k=0;
k<p.length;
k++){l=p[k];
g=Legato.Lang.ObjectUtils.exists(l.layerId)?l.layerId:l.name;
if(!m.contains(g)){f=true;
this.map.addLayer(l)
}}p=Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore(this.map.layers);
for(k=0;
k<p.length;
k++){l=p[k];
g=Legato.Lang.ObjectUtils.exists(l.layerId)?l.layerId:l.name;
if(!h.contains(g)){f=true;
this.map.removeLayer(l)
}}if(f){this.map.events.triggerEvent("legato.refresh",{})
}if(Legato.Lang.ObjectUtils.isFunction(a)){a()
}}catch(n){Legato.Util.Logger.getLogger().error("Could not parse synchronize viewcontext response ["+this.url+"] with params "+this.params);
throw n
}};
var b=function(f){Legato.Util.Logger.getLogger().error("Could not synchronize viewcontext ["+this.url+"] with params "+this.params);
if(Legato.Lang.ObjectUtils.isFunction(e)){e()
}};
var c=this;
OpenLayers.Request.GET({url:c.url,params:c.params,scope:c,success:d,failure:b})
},CLASS_NAME:"Legato.Format.ExtendedWMCLoader"});
Legato.Format.ExtendedWMCLoader.Bean=Legato.Beans.Object.Extend("Legato.Format.ExtendedWMCLoader",Legato.Format.QName("ExtendedWMCLoader"),{_constructor:Legato.Format.ExtendedWMCLoader,options:{map:OpenLayers.Map.Bean,url:Legato.Lang.String,defaultOptions:Legato.Lang["String{}"],zoomToBoundingBox:Legato.Lang.Boolean,resizeToWindow:Legato.Lang.Boolean,createDefaultBaseLayer:Legato.Lang.Boolean},afterInstancePopulated:function(a){a.load()
}});
Legato.Format.SuperWMCLoader={};
Legato.Format.SuperWMCLoader.Bean=Legato.Beans.Object.Extend("Legato.Format.ExtendedWMCLoader",Legato.Format.QName("SuperWMCLoader"),{_constructor:Legato.Format.ExtendedWMCLoader,options:{map:OpenLayers.Map.Bean,url:Legato.Lang.String,defaultOptions:Legato.Lang["String{}"],zoomToBoundingBox:Legato.Lang.Boolean,resizeToWindow:Legato.Lang.Boolean,createDefaultBaseLayer:Legato.Lang.Boolean},afterInstancePopulated:function(a){a.load()
}});
Legato.Format.ExtendedWMC.LayerFactory=Legato.Lang.Class({layerType:OpenLayers.Layer.Bean,initialize:function(a){if(Legato.Lang.ObjectUtils.exists(a)){this.layerType=a
}},createLayer:function(f,d,c){var e={};
e.visibility=!f.hidden;
if(f.queryable){e.queryable=true
}e.name=f.name;
e.id=f.id;
e.layerId=Legato.Lang.ObjectUtils.exists(f.layerId)?f.layerId:f.name;
e.title=f.title;
e.url=f.server.onlineResource;
if(Legato.Lang.ObjectUtils.exists(f.minScaleDenominator)){e.minScale=f.minScaleDenominator
}if(Legato.Lang.ObjectUtils.exists(f.maxScaleDenominator)){e.maxScale=f.maxScaleDenominator
}if(f.srs.length>0){e.projection=new OpenLayers.Projection(f.srs[0])
}if(Legato.Lang.ObjectUtils.exists(f.currentFormat)){e.format=f.currentFormat
}if(Legato.Lang.ObjectUtils.exists(f.currentStyle)){e.style=f.currentStyle.name;
if(Legato.Lang.ObjectUtils.exists(f.currentStyle.legend&&f.currentStyle.legend.onlineResource)){e.legend=new Legato.Layer.Legend(f.currentStyle.legend.onlineResource)
}}var b;
if(d){for(b in d){if(d.hasOwnProperty(b)){e[b]=d[b]
}}}if(f.extension){for(b in f.extension){if(f.extension.hasOwnProperty(b)){e[b]=f.extension[b]
}}}this.populateLayerDefinition(e,f,d,c);
var a=this.layerType.define(e);
return c.retrieveBean(a)
},populateLayerDefinition:function(c,d,b,a){}});
Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES={};
Legato.Format.ExtendedWMC.registerDefaultLayerType=function(a,b){Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES[a]=new Legato.Format.ExtendedWMC.LayerFactory(b)
};
Legato.Format.ExtendedWMC.registerDefaultLayerFactory=function(a,b){Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES[a]=b
};
Legato.Format.ExtendedWMC.Model=OpenLayers.Class({initialize:function(){this.layerList=[]
},toString:function(){return this.CLASS_NAME
},id:null,version:null,boundingBox:null,window:null,title:null,extensions:null,layerList:null,CLASS_NAME:"Legato.Format.ExtendedWMC.Model"});
Legato.Format.ExtendedWMC.Model.BoundingBox=OpenLayers.Class({initialize:function(){},toString:function(){return this.CLASS_NAME
},SRS:null,bounds:null,CLASS_NAME:"Legato.Format.ExtendedWMC.Model.BoundingBox"});
Legato.Format.ExtendedWMC.Model.Window=OpenLayers.Class({initialize:function(){},toString:function(){return this.CLASS_NAME
},width:null,height:null,CLASS_NAME:"Legato.Format.ExtendedWMC.Model.Window"});
Legato.Format.ExtendedWMC.Model.Extensions=OpenLayers.Class({initialize:function(){},toString:function(){return this.CLASS_NAME
},legato:null,CLASS_NAME:"Legato.Format.ExtendedWMC.Model.Extensions"});
Legato.Format.ExtendedWMC.Model.Extensions.Legato=OpenLayers.Class({initialize:function(){this.capabilities=[]
},toString:function(){return this.CLASS_NAME
},capabilities:null,minScale:null,maxScale:null,CLASS_NAME:"Legato.Format.ExtendedWMC.Model.Extensions.Legato"});
Legato.Format.ExtendedWMC.Model.Layer=OpenLayers.Class({initialize:function(){this.formatList=[];
this.styleList=[];
this.extension={};
this.srs=[]
},toString:function(){result=this.CLASS_NAME;
result+=(this.name)?": "+this.name:"";
return result
},hidden:null,queryable:null,server:null,name:null,title:null,layerAbstract:null,minScaleDenominator:null,maxScaleDenominator:null,srs:null,formatList:null,styleList:null,currentFormat:null,extension:null,CLASS_NAME:"Legato.Format.ExtendedWMC.Model.Layer"});
Legato.Format.ExtendedWMC.Model.Layer.Server=OpenLayers.Class({initialize:function(){},toString:function(){return this.CLASS_NAME
},service:null,version:null,title:null,onlineResource:null,CLASS_NAME:"Legato.Format.ExtendedWMC.Model.Layer.Server"});
Legato.Format.ExtendedWMC.Model.Layer.Style=OpenLayers.Class({initialize:function(){},toString:function(){return this.CLASS_NAME
},name:null,title:null,styleAbstract:null,legendURL:null,CLASS_NAME:"Legato.Format.ExtendedWMC.Model.Layer.Style"});
Legato.Format.ExtendedWMC.Parser=OpenLayers.Class(OpenLayers.Format.XML,{layerFactories:Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES,namespaces:{ol:"http://openlayers.org/context",l:"http://www.disy.net/legato/extensions",lb:"http://www.disy.net/legato/beans",wmc:"http://www.opengis.net/context",sld:"http://www.opengis.net/sld",xlink:"http://www.w3.org/1999/xlink",xsi:"http://www.w3.org/2001/XMLSchema-instance"},schemaLocation:"",getNamespacePrefix:function(a){var b=null;
if(a===null){b=this.namespaces[this.defaultPrefix]
}else{for(b in this.namespaces){if(this.namespaces[b]==a){break
}}}return b
},defaultPrefix:"wmc",rootPrefix:null,defaultStyleName:"",defaultStyleTitle:"Default",initialize:function(a){OpenLayers.Format.XML.prototype.initialize.apply(this,[a]);
if(Legato.Lang.ObjectUtils.isObject(a)){if(Legato.Lang.ObjectUtils.exists(a.layerFactories)){Legato.Util.Ensure.ensureObject(a.layerFactories);
this.layerFactories=a.layerFactories
}}},beanFactory:null,setBeanFactory:function(a){Legato.Util.Ensure.ensureObject(a);
this.beanFactory=a
},getBeanFactory:function(){if(this.beanFactory===null){this.beanFactory=new Legato.Beans.XMLBeanFactory()
}return this.beanFactory
},getLayerType:function(a){Legato.Util.Ensure.ensureString(a);
var b=this.layerFactories[a];
Legato.Util.Ensure.ensureExists(b,"Could not find the layer factory for service ["+a+"].");
Legato.Util.Ensure.ensureExists(b.layerType,"Layer factory for service ["+a+"] does not deliver a layer type.");
return b.layerType
},read:function(c){if(typeof c=="string"){var d=new OpenLayers.Format.XML();
c=d.read(c)
}var a=c.documentElement;
if(a===null){throw new Legato.Lang.Exception("ViewContext seems to be empty")
}if(a.nodeName!=="ViewContext"){throw new Legato.Lang.Exception("ViewContext seems to be incorrect. First node element must be named ViewContext")
}this.rootPrefix=a.prefix;
var b=new Legato.Format.ExtendedWMC.Model();
b.id=a.getAttribute("id");
b.version=a.getAttribute("version");
this.runChildNodes(b,a);
return b
},runChildNodes:function(f,d){var b=d.childNodes;
var a,c,g,j;
for(var e=0,h=b.length;
e<h;
++e){a=b[e];
if(a.nodeType==1){g=this.getNamespacePrefix(a.namespaceURI);
j=a.nodeName.split(":").pop();
c=this["read_"+g+"_"+j];
if(c){c.apply(this,[f,a])
}}}},read_wmc_General:function(a,b){this.runChildNodes(a,b)
},read_wmc_BoundingBox:function(b,c){var a=c.getAttribute("SRS");
if(a){var d=new Legato.Format.ExtendedWMC.Model.BoundingBox();
b.boundingBox=d;
d.SRS=a;
d.bounds=new OpenLayers.Bounds(parseFloat(c.getAttribute("minx")),parseFloat(c.getAttribute("miny")),parseFloat(c.getAttribute("maxx")),parseFloat(c.getAttribute("maxy")))
}},read_wmc_LayerList:function(a,b){a.layers=[];
this.runChildNodes(a,b)
},read_wmc_Layer:function(b,c){var a=new Legato.Format.ExtendedWMC.Model.Layer();
b.layerList.push(a);
a.hidden=(c.getAttribute("hidden")=="1");
a.queryable=(c.getAttribute("queryable")=="1");
var d=c.getAttribute("id");
this.runChildNodes(a,c);
if(Legato.Lang.ObjectUtils.isString(d)){a.layerId=d
}else{a.layerId=a.name
}},read_wmc_Extension:function(b,a){if(b.CLASS_NAME&&b.CLASS_NAME==="Legato.Format.ExtendedWMC.Model.Layer"){this.runChildNodes(b,a)
}else{if(b.CLASS_NAME&&b.CLASS_NAME==="Legato.Format.ExtendedWMC.Model"){this.runChildNodes(b,a)
}}},read_l_Extension:function(g,e){var c=this.getBeanFactory();
var h;
if(g.CLASS_NAME&&g.CLASS_NAME==="Legato.Format.ExtendedWMC.Model.Layer"){var f=g;
var a=f.server.service;
var d=this.getLayerType(a);
h=c.retrieveBeanFromElement(e,d.Components());
f.extension=h
}else{if(g.CLASS_NAME&&g.CLASS_NAME==="Legato.Format.ExtendedWMC.Model"){var b=g;
h=c.retrieveBeanFromElement(e,OpenLayers.Map.Bean.Components());
b.extension=h
}}},read_lb_beans:function(d,c){var b=this.getBeanFactory();
var a=b.retrieveBeansFromElement(c);
d.beans=a
},read_ol_units:function(b,a){b.extension.units=this.getChildValue(a)
},read_ol_maxExtent:function(c,b){var a=new OpenLayers.Bounds(b.getAttribute("minx"),b.getAttribute("miny"),b.getAttribute("maxx"),b.getAttribute("maxy"));
c.extension.maxExtent=a
},read_ol_minExtent:function(c,b){var a=new OpenLayers.Bounds(b.getAttribute("minx"),b.getAttribute("miny"),b.getAttribute("maxx"),b.getAttribute("maxy"));
c.extension.minExtent=a
},read_ol_transparent:function(b,a){if(!b.extension.params){b.extension.params={}
}b.extension.params.TRANSPARENT=this.getChildValue(a)
},read_ol_numZoomLevels:function(b,a){b.extension.numZoomLevels=parseInt(this.getChildValue(a),10)
},read_ol_opacity:function(b,a){b.extension.opacity=parseFloat(this.getChildValue(a))
},read_ol_singleTile:function(b,a){b.extension.singleTile=(this.getChildValue(a)=="true")
},read_ol_isBaseLayer:function(b,a){b.extension.isBaseLayer=(this.getChildValue(a)=="true")
},read_ol_displayInLayerSwitcher:function(b,a){b.extension.displayInLayerSwitcher=(this.getChildValue(a)=="true")
},read_wmc_Server:function(b,a){if(b.server===null){b.server=new Legato.Format.ExtendedWMC.Model.Layer.Server()
}b.server.version=a.getAttribute("version");
b.server.service=a.getAttribute("service");
b.server.title=a.getAttribute("title");
this.runChildNodes(b.server,a)
},read_wmc_FormatList:function(b,a){this.runChildNodes(b,a)
},read_wmc_Format:function(c,a){var b=this.getChildValue(a);
c.formatList.push(b);
if(a.getAttribute("current")=="1"){c.currentFormat=b
}},read_wmc_StyleList:function(b,a){this.runChildNodes(b,a)
},read_wmc_Style:function(c,b){var a=new Legato.Format.ExtendedWMC.Model.Layer.Style();
this.runChildNodes(a,b);
c.styleList.push(a);
if(b.getAttribute("current")=="1"){c.currentStyle=a
}},read_wmc_OnlineResource:function(b,a){b.onlineResource=this.getAttributeNS(a,this.namespaces.xlink,"href")
},read_wmc_Name:function(c,b){var a=this.getChildValue(b);
if(a){c.name=a
}},read_wmc_Title:function(b,a){var c=this.getChildValue(a);
if(c){b.title=c
}},read_wmc_Abstract:function(c,b){var a=this.getChildValue(b);
if(a){if(c.CLASS_NAME&&c.CLASS_NAME=="Legato.Format.ExtendedWMC.Model.Layer"){c.layerAbstract=a
}else{if(c.CLASS_NAME&&c.CLASS_NAME=="Legato.Format.ExtendedWMC.Model.Layer.Style"){c.styleAbstract=a
}}}},read_wmc_SRS:function(c,b){var a=this.getChildValue(b);
if(a){if(c.CLASS_NAME&&c.CLASS_NAME==="Legato.Format.ExtendedWMC.Model.Layer"){c.srs.push(a)
}}},read_wmc_Window:function(a,b){if(a.window===null){a.window=new Legato.Format.ExtendedWMC.Model.Window()
}a.window.width=parseInt(b.getAttribute("width"),10);
a.window.height=parseInt(b.getAttribute("height"),10)
},read_wmc_LegendURL:function(b,c){var a={width:c.getAttribute("width"),height:c.getAttribute("height"),format:c.getAttribute("format")};
this.runChildNodes(a,c);
b.legend=a
},read_sld_MinScaleDenominator:function(b,a){var c=this.getChildValue(a);
if(c){b.minScaleDenominator=parseFloat(c)
}},read_sld_MaxScaleDenominator:function(b,a){var c=this.getChildValue(a);
if(c){b.maxScaleDenominator=parseFloat(c)
}},write:function(b,a){OpenLayers.Console.userError(OpenLayers.i18n("writeNotImplemented"))
},CLASS_NAME:"Legato.Format.ExtendedWMC.Parser"});
OpenLayers.Layer.Image.Bean=OpenLayers.Layer.Bean.Extend("OpenLayers.Layer.Image",Legato.OpenLayers.Layer.QName("Image"),{factoryFunction:function(c,b,a){var e=OpenLayers.Util.createUrlObject(b,{ignorePort80:true});
e.args.w=a.size.w;
e.args.h=a.size.h;
b=Legato.Util.getUrlString(e);
OpenLayers.Console.debug(b);
a.isBaseLayer=true;
a.visibility=true;
var d=new OpenLayers.Layer.Image(c,b,a.extent,a.size,a);
return d
},constructorArguments:{name:Legato.Lang.String,url:Legato.Lang.String},constructorOrder:["name","url"],options:{size:OpenLayers.Size.Bean,extent:OpenLayers.Bounds.Bean}});
OpenLayers.Layer.Image.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.Image.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("OpenLayer:Image",new OpenLayers.Layer.Image.LayerFactory());
OpenLayers.Layer.Markers.Bean=OpenLayers.Layer.Bean.Extend("OpenLayers.Layer.Markers",Legato.OpenLayers.Layer.QName("Markers"),{factoryFunction:function(b,a){if(!Legato.Lang.ObjectUtils.exists(a)){a={}
}a.isBaseLayer=false;
return new OpenLayers.Layer.Markers(b,a)
},constructorArguments:{name:Legato.Lang.String},constructorOrder:["name"],properties:{markers:new Legato.Beans.Property(Legato.Beans["Object[]"],function(b,c){Legato.Util.Ensure.ensureArray(c);
for(var a=0;
a<c;
a++){b.addControls(c[a])
}})}});
OpenLayers.Layer.Markers.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.Markers.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("OL:Markers",new OpenLayers.Layer.Markers.LayerFactory());
OpenLayers.Layer.GeoRSS.Bean=OpenLayers.Layer.Markers.Bean.Extend("OpenLayers.Layer.GeoRSS",Legato.OpenLayers.Layer.QName("GeoRSS"),{factoryFunction:function(c,b,a){if(!Legato.Lang.ObjectUtils.exists(a)){a={}
}a.isBaseLayer=false;
return new OpenLayers.Layer.GeoRSS(c,b,a)
},constructorArguments:{name:Legato.Lang.String,url:Legato.Lang.String},options:{icon:Legato.Beans.Object,popupSize:OpenLayers.Size.Bean,useFeedTitle:Legato.Lang.Boolean,formatOptions:Legato.Beans.Object},constructorOrder:["name","url"]});
OpenLayers.Layer.GeoRSS.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.GeoRSS.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("OL:GeoRSS",new OpenLayers.Layer.GeoRSS.LayerFactory());
OpenLayers.Layer.Grid.Bean=OpenLayers.Layer.Bean.Extend("OpenLayers.Layer.Grid",Legato.OpenLayers.Layer.QName("Grid"),{_constructor:OpenLayers.Layer.Grid,constructorArguments:{name:Legato.Lang.String,url:Legato.Lang.String,params:Legato.Lang["String{}"]},constructorOrder:["name","url","params"],options:{tileSize:OpenLayers.Size.Bean,singleTile:Legato.Lang.Boolean,ratio:Legato.Lang.Number,buffer:Legato.Lang.Integer}});
OpenLayers.Layer.Vector.Bean=OpenLayers.Layer.Bean.Extend("OpenLayers.Layer.Vector",Legato.OpenLayers.Layer.QName("Vector"),{_constructor:OpenLayers.Layer.Vector,constructorArguments:{name:Legato.Lang.String},constructorOrder:["name"],options:{isFixed:Legato.Lang.Boolean,isVector:Legato.Lang.Boolean,features:Legato.Beans["Object[]"],reportError:Legato.Lang.Boolean,style:Legato.Lang["String{}"],rendererOptions:Legato.Beans.Object,geometryType:Legato.Lang.String}});
OpenLayers.Layer.Vector.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.Vector.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("OL:Vector",new OpenLayers.Layer.Vector.LayerFactory());
OpenLayers.Layer.WMS.Bean=OpenLayers.Layer.Grid.Bean.Extend("OpenLayers.Layer.WMS",Legato.OpenLayers.Layer.QName("WMS"),{factoryFunction:function(c,b,d,a){if(!Legato.Lang.ObjectUtils.exists(d)){d={}
}if(!Legato.Lang.ObjectUtils.exists(a)){a={}
}if(!Legato.Lang.ObjectUtils.exists(d.LAYERS)){d.LAYERS=c
}if(!Legato.Lang.ObjectUtils.exists(d.TRANSPARENT)&&Legato.Lang.ObjectUtils.exists(a.transparent)){d.TRANSPARENT=a.transparent?"TRUE":"FALSE";
delete a.transparent
}if(!Legato.Lang.ObjectUtils.exists(d.EXCEPTIONS)&&Legato.Lang.ObjectUtils.exists(a.exceptions)){d.EXCEPTIONS=a.exceptions;
delete a.exceptions
}if(!Legato.Lang.ObjectUtils.exists(d.FORMAT)&&Legato.Lang.ObjectUtils.exists(a.format)){d.FORMAT=a.format;
delete a.format
}return new OpenLayers.Layer.WMS(c,b,d,a)
},constructorArguments:{name:Legato.Lang.String,url:Legato.Lang.String,params:Legato.Lang["String{}"]},constructorOrder:["name","url","params"],options:{reproject:Legato.Lang.Boolean,encodeBBOX:Legato.Lang.Boolean,transparent:Legato.Lang.Boolean,exceptions:Legato.Lang.String,format:Legato.Lang.String,style:Legato.Lang.String},afterInstancePopulated:function(a){if(!Legato.Lang.ObjectUtils.isObject(a.params)){a.params={}
}if(!Legato.Lang.ObjectUtils.exists(a.params.LAYERS)){a.params.LAYERS=a.name
}}});
OpenLayers.Layer.WMS.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.WMS.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("OGC:WMS",new OpenLayers.Layer.WMS.LayerFactory());
OpenLayers.Layer.WFS.Bean=OpenLayers.Layer.Vector.Bean.Extend("OpenLayers.Layer.WFS",Legato.OpenLayers.Layer.QName("WFS"),{factoryFunction:function(c,b,d,a){if(!Legato.Lang.ObjectUtils.exists(d)){d={}
}if(!Legato.Lang.ObjectUtils.exists(a)){a={}
}if(!Legato.Lang.ObjectUtils.exists(d.MAXFEATURES)&&Legato.Lang.ObjectUtils.exists(a.maxFeatures)){d.MAXFEATURES=a.maxFeatures;
delete a.maxFeatures
}if(!Legato.Lang.ObjectUtils.exists(d.TYPENAME)){d.TYPENAME=c
}return new OpenLayers.Layer.WFS(c,b,d,a)
},constructorArguments:{name:Legato.Lang.String,url:Legato.Lang.String,params:Legato.Lang["String{}"]},constructorOrder:["name","url","params"],options:{maxFeatures:Legato.Lang.Integer}});
OpenLayers.Layer.WFS.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.WFS.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("OGC:WFS",new OpenLayers.Layer.WFS.LayerFactory());
OpenLayers.Layer.GML.prototype.requestSuccess=function(c){var d=c.responseXML;
if(!d||!d.documentElement){d=c.responseText
}var a={};
OpenLayers.Util.extend(a,this.formatOptions);
if(this.map&&!this.projection.equals(this.map.getProjectionObject())){a.externalProjection=this.projection;
a.internalProjection=this.map.getProjectionObject()
}var b;
if(Legato.Lang.ObjectUtils.exists(this.format)){if(Legato.Lang.ObjectUtils.isFunction(this.format)){b=new this.format(a)
}else{b=this.format
}}else{b=new OpenLayers.Format.GML(a)
}this.addFeatures(b.read(d));
this.events.triggerEvent("loadend")
};
OpenLayers.Layer.GML.Bean=OpenLayers.Layer.Vector.Bean.Extend("OpenLayers.Layer.GML",Legato.OpenLayers.Layer.QName("GML"),{_constructor:OpenLayers.Layer.GML,constructorArguments:{name:Legato.Lang.String,url:Legato.Lang.String},constructorOrder:["name","url"],options:{format:Legato.Beans.Object,formatOptions:Legato.Beans.Object}});
OpenLayers.Layer.GML.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.GML.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("OGC:GML",new OpenLayers.Layer.GML.LayerFactory());
OpenLayers.Layer.Yahoo.MapType=null;
if(typeof YAHOO_MAP_REG!="undefined"){OpenLayers.Layer.Yahoo.MapType=Legato.Lang.String.Enum("OpenLayers.Layer.Yahoo.MapType",{normal:YAHOO_MAP_REG,satellite:YAHOO_MAP_SAT,hybrid:YAHOO_MAP_HYB})
}else{OpenLayers.Layer.Yahoo.MapType=Legato.Lang.String.Enum("OpenLayers.Layer.Yahoo.MapType",{})
}OpenLayers.Layer.Yahoo.Bean=OpenLayers.Layer.Bean.Extend("OpenLayers.Layer.Yahoo",Legato.OpenLayers.Layer.QName("Yahoo"),{factoryFunction:function(b,a){if(Legato.Lang.ObjectUtils.exists(a)&&!Legato.Lang.ObjectUtils.exists(a.sphericalMercator)){a.sphericalMercator=true
}var c=new OpenLayers.Layer.Yahoo(b,a);
return c
},constructorArguments:{name:Legato.Lang.String},constructorOrder:["name"],options:{type:OpenLayers.Layer.Yahoo.MapType,sphericalMercator:Legato.Lang.Boolean}});
OpenLayers.Layer.Yahoo.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.Yahoo.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("OL:Yahoo",new OpenLayers.Layer.Yahoo.LayerFactory());
OpenLayers.Layer.ArcIMS.ArcIMSLayer=Legato.Lang.Class({id:null,visible:true,initialize:function(){},toString:function(){return this.CLASS_NAME+": id:"+this.id
},CLASS_NAME:"OpenLayers.Layer.ArcIMS.ArcIMSLayer"});
OpenLayers.Layer.ArcIMS.Background=Legato.Lang.Class({color:null,transcolor:null,initialize:function(){},toString:function(){return this.CLASS_NAME
},CLASS_NAME:"OpenLayers.Layer.ArcIMS.Background"});
OpenLayers.Layer.ArcIMS.NAMESPACE_URI="http://www.disy.net/legato/arcims";
OpenLayers.Layer.ArcIMS.PREFIX="ai";
OpenLayers.Layer.ArcIMS.QName=function(a){return new Legato.XML.QName(OpenLayers.Layer.ArcIMS.NAMESPACE_URI,a,OpenLayers.Layer.ArcIMS.PREFIX)
};
OpenLayers.Layer.ArcIMS.ArcIMSLayer.Bean=Legato.Beans.Object.Extend("OpenLayers.Layer.ArcIMS.ArcIMSLayer",OpenLayers.Layer.ArcIMS.QName("ArcIMSLayer"),{_constructor:OpenLayers.Layer.ArcIMS.ArcIMSLayer,constructorArguments:{},constructorOrder:[],fields:{id:Legato.Lang.String,visible:Legato.Lang.Boolean}});
OpenLayers.Layer.ArcIMS.Background.Bean=Legato.Beans.Object.Extend("OpenLayers.Layer.ArcIMS.Background",OpenLayers.Layer.ArcIMS.QName("Background"),{_constructor:OpenLayers.Layer.ArcIMS.Background,constructorArguments:{},constructorOrder:[],fields:{color:Legato.Lang.RGBColor,transcolor:Legato.Lang.RGBColor}});
OpenLayers.Layer.ArcIMS.Bean=OpenLayers.Layer.Grid.Bean.Extend("OpenLayers.Layer.ArcIMS",Legato.OpenLayers.Layer.QName("ArcIMS"),{factoryFunction:function(c,b,a){if(Legato.Lang.ObjectUtils.exists(a)&&!Legato.Lang.ObjectUtils.exists(a.serviceName)){a.serviceName=c
}var d=new OpenLayers.Layer.ArcIMS(c,b,a);
return d
},constructorArguments:{name:Legato.Lang.String,url:Legato.Lang.String},constructorOrder:["name","url"],options:{serviceName:Legato.Lang.String,reproject:Legato.Lang.Boolean,encodeBBOX:Legato.Lang.Boolean,background:OpenLayers.Layer.ArcIMS.Background.Bean,featureCoordSys:Legato.Lang.String,filterCoordSys:Legato.Lang.String,layers:OpenLayers.Layer.ArcIMS.ArcIMSLayer.Bean.List(),async:Legato.Lang.Boolean}});
OpenLayers.Layer.ArcIMS.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.ArcIMS.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("ESRI:ArcIMS",new OpenLayers.Layer.ArcIMS.LayerFactory());
OpenLayers.Layer.Google.MapType=null;
if(typeof G_NORMAL_MAP!="undefined"){OpenLayers.Layer.Google.MapType=Legato.Beans.Object.Enum("OpenLayers.Layer.Google.MapType",{normal:G_NORMAL_MAP,satellite:G_SATELLITE_MAP,hybrid:G_HYBRID_MAP})
}else{OpenLayers.Layer.Google.MapType=Legato.Beans.Object.Enum("OpenLayers.Layer.Google.MapType",{})
}OpenLayers.Layer.Google.Bean=OpenLayers.Layer.Bean.Extend("OpenLayers.Layer.Google",Legato.OpenLayers.Layer.QName("Google"),{factoryFunction:function(b,a){if(Legato.Lang.ObjectUtils.exists(a)&&!Legato.Lang.ObjectUtils.exists(a.sphericalMercator)){a.sphericalMercator=true
}var c=new OpenLayers.Layer.Google(b,a);
return c
},constructorArguments:{name:Legato.Lang.String},constructorOrder:["name"],options:{type:OpenLayers.Layer.Google.MapType,sphericalMercator:Legato.Lang.Boolean}});
OpenLayers.Layer.Google.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.Google.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("OL:Google",new OpenLayers.Layer.Google.LayerFactory());
OpenLayers.Layer.ArcGIS93Rest.Bean=OpenLayers.Layer.Grid.Bean.Extend("OpenLayers.Layer.ArcGIS93Rest",Legato.OpenLayers.Layer.QName("ArcGIS93Rest"),{factoryFunction:function(c,b,d,a){if(!Legato.Lang.ObjectUtils.exists(d)){d={}
}if(!Legato.Lang.ObjectUtils.exists(a)){a={}
}if(!Legato.Lang.ObjectUtils.exists(d.TRANSPARENT)&&Legato.Lang.ObjectUtils.exists(a.transparent)){d.TRANSPARENT=a.transparent?"TRUE":"FALSE";
delete a.transparent
}if(!Legato.Lang.ObjectUtils.exists(d.FORMAT)&&Legato.Lang.ObjectUtils.exists(a.format)){d.FORMAT=a.format.slice("image/".length);
delete a.format
}return new OpenLayers.Layer.ArcGIS93Rest(c,b,d,a)
},constructorArguments:{name:Legato.Lang.String,url:Legato.Lang.String,params:Legato.Lang["String{}"]},constructorOrder:["name","url","params"],options:{format:Legato.Lang.String,transparent:Legato.Lang.Boolean}});
OpenLayers.Layer.ArcGIS93Rest.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.ArcGIS93Rest.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("ESRI:ArcGIS93Rest",new OpenLayers.Layer.ArcGIS93Rest.LayerFactory());
OpenLayers.Layer.XYZ.Bean=OpenLayers.Layer.Grid.Bean.Extend("OpenLayers.Layer.XYZ",Legato.OpenLayers.Layer.QName("XYZ"),{_constructor:OpenLayers.Layer.XYZ,options:{sphericalMercator:Legato.Lang.Boolean}});
OpenLayers.Layer.XYZ.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.XYZ.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("OL:XYZ",new OpenLayers.Layer.XYZ.LayerFactory());
OpenLayers.Layer.OSM.Bean=OpenLayers.Layer.XYZ.Bean.Extend("OpenLayers.Layer.OSM",Legato.OpenLayers.Layer.QName("OSM"),{_constructor:OpenLayers.Layer.OSM,options:{sphericalMercator:Legato.Lang.Boolean}});
OpenLayers.Layer.OSM.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:OpenLayers.Layer.OSM.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("OL:OSM",new OpenLayers.Layer.OSM.LayerFactory());
Legato.Layer.Blank=OpenLayers.Class(OpenLayers.Layer.WMS,{initialize:function(c,d,b){var a=[];
if(!Legato.Lang.ObjectUtils.exists(b)){b={}
}if(!Legato.Lang.ObjectUtils.isBoolean(b.legatoIgnore)){b.legatoIgnore=true
}a.push(c,OpenLayers.Util.getImagesLocation()+"blank.gif?",d,b);
OpenLayers.Layer.WMS.prototype.initialize.apply(this,a)
},CLASS_NAME:"Legato.Layer.Blank"});
Legato.Layer.Blank.Bean=Legato.Layer.Bean.Extend("Legato.Layer.Blank",Legato.Layer.QName("BlankLayer"),{_constructor:Legato.Layer.Blank,constructorOrder:["name","params"],constructorArguments:{name:Legato.Lang.String,params:Legato.Lang.Object}});
Legato.Layer.Blank.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:Legato.Layer.Blank.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("L:Blank",new Legato.Layer.Blank.LayerFactory());
Legato.Layer.VectorOSM=OpenLayers.Class(OpenLayers.Layer.GML,{format:OpenLayers.Format.OSM,projection:new OpenLayers.Projection("EPSG:4326"),CLASS_NAME:"Legato.Layer.VectorOSM"});
Legato.Layer.VectorOSM.Bean=OpenLayers.Layer.GML.Bean.Extend("Legato.Layer.VectorOSM",Legato.Layer.QName("VectorOSM"),{_constructor:Legato.Layer.VectorOSM});
Legato.Layer.VectorOSM.LayerFactory=Legato.Lang.Class(Legato.Format.ExtendedWMC.LayerFactory,{layerType:Legato.Layer.VectorOSM.Bean});
Legato.Format.ExtendedWMC.registerDefaultLayerFactory("Legato:VectorOSM",new Legato.Layer.VectorOSM.LayerFactory());
Legato.Layer.GetLegend=Legato.Lang.Class({url:null,params:null,dynamic:true,initialize:function(b){Legato.Util.Ensure.ensureString(b);
var a=b.indexOf("?");
if(a>0){this.url=b.substring(0,a);
this.params=OpenLayers.Util.upperCaseObject(OpenLayers.Util.getParameters(b))
}else{this.url=b;
this.params={}
}},getURL:function(d){Legato.Util.Ensure.ensureExists(d);
var f=OpenLayers.Util.extend({},this.params);
var e=d.map.getExtent();
if(Legato.Lang.ObjectUtils.exists(e)){f.BBOX=e.toArray()
}var c=d.map.getSize();
if(Legato.Lang.ObjectUtils.exists(c)){f.WIDTH=c.w;
f.HEIGHT=c.h
}var a=d.map.getProjection();
if(Legato.Lang.ObjectUtils.exists(a)&&a!="none"){f.SRS=a
}f.LAYERS=Legato.Lang.ObjectUtils.exists(d.layerId)?d.layerId:d.name;
var b=this.url+"?"+OpenLayers.Util.getParameterString(f);
return b
},CLASS_NAME:"Legato.Layer.GetLegend"});
Legato.Layer.Legend=Legato.Lang.Class({url:null,dynamic:false,initialize:function(a){Legato.Util.Ensure.ensureString(a);
this.url=a
},getURL:function(a){return this.url
},CLASS_NAME:"Legato.Layer.Legend"});
Legato.Layer.VectorUpdater=OpenLayers.Class({url:null,params:null,layer:null,format:null,onSuccess:function(a){},onFailure:function(a){OpenLayers.Console.error(a)
},initialize:function(c){OpenLayers.Util.extend(this,c);
var b=c.url;
if(Legato.Lang.ObjectUtils.isString(b)){var a=b.indexOf("?");
if(a>0){this.url=b.substring(0,a);
this.params=OpenLayers.Util.getParameters(b)
}else{this.url=b;
this.params=null
}if(!Legato.Lang.ObjectUtils.exists(this.format)){this.format=new Legato.Format.GML3()
}var d=c.layer;
if(Legato.Lang.ObjectUtils.exists(d)&&Legato.Lang.ObjectUtils.exists(d.events)){this.layer=d;
this.layer.events.on({featuresadded:this.update,featuresremoved:this.update,featuremodified:this.update,scope:this})
}}else{this.url=null;
this.params=null
}},destroy:function(){if(Legato.Lang.ObjectUtils.exists(this.layer)){this.layer.events.un({featuresadded:this.update,featuresremoved:this.update,featuremodified:this.update,scope:this})
}this.layer=null;
this.url=null;
this.params=null
},update:function(){var a=this.layer.features;
if(Legato.Lang.ObjectUtils.isNotEmptyArray(a)){var c=this.format.write(a);
var b=new OpenLayers.Request.POST({url:this.url,params:this.params,data:c,success:this.onSuccess,failure:this.onFailure,scope:this})
}},CLASS_NAME:"Legato.Layer.VectorUpdater"});
Legato.Layer.VectorUpdater.Bean=Legato.Beans.Object.Extend("Legato.Layer.VectorUpdater",Legato.Layer.QName("VectorUpdater"),{_constructor:Legato.Layer.VectorUpdater,options:{url:Legato.Lang.String,format:Legato.Beans.Object,layer:Legato.Beans.Object}});
Legato.Layer.Legend.Bean=Legato.Beans.Object.Extend("Legato.Layer.Legend",Legato.Layer.QName("Legend"),{_constructor:Legato.Layer.Legend,constructorOrder:["url"],constructorArguments:{url:Legato.Lang.String}});
Legato.Layer.GetLegend.Bean=Legato.Beans.Object.Extend("Legato.Layer.GetLegend",Legato.Layer.QName("GetLegend"),{_constructor:Legato.Layer.GetLegend,constructorOrder:["url"],constructorArguments:{url:Legato.Lang.String}});
Legato.OverviewMap=OpenLayers.Class(OpenLayers.Map,{Z_INDEX_BASE:{BaseLayer:2100,Overlay:2325,Feature:2725,Popup:2750,Control:3000},CLASS_NAME:"Legato.OverviewMap"});
Legato.OverviewMap.Bean=OpenLayers.Map.Bean.Extend("Legato.OverviewMap",Legato.QName("OverviewMap"),{factoryFunction:function(b,a){if(!Legato.Lang.ObjectUtils.exists(a)){a={}
}if(!Legato.Lang.ObjectUtils.exists(a.controls)){a.controls=[]
}if(!Legato.Lang.ObjectUtils.exists(a.theme)){a.theme=null
}return new Legato.OverviewMap(b,a)
}});
Legato.Style=Legato.Lang.Class({name:null,styles:{},initialize:function(a){this.name=a.name;
this.styles=a.styles
},CLASS_NAME:"Legato.Style"});
Legato.Style.NAMESPACE_URI="http://www.disy.net/legato/style";
Legato.Style.PREFIX="ls";
Legato.Style.QName=function(a){return new Legato.XML.QName(Legato.Style.NAMESPACE_URI,a,Legato.Style.PREFIX)
};
Legato.Style.Bean=OpenLayers.Control.Bean.Extend("Legato.Style",Legato.Style.QName("Style"),{_constructor:Legato.Style,options:{name:Legato.Lang.String,styles:Legato.Beans.Object.Map()}});
Legato.BootLoader=Legato.Lang.Class({configUrl:"config.xml",onCreateCallback:null,onConfiguredCallback:null,onDestroyCallback:null,beanFactory:null,map:null,initialize:function(a){OpenLayers.Control.prototype.initialize.apply(this,arguments);
if(typeof legatoI18nLocale!="undefined"&&Legato.Lang.ObjectUtils.isString(legatoI18nLocale)){Legato.I18n.setLocale(legatoI18nLocale)
}if(typeof legatoBootLoaderConfigUrl!="undefined"&&!Legato.Lang.ObjectUtils.isNullOrUndefined(legatoBootLoaderConfigUrl)){this.configUrl=legatoBootLoaderConfigUrl
}if(typeof legatoBootLoaderOnCreate!="undefined"&&Legato.Lang.ObjectUtils.isFunction(legatoBootLoaderOnCreate)){this.onCreateCallback=legatoBootLoaderOnCreate
}if(typeof legatoBootLoaderOnConfigured!="undefined"&&Legato.Lang.ObjectUtils.isFunction(legatoBootLoaderOnConfigured)){this.onConfiguredCallback=legatoBootLoaderOnConfigured
}if(typeof legatoBootLoaderOnDestroy!="undefined"&&Legato.Lang.ObjectUtils.isFunction(legatoBootLoaderOnDestroy)){this.onDestroyCallback=legatoBootLoaderOnDestroy
}this.load();
Legato.Util.DOM.addDOMUnLoadEvent(OpenLayers.Function.bind(this.unload,this))
},load:function(){this.beanFactory=new Legato.Beans.XMLBeanFactory();
if(Legato.Lang.ObjectUtils.isFunction(this.onCreateCallback)){this.onCreateCallback(this.beanFactory)
}this.beanFactory.loadURL({url:this.configUrl,onFailure:function(a){OpenLayers.Console.error(a)
},onSuccess:OpenLayers.Function.bind(function(a){this.map=this.beanFactory.getBean("map");
if(Legato.Lang.ObjectUtils.exists(this.onConfiguredCallback)){this.onConfiguredCallback(this.beanFactory)
}},this)})
},unload:function(){if(Legato.Lang.ObjectUtils.exists(this.onDestroyCallback)){this.onDestroyCallback(this.beanFactory)
}if(Legato.Lang.ObjectUtils.exists(this.beanFactory)){this.beanFactory.destroy()
}},CLASS_NAME:"Legato.BootLoader"});
Legato.Util.DOM.addDOMLoadEvent(function(){if(typeof legatoBootLoader!="undefined"&&Legato.Lang.ObjectUtils.isTrue(legatoBootLoader)){legatoBootLoader=new Legato.BootLoader()
}});
Legato.Util.EventListener=OpenLayers.Class({events:null,types:null,scope:null,callback:null,initialize:function(e,b,d,f){this.events=e.events;
this.types=b;
this.callback=f;
for(var a=0;
a<this.types.length;
a++){var c=this.types[a];
this.events.register(c,null,this.callback)
}},destroy:function(){for(var a=0;
a<this.types.length;
a++){var b=this.types[a];
this.events.unregister(b,null,this.callback)
}},CLASS_NAME:"Legato.Util.EventListener"});
Legato.Util.EventListener.Bean=Legato.Beans.Object.Extend("Legato.Util.EventListener",Legato.Util.QName("EventListener"),{_constructor:Legato.Util.EventListener,constructorArguments:{target:Legato.Beans.Object,types:Legato.Lang["String[]"],scope:Legato.Beans.Object,callback:Legato.Lang.Function},constructorOrder:["target","types","scope","callback"]});
