/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.XML.ElementUtils = {
    
      hide: function(element) {
        element.style.display = 'none';
      },
      
      show: function(element) {
        element.style.display = '';
      },
    
	    /**
	     * APIMethod: getAttributeNodeNS
	     * Get an attribute node given the namespace URI and local name.
	     * 
	     * Parameters:
	     * node - {Element} Node on which to search for attribute nodes.
	     * uri - {String} Namespace URI.
	     * name - {String} Local name of the attribute (without the prefix).
	     * 
	     * Returns:
	     * {DOMElement} An attribute node or null if none found.
	     */
	    getAttributeNodeNS: function(node, uri, name) {
	        var attributeNode = null;
	        if(node.getAttributeNodeNS) {
	            attributeNode = node.getAttributeNodeNS(uri, name);
	        } else {
	            var attributes = node.attributes;
	            var potentialNode, fullName;
	            for(var i=0, len=attributes.length; i<len; ++i) {
	                potentialNode = attributes[i];
	                if(potentialNode.namespaceURI == uri) {
	                    fullName = (potentialNode.prefix) ?
	                               (potentialNode.prefix + ":" + name) : name;
	                    if(fullName == potentialNode.nodeName) {
	                        attributeNode = potentialNode;
	                        break;
	                    }
	                }
	            }
	        }
	        return attributeNode;
	    },
		
	    /**
	     * APIMethod: getAttributeNS
	     * Get an attribute value given the namespace URI and local name.
	     * 
	     * Parameters:
	     * node - {Element} Node on which to search for an attribute.
	     * uri - {String} Namespace URI.
	     * name - {String} Local name of the attribute (without the prefix).
	     * 
	     * Returns:
	     * {String} An attribute value or and empty string if none found.
	     */
	    getAttributeNS: function(node, uri, name) {
	        var attributeValue = "";
	        if(node.getAttributeNS) {
	            attributeValue = node.getAttributeNS(uri, name) || "";
	        } else {
	            var attributeNode = this.getAttributeNodeNS(node, uri, name);
	            if(attributeNode) {
	                attributeValue = attributeNode.nodeValue;
	            }
	        }
	        return attributeValue;
	    },
	    
	    /**
	     * APIMethod: hasAttributeNS
	     * Determine whether a node has a particular attribute matching the given
	     *     name and namespace.
	     * 
	     * Parameters:
	     * node - {Element} Node on which to search for an attribute.
	     * uri - {String} Namespace URI.
	     * name - {String} Local name of the attribute (without the prefix).
	     * 
	     * Returns:
	     * {Boolean} The node has an attribute matching the name and namespace.
	     */
	    hasAttributeNS: function(node, uri, name) {
	        var found = false;
	        if(node.hasAttributeNS) {
	            found = node.hasAttributeNS(uri, name);
	        } else {
	            found = !!this.getAttributeNodeNS(node, uri, name);
	        }
	        return found;
	    },
	    
	    /**
	     * APIMethod: setAttributeNS
	     * Adds a new attribute or changes the value of an attribute with the given
	     *     namespace and name.
	     *
	     * Parameters:
	     * node - {Element} Element node on which to set the attribute.
	     * uri - {String} Namespace URI for the attribute.
	     * name - {String} Qualified name (prefix:localname) for the attribute.
	     * value - {String} Attribute value.
	     */
	    setAttributeNS: function(node, uri, name, value) {
	        if(node.setAttributeNS) {
	            node.setAttributeNS(uri, name, value);
	        } else {
	            if(this.xmldom) {
	                if(uri) {
	                    var attribute = node.ownerDocument.createNode(
	                        2, name, uri
	                    );
	                    attribute.nodeValue = value;
	                    node.setAttributeNode(attribute);
	                } else {
	                    node.setAttribute(name, value);
	                }
	            } else {
	                throw "setAttributeNS not implemented";
	            }
	        }
	    }
};